/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.ContributedReferenceHost;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.PyStubElementTypes;
import com.jetbrains.python.ast.PyAstFunction;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyConditionalExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIfPart;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyMatchStatement;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBaseElementImpl;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyElementPresentation;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.PyTypeProvider;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.stubs.PyAnnotationOwnerStub;
import com.jetbrains.python.psi.stubs.PyNamedParameterStub;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableParameterImpl;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyFunctionType;
import com.jetbrains.python.psi.types.PyLiteralType;
import com.jetbrains.python.psi.types.PyNoneTypeKt;
import com.jetbrains.python.psi.types.PySelfType;
import com.jetbrains.python.psi.types.PyStructuralType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyNamedParameterImpl
extends PyBaseElementImpl<PyNamedParameterStub>
implements PyNamedParameter,
ContributedReferenceHost {
    public PyNamedParameterImpl(ASTNode astNode) {
        super(astNode);
    }

    public PyNamedParameterImpl(PyNamedParameterStub stub) {
        this(stub, (IStubElementType)PyStubElementTypes.NAMED_PARAMETER);
    }

    public PyNamedParameterImpl(PyNamedParameterStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    public final PsiReference @NotNull [] getReferences() {
        PsiReference[] psiReferenceArray = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this, (PsiReferenceService.Hints)PsiReferenceService.Hints.NO_HINTS);
        if (psiReferenceArray == null) {
            PyNamedParameterImpl.$$$reportNull$$$0(0);
        }
        return psiReferenceArray;
    }

    @Nullable
    public String getName() {
        PyNamedParameterStub stub = (PyNamedParameterStub)this.getStub();
        if (stub != null) {
            return stub.getName();
        }
        return super.getName();
    }

    public int getTextOffset() {
        return super.getTextOffset();
    }

    @NotNull
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        ASTNode oldNameIdentifier;
        if (name == null) {
            PyNamedParameterImpl.$$$reportNull$$$0(1);
        }
        if ((oldNameIdentifier = this.getNameIdentifierNode()) != null) {
            ASTNode nameElement = PyUtil.createNewName(this, name);
            this.getNode().replaceChild(oldNameIdentifier, nameElement);
        }
        PyNamedParameterImpl pyNamedParameterImpl = this;
        if (pyNamedParameterImpl == null) {
            PyNamedParameterImpl.$$$reportNull$$$0(2);
        }
        return pyNamedParameterImpl;
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyNamedParameter((PyNamedParameter)this);
    }

    public boolean isPositionalContainer() {
        PyNamedParameterStub stub = (PyNamedParameterStub)this.getStub();
        if (stub != null) {
            return stub.isPositionalContainer();
        }
        return super.isPositionalContainer();
    }

    public boolean isKeywordContainer() {
        PyNamedParameterStub stub = (PyNamedParameterStub)this.getStub();
        if (stub != null) {
            return stub.isKeywordContainer();
        }
        return super.isKeywordContainer();
    }

    @Nullable
    public PyExpression getDefaultValue() {
        PyNamedParameterStub stub = (PyNamedParameterStub)this.getStub();
        if (stub != null && stub.getDefaultValueText() == null) {
            return null;
        }
        return super.getDefaultValue();
    }

    public boolean hasDefaultValue() {
        PyNamedParameterStub stub = (PyNamedParameterStub)this.getStub();
        if (stub != null) {
            return stub.getDefaultValueText() != null;
        }
        return super.hasDefaultValue();
    }

    @Nullable
    public String getDefaultValueText() {
        PyNamedParameterStub stub = (PyNamedParameterStub)this.getStub();
        if (stub != null) {
            return stub.getDefaultValueText();
        }
        return super.getDefaultValueText();
    }

    @Nullable
    public PyType getArgumentType(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyNamedParameterImpl.$$$reportNull$$$0(3);
        }
        return PyCallableParameterImpl.psi((PyParameter)this).getArgumentType(context);
    }

    @Nullable
    public PyAnnotation getAnnotation() {
        return (PyAnnotation)this.getStubOrPsiChild((IStubElementType)PyStubElementTypes.ANNOTATION);
    }

    @Nullable
    public String getAnnotationValue() {
        PyAnnotationOwnerStub stub = (PyAnnotationOwnerStub)this.getStub();
        if (stub != null) {
            return stub.getAnnotation();
        }
        return super.getAnnotationValue();
    }

    @NotNull
    public Icon getIcon(int flags) {
        Icon icon = IconManager.getInstance().getPlatformIcon(PlatformIcons.Parameter);
        if (icon == null) {
            PyNamedParameterImpl.$$$reportNull$$$0(4);
        }
        return icon;
    }

    @Nullable
    protected PyCallable getContainingCallable(@NotNull PyParameterList parameterList) {
        if (parameterList == null) {
            PyNamedParameterImpl.$$$reportNull$$$0(5);
        }
        return parameterList.getContainingCallable();
    }

    @Nullable
    public PyType getType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        PyCallable callable;
        PsiElement parent;
        if (context == null) {
            PyNamedParameterImpl.$$$reportNull$$$0(6);
        }
        if (key == null) {
            PyNamedParameterImpl.$$$reportNull$$$0(7);
        }
        if ((parent = this.getParentByStub()) instanceof PyParameterList && (callable = this.getContainingCallable((PyParameterList)parent)) != null) {
            PyType type;
            PyExpression defaultValue;
            if (callable instanceof PyFunction) {
                PyClass containingClass;
                PyFunction func = (PyFunction)callable;
                for (PyTypeProvider provider : PyTypeProvider.EP_NAME.getExtensionList()) {
                    Ref resultRef = provider.getParameterType((PyNamedParameter)this, func, context);
                    if (resultRef == null) continue;
                    return (PyType)resultRef.get();
                }
                if (this.isSelf() && (containingClass = func.getContainingClass()) != null) {
                    boolean isDefinition = PyUtil.isNewMethod((PsiElement)func) || func.getModifier() == PyAstFunction.Modifier.CLASSMETHOD;
                    return new PySelfType(new PyClassTypeImpl(containingClass, isDefinition));
                }
            }
            if (callable instanceof PyLambdaExpression) {
                PyType result;
                PyCallableParameter parameter;
                List parameters;
                PyLambdaExpression lambda = (PyLambdaExpression)callable;
                PyType lambdaType = context.getType((PyTypedElement)lambda);
                if (lambdaType instanceof PyFunctionType) {
                    PyFunctionType funcType = (PyFunctionType)lambdaType;
                    v0 = funcType.getParameters(context);
                } else {
                    v0 = parameters = null;
                }
                if (parameters != null && (parameter = (PyCallableParameter)ContainerUtil.find((Iterable)parameters, param -> Objects.equals(param.getName(), this.getName()))) != null && (result = parameter.getType(context)) != null) {
                    return result;
                }
            }
            if (this.isKeywordContainer()) {
                return PyTypeUtil.toKeywordContainerType((PsiElement)this, null);
            }
            if (this.isPositionalContainer()) {
                return PyTypeUtil.toPositionalContainerType((PsiElement)this, null);
            }
            if (context.maySwitchToAST((PsiElement)this) && (defaultValue = this.getDefaultValue()) != null && (type = PyLiteralType.upcastLiteralToClass(context.getType((PyTypedElement)defaultValue))) != null && !PyNoneTypeKt.isNoneType(type)) {
                if (type instanceof PyTupleType) {
                    return PyUnionType.createWeakType(type);
                }
                return type;
            }
            PyType assumedResult = (PyType)context.assumeType((PyTypedElement)this, null, ctx -> {
                PyType typeFromUsages;
                if (ctx.allowCallContext((PsiElement)this)) {
                    ArrayList<PyType> types = new ArrayList<PyType>();
                    PyResolveContext resolveContext = PyResolveContext.defaultContext((TypeEvalContext)ctx);
                    PyCallableParameter parameter = PyCallableParameterImpl.psi((PyParameter)this);
                    PyNamedParameterImpl.processLocalCalls(callable, (Processor<? super PyCallExpression>)((Processor)call -> {
                        ((StreamEx)StreamEx.of((Collection)call.multiMapArguments(resolveContext)).flatCollection(mapping -> mapping.getMappedParameters().entrySet()).filter(entry -> parameter.equals(entry.getValue()))).map(Map.Entry::getKey).nonNull().map(arg_0 -> ((TypeEvalContext)ctx).getType(arg_0)).nonNull().forEach(types::add);
                        return true;
                    }));
                    if (!types.isEmpty()) {
                        return PyUnionType.createWeakType(PyUnionType.union(types));
                    }
                }
                if (ctx.maySwitchToAST((PsiElement)this) && (typeFromUsages = this.getTypeFromUsages((TypeEvalContext)ctx)) != null) {
                    return typeFromUsages;
                }
                return null;
            });
            if (assumedResult != null) {
                return assumedResult;
            }
        }
        return null;
    }

    public ItemPresentation getPresentation() {
        return new PyElementPresentation(this);
    }

    @Nullable
    private PyType getTypeFromUsages(final @NotNull TypeEvalContext context) {
        if (context == null) {
            PyNamedParameterImpl.$$$reportNull$$$0(8);
        }
        final LinkedHashSet<String> usedAttributes = new LinkedHashSet<String>();
        final ScopeOwner owner = ScopeUtil.getScopeOwner((PsiElement)this);
        String name = this.getName();
        final Ref noneComparison = Ref.create((Object)false);
        final PyResolveContext resolveContext = PyResolveContext.defaultContext((TypeEvalContext)context);
        if (owner != null && name != null) {
            owner.accept((PsiElementVisitor)new PyRecursiveElementVisitor(){

                public void visitPyElement(@NotNull PyElement node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (node instanceof ScopeOwner && node != owner) {
                        return;
                    }
                    if (node instanceof PyQualifiedExpression) {
                        PyQualifiedExpression expr = (PyQualifiedExpression)node;
                        PyExpression qualifier = expr.getQualifier();
                        if (qualifier != null) {
                            PyExpression referencedExpr;
                            String attributeName = expr.getReferencedName();
                            PyExpression pyExpression = referencedExpr = node instanceof PyBinaryExpression && PyNames.isRightOperatorName((String)attributeName) ? ((PyBinaryExpression)node).getRightExpression() : qualifier;
                            if (attributeName != null && this.isReferenceToParameter((PsiElement)referencedExpr)) {
                                usedAttributes.add(attributeName);
                            }
                        } else if (this.isReferenceToParameter((PsiElement)expr)) {
                            StreamEx.of(PyNamedParameterImpl.this.getParametersByCallArgument((PsiElement)expr, context)).nonNull().map(parameter -> parameter.getType(context)).select(PyStructuralType.class).forEach(type -> usedAttributes.addAll(type.getAttributeNames()));
                        }
                    }
                    super.visitPyElement(node);
                }

                public void visitPyIfStatement(@NotNull PyIfStatement node) {
                    PyExpression ifCondition;
                    if (node == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if ((ifCondition = node.getIfPart().getCondition()) != null) {
                        ifCondition.accept((PsiElementVisitor)this);
                    }
                    for (PyIfPart part : node.getElifParts()) {
                        PyExpression elseIfCondition = part.getCondition();
                        if (elseIfCondition == null) continue;
                        elseIfCondition.accept((PsiElementVisitor)this);
                    }
                }

                public void visitPyCallExpression(@NotNull PyCallExpression node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    Optional.ofNullable(node.getCallee()).filter(callee -> "len".equals(callee.getName()) && this.isReferenceToParameter(node.getArgument(0, PyReferenceExpression.class))).map(PsiElement::getReference).map(PsiReference::resolve).filter(element -> PyBuiltinCache.getInstance(element).isBuiltin((PsiElement)element)).ifPresent(callable -> usedAttributes.add("__len__"));
                    super.visitPyCallExpression(node);
                }

                public void visitPyForStatement(@NotNull PyForStatement node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    if (this.isReferenceToParameter((PsiElement)node.getForPart().getSource())) {
                        usedAttributes.add(node.isAsync() ? "__aiter__" : "__iter__");
                    }
                    super.visitPyForStatement(node);
                }

                public void visitPyMatchStatement(@NotNull PyMatchStatement node) {
                    PyExpression subject;
                    if (node == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    if ((subject = node.getSubject()) != null) {
                        subject.accept((PsiElementVisitor)this);
                    }
                }

                public void visitPyConditionalExpression(@NotNull PyConditionalExpression node) {
                    PyExpression condition;
                    if (node == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    if ((condition = node.getCondition()) != null) {
                        condition.accept((PsiElementVisitor)this);
                    }
                }

                public void visitPyBinaryExpression(@NotNull PyBinaryExpression node) {
                    boolean rhsIsParam;
                    if (node == null) {
                        1.$$$reportNull$$$0(6);
                    }
                    super.visitPyBinaryExpression(node);
                    if (((Boolean)noneComparison.get()).booleanValue() || !node.isOperator("is") && !node.isOperator("isnot")) {
                        return;
                    }
                    PyExpression lhs = node.getLeftExpression();
                    PyExpression rhs = node.getRightExpression();
                    boolean lhsIsParam = this.isReferenceToParameter((PsiElement)lhs);
                    if (lhsIsParam ^ (rhsIsParam = this.isReferenceToParameter((PsiElement)rhs))) {
                        PyExpression other;
                        PyExpression pyExpression = other = lhsIsParam ? rhs : lhs;
                        if (other != null && PyNoneTypeKt.isNoneType(context.getType((PyTypedElement)other))) {
                            noneComparison.set((Object)true);
                        }
                    }
                }

                @Contract(value="null -> false")
                private boolean isReferenceToParameter(@Nullable PsiElement element) {
                    if (element == null) {
                        return false;
                    }
                    if (!(element instanceof PyReferenceExpression) && !(element instanceof PyTargetExpression)) {
                        return false;
                    }
                    if (((PyQualifiedExpression)element).isQualified()) {
                        return false;
                    }
                    List<@Nullable PsiElement> definitions = PyUtil.multiResolveTopPriority(element, resolveContext);
                    return ContainerUtil.all(definitions, e -> e == PyNamedParameterImpl.this);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "node";
                    objectArray2[1] = "com/jetbrains/python/psi/impl/PyNamedParameterImpl$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitPyElement";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitPyIfStatement";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitPyCallExpression";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitPyForStatement";
                            break;
                        }
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitPyMatchStatement";
                            break;
                        }
                        case 5: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitPyConditionalExpression";
                            break;
                        }
                        case 6: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitPyBinaryExpression";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        if (!usedAttributes.isEmpty()) {
            PyStructuralType structuralType = new PyStructuralType(usedAttributes, true);
            return (Boolean)noneComparison.get() != false ? PyUnionType.union(structuralType, (PyType)PyBuiltinCache.getInstance((PsiElement)this).getNoneType()) : structuralType;
        }
        return null;
    }

    @NotNull
    private List<PyCallableParameter> getParametersByCallArgument(@NotNull PsiElement element, @NotNull TypeEvalContext context) {
        PyArgumentList argumentList;
        if (element == null) {
            PyNamedParameterImpl.$$$reportNull$$$0(9);
        }
        if (context == null) {
            PyNamedParameterImpl.$$$reportNull$$$0(10);
        }
        if ((argumentList = (PyArgumentList)PsiTreeUtil.getParentOfType((PsiElement)element, PyArgumentList.class)) != null) {
            boolean elementIsArgument = false;
            for (PyExpression argument : argumentList.getArgumentExpressions()) {
                if (PyPsiUtils.flattenParens((PyExpression)argument) != element) continue;
                elementIsArgument = true;
                break;
            }
            PyCallExpression callExpression = argumentList.getCallExpression();
            if (elementIsArgument && callExpression != null) {
                PyReferenceExpression calleeReferenceExpr;
                PyExpression firstQualifier;
                PsiReference ref;
                PyExpression callee = callExpression.getCallee();
                if (callee instanceof PyReferenceExpression && (ref = (firstQualifier = PyPsiUtils.getFirstQualifier((PyQualifiedExpression)(calleeReferenceExpr = (PyReferenceExpression)callee))).getReference()) != null && ref.isReferenceTo((PsiElement)this)) {
                    List<PyCallableParameter> list = Collections.emptyList();
                    if (list == null) {
                        PyNamedParameterImpl.$$$reportNull$$$0(11);
                    }
                    return list;
                }
                PyResolveContext resolveContext = PyResolveContext.defaultContext((TypeEvalContext)context);
                List<PyCallableParameter> list = callExpression.multiMapArguments(resolveContext).stream().flatMap(mapping -> mapping.getMappedParameters().entrySet().stream()).filter(entry -> entry.getKey() == element).map(Map.Entry::getValue).collect(Collectors.toList());
                if (list == null) {
                    PyNamedParameterImpl.$$$reportNull$$$0(12);
                }
                return list;
            }
        }
        List<PyCallableParameter> list = Collections.emptyList();
        if (list == null) {
            PyNamedParameterImpl.$$$reportNull$$$0(13);
        }
        return list;
    }

    private static void processLocalCalls(@NotNull PyCallable function, @NotNull Processor<? super PyCallExpression> processor2) {
        if (function == null) {
            PyNamedParameterImpl.$$$reportNull$$$0(14);
        }
        if (processor2 == null) {
            PyNamedParameterImpl.$$$reportNull$$$0(15);
        }
        PsiFile file = function.getContainingFile();
        String name = function.getName();
        if (file != null && name != null) {
            String text = file.getText();
            int pos = text.indexOf(name);
            while (pos != -1) {
                PyCallExpression expr;
                PsiReference ref = file.findReferenceAt(pos);
                if (ref != null && ref.isReferenceTo((PsiElement)function) && (expr = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(pos), PyCallExpression.class)) != null && !processor2.process((Object)expr)) {
                    return;
                }
                pos = text.indexOf(name, pos + 1);
            }
        }
    }

    @Override
    public String toString() {
        return super.toString() + "('" + this.getName() + "')";
    }

    @NotNull
    public SearchScope getUseScope() {
        ScopeOwner owner = ScopeUtil.getScopeOwner((PsiElement)this);
        if (owner instanceof PyFunction) {
            SearchScope searchScope = owner.getUseScope();
            if (searchScope == null) {
                PyNamedParameterImpl.$$$reportNull$$$0(16);
            }
            return searchScope;
        }
        return new LocalSearchScope((PsiElement)this.getContainingFile());
    }

    @Nullable
    public String getTypeCommentAnnotation() {
        return PyNamedParameterImpl.getTypeCommentAnnotationFromStubOrPsi(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 5, 6, 7, 8, 9, 10, 14, 15 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyNamedParameterImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyNamedParameterImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "setName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getParametersByCallArgument";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getContainingCallable";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromUsages";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getParametersByCallArgument";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processLocalCalls";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 5, 6, 7, 8, 9, 10, 14, 15 -> new IllegalArgumentException(string);
        };
    }
}

