/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.actions.timestamps;

import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.model.CaretTimestampModel;
import com.jetbrains.rd.ide.model.OffsetTimestampModel;
import com.jetbrains.rd.ide.model.RangeMarkerTimestampModel;
import com.jetbrains.rd.ide.model.UpgradableActionTimestampModel;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.actions.ActionTimestampKey;
import com.jetbrains.rdserver.actions.ActionTimestampSet;
import com.jetbrains.rdserver.actions.TimestampUpgradeResult;
import com.jetbrains.rdserver.actions.UpgradableTimestamp;
import com.jetbrains.rdserver.actions.timestamps.OffsetTimestamp;
import com.jetbrains.rdserver.actions.timestamps.RangeMarkerTimestamp;
import com.jetbrains.rdserver.document.BackendDocumentHost;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\rB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/actions/timestamps/CaretTimestamp;", "Lcom/jetbrains/rdserver/actions/UpgradableTimestamp;", "Lcom/jetbrains/rd/ide/model/CaretTimestampModel;", "offsetTimestamp", "Lcom/jetbrains/rdserver/actions/timestamps/OffsetTimestamp;", "rangeMarkerTimestamp", "Lcom/jetbrains/rdserver/actions/timestamps/RangeMarkerTimestamp;", "<init>", "(Lcom/jetbrains/rdserver/actions/timestamps/OffsetTimestamp;Lcom/jetbrains/rdserver/actions/timestamps/RangeMarkerTimestamp;)V", "upgrade", "Lcom/jetbrains/rdserver/actions/TimestampUpgradeResult;", "actualSet", "Lcom/jetbrains/rdserver/actions/ActionTimestampSet;", "Companion", "intellij.platform.backend.split"})
public final class CaretTimestamp
extends UpgradableTimestamp<CaretTimestampModel> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OffsetTimestamp offsetTimestamp;
    @NotNull
    private final RangeMarkerTimestamp rangeMarkerTimestamp;
    @NotNull
    private static final ActionTimestampKey<CaretTimestamp, CaretTimestampModel> NAME = new ActionTimestampKey("CARET_MODEL");

    public CaretTimestamp(@NotNull OffsetTimestamp offsetTimestamp, @NotNull RangeMarkerTimestamp rangeMarkerTimestamp) {
        Intrinsics.checkNotNullParameter((Object)offsetTimestamp, (String)"offsetTimestamp");
        Intrinsics.checkNotNullParameter((Object)rangeMarkerTimestamp, (String)"rangeMarkerTimestamp");
        super(NAME, (UpgradableActionTimestampModel)new CaretTimestampModel((RangeMarkerTimestampModel)rangeMarkerTimestamp.getModel(), (OffsetTimestampModel)offsetTimestamp.getModel()));
        this.offsetTimestamp = offsetTimestamp;
        this.rangeMarkerTimestamp = rangeMarkerTimestamp;
    }

    @Override
    @NotNull
    public TimestampUpgradeResult upgrade(@NotNull ActionTimestampSet actualSet) {
        Intrinsics.checkNotNullParameter((Object)actualSet, (String)"actualSet");
        TimestampUpgradeResult offsetUpgradeResult = this.offsetTimestamp.upgrade(actualSet);
        if (!(offsetUpgradeResult instanceof TimestampUpgradeResult.Success)) {
            return offsetUpgradeResult;
        }
        ActionTimestamp actionTimestamp = ((TimestampUpgradeResult.Success)offsetUpgradeResult).getTimestamp();
        Intrinsics.checkNotNull(actionTimestamp, (String)"null cannot be cast to non-null type com.jetbrains.rdserver.actions.timestamps.OffsetTimestamp");
        OffsetTimestamp upgradedOffset = (OffsetTimestamp)actionTimestamp;
        TimestampUpgradeResult rangeUpgradeResult = this.rangeMarkerTimestamp.upgrade(actualSet);
        if (!(rangeUpgradeResult instanceof TimestampUpgradeResult.Success)) {
            return rangeUpgradeResult;
        }
        ActionTimestamp actionTimestamp2 = ((TimestampUpgradeResult.Success)rangeUpgradeResult).getTimestamp();
        Intrinsics.checkNotNull(actionTimestamp2, (String)"null cannot be cast to non-null type com.jetbrains.rdserver.actions.timestamps.RangeMarkerTimestamp");
        RangeMarkerTimestamp upgradedRange = (RangeMarkerTimestamp)actionTimestamp2;
        return new TimestampUpgradeResult.Success(new CaretTimestamp(upgradedOffset, upgradedRange));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rdserver/actions/timestamps/CaretTimestamp$Companion;", "", "<init>", "()V", "NAME", "Lcom/jetbrains/rdserver/actions/ActionTimestampKey;", "Lcom/jetbrains/rdserver/actions/timestamps/CaretTimestamp;", "Lcom/jetbrains/rd/ide/model/CaretTimestampModel;", "getNAME", "()Lcom/jetbrains/rdserver/actions/ActionTimestampKey;", "create", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "caret", "Lcom/intellij/openapi/editor/Caret;", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ActionTimestampKey<CaretTimestamp, CaretTimestampModel> getNAME() {
            return NAME;
        }

        @Nullable
        public final CaretTimestamp create(@NotNull ClientProjectSession session, @NotNull Caret caret) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
            Document document = caret.getEditor().getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            DocumentSynchronizer documentSynchronizer = BackendDocumentHost.Companion.getInstance(session.getAppSession()).tryGetSynchronizer(document2);
            if (documentSynchronizer == null) {
                return null;
            }
            DocumentSynchronizer documentSynchronizer2 = documentSynchronizer;
            OffsetTimestamp offsetTimestamp = OffsetTimestamp.Companion.create$default(OffsetTimestamp.Companion, documentSynchronizer2, caret.getOffset(), false, 4, null);
            RangeMarkerTimestamp rangeMarkerTimestamp = RangeMarkerTimestamp.Companion.create$default(RangeMarkerTimestamp.Companion, documentSynchronizer2, new TextRange(caret.getSelectionStart(), caret.getSelectionEnd()), false, 4, null);
            return new CaretTimestamp(offsetTimestamp, rangeMarkerTimestamp);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

