/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.actions.timestamps;

import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.rd.ide.model.DebuggerExecutionLineTimestampModel;
import com.jetbrains.rd.ide.model.OffsetTimestampModel;
import com.jetbrains.rd.ide.model.UpgradableActionTimestampModel;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.actions.ActionTimestampKey;
import com.jetbrains.rdserver.actions.ActionTimestampSet;
import com.jetbrains.rdserver.actions.TimestampUpgradeResult;
import com.jetbrains.rdserver.actions.UpgradableTimestamp;
import com.jetbrains.rdserver.actions.timestamps.OffsetTimestamp;
import com.jetbrains.rdserver.actions.timestamps.ProjectTimestamp;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000bB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rdserver/actions/timestamps/DebuggerExecutionLineTimestamp;", "Lcom/jetbrains/rdserver/actions/UpgradableTimestamp;", "Lcom/jetbrains/rd/ide/model/DebuggerExecutionLineTimestampModel;", "offset", "Lcom/jetbrains/rdserver/actions/timestamps/OffsetTimestamp;", "<init>", "(Lcom/jetbrains/rdserver/actions/timestamps/OffsetTimestamp;)V", "upgrade", "Lcom/jetbrains/rdserver/actions/TimestampUpgradeResult;", "actualSet", "Lcom/jetbrains/rdserver/actions/ActionTimestampSet;", "Companion", "intellij.platform.backend.split"})
public final class DebuggerExecutionLineTimestamp
extends UpgradableTimestamp<DebuggerExecutionLineTimestampModel> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OffsetTimestamp offset;
    @NotNull
    private static final ActionTimestampKey<DebuggerExecutionLineTimestamp, DebuggerExecutionLineTimestampModel> NAME = new ActionTimestampKey("EXECUTION_LINE");

    public DebuggerExecutionLineTimestamp(@NotNull OffsetTimestamp offset) {
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        super(NAME, (UpgradableActionTimestampModel)new DebuggerExecutionLineTimestampModel((OffsetTimestampModel)offset.getModel()));
        this.offset = offset;
    }

    @Override
    @NotNull
    public TimestampUpgradeResult upgrade(@NotNull ActionTimestampSet actualSet) {
        Intrinsics.checkNotNullParameter((Object)actualSet, (String)"actualSet");
        ProjectTimestamp projectTimestamp = actualSet.getTimestamp(ProjectTimestamp.Companion.getNAME());
        if (projectTimestamp == null || (projectTimestamp = projectTimestamp.getData()) == null) {
            return new TimestampUpgradeResult.Failure("No Project");
        }
        ProjectTimestamp project = projectTimestamp;
        XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)project).getCurrentSession();
        if (xDebugSession == null) {
            return new TimestampUpgradeResult.Failure("Debug session is terminated");
        }
        XDebugSession session = xDebugSession;
        XSourcePosition xSourcePosition = session.getCurrentPosition();
        if (xSourcePosition == null) {
            return new TimestampUpgradeResult.Failure("Execution position is not available");
        }
        XSourcePosition currentPosition = xSourcePosition;
        TimestampUpgradeResult offsetUpgradeResult = this.offset.upgrade(actualSet);
        if (!(offsetUpgradeResult instanceof TimestampUpgradeResult.Success)) {
            return offsetUpgradeResult;
        }
        ActionTimestamp actionTimestamp = ((TimestampUpgradeResult.Success)offsetUpgradeResult).getTimestamp();
        Intrinsics.checkNotNull(actionTimestamp, (String)"null cannot be cast to non-null type com.jetbrains.rdserver.actions.timestamps.OffsetTimestamp");
        OffsetTimestamp upgradedOffset = (OffsetTimestamp)actionTimestamp;
        int offset = ((OffsetTimestampModel)upgradedOffset.getModel()).getOffset();
        if (offset != currentPosition.getOffset()) {
            return new TimestampUpgradeResult.RetryRequest("Execution position was changed");
        }
        return new TimestampUpgradeResult.Success(new DebuggerExecutionLineTimestamp(upgradedOffset));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rdserver/actions/timestamps/DebuggerExecutionLineTimestamp$Companion;", "", "<init>", "()V", "NAME", "Lcom/jetbrains/rdserver/actions/ActionTimestampKey;", "Lcom/jetbrains/rdserver/actions/timestamps/DebuggerExecutionLineTimestamp;", "Lcom/jetbrains/rd/ide/model/DebuggerExecutionLineTimestampModel;", "getNAME", "()Lcom/jetbrains/rdserver/actions/ActionTimestampKey;", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ActionTimestampKey<DebuggerExecutionLineTimestamp, DebuggerExecutionLineTimestampModel> getNAME() {
            return NAME;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

