/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.actions.timestamps;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.ide.model.ProjectViewTimestampModel;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.ide.model.UpgradableActionTimestampModel;
import com.jetbrains.rd.platform.client.SessionUtilKt;
import com.jetbrains.rdserver.actions.ActionTimestampKey;
import com.jetbrains.rdserver.actions.ActionTimestampSet;
import com.jetbrains.rdserver.actions.BackendDataKeys;
import com.jetbrains.rdserver.actions.TimestampUpgradeResult;
import com.jetbrains.rdserver.actions.UpgradableTimestamp;
import com.jetbrains.rdserver.actions.timestamps.BackendProjectViewSelection;
import com.jetbrains.rdserver.actions.timestamps.ProjectTimestamp;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0010B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rdserver/actions/timestamps/ProjectViewTimestamp;", "Lcom/jetbrains/rdserver/actions/UpgradableTimestamp;", "Lcom/jetbrains/rd/ide/model/ProjectViewTimestampModel;", "paneId", "", "selectedNodeIds", "", "", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "upgrade", "Lcom/jetbrains/rdserver/actions/TimestampUpgradeResult;", "actualSet", "Lcom/jetbrains/rdserver/actions/ActionTimestampSet;", "getData", "Lcom/jetbrains/rdserver/actions/timestamps/BackendProjectViewSelection;", "Companion", "intellij.platform.backend.split"})
public final class ProjectViewTimestamp
extends UpgradableTimestamp<ProjectViewTimestampModel> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ActionTimestampKey<ProjectViewTimestamp, ProjectViewTimestampModel> NAME = new ActionTimestampKey(BackendDataKeys.INSTANCE.getPROJECT_VIEW_SELECTION().getName());

    public ProjectViewTimestamp(@NotNull String paneId, @NotNull List<Integer> selectedNodeIds) {
        Intrinsics.checkNotNullParameter((Object)paneId, (String)"paneId");
        Intrinsics.checkNotNullParameter(selectedNodeIds, (String)"selectedNodeIds");
        super(NAME, (UpgradableActionTimestampModel)new ProjectViewTimestampModel(paneId, selectedNodeIds));
    }

    @Override
    @NotNull
    public TimestampUpgradeResult upgrade(@NotNull ActionTimestampSet actualSet) {
        Intrinsics.checkNotNullParameter((Object)actualSet, (String)"actualSet");
        ProjectTimestamp projectTimestamp = actualSet.getTimestamp(ProjectTimestamp.Companion.getNAME());
        RdProjectId projectId = projectTimestamp != null ? projectTimestamp.getProjectId() : null;
        ClientProjectSession session = SessionUtilKt.getProjectSession((ClientAppSession)ClientSessionsUtil.getCurrentSession((Application)ApplicationKt.getApplication()), (RdProjectId)projectId);
        if (session == null || ((ProjectViewTimestampModel)this.getModel()).getSelectedNodeIds().size() != this.getData().getNodes(session).size()) {
            return new TimestampUpgradeResult.Failure("ProjectView was already changed, operation can not be performed");
        }
        return new TimestampUpgradeResult.Success(this);
    }

    @Override
    @NotNull
    public BackendProjectViewSelection getData() {
        return new BackendProjectViewSelection(((ProjectViewTimestampModel)this.getModel()).getPaneId(), ((ProjectViewTimestampModel)this.getModel()).getSelectedNodeIds());
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rdserver/actions/timestamps/ProjectViewTimestamp$Companion;", "", "<init>", "()V", "NAME", "Lcom/jetbrains/rdserver/actions/ActionTimestampKey;", "Lcom/jetbrains/rdserver/actions/timestamps/ProjectViewTimestamp;", "Lcom/jetbrains/rd/ide/model/ProjectViewTimestampModel;", "getNAME", "()Lcom/jetbrains/rdserver/actions/ActionTimestampKey;", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ActionTimestampKey<ProjectViewTimestamp, ProjectViewTimestampModel> getNAME() {
            return NAME;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

