/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.daemon.highlighters.gutterMarks;

import com.intellij.codeInsight.daemon.NavigateAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.impl.EditorMousePopupActionGroup;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.jetbrains.rd.actions.ActionProvider;
import com.jetbrains.rd.actions.EditorActionsProviderKt;
import com.jetbrains.rd.actions.GutterActionKind;
import com.jetbrains.rdserver.daemon.BackendMarkupModelContributorKt;
import com.jetbrains.rdserver.daemon.highlighters.gutterMarks.BackendGutterActionProviderKt;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\u0005H\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rdserver/daemon/highlighters/gutterMarks/BackendGutterActionProvider;", "Lcom/jetbrains/rd/actions/ActionProvider;", "<init>", "()V", "getAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "backendActionId", "", "actionEvent", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getId", "action", "intellij.platform.backend.split"})
public final class BackendGutterActionProvider
implements ActionProvider {
    @Nullable
    public AnAction getAction(@NotNull String backendActionId, @Nullable AnActionEvent actionEvent) {
        AnAction clickAction;
        Intrinsics.checkNotNullParameter((Object)backendActionId, (String)"backendActionId");
        if (actionEvent == null) {
            return null;
        }
        Pair pair = EditorActionsProviderKt.parseGutterIconRendererActionId((String)backendActionId);
        if (pair == null) {
            return null;
        }
        Pair pair2 = pair;
        GutterActionKind actionKind = (GutterActionKind)pair2.component1();
        long rendererId = ((Number)pair2.component2()).longValue();
        Editor editor = (Editor)actionEvent.getDataContext().getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return null;
        }
        Editor editor2 = editor;
        RangeMarkerEx rangeMarker = BackendMarkupModelContributorKt.getRangeMarker(editor2, rendererId);
        Object object = rangeMarker instanceof RangeHighlighterEx ? ((RangeHighlighterEx)rangeMarker).getGutterIconRenderer() : (rangeMarker instanceof CustomFoldRegion ? ((CustomFoldRegion)rangeMarker).getGutterIconRenderer() : null);
        if (object == null) {
            return null;
        }
        GutterIconRenderer gutterRenderer = object;
        AnAction anAction = clickAction = (switch (WhenMappings.$EnumSwitchMapping$0[actionKind.ordinal()]) {
            case 1 -> gutterRenderer.getClickAction();
            case 2 -> gutterRenderer.getMiddleButtonClickAction();
            case 3 -> gutterRenderer.getRightButtonClickAction();
            default -> null;
        });
        if (anAction != null) {
            return anAction;
        }
        if (actionKind != GutterActionKind.POPUP_GROUP) {
            return null;
        }
        InputEvent inputEvent = actionEvent.getInputEvent();
        MouseEvent mouseEvent = inputEvent instanceof MouseEvent ? (MouseEvent)inputEvent : null;
        if (mouseEvent == null) {
            inputEvent = editor2.getGutter();
            mouseEvent = new MouseEvent((Component)(inputEvent instanceof EditorGutterComponentEx ? (EditorGutterComponentEx)inputEvent : null), 502, 0L, 0, 0, 0, 1, false);
        }
        MouseEvent mouseEvent2 = mouseEvent;
        ActionGroup actionGroup = gutterRenderer.getPopupMenuActions();
        if (actionGroup == null) {
            return null;
        }
        ActionGroup popupMenuActions = actionGroup;
        EditorMousePopupActionGroup result = new EditorMousePopupActionGroup(popupMenuActions, new EditorMouseEvent(editor2, mouseEvent2, EditorMouseEventArea.LINE_MARKERS_AREA, 0, new LogicalPosition(0, 0), new VisualPosition(0, 0), true, null, null, gutterRenderer));
        result.getTemplatePresentation().putClientProperty(BackendGutterActionProviderKt.access$getOriginalIdKey$p(), (Object)backendActionId);
        return (AnAction)result;
    }

    @Nullable
    public String getId(@NotNull AnAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        if (action instanceof NavigateAction) {
            return ((NavigateAction)action).getOriginalActionId();
        }
        if (action instanceof EditorMousePopupActionGroup && ((EditorMousePopupActionGroup)action).getEvent().getGutterIconRenderer() != null) {
            return (String)((EditorMousePopupActionGroup)action).getTemplatePresentation().getClientProperty(BackendGutterActionProviderKt.access$getOriginalIdKey$p());
        }
        return null;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GutterActionKind.values().length];
            try {
                nArray[GutterActionKind.LEFT_CLICK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GutterActionKind.MIDDLE_CLICK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GutterActionKind.RIGHT_CLICK.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

