/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.execution.configurations;

import com.intellij.execution.ExecutionListener;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R3\u0010\u0006\u001a'\u0012\u000e\u0012\f0\b\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\b\n\u0012\u000e\u0012\f0\u000b\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\b\n0\u0007\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rdserver/execution/configurations/BackendRunContentStore;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "descriptorToEnvironment", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/execution/ui/RunContentDescriptor;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "tryGetEnvironment", "descriptor", "MyExecutionListener", "intellij.platform.backend.split"})
public final class BackendRunContentStore
extends LifetimedService {
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentMap<RunContentDescriptor, ExecutionEnvironment> descriptorToEnvironment;

    public BackendRunContentStore(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentWeakMap(...)");
        this.descriptorToEnvironment = concurrentMap;
    }

    @Nullable
    public final ExecutionEnvironment tryGetEnvironment(@NotNull RunContentDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return (ExecutionEnvironment)this.descriptorToEnvironment.get(descriptor);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rdserver/execution/configurations/BackendRunContentStore$MyExecutionListener;", "Lcom/intellij/execution/ExecutionListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "processStarted", "", "executorId", "", "env", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "handler", "Lcom/intellij/execution/process/ProcessHandler;", "processTerminated", "exitCode", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nBackendRunContentStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendRunContentStore.kt\ncom/jetbrains/rdserver/execution/configurations/BackendRunContentStore$MyExecutionListener\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,39:1\n30#2,2:40\n30#2,2:42\n*S KotlinDebug\n*F\n+ 1 BackendRunContentStore.kt\ncom/jetbrains/rdserver/execution/configurations/BackendRunContentStore$MyExecutionListener\n*L\n24#1:40,2\n32#1:42,2\n*E\n"})
    public static final class MyExecutionListener
    implements ExecutionListener {
        @NotNull
        private final Project project;

        public MyExecutionListener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        public void processStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler) {
            Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            RunContentDescriptor descriptor = env.getContentToReuse();
            if (descriptor == null) {
                return;
            }
            ComponentManager $this$service$iv = (ComponentManager)this.project;
            boolean $i$f$service = false;
            Class<BackendRunContentStore> serviceClass$iv = BackendRunContentStore.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            Map map2 = ((BackendRunContentStore)((Object)object)).descriptorToEnvironment;
            map2.put(descriptor, env);
        }

        public void processTerminated(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler, int exitCode) {
            Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            RunContentDescriptor descriptor = env.getContentToReuse();
            if (descriptor == null) {
                return;
            }
            ComponentManager $this$service$iv = (ComponentManager)this.project;
            boolean $i$f$service = false;
            Class<BackendRunContentStore> serviceClass$iv = BackendRunContentStore.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((BackendRunContentStore)((Object)object)).descriptorToEnvironment.remove(descriptor);
        }
    }
}

