/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.fileEditors;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorNavigatable;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rdserver.fileEditors.BackendFileEditorHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rdserver/fileEditors/TextBackendFileEditorHandler;", "Lcom/jetbrains/rdserver/fileEditors/BackendFileEditorHandler;", "<init>", "()V", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "provider", "Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "createFollowNavigatable", "Lcom/intellij/openapi/fileEditor/FileEditorNavigatable;", "editor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "intellij.platform.backend.split"})
public final class TextBackendFileEditorHandler
implements BackendFileEditorHandler {
    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull VirtualFile file2, @NotNull FileEditorProvider provider) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        return provider instanceof TextEditorProvider;
    }

    @Override
    @Nullable
    public FileEditorNavigatable createFollowNavigatable(@NotNull Project project, @NotNull FileEditor editor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (editor instanceof TextEditor) {
            VirtualFile virtualFile = ((TextEditor)editor).getFile();
            if (virtualFile == null) {
                return null;
            }
            VirtualFile fileToNavigate = virtualFile;
            int offset = ((TextEditor)editor).getEditor().getCaretModel().getOffset();
            return (FileEditorNavigatable)new OpenFileDescriptor(project, fileToNavigate, offset);
        }
        return null;
    }
}

