/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.ui;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientKind;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.DeferredIcon;
import com.intellij.ui.DeferredIconImpl;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.ide.model.DeferredIconModel;
import com.jetbrains.rd.ide.model.ShellModel_GeneratedKt;
import com.jetbrains.rd.ui.icons.ProtocolIconModelRegistry;
import com.jetbrains.rdserver.core.RemoteSessionKt;
import com.jetbrains.rdserver.ui.BackendDeferredIconConverterKt;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0003\u0018\u00002\u00020\u0001:\u0003\u0016\u0017\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u000f\u001a\u00020\f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0002R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rdserver/ui/BackendDeferredIconStorage;", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "storage", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/jetbrains/rdserver/ui/BackendDeferredIconStorage$DeferredIconData;", "modelReferenceQueue", "Ljava/lang/ref/ReferenceQueue;", "Lcom/jetbrains/rd/ide/model/DeferredIconModel;", "iconReferenceQueue", "Lcom/intellij/ui/DeferredIcon;", "getOrCreateModel", "icon", "Lcom/intellij/ui/DeferredIconImpl;", "registry", "Lcom/jetbrains/rd/ui/icons/ProtocolIconModelRegistry;", "collectAndSendReclaimedIds", "", "DeferredIconData", "DeferredIconModelWeakReference", "DeferredIconWeakReference", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendDeferredIconConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendDeferredIconConverter.kt\ncom/jetbrains/rdserver/ui/BackendDeferredIconStorage\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,172:1\n67#2,4:173\n67#2,4:177\n*S KotlinDebug\n*F\n+ 1 BackendDeferredIconConverter.kt\ncom/jetbrains/rdserver/ui/BackendDeferredIconStorage\n*L\n96#1:173,4\n148#1:177,4\n*E\n"})
final class BackendDeferredIconStorage {
    @NotNull
    private final ConcurrentHashMap<Long, DeferredIconData> storage;
    @NotNull
    private final ReferenceQueue<DeferredIconModel> modelReferenceQueue;
    @NotNull
    private final ReferenceQueue<DeferredIcon> iconReferenceQueue;

    public BackendDeferredIconStorage(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.storage = new ConcurrentHashMap();
        this.modelReferenceQueue = new ReferenceQueue();
        this.iconReferenceQueue = new ReferenceQueue();
        BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ BackendDeferredIconStorage this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
lbl6:
                        // 2 sources

                        while (true) {
                            this.label = 1;
                            v0 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.SECONDS), (Continuation)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl16
                            break;
                        }
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        BackendDeferredIconStorage.access$collectAndSendReclaimedIds(this.this$0);
                        ** continue;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public final DeferredIconModel getOrCreateModel(@NotNull DeferredIconImpl<?> icon2, @NotNull ProtocolIconModelRegistry registry) {
        DeferredIconModelWeakReference newRef;
        DeferredIconModelWeakReference modelRef;
        DeferredIconModel cachedModel;
        Intrinsics.checkNotNullParameter(icon2, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Object object = this.storage.get(icon2.getUniqueId());
        DeferredIconModel deferredIconModel = cachedModel = object != null && (object = ((DeferredIconData)object).getModelRef()) != null && (object = (DeferredIconModelWeakReference)((AtomicReference)object).get()) != null ? (DeferredIconModel)((Reference)object).get() : null;
        if (deferredIconModel != null) {
            return deferredIconModel;
        }
        Logger $this$trace$iv = BackendDeferredIconConverterKt.access$getLOG$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Triggering evaluation for deferred icon " + icon2.getUniqueId());
        }
        icon2.triggerEvaluation();
        DeferredIconModel newModel = new DeferredIconModel(icon2.getUniqueId(), registry.createModel(icon2.getBaseIcon()));
        DeferredIconData deferredIconData = this.storage.computeIfAbsent(icon2.getUniqueId(), arg_0 -> BackendDeferredIconStorage.getOrCreateModel$lambda$2(arg_0 -> BackendDeferredIconStorage.getOrCreateModel$lambda$1(icon2, newModel, this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)deferredIconData, (String)"computeIfAbsent(...)");
        DeferredIconData data = deferredIconData;
        do {
            DeferredIconModel storedModel;
            Intrinsics.checkNotNull((Object)data.getModelRef().get());
            DeferredIconModel deferredIconModel2 = storedModel = (DeferredIconModel)modelRef.get();
            if (deferredIconModel2 != null) {
                return deferredIconModel2;
            }
            newRef = new DeferredIconModelWeakReference(newModel, this.modelReferenceQueue);
        } while (!data.getModelRef().compareAndSet(modelRef, newRef));
        return newModel;
    }

    private final void collectAndSendReclaimedIds() {
        Reference<DeferredIcon> reference;
        ArrayList<Long> idsToCheck = new ArrayList<Long>();
        while (this.iconReferenceQueue.poll() != null) {
            idsToCheck.add(((DeferredIconWeakReference)reference).getId());
        }
        while (this.modelReferenceQueue.poll() != null) {
            idsToCheck.add(((DeferredIconModelWeakReference)reference).getId());
        }
        if (idsToCheck.isEmpty()) {
            return;
        }
        ArrayList<Long> idsToReclaim = new ArrayList<Long>();
        Iterator iterator = idsToCheck.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            DeferredIconModelWeakReference modelRef;
            DeferredIconData data;
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            long id = ((Number)e).longValue();
            if (this.storage.get(id) == null || data.getIconRef().get() != null) continue;
            DeferredIconModelWeakReference deferredIconModelWeakReference = modelRef = data.getModelRef().get();
            if ((deferredIconModelWeakReference != null ? (DeferredIconModel)deferredIconModelWeakReference.get() : null) != null) continue;
            this.storage.remove(id);
            idsToReclaim.add(id);
        }
        if (!((Collection)idsToReclaim).isEmpty()) {
            long[] reclaimedIdsArray = CollectionsKt.toLongArray((Collection)idsToReclaim);
            for (ClientAppSession session : ClientSessionsUtil.sessions((Application)ApplicationKt.getApplication(), (ClientKind)ClientKind.REMOTE)) {
                Logger $this$trace$iv = BackendDeferredIconConverterKt.access$getLOG$p();
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("Firing reclaimed deferred icon (" + idsToReclaim + ") to client " + session.getClientId());
                }
                ShellModel_GeneratedKt.getShellModel((IProtocol)((IProtocol)RemoteSessionKt.getProtocol(session))).getDeferredIconsReclaimed().fire((Object)reclaimedIdsArray);
            }
        }
    }

    private static final DeferredIconData getOrCreateModel$lambda$1(DeferredIconImpl $icon, DeferredIconModel $newModel, BackendDeferredIconStorage this$0, Long it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new DeferredIconData($icon, $newModel, this$0.iconReferenceQueue, this$0.modelReferenceQueue);
    }

    private static final DeferredIconData getOrCreateModel$lambda$2(Function1 $tmp0, Object p0) {
        return (DeferredIconData)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$collectAndSendReclaimedIds(BackendDeferredIconStorage $this) {
        $this.collectAndSendReclaimedIds();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B7\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001f\u0010\u0010\u001a\u0010\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00120\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rdserver/ui/BackendDeferredIconStorage$DeferredIconData;", "", "icon", "Lcom/intellij/ui/DeferredIconImpl;", "model", "Lcom/jetbrains/rd/ide/model/DeferredIconModel;", "iconReferenceQueue", "Ljava/lang/ref/ReferenceQueue;", "Lcom/intellij/ui/DeferredIcon;", "modelReferenceQueue", "<init>", "(Lcom/intellij/ui/DeferredIconImpl;Lcom/jetbrains/rd/ide/model/DeferredIconModel;Ljava/lang/ref/ReferenceQueue;Ljava/lang/ref/ReferenceQueue;)V", "iconRef", "Lcom/jetbrains/rdserver/ui/BackendDeferredIconStorage$DeferredIconWeakReference;", "getIconRef", "()Lcom/jetbrains/rdserver/ui/BackendDeferredIconStorage$DeferredIconWeakReference;", "modelRef", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/jetbrains/rdserver/ui/BackendDeferredIconStorage$DeferredIconModelWeakReference;", "kotlin.jvm.PlatformType", "getModelRef", "()Ljava/util/concurrent/atomic/AtomicReference;", "intellij.platform.backend.split"})
    private static final class DeferredIconData {
        @NotNull
        private final DeferredIconWeakReference iconRef;
        @NotNull
        private final AtomicReference<DeferredIconModelWeakReference> modelRef;

        public DeferredIconData(@NotNull DeferredIconImpl<?> icon2, @NotNull DeferredIconModel model2, @NotNull ReferenceQueue<DeferredIcon> iconReferenceQueue, @NotNull ReferenceQueue<DeferredIconModel> modelReferenceQueue) {
            Intrinsics.checkNotNullParameter(icon2, (String)"icon");
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            Intrinsics.checkNotNullParameter(iconReferenceQueue, (String)"iconReferenceQueue");
            Intrinsics.checkNotNullParameter(modelReferenceQueue, (String)"modelReferenceQueue");
            this.iconRef = new DeferredIconWeakReference(icon2, iconReferenceQueue);
            this.modelRef = new AtomicReference<DeferredIconModelWeakReference>(new DeferredIconModelWeakReference(model2, modelReferenceQueue));
        }

        @NotNull
        public final DeferredIconWeakReference getIconRef() {
            return this.iconRef;
        }

        @NotNull
        public final AtomicReference<DeferredIconModelWeakReference> getModelRef() {
            return this.modelRef;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rdserver/ui/BackendDeferredIconStorage$DeferredIconModelWeakReference;", "Ljava/lang/ref/WeakReference;", "Lcom/jetbrains/rd/ide/model/DeferredIconModel;", "instance", "queue", "Ljava/lang/ref/ReferenceQueue;", "<init>", "(Lcom/jetbrains/rd/ide/model/DeferredIconModel;Ljava/lang/ref/ReferenceQueue;)V", "id", "", "getId", "()J", "intellij.platform.backend.split"})
    private static final class DeferredIconModelWeakReference
    extends WeakReference<DeferredIconModel> {
        private final long id;

        public DeferredIconModelWeakReference(@NotNull DeferredIconModel instance, @NotNull ReferenceQueue<DeferredIconModel> queue) {
            Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
            Intrinsics.checkNotNullParameter(queue, (String)"queue");
            super(instance, queue);
            this.id = instance.getId();
        }

        public final long getId() {
            return this.id;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rdserver/ui/BackendDeferredIconStorage$DeferredIconWeakReference;", "Ljava/lang/ref/WeakReference;", "Lcom/intellij/ui/DeferredIcon;", "instance", "Lcom/intellij/ui/DeferredIconImpl;", "queue", "Ljava/lang/ref/ReferenceQueue;", "<init>", "(Lcom/intellij/ui/DeferredIconImpl;Ljava/lang/ref/ReferenceQueue;)V", "id", "", "getId", "()J", "intellij.platform.backend.split"})
    private static final class DeferredIconWeakReference
    extends WeakReference<DeferredIcon> {
        private final long id;

        public DeferredIconWeakReference(@NotNull DeferredIconImpl<?> instance, @NotNull ReferenceQueue<DeferredIcon> queue) {
            Intrinsics.checkNotNullParameter(instance, (String)"instance");
            Intrinsics.checkNotNullParameter(queue, (String)"queue");
            super(instance, queue);
            this.id = instance.getUniqueId();
        }

        public final long getId() {
            return this.id;
        }
    }
}

