/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.ui.converters;

import com.jediterm.core.Color;
import com.jediterm.terminal.TerminalColor;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.model.CharBuffer;
import com.jediterm.terminal.model.LinesBuffer;
import com.jediterm.terminal.model.TerminalLine;
import com.jetbrains.codeWithMe.model.BeTerminalColor;
import com.jetbrains.codeWithMe.model.BeTerminalEntryStyle;
import com.jetbrains.codeWithMe.model.BeTerminalLine;
import com.jetbrains.codeWithMe.model.BeTerminalLineEntry;
import com.jetbrains.rdserver.ui.converters.TerminalWidgetConverterKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\fH\u0002J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\b0!R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/jetbrains/rdserver/ui/converters/OutputBuilder;", "", "<init>", "()V", "entries", "", "Lcom/jetbrains/codeWithMe/model/BeTerminalLineEntry;", "output", "Lcom/jetbrains/codeWithMe/model/BeTerminalLine;", "pendingNewLines", "", "addLines", "", "linesBuffer", "Lcom/jediterm/terminal/model/LinesBuffer;", "addLine", "line", "Lcom/jediterm/terminal/model/TerminalLine;", "addTextChunk", "entry", "Lcom/jediterm/terminal/model/TerminalLine$TextEntry;", "newLine", "createEntryModel", "createOptionsMask", "style", "Lcom/jediterm/terminal/TextStyle;", "createColorModel", "Lcom/jetbrains/codeWithMe/model/BeTerminalColor;", "color", "Lcom/jediterm/terminal/TerminalColor;", "flushEntriesIfNeeded", "", "build", "", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nTerminalWidgetConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalWidgetConverter.kt\ncom/jetbrains/rdserver/ui/converters/OutputBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,210:1\n1#2:211\n1915#3,2:212\n*S KotlinDebug\n*F\n+ 1 TerminalWidgetConverter.kt\ncom/jetbrains/rdserver/ui/converters/OutputBuilder\n*L\n177#1:212,2\n*E\n"})
final class OutputBuilder {
    @NotNull
    private final List<BeTerminalLineEntry> entries = new ArrayList();
    @NotNull
    private final List<BeTerminalLine> output = new ArrayList();
    private int pendingNewLines;

    public final void addLines(@NotNull LinesBuffer linesBuffer) {
        Intrinsics.checkNotNullParameter((Object)linesBuffer, (String)"linesBuffer");
        int n = linesBuffer.getLineCount();
        for (int i = 0; i < n; ++i) {
            TerminalLine terminalLine = linesBuffer.getLine(i);
            Intrinsics.checkNotNullExpressionValue((Object)terminalLine, (String)"getLine(...)");
            this.addLine(terminalLine);
        }
    }

    private final void addLine(TerminalLine line) {
        line.forEachEntry(arg_0 -> OutputBuilder.addLine$lambda$0(this, arg_0));
        if (!line.isWrapped()) {
            int n = this.pendingNewLines;
            this.pendingNewLines = n + 1;
        }
    }

    private final void addTextChunk(TerminalLine.TextEntry entry) {
        CharBuffer charBuffer = entry.getText();
        Intrinsics.checkNotNullExpressionValue((Object)charBuffer, (String)"getText(...)");
        if (((CharSequence)charBuffer).length() > 0) {
            int n = this.pendingNewLines;
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                this.newLine();
            }
            this.pendingNewLines = 0;
            this.entries.add(this.createEntryModel(entry));
        }
    }

    private final void newLine() {
        if (!this.flushEntriesIfNeeded()) {
            this.output.add(new BeTerminalLine(CollectionsKt.emptyList()));
        }
    }

    private final BeTerminalLineEntry createEntryModel(TerminalLine.TextEntry entry) {
        BeTerminalColor beTerminalColor;
        BeTerminalColor beTerminalColor2;
        CharBuffer charBuffer = entry.getText();
        Intrinsics.checkNotNullExpressionValue((Object)charBuffer, (String)"getText(...)");
        String text = TerminalWidgetConverterKt.access$normalize(charBuffer);
        TerminalColor terminalColor = entry.getStyle().getForeground();
        if (terminalColor != null) {
            TerminalColor it = terminalColor;
            boolean bl = false;
            beTerminalColor2 = this.createColorModel(it);
        } else {
            beTerminalColor2 = null;
        }
        BeTerminalColor foreground = beTerminalColor2;
        TerminalColor terminalColor2 = entry.getStyle().getBackground();
        if (terminalColor2 != null) {
            TerminalColor it = terminalColor2;
            boolean bl = false;
            beTerminalColor = this.createColorModel(it);
        } else {
            beTerminalColor = null;
        }
        BeTerminalColor background = beTerminalColor;
        TextStyle textStyle = entry.getStyle();
        Intrinsics.checkNotNullExpressionValue((Object)textStyle, (String)"getStyle(...)");
        int options = this.createOptionsMask(textStyle);
        return new BeTerminalLineEntry(text, new BeTerminalEntryStyle(foreground, background, options));
    }

    private final int createOptionsMask(TextStyle style) {
        int mask = 0;
        Iterable $this$forEach$iv = (Iterable)EntriesMappings.entries$0;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TextStyle.Option option = (TextStyle.Option)element$iv;
            boolean bl = false;
            if (!style.hasOption(option)) continue;
            mask |= 1 << option.ordinal();
        }
        return mask;
    }

    private final BeTerminalColor createColorModel(TerminalColor color) {
        if (color.getColorIndex() >= 0) {
            return new BeTerminalColor(color.getColorIndex(), 0, 0, 0);
        }
        Color color2 = color.toColor();
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"toColor(...)");
        Color rgbColor = color2;
        return new BeTerminalColor(-1, rgbColor.getRed(), rgbColor.getGreen(), rgbColor.getBlue());
    }

    private final boolean flushEntriesIfNeeded() {
        if (this.entries.isEmpty()) {
            return false;
        }
        this.output.add(new BeTerminalLine(CollectionsKt.toList((Iterable)this.entries)));
        this.entries.clear();
        return true;
    }

    @NotNull
    public final List<BeTerminalLine> build() {
        this.flushEntriesIfNeeded();
        return this.output;
    }

    private static final void addLine$lambda$0(OutputBuilder this$0, TerminalLine.TextEntry entry) {
        CharBuffer charBuffer = entry.getText();
        Intrinsics.checkNotNullExpressionValue((Object)charBuffer, (String)"getText(...)");
        if (((CharSequence)charBuffer).length() > 0 && !entry.isNul()) {
            Intrinsics.checkNotNull((Object)entry);
            this$0.addTextChunk(entry);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<TextStyle.Option> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])TextStyle.Option.values()));
        }
    }
}

