/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.impl.TemplateContextTypes;
import com.intellij.codeInsight.template.impl.TemplateGroup;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.codeInsight.template.impl.Variable;
import com.intellij.database.Dbms;
import com.intellij.database.actions.DbActionUtils;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.explorer.structure.DvTreeNodeRank;
import com.intellij.database.liveTemplates.macros.DbContextMacroBase;
import com.intellij.database.model.DasTable;
import com.intellij.database.psi.DbElement;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u00012\u00020\u0002:\u0002\u000f\u0010B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001d\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/actions/DbContextTemplateGroup;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "DbContextTemplateAction", "Companion", "intellij.database.impl"})
public final class DbContextTemplateGroup
extends ActionGroup
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        Set<DvTreeNodeRank> ranks = DatabaseContextFun.getSelectedTreeNodeRanks(dataContext);
        e.getPresentation().setEnabledAndVisible(ranks.size() == 1 && ranks.contains(DvTreeNodeRank.TL_ELEMENT));
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        if (e == null) {
            Intrinsics.checkNotNullExpressionValue((Object)ActionGroup.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return ActionGroup.EMPTY_ARRAY;
        }
        DbElement dbElement = DbContextTemplateGroup.Companion.getTargetObject(e);
        if (dbElement == null) {
            Intrinsics.checkNotNullExpressionValue((Object)ActionGroup.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return ActionGroup.EMPTY_ARRAY;
        }
        DbElement target = dbElement;
        Dbms dbms = target.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        TemplateContextType templateContextType = DbContextTemplateGroup.Companion.getContextType(dbms);
        if (templateContextType == null) {
            Intrinsics.checkNotNullExpressionValue((Object)ActionGroup.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return ActionGroup.EMPTY_ARRAY;
        }
        TemplateContextType contextType = templateContextType;
        List templates = DbContextTemplateGroup.Companion.getApplicableTemplates(contextType);
        if (templates.isEmpty()) {
            Intrinsics.checkNotNullExpressionValue((Object)ActionGroup.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return ActionGroup.EMPTY_ARRAY;
        }
        int n = templates.size() + 1;
        AnAction[] anActionArray = new AnAction[n];
        for (int i = 0; i < n; ++i) {
            Object object;
            int n2 = i;
            if (n2 == 0) {
                Separator separator = Separator.getInstance();
                object = separator;
                Intrinsics.checkNotNullExpressionValue((Object)separator, (String)"getInstance(...)");
            } else {
                object = new DbContextTemplateAction((TemplateImpl)templates.get(n2 - 1));
            }
            anActionArray[n2] = object;
        }
        return anActionArray;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/actions/DbContextTemplateGroup$Companion;", "", "<init>", "()V", "getApplicableTemplates", "", "Lcom/intellij/codeInsight/template/impl/TemplateImpl;", "contextType", "Lcom/intellij/codeInsight/template/TemplateContextType;", "getContextType", "dbms", "Lcom/intellij/database/Dbms;", "getTargetObject", "Lcom/intellij/database/psi/DbElement;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDbContextTemplateGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbContextTemplateGroup.kt\ncom/intellij/database/actions/DbContextTemplateGroup$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n296#2,2:103\n777#2:105\n873#2:106\n1807#2,3:107\n874#2:110\n296#2,2:111\n296#2,2:113\n1#3:115\n*S KotlinDebug\n*F\n+ 1 DbContextTemplateGroup.kt\ncom/intellij/database/actions/DbContextTemplateGroup$Companion\n*L\n81#1:103,2\n82#1:105\n82#1:106\n83#1:107,3\n82#1:110\n90#1:111,2\n91#1:113,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final List<TemplateImpl> getApplicableTemplates(TemplateContextType contextType) {
            void $this$filterTo$iv$iv;
            Object v1;
            block6: {
                List list = TemplateSettings.getInstance().getTemplateGroups();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTemplateGroups(...)");
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    TemplateGroup it = (TemplateGroup)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"SQL")) continue;
                    v1 = element$iv;
                    break block6;
                }
                v1 = null;
            }
            TemplateGroup templateGroup = v1;
            if (templateGroup == null) {
                return CollectionsKt.emptyList();
            }
            TemplateGroup group = templateGroup;
            List list = group.getElements();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getElements(...)");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable $i$f$firstOrNull = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                TemplateImpl template;
                block7: {
                    template = (TemplateImpl)element$iv$iv;
                    boolean bl2 = false;
                    ArrayList arrayList = template.getVariables();
                    Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"getVariables(...)");
                    Iterable $this$any$iv = arrayList;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Variable it = (Variable)element$iv;
                            boolean bl3 = false;
                            Expression expression = it.getExpression();
                            MacroCallNode macroCallNode = expression instanceof MacroCallNode ? (MacroCallNode)expression : null;
                            if (!((macroCallNode != null ? macroCallNode.getMacro() : null) instanceof DbContextMacroBase)) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                }
                if (!(bl && template.getTemplateContext().isEnabled(contextType))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final TemplateContextType getContextType(Dbms dbms) {
            TemplateContextType templateContextType;
            Object v1;
            TemplateContextType it;
            boolean $i$f$firstOrNull;
            Iterable $this$firstOrNull$iv;
            List allTemplates;
            block3: {
                List list = TemplateContextTypes.getAllContextTypes();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllContextTypes(...)");
                allTemplates = list;
                $this$firstOrNull$iv = allTemplates;
                $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (TemplateContextType)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getContextId(), (Object)("SQL_QUERY_" + dbms.getName()))) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            if ((templateContextType = (TemplateContextType)v1) == null) {
                Object v3;
                block4: {
                    $this$firstOrNull$iv = allTemplates;
                    $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        it = (TemplateContextType)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getContextId(), (Object)"SQL_QUERY")) continue;
                        v3 = element$iv;
                        break block4;
                    }
                    v3 = null;
                }
                templateContextType = v3;
            }
            return templateContextType;
        }

        private final DbElement getTargetObject(AnActionEvent e) {
            DasTable gridTable;
            DataGrid dataGrid;
            DataGrid dataGrid2 = dataGrid = GridUtil.getDataGrid((DataContext)e.getDataContext());
            if (dataGrid2 != null) {
                DataGrid it = dataGrid2;
                boolean bl = false;
                v1 = DataGridUtil.getDatabaseTable(it);
            } else {
                v1 = gridTable = null;
            }
            if (gridTable instanceof DbElement) {
                return (DbElement)gridTable;
            }
            DataContext dataContext = e.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
            return (DbElement)CollectionsKt.singleOrNull((Iterable)((Iterable)DatabaseContextFun.getSelectedDbElements(dataContext)));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/actions/DbContextTemplateGroup$DbContextTemplateAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "template", "Lcom/intellij/codeInsight/template/impl/TemplateImpl;", "<init>", "(Lcom/intellij/codeInsight/template/impl/TemplateImpl;)V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "getPresentableText", "", "intellij.database.impl"})
    private static final class DbContextTemplateAction
    extends DumbAwareAction {
        @NotNull
        private final TemplateImpl template;

        public DbContextTemplateAction(@NotNull TemplateImpl template) {
            Intrinsics.checkNotNullParameter((Object)template, (String)"template");
            this.template = template;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Presentation presentation = e.getPresentation();
            String string = this.template.getDescription();
            if (string == null) {
                string = "";
            }
            presentation.setText(StringUtil.capitalize((String)string));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            DbElement dbElement = Companion.getTargetObject(e);
            if (dbElement == null) {
                return;
            }
            DbElement target = dbElement;
            Project project = target.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            boolean preferExisting = DatabaseSettings.getSettings().contextTemplateTarget == DatabaseSettings.ContextTemplateTarget.APPEND_TO_EXISTING_CONSOLE;
            Editor editor2 = DbActionUtils.findOrCreateEditor(target, preferExisting);
            if (editor2 == null) {
                return;
            }
            Editor editor3 = editor2;
            DbActionUtils.moveCaretToEnd(editor3);
            editor3.putUserData(DbContextMacroBase.Companion.getDB_CONTEXT_KEY(), new SoftReference<DbElement>(target));
            TemplateEditingAdapter listener2 = new TemplateEditingAdapter(editor3){
                final /* synthetic */ Editor $editor;
                {
                    this.$editor = $editor;
                }

                public void templateFinished(Template template, boolean brokenOff) {
                    Intrinsics.checkNotNullParameter((Object)template, (String)"template");
                    this.$editor.putUserData(DbContextMacroBase.Companion.getDB_CONTEXT_KEY(), null);
                }

                public void templateCancelled(Template template) {
                    this.$editor.putUserData(DbContextMacroBase.Companion.getDB_CONTEXT_KEY(), null);
                }
            };
            TemplateManager.getInstance((Project)project2).startTemplate(editor3, (Template)this.template, (TemplateEditingListener)listener2);
        }

        @NlsSafe
        private final String getPresentableText(TemplateImpl template) {
            String string = template.getString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            return string;
        }
    }
}

