/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.lsp.core.type;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.codeInsight.typeRepresentation.psi.PyTypeRepresentationFile;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/intellij/python/lsp/core/type/PyStringTypeResolver;", "", "<init>", "()V", "resolvePyType", "Lcom/jetbrains/python/psi/types/PyType;", "anchor", "Lcom/intellij/psi/PsiElement;", "stringType", "", "intellij.python.lsp.core"})
public final class PyStringTypeResolver {
    @NotNull
    public static final PyStringTypeResolver INSTANCE = new PyStringTypeResolver();

    private PyStringTypeResolver() {
    }

    @Nullable
    public final PyType resolvePyType(@NotNull PsiElement anchor, @NotNull String stringType) {
        Ref type;
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Intrinsics.checkNotNullParameter((Object)stringType, (String)"stringType");
        if (StringsKt.isBlank((CharSequence)stringType) || Intrinsics.areEqual((Object)stringType, (Object)"Unknown")) {
            return null;
        }
        TypeEvalContext codeInsightFallback = TypeEvalContext.codeInsightFallback((Project)anchor.getProject());
        QualifiedName qualifiedName = QualifiedName.fromDottedString((String)stringType);
        Intrinsics.checkNotNullExpressionValue((Object)qualifiedName, (String)"fromDottedString(...)");
        QualifiedName qualifiedName2 = qualifiedName;
        TypeEvalContext typeEvalContext = TypeEvalContext.codeInsightFallback((Project)anchor.getProject());
        String[] stringArray = new String[]{"builtins"};
        if (qualifiedName2.matchesPrefix(QualifiedName.fromComponents((String[])stringArray))) {
            QualifiedName qualifiedName3 = qualifiedName2.removeHead(1);
            Intrinsics.checkNotNullExpressionValue((Object)qualifiedName3, (String)"removeHead(...)");
            QualifiedName builtinClassName = qualifiedName3;
            if (builtinClassName.getComponentCount() == 1) {
                PyBuiltinCache pyBuiltinCache = PyBuiltinCache.Companion.getInstance(anchor);
                String string = builtinClassName.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                PyClass builtinClass = pyBuiltinCache.getClass(string);
                if (builtinClass != null) {
                    return (PyType)builtinClass.getType(codeInsightFallback);
                }
            }
        }
        PsiFile psiFile = FileContextUtil.getContextFile((PsiElement)anchor);
        if (psiFile == null) {
            return null;
        }
        PsiFile file = psiFile;
        PyExpression pyExpression = new PyTypeRepresentationFile(stringType, (PsiElement)file).getType();
        if (pyExpression == null) {
            return null;
        }
        PyExpression typeExpression = pyExpression;
        Ref ref = type = PyTypingTypeProvider.getTypeForTypeHint((PyExpression)typeExpression, (TypeEvalContext)codeInsightFallback);
        return ref != null ? (PyType)ref.get() : null;
    }
}

