/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.ruff.codeinsight;

import com.intellij.codeInsight.navigation.actions.GotoDeclarationHandlerBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.paths.WebReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.python.ruff.codeinsight.RuffDocumentationUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.toml.lang.psi.TomlFile;
import org.toml.lang.psi.TomlKeySegment;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a8\u0006\n"}, d2={"Lcom/intellij/python/ruff/codeinsight/RuffConfigOptionGotoDeclarationHandler;", "Lcom/intellij/codeInsight/navigation/actions/GotoDeclarationHandlerBase;", "<init>", "()V", "getGotoDeclarationTarget", "Lcom/intellij/psi/PsiElement;", "sourceElement", "editor", "Lcom/intellij/openapi/editor/Editor;", "handleTomlFile", "intellij.python.ruff"})
public final class RuffConfigOptionGotoDeclarationHandler
extends GotoDeclarationHandlerBase {
    @Nullable
    public PsiElement getGotoDeclarationTarget(@Nullable PsiElement sourceElement, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (sourceElement == null) {
            return null;
        }
        if (!(sourceElement.getContainingFile() instanceof TomlFile)) {
            return null;
        }
        return this.handleTomlFile(sourceElement);
    }

    private final PsiElement handleTomlFile(PsiElement sourceElement) {
        PsiFile psiFile = sourceElement.getContainingFile();
        TomlFile tomlFile = psiFile instanceof TomlFile ? (TomlFile)psiFile : null;
        if (tomlFile == null) {
            return null;
        }
        TomlFile file = tomlFile;
        if (!RuffDocumentationUtilKt.isRuffConfigFile(file)) {
            return null;
        }
        PsiElement psiElement = sourceElement.getParent();
        TomlKeySegment tomlKeySegment = psiElement instanceof TomlKeySegment ? (TomlKeySegment)psiElement : null;
        if (tomlKeySegment == null) {
            return null;
        }
        TomlKeySegment keySegment = tomlKeySegment;
        String string = RuffDocumentationUtilKt.ruffConfigPath(keySegment);
        if (string == null) {
            return null;
        }
        String configPath = string;
        String formattedPath = ((CharSequence)configPath).length() == 0 ? "top-level" : StringsKt.replace$default((String)configPath, (String)".", (String)"_", (boolean)false, (int)4, null);
        String url = "https://docs.astral.sh/ruff/settings/#" + formattedPath;
        return new WebReference((PsiElement)keySegment, url).resolve();
    }
}

