/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.ruff.codeinsight;

import com.intellij.markdown.utils.doc.DocMarkdownToHtmlConverter;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.python.ruff.RuffRuleInfo;
import com.intellij.python.ruff.codeinsight.RuffDocumentationUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.toml.lang.psi.TomlArray;
import org.toml.lang.psi.TomlKeySegment;
import org.toml.lang.psi.TomlKeyValue;
import org.toml.lang.psi.TomlLiteral;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eJ\n\u0010\u0014\u001a\u00020\u0012*\u00020\u0015J\u0015\u0010\u0016\u001a\u00070\u000e\u00a2\u0006\u0002\b\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0018\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lcom/intellij/python/ruff/codeinsight/RuffDocumentationUtil;", "", "<init>", "()V", "CODE_PATTERN", "Lkotlin/text/Regex;", "getCODE_PATTERN", "()Lkotlin/text/Regex;", "RUFF_LINTER_PATTERN", "getRUFF_LINTER_PATTERN", "SUPPRESSION_PATTERN", "getSUPPRESSION_PATTERN", "ERROR_CODE_ARRAY_KEYS", "", "", "getERROR_CODE_ARRAY_KEYS", "()Ljava/util/List;", "isRuffErrorCode", "", "code", "isRuffCodeElement", "Lorg/toml/lang/psi/TomlLiteral;", "formatRuleDocumentationHint", "Lcom/intellij/openapi/util/NlsSafe;", "ruleInfo", "Lcom/intellij/python/ruff/RuffRuleInfo;", "formatRuleDocumentation", "project", "Lcom/intellij/openapi/project/Project;", "intellij.python.ruff"})
@SourceDebugExtension(value={"SMAP\nRuffDocumentationUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuffDocumentationUtil.kt\ncom/intellij/python/ruff/codeinsight/RuffDocumentationUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n1586#2:109\n1661#2,3:110\n*S KotlinDebug\n*F\n+ 1 RuffDocumentationUtil.kt\ncom/intellij/python/ruff/codeinsight/RuffDocumentationUtil\n*L\n37#1:109\n37#1:110,3\n*E\n"})
public final class RuffDocumentationUtil {
    @NotNull
    public static final RuffDocumentationUtil INSTANCE;
    @NotNull
    private static final Regex CODE_PATTERN;
    @NotNull
    private static final Regex RUFF_LINTER_PATTERN;
    @NotNull
    private static final Regex SUPPRESSION_PATTERN;
    @NotNull
    private static final List<String> ERROR_CODE_ARRAY_KEYS;

    private RuffDocumentationUtil() {
    }

    @NotNull
    public final Regex getCODE_PATTERN() {
        return CODE_PATTERN;
    }

    @NotNull
    public final Regex getRUFF_LINTER_PATTERN() {
        return RUFF_LINTER_PATTERN;
    }

    @NotNull
    public final Regex getSUPPRESSION_PATTERN() {
        return SUPPRESSION_PATTERN;
    }

    @NotNull
    public final List<String> getERROR_CODE_ARRAY_KEYS() {
        return ERROR_CODE_ARRAY_KEYS;
    }

    public final boolean isRuffErrorCode(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        return CODE_PATTERN.matches((CharSequence)code);
    }

    public final boolean isRuffCodeElement(@NotNull TomlLiteral $this$isRuffCodeElement) {
        String configPath;
        Intrinsics.checkNotNullParameter((Object)$this$isRuffCodeElement, (String)"<this>");
        PsiElement psiElement = $this$isRuffCodeElement.getParent();
        TomlArray tomlArray = psiElement instanceof TomlArray ? (TomlArray)psiElement : null;
        if (tomlArray == null) {
            return false;
        }
        TomlArray array = tomlArray;
        PsiElement psiElement2 = array.getParent();
        TomlKeyValue tomlKeyValue = psiElement2 instanceof TomlKeyValue ? (TomlKeyValue)psiElement2 : null;
        if (tomlKeyValue == null) {
            return false;
        }
        TomlKeyValue keyValue = tomlKeyValue;
        PsiElement[] psiElementArray = keyValue.getKey().getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
        Object object = ArraysKt.last((Object[])psiElementArray);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.toml.lang.psi.TomlKeySegment");
        String string = RuffDocumentationUtilKt.ruffConfigPath((TomlKeySegment)object);
        if (string == null) {
            string = "";
        }
        return ERROR_CODE_ARRAY_KEYS.contains(configPath = string) || new Regex("lint\\.(extend-)?per-file-ignores\\..*").matches((CharSequence)configPath);
    }

    @Nls
    @NotNull
    public final String formatRuleDocumentationHint(@NotNull RuffRuleInfo ruleInfo) {
        Intrinsics.checkNotNullParameter((Object)ruleInfo, (String)"ruleInfo");
        return "<b>" + ruleInfo.getName() + "</b>: " + ruleInfo.getCode() + "<br>" + ruleInfo.getSummary();
    }

    @Nls
    @NotNull
    public final String formatRuleDocumentation(@NotNull RuffRuleInfo ruleInfo, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)ruleInfo, (String)"ruleInfo");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return DocMarkdownToHtmlConverter.convert$default((Project)project, (String)(StringsKt.trimIndent((String)("\n      # " + ruleInfo.getName() + " (" + ruleInfo.getCode() + ")\n      Derived from the **" + ruleInfo.getLinter() + "** linter.\n      \n      ")) + ruleInfo.getExplanation()), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        INSTANCE = new RuffDocumentationUtil();
        CODE_PATTERN = new Regex("[A-Z]+[0-9]{3}");
        RUFF_LINTER_PATTERN = new Regex("[A-Z]+");
        SUPPRESSION_PATTERN = new Regex("# (?:ruff: )?noqa: ?([A-Z]+[0-9]{3}(?:, ?([A-Z]+[0-9]{3}))*)?");
        Object[] objectArray = new String[]{"select", "ignore", "fixable", "unfixable", "extend-fixable", "extend-safe-fixes", "extend-select", "extend-unsafe-fixes", "extend-ignore"};
        Iterable $this$map$iv = SetsKt.setOf((Object[])objectArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add("lint." + (String)it);
        }
        ERROR_CODE_ARRAY_KEYS = (List)var3_3;
    }
}

