/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.ruff.codeinsight;

import com.intellij.codeInsight.hints.declarative.HintFormat;
import com.intellij.codeInsight.hints.declarative.HintMarginPadding;
import com.intellij.codeInsight.hints.declarative.InlayHintsCollector;
import com.intellij.codeInsight.hints.declarative.InlayHintsProvider;
import com.intellij.codeInsight.hints.declarative.InlayPosition;
import com.intellij.codeInsight.hints.declarative.InlayTreeSink;
import com.intellij.codeInsight.hints.declarative.InlineInlayPosition;
import com.intellij.codeInsight.hints.declarative.PresentationTreeBuilder;
import com.intellij.codeInsight.hints.declarative.SharedBypassCollector;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.python.ruff.RuffRuleInfo;
import com.intellij.python.ruff.RuffService;
import com.intellij.python.ruff.codeinsight.RuffDocumentationUtil;
import com.jetbrains.python.PyTokenTypes;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/python/ruff/codeinsight/RuffSuppressionInlayHintsProvider;", "Lcom/intellij/codeInsight/hints/declarative/InlayHintsProvider;", "<init>", "()V", "createCollector", "Lcom/intellij/codeInsight/hints/declarative/InlayHintsCollector;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "Collector", "intellij.python.ruff"})
public final class RuffSuppressionInlayHintsProvider
implements InlayHintsProvider {
    @NotNull
    public InlayHintsCollector createCollector(@NotNull PsiFile file, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return (InlayHintsCollector)new Collector();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/python/ruff/codeinsight/RuffSuppressionInlayHintsProvider$Collector;", "Lcom/intellij/codeInsight/hints/declarative/SharedBypassCollector;", "<init>", "()V", "hintFormat", "Lcom/intellij/codeInsight/hints/declarative/HintFormat;", "getHintFormat", "()Lcom/intellij/codeInsight/hints/declarative/HintFormat;", "collectFromElement", "", "element", "Lcom/intellij/psi/PsiElement;", "sink", "Lcom/intellij/codeInsight/hints/declarative/InlayTreeSink;", "processComment", "comment", "Lcom/intellij/psi/PsiComment;", "intellij.python.ruff"})
    @SourceDebugExtension(value={"SMAP\nRuffSuppressionInlayHintsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuffSuppressionInlayHintsProvider.kt\ncom/intellij/python/ruff/codeinsight/RuffSuppressionInlayHintsProvider$Collector\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,54:1\n30#2,2:55\n*S KotlinDebug\n*F\n+ 1 RuffSuppressionInlayHintsProvider.kt\ncom/intellij/python/ruff/codeinsight/RuffSuppressionInlayHintsProvider$Collector\n*L\n42#1:55,2\n*E\n"})
    private static final class Collector
    implements SharedBypassCollector {
        @NotNull
        private final HintFormat hintFormat = HintFormat.Companion.getDefault().withHorizontalMargin(HintMarginPadding.MarginAndSmallerPadding);

        @NotNull
        public final HintFormat getHintFormat() {
            return this.hintFormat;
        }

        public void collectFromElement(@NotNull PsiElement element, @NotNull InlayTreeSink sink) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            if (element instanceof PsiComment && Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)element), (Object)PyTokenTypes.END_OF_LINE_COMMENT)) {
                this.processComment((PsiComment)element, sink);
            }
        }

        private final void processComment(PsiComment comment, InlayTreeSink sink) {
            String commentText = comment.getText();
            Regex regex = RuffDocumentationUtil.INSTANCE.getSUPPRESSION_PATTERN();
            Intrinsics.checkNotNull((Object)commentText);
            MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)commentText, (int)0, (int)2, null);
            if (matchResult == null || (matchResult = matchResult.getGroups().get(1)) == null) {
                return;
            }
            MatchResult matcher = matchResult;
            for (MatchResult match : Regex.findAll$default((Regex)RuffDocumentationUtil.INSTANCE.getCODE_PATTERN(), (CharSequence)matcher.getValue(), (int)0, (int)2, null)) {
                String code = match.getValue();
                Project project = comment.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                ComponentManager $this$service$iv = (ComponentManager)project;
                boolean $i$f$service = false;
                Class<RuffService> serviceClass$iv = RuffService.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                Object object2 = ((RuffService)object).getRuleInformation().get(code);
                if (object2 == null || (object2 = ((RuffRuleInfo)object2).getName()) == null) {
                    return;
                }
                Object ruleName = object2;
                InlayTreeSink.addPresentation$default((InlayTreeSink)sink, (InlayPosition)((InlayPosition)new InlineInlayPosition(PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)comment)) + matcher.getRange().getFirst() + match.getRange().getLast() + 1, false, 0, 4, null)), null, null, (HintFormat)this.hintFormat, arg_0 -> Collector.processComment$lambda$0((String)ruleName, arg_0), (int)6, null);
            }
        }

        private static final Unit processComment$lambda$0(String $ruleName, PresentationTreeBuilder $this$addPresentation) {
            Intrinsics.checkNotNullParameter((Object)$this$addPresentation, (String)"$this$addPresentation");
            PresentationTreeBuilder.text$default((PresentationTreeBuilder)$this$addPresentation, (String)$ruleName, null, (int)2, null);
            return Unit.INSTANCE;
        }
    }
}

