/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.ruff.codeinsight.actions;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.python.lsp.core.PyLspUsageCollector;
import com.intellij.python.ruff.RuffBundle;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0003H\u0017J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J!\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0096\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/python/ruff/codeinsight/actions/RuffDisableRuleForFileIntentionAction;", "Lcom/intellij/codeInsight/intention/impl/BaseIntentionAction;", "ruleCode", "", "<init>", "(Ljava/lang/String;)V", "getFamilyName", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "invoke", "", "intellij.python.ruff"})
@SourceDebugExtension(value={"SMAP\nRuffDisableRuleForFileIntentionAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuffDisableRuleForFileIntentionAction.kt\ncom/intellij/python/ruff/codeinsight/actions/RuffDisableRuleForFileIntentionAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n1586#2:62\n1661#2,3:63\n*S KotlinDebug\n*F\n+ 1 RuffDisableRuleForFileIntentionAction.kt\ncom/intellij/python/ruff/codeinsight/actions/RuffDisableRuleForFileIntentionAction\n*L\n43#1:62\n43#1:63,3\n*E\n"})
public final class RuffDisableRuleForFileIntentionAction
extends BaseIntentionAction {
    @NotNull
    private final String ruleCode;

    public RuffDisableRuleForFileIntentionAction(@NotNull String ruleCode) {
        Intrinsics.checkNotNullParameter((Object)ruleCode, (String)"ruleCode");
        this.ruleCode = ruleCode;
        this.setText(RuffBundle.INSTANCE.message("intention.name.disable.for.this.file", new Object[0]));
    }

    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        return RuffBundle.INSTANCE.message("intention.family.name.disable.ruff.rule.for.entire.file", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) throws IncorrectOperationException {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PyLspUsageCollector.Companion.logDisableRule(project, true);
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        String string = document2.getLineCount() > 0 ? document2.getText(new TextRange(0, document2.getLineEndOffset(0))) : "";
        Intrinsics.checkNotNull((Object)string);
        String firstLineText = string;
        Regex noqaCommentRegex = new Regex("#\\s*ruff:\\s*noqa:\\s*(.*?)(#|$)");
        MatchResult matchResult = Regex.find$default((Regex)noqaCommentRegex, (CharSequence)firstLineText, (int)0, (int)2, null);
        if (matchResult != null) {
            void $this$mapTo$iv$iv;
            String[] stringArray = new String[]{","};
            PsiFile[] $this$map$iv = (PsiFile[])StringsKt.split$default((CharSequence)((CharSequence)matchResult.getGroupValues().get(1)), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            PsiFile[] psiFileArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
            }
            List existingRuleCodes = (List)destination$iv$iv;
            if (!existingRuleCodes.contains(this.ruleCode)) {
                String updatedRuleCodes = CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)existingRuleCodes, (Object)this.ruleCode), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
                String updatedComment = "# ruff: noqa: " + updatedRuleCodes;
                psiFileArray = new PsiFile[]{file};
                WriteCommandAction.runWriteCommandAction((Project)project, (String)RuffBundle.INSTANCE.message("command.name.append.ruff.rule.to.noqa.comment", new Object[0]), null, () -> RuffDisableRuleForFileIntentionAction.invoke$lambda$1(document2, matchResult, updatedComment), (PsiFile[])psiFileArray);
            }
        } else {
            String comment = "# ruff: noqa: " + this.ruleCode + "\n";
            PsiFile[] psiFileArray = new PsiFile[]{file};
            WriteCommandAction.runWriteCommandAction((Project)project, (String)RuffBundle.INSTANCE.message("command.name.add.ruff.noqa.comment", new Object[0]), null, () -> RuffDisableRuleForFileIntentionAction.invoke$lambda$2(document2, comment), (PsiFile[])psiFileArray);
        }
    }

    private static final void invoke$lambda$1(Document $document, MatchResult $matchResult, String $updatedComment) {
        $document.replaceString($matchResult.getRange().getFirst(), $matchResult.getRange().getLast() + 1, (CharSequence)$updatedComment);
    }

    private static final void invoke$lambda$2(Document $document, String $comment) {
        $document.insertString(0, (CharSequence)$comment);
    }
}

