/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.generator;

import com.intellij.indexing.shared.generator.IndexedFileHash;
import com.intellij.indexing.shared.metadata.SharedIndexMetadata;
import com.intellij.openapi.util.text.StringUtil;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u0018J,\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u00020\f0\u0019\"\u0004\b\u0000\u0010\u001a2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u00020\f0\u0019J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\fJ\n\u0010\u001e\u001a\u00020\u0005H\u0096\u0080\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lcom/intellij/indexing/shared/generator/SharedIndexBase;", "", "sharedIndexPath", "Ljava/nio/file/Path;", "sharedIndexSha256", "", "sharedIndexSize", "", "metadata", "Lcom/intellij/indexing/shared/metadata/SharedIndexMetadata;", "knownHashes", "", "Lcom/intellij/indexing/shared/generator/IndexedFileHash;", "<init>", "(Ljava/nio/file/Path;Ljava/lang/String;JLcom/intellij/indexing/shared/metadata/SharedIndexMetadata;Ljava/util/Set;)V", "getMetadata", "()Lcom/intellij/indexing/shared/metadata/SharedIndexMetadata;", "knownHashCount", "", "getKnownHashCount", "()I", "keepOnlyUnknownHashes", "", "hashes", "", "", "Y", "includeHash", "", "hash", "toString", "intellij.indexing.shared.generator"})
@SourceDebugExtension(value={"SMAP\nIndexesExporterBasesLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexesExporterBasesLoader.kt\ncom/intellij/indexing/shared/generator/SharedIndexBase\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,101:1\n507#2,7:102\n*S KotlinDebug\n*F\n+ 1 IndexesExporterBasesLoader.kt\ncom/intellij/indexing/shared/generator/SharedIndexBase\n*L\n27#1:102,7\n*E\n"})
public final class SharedIndexBase {
    @NotNull
    private final Path sharedIndexPath;
    @NotNull
    private final String sharedIndexSha256;
    private final long sharedIndexSize;
    @NotNull
    private final SharedIndexMetadata metadata;
    @NotNull
    private final Set<IndexedFileHash> knownHashes;
    private final int knownHashCount;

    public SharedIndexBase(@NotNull Path sharedIndexPath, @NotNull String sharedIndexSha256, long sharedIndexSize, @NotNull SharedIndexMetadata metadata, @NotNull Set<IndexedFileHash> knownHashes) {
        Intrinsics.checkNotNullParameter((Object)sharedIndexPath, (String)"sharedIndexPath");
        Intrinsics.checkNotNullParameter((Object)sharedIndexSha256, (String)"sharedIndexSha256");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter(knownHashes, (String)"knownHashes");
        this.sharedIndexPath = sharedIndexPath;
        this.sharedIndexSha256 = sharedIndexSha256;
        this.sharedIndexSize = sharedIndexSize;
        this.metadata = metadata;
        this.knownHashes = knownHashes;
        this.knownHashCount = this.knownHashes.size();
    }

    @NotNull
    public final SharedIndexMetadata getMetadata() {
        return this.metadata;
    }

    public final int getKnownHashCount() {
        return this.knownHashCount;
    }

    @NotNull
    public final List<IndexedFileHash> keepOnlyUnknownHashes(@NotNull Collection<IndexedFileHash> hashes) {
        Intrinsics.checkNotNullParameter(hashes, (String)"hashes");
        return CollectionsKt.minus((Iterable)hashes, (Iterable)this.knownHashes);
    }

    @NotNull
    public final <Y> Map<Y, IndexedFileHash> keepOnlyUnknownHashes(@NotNull Map<Y, IndexedFileHash> hashes) {
        Intrinsics.checkNotNullParameter(hashes, (String)"hashes");
        Map<Y, IndexedFileHash> $this$filterValues$iv = hashes;
        boolean $i$f$filterValues = false;
        LinkedHashMap<Y, IndexedFileHash> result$iv = new LinkedHashMap<Y, IndexedFileHash>();
        for (Map.Entry<Y, IndexedFileHash> entry$iv : $this$filterValues$iv.entrySet()) {
            IndexedFileHash it = entry$iv.getValue();
            boolean bl = false;
            if (!(!this.knownHashes.contains(it))) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return result$iv;
    }

    public final boolean includeHash(@NotNull IndexedFileHash hash) {
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        return this.knownHashes.contains(hash);
    }

    @NotNull
    public String toString() {
        return "SharedIndexBase(" + this.sharedIndexSha256 + ": hashes: " + this.knownHashes.size() + ", size " + StringUtil.formatFileSize((long)this.sharedIndexSize) + ", file: " + this.sharedIndexPath + ")";
    }
}

