/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.nlp.langs.Language;
import ai.grazie.nlp.similarity.Levenshtein;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.Diacritics;
import ai.grazie.rules.common.KnownPhrases;
import ai.grazie.rules.common.MultiWordSpelling;
import ai.grazie.rules.common.ProperNames;
import ai.grazie.rules.common.PunctuationTypos;
import ai.grazie.rules.en.Articles;
import ai.grazie.rules.en.EnglishParameters;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.languagetool.tools.MostlySingularMultiMap;
import org.languagetool.tools.StringTools;

class SpellingRules {
    private static final String PROPER_NAMES_SHOULD_BE_CAPITALIZED = "Proper names should be capitalized";
    private static final String GEO_MSG = "If it\u2019s a city in %s, it\u2019s usually written with diacritics";
    private static final String LOAN_MSG = "This %s-borrowed phrase usually has diacritics";
    static final String NER_GEO_LABELS = "GEO_POLITICAL_ENTITY|LOCATION";
    private static final String suffixableOrdinal = "[1-9]+\\d*";
    static final NodePattern numberWithSeparateSuffix = NodePattern.N.inFormSequence(0, "[1-9]+\\d*", "[a-z]{2}").spaceAfter().and(num -> SpellingRules.expectedSuffix(num.form()).equals(num.neighbor(1).lowForm()));
    private static final NodePattern flatDotName = NodePattern.N.noSpaceBefore().directlyAfter(CommonPatterns.dot);
    private static final MultiWordSpelling multiWord = new MultiWordSpelling(KnownPhrases.forLanguage(Language.ENGLISH)){
        final NodePattern allowSingleNodeExpansion = NodePattern.or(NodePattern.not(EnglishTreePatterns.apostropheS).noForm("is"), NodePattern.N.directlyAfter(NodePattern.N.form("macdonald").withHeadRelation("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound|root")));

        @Override
        protected boolean allowExpansion(Node start, Node lastSuggestionEnd, Node expandedEnd) {
            if (expandedEnd == lastSuggestionEnd.nextNode()) {
                return this.allowSingleNodeExpansion.matches(expandedEnd);
            }
            return super.allowExpansion(start, lastSuggestionEnd, expandedEnd);
        }
    }.popularTypo("e", "i").allowTypoFixes(NodePattern.N.form("untied|state|ice|traveler|forest|gray|get|fed|som|unite|who|humans|barrack|regan|studios|macdonald|covid|devotion"), NodePattern.N.inFormSequence(1, 2, "whom?", "it", "ma?y"), EnglishTreePatterns.startsWithApostrophe.noSpaceBefore());
    static final String aposTypos = "[\u00b4\u2032`;<>4\"!@#$%^&*()+,]";
    private static final Pattern WORD_SPLIT_PATTERN = Pattern.compile(" |(?=-)|(?<=-)");

    SpellingRules() {
    }

    static NodePattern commonTypos() {
        return NodePattern.or(PunctuationTypos.findCommonTypos("Did you mean '%s'?", Map.of("[", "p", ";", "l", ",", "m"), null), SpellingRules.mistypedDet(), SpellingRules.mistypedOr(), SpellingRules.wrongAbbreviation(), SpellingRules.wrongApostrophe(), SpellingRules.missingContractionApostrophe());
    }

    private static NodePattern wrongApostrophe() {
        String negationContractions = "(is|are|were|was|had|has|have|did|does|do|could|must|should|would|need|wo|ca|sha)n";
        String contractedAux = "(ll|s|d|m|re|ve)";
        NodePattern anotherPunct = NodePattern.or(NodePattern.N.form(negationContractions + "[\u00b4\u2032`;<>4\"!@#$%^&*()+,]t"), NodePattern.N.inFormSequence(1, negationContractions, aposTypos, "t").noSpaceAround(), NodePattern.N.form("n[\u00b4\u2032`;<>4\"!@#$%^&*()+,]t").noSpaceBefore(), NodePattern.N.form("[a-z]*[\u00b4\u2032`;<>4\"!@#$%^&*()+,]" + contractedAux).andOr(NodePattern.N.form(".s").withHeadRelation("cop|obj|case"), NodePattern.N.withHeadRelation("cop|aux|aux:pass|case|root|nsubj|nmod").noLabel(".*")).noDependents("flat(:name)?").andNot(CommonPatterns.firstToken.form("[\u00b4\u2032`;<>4\"!@#$%^&*()+,].*")).andNot(NodePattern.N.form("`s").after(NodePattern.N.form("`").spaceBefore()).trace("backtick-quoted code")), NodePattern.N.inFormSequence(1, "[a-z]*", aposTypos, contractedAux).noSpaceAround().andOr(NodePattern.N.directlyBefore(NodePattern.N.withHeadRelation("cop|aux|aux:pass")), NodePattern.N.directlyAfter(NodePattern.N.pos("PRP|WP")), NodePattern.N.directlyAfter(NodePattern.N.pos("NN.*")).noForm("[(,+]")).andNot(NodePattern.N.inFormSequence(2, "\"", ".*", "\""))).reportEverythingTouched().andNot(NodePattern.N.directlyAfter(NodePattern.PUNCT.noSpaceAfter())).andNot(NodePattern.N.noForm(".*['\u2019`\u2018].*").and(n -> n.tree().treeSupport().isAcceptedBySpellchecker(n.form()))).noForm("r&d").andOptionally(NodePattern.N.noSpaceBefore().directlyAfter(NodePattern.N.includeIntoReport())).correct(NodeCorrector.regexReplace("(.*)[\u00b4\u2032`;<>4\"!@#$%^&*()+,](.*)", "$1\u2019$2"));
        NodePattern space = NodePattern.N.inFormSequence(0, negationContractions, "t").and((node, match) -> match.withCorrector(NodeCorrector.replaceNodes(node, node.neighbor(1), node.form() + "\u2019t")));
        return NodePattern.or(anotherPunct, space).message("Did you mean an apostrophe?");
    }

    private static NodePattern wrongAbbreviation() {
        return NodePattern.or(NodePattern.N.form("~?\\d+([,.]\\d+)*ltr?").correct(NodeCorrector.regexReplace("(.*)l.*", "$1 l")), NodePattern.N.form("ltr?").directlyAfter(CommonPatterns.withNumberLikeForm).correct(NodeCorrector.replace("l"))).reportEverythingTouched().andOr(EnglishParameters.VARIANT.withValue("|US").message("The abbreviation for 'liter' is 'l'"), NodePattern.N.message("The abbreviation for 'litre' is 'l'"));
    }

    private static NodePattern missingContractionApostrophe() {
        return NodePattern.or(NodePattern.N.form("id").andOr(NodePattern.N.withHeadRelation("aux"), CommonPatterns.firstWord.directlyBefore(NodePattern.N.pos("VBN"))).and(EnglishTreePatterns.typoReplacement("I\u2019d")), NodePattern.N.form("im").andOr(NodePattern.N.withHeadRelation("cop"), NodePattern.N.directlyBefore(NodePattern.or(NodePattern.N.pos("VBG|JJ|RB"), NodePattern.N.form("gonna")))).and(EnglishTreePatterns.typoReplacement("I\u2019m")));
    }

    private static NodePattern mistypedDet() {
        return NodePattern.N.beforeHead().andOr(NodePattern.N.noPos().withHead("amod|case|compound", NodePattern.N.noDependents("det|nmod:poss").pos(".*")), NodePattern.N.noPos("DT").noForm("none").withHead("det", NodePattern.N.potentialPos("NN.*").andNot(CommonPatterns.severalDependents("det")))).andNot(NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("det"))).andNot(NodePattern.N.form("(st|nd|rd|th)").directlyAfter(CommonPatterns.withNumberLikeForm)).andNot(NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("amod|compound"))).andNot(NodePattern.N.withNextSibling(NodePattern.PUNCT)).andNot(CommonPatterns.capitalizedMiddle).noDependents().and((node, match) -> {
            if (KnownPhrases.forLanguage(Language.ENGLISH).isPartOfValidPhrase(node)) {
                return null;
            }
            ArrayList<String> determiners = new ArrayList<String>();
            determiners.add("the");
            if (node.neighbor(1).hasHeadRelation("nummod")) {
                determiners.add("only");
            }
            determiners.add(Objects.requireNonNull(node.head()).hasPos("NNP?S") ? "many" : "one");
            for (String det : determiners) {
                if (Levenshtein.WithDamerau.distance(node.lowForm(), det) != 1) continue;
                return match.withCorrector(NodeCorrector.replace(node, det)).withMessage("Did you mean '" + det + "'?");
            }
            return null;
        });
    }

    private static NodePattern mistypedOr() {
        return NodePattern.N.withHeadRelation("cc").form("o[^r]?").noDependents("fixed").and(EnglishTreePatterns.typoReplacement("or")).andOptionally(NodePattern.N.form(".").and(CommonPatterns.highlightWithTrailingSpace())).andOptionally(NodePattern.N.directlyBefore(NodePattern.N.pos("CD")).directlyAfter(NodePattern.N.pos("CD")).correct(NodeCorrector.replace("of", "to", "on"))).and((node, match) -> match.concedingToOtherGrammarCheckers());
    }

    static NodePattern properNames() {
        NodePattern dotNet = NodePattern.or(NodePattern.N.form("\\.net").markAs("DotStart"), NodePattern.N.form("net").and(flatDotName).directlyAfter(NodePattern.N.markAs("DotStart")).andNot(NodePattern.N.withNeighbor(-2, CommonPatterns.letterWord.noSpaceAfter())));
        NodePattern multiWord = NodePattern.or(SpellingRules.ensureCapitalized("Chrome|Chromium").directlyBefore(NodePattern.N.form("\\d+|browser")), NodePattern.or(dotNet.directlyBefore(NodePattern.N.form("framework")).andNot(NodePattern.N.formCaseSensitive(".*NET").directlyBefore(NodePattern.N.formCaseSensitive("Framework"))).correct(NodeCorrector.replaceNodes(NodePointer.marked("DotStart"), NodePointer.neighbor(1), " .NET Framework")), dotNet.formCaseSensitive(".*Net").correct(NodeCorrector.replaceNodes(NodePointer.marked("DotStart"), NodePointer.anchor(), " .NET"))).message("Did you mean .NET Framework?"), CommonPatterns.googleProducts("Did you mean '%s'?"), NodePattern.N.form("apple").directlyBefore(NodePattern.or(NodePattern.N.form("id").markAs("D"), NodePattern.N.form("i").directlyBefore(NodePattern.N.form("d").markAs("D")))).andNot(NodePattern.N.formCaseSensitive("Apple").directlyBefore(NodePattern.N.formCaseSensitive("ID"))).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.marked("D"), "Apple ID")).message("Did you mean Apple ID?"), NodePattern.N.formCaseSensitive("apple").and(CommonPatterns.beforeSkipping(NodePattern.N.lemma("'s"), NodePattern.N.form("carplay|tv|products?|iphones?|ipads?|devices?|id|apps?|ceo|logo|revenues?|headquarters?|offices?|cloud|(mac)?os|computers?|silicon|fans?|stores?|hardware|developers?|stock|airpods|founders?|chargers?|launch(ed|es|ing)?|users?|employees?|releas(es|ed|ing)|software|ecosystem|mobile|engineers?|customers?|tablets?|platforms?|accounts?|laptops?|brands?|(smart)?phones?|login|profits?|(web)?site|mails?|germany|cell|technology|retail|app|system|mac|quicktime|safari|resellers?|repair|genius|upgrades?|macbooks?|icloud|jobs?|keyboard|news|nasdaq|newsroom|online|refurbished|support|updates?|usb|screen|thunderbolt|lightning|dividends?|events?|emails?|education|siri|security"))).correct(NodeCorrector.replace("Apple")).message("Did you mean the Apple corporation?"), NodePattern.N.form("macs?").noFormCaseSensitive("Macs?|MACs?").noLabel("PERSON").andNot(NodePattern.N.directlyBefore(NodePattern.or(NodePattern.N.form("salad|cosmetics?|lipsticks?|address(es)?|spoof(ing|ers?|s|ed)?|os|books?|(sub)?layers?|protocols?"), CommonPatterns.capitalized, NodePattern.N.inFormSequence(0, "and|&|n", "cheese"), CommonPatterns.HYPHEN_NODE.noSpaceBefore()))).andNot(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.form("big"))).correct(NodeCorrector.regexReplace("mac", "Mac")).message("Did you mean Mac computer?"));
        NodePattern softwareNameContext = NodePattern.or(NodePattern.N.directlyAfter(NodePattern.N.lemma("install|download|try|use|on|learn|study")), NodePattern.N.directlyBefore(NodePattern.N.lemma("skill|page|plugin|browser|doc|channel|program|bot|chat")));
        NodePattern caseDetOrCop = NodePattern.or(NodePattern.N.pos("DT|IN"), NodePattern.N.lemma("be").pos("VB[ZD]"));
        NodePattern markdownPricing = NodePattern.or(NodePattern.N.inSentenceWith(NodePattern.N.lemma("price|pricing|sale|apparel|furniture|inventory|strategy|tactic")), NodePattern.N.directlyBefore(NodePattern.N.lemma("item|product|service|offer|offering"))).trace("markdownPricing");
        NodePattern singleWord = NodePattern.or(SpellingRules.fixWordCase("Grazie", "JetBrains Grazie").andOr(NodePattern.N.withHeadRelation("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound"), NodePattern.N.directlyAfterHead().withHead("discourse", NodePattern.N.pos("V.*")), softwareNameContext).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("\\[").noSpaceAfter())), SpellingRules.fixWordCase("IT", "the IT (Information Technology)").withDependent("det|nmod:poss", NodePattern.N.directlyBeforeHead()).andOptionally(NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("det").correct(NodeCorrector.replace("")))), SpellingRules.fixWordCase("Windows", "Microsoft Windows").andOr(NodePattern.N.directlyBefore(EnglishTreePatterns.number), NodePattern.ROOT.withDependent("case").withDependent("cop"), softwareNameContext), SpellingRules.fixWordCase("Opera", "the Opera browser").andOr(NodePattern.N.directlyBefore(EnglishTreePatterns.number), softwareNameContext), SpellingRules.languagesFileTypes(), ProperNames.fixFritzProducts.message("Fritz! products are spelled with an exclamation mark"), ProperNames.openAI.message("Did you mean the company OpenAI?"), NodePattern.N.formCaseSensitive("Googl(e[ds]?|ing)").pos("VB.*").and(CommonPatterns.possiblyConj(NodePattern.or(EnglishTreePatterns.withToMark, NodePattern.N.withDependent("aux.*|obj|obl"), NodePattern.N.directlyBefore(NodePattern.N.form("a|the"))))).andNot(CommonPatterns.firstWord).andNot(CommonPatterns.inAllCapitalizedSentence).message("The verb 'to google' should be in lower case").and(CommonPatterns.toLowerCase), CommonPatterns.possiblyConj(NodePattern.or(NodePattern.N.withHeadRelation("i?obj|obl|nsubj.*|nmod").andNot(NodePattern.N.withHead("obj", CommonPatterns.severalDependents("obj"))), NodePattern.N.withHead("compound|amod", NodePattern.N.pos("NN.*").and(CommonPatterns.skipUp("compound", NodePattern.N.withDependent("det|case|nmod:poss")))), NodePattern.ROOT.withDependent("det|case|nmod:poss"), NodePattern.N.directlyAfter(NodePattern.or(caseDetOrCop, NodePattern.N.onlyPos("JJ.*|VB[DNG]").directlyAfter(caseDetOrCop))), softwareNameContext, NodePattern.N.withDependent("cop").noDependents("aux.*"))).andNot(NodePattern.N.potentialPos("VB").directlyAfter(NodePattern.N.form("to"))).andNot(NodePattern.N.directlyBefore(CommonPatterns.HYPHEN_NODE)).andNot(NodePattern.N.directlyAfter(CommonPatterns.HYPHEN_NODE)).andOr(SpellingRules.fixWordCase("Google", "the Google search or company"), SpellingRules.fixWordCase("React", "the React JS framework").andOr(softwareNameContext, NodePattern.not(NodePattern.N.pos("VB").noHeadRelation("compound|amod"))), SpellingRules.fixWordCase("Kindle", "Amazon Kindle"), SpellingRules.fixWordCase("Excel", "Microsoft Excel"), SpellingRules.fixWordCase("Snickers", "the Snickers chocolate bar"), SpellingRules.fixWordCase("Twitter", "the social network").noPos("VB"), SpellingRules.fixWordCase("Slack", "the Slack messenger").andOr(softwareNameContext, NodePattern.N.noDependents("det").andNot(NodePattern.N.after(NodePattern.N.pos("DT")))), SpellingRules.fixWordCase("Chevy", "Chevrolet")), SpellingRules.fixWordCase("Skype", "the Skype videoconferencing tool"), SpellingRules.fixWordCase("Gradle", "the Gradle build tool").andNot(flatDotName), SpellingRules.fixWordCase("Markdown", "the formatting language").andNot(markdownPricing), SpellingRules.fixWordCase("TV", "television")).andNot(NodePattern.N.directlyAfter(NodePattern.or(EnglishTreePatterns.quotations, CommonPatterns.HYPHEN_NODE, CommonPatterns.anySlash).noSpaceAfter())).andNot(NodePattern.N.directlyBefore(NodePattern.or(EnglishTreePatterns.quotations, CommonPatterns.HYPHEN_NODE, CommonPatterns.anySlash).noSpaceBefore())).andNot(CommonPatterns.hashtag);
        return NodePattern.or(multiWord, singleWord);
    }

    private static NodePattern languagesFileTypes() {
        Pattern fileTypeRegex = Pattern.compile("(pdf|html|xml|css|gif|php|jsonl?|sql|xsl|yaml)(s?)", 2);
        NodePattern ftHead = NodePattern.N.lemma("file|source|inspection|analysis");
        NodePattern langHead = NodePattern.or(ftHead, NodePattern.N.lemma("language|program|code|script|codebase|library|framework|specification|ides?"));
        Set<String> popularLangs = Set.of("ABAP", "ALGOL", "APL", "ActionScript", "Ada", "Agda", "Alice", "Apex", "Blockly", "C", "COBOL", "Chapel", "Clojure", "CoffeeScript", "Coq", "Crystal", "Curry", "D", "Dart", "Delphi", "Dylan", "Eiffel", "Elixir", "Elm", "Erlang", "F", "Fortran", "Go", "Groovy", "Haskell", "Haxe", "Idris", "Isabelle", "J", "Java", "JavaScript", "Julia", "K", "Kotlin", "LabVIEW", "Lean", "Lisp", "LiveScript", "Logo", "Lua", "MATLAB", "Maple", "Mathematica", "Nim", "OCaml", "Oberon", "PHP", "Pascal", "Perl", "PostScript", "PowerShell", "Prolog", "PureScript", "Python", "Q", "R", "Racket", "Reason", "Ruby", "Rust", "SQL", "Scala", "Scheme", "Simula", "Smalltalk", "Solidity", "Swift", "Tcl", "TeX", "TypeScript", "VHDL", "Verilog", "Wolfram", "Zig");
        return NodePattern.or(NodePattern.N.form(fileTypeRegex.pattern()).noFormCaseSensitive("[A-Z]{3,4}[sS]?").andOr(NodePattern.N.noForm("php"), NodePattern.N.withHead("amod|compound", ftHead), NodePattern.N.directlyBefore(ftHead)).and((node, match) -> {
            Matcher matcher = fileTypeRegex.matcher(node.form());
            if (!matcher.matches()) {
                throw new AssertionError();
            }
            return match.withCorrector(NodeCorrector.rawReplace(node.textRange(), matcher.group(1).toUpperCase(Locale.ROOT) + matcher.group(2)));
        }).message("File types are usually capitalized"), NodePattern.N.form(StreamEx.of(popularLangs).joining((CharSequence)"|")).andOr(NodePattern.N.withHead("amod|compound", langHead), NodePattern.N.directlyBefore(langHead)).and((node, match) -> {
            if (!popularLangs.contains(node.form())) {
                return match.withCorrectors(popularLangs.stream().filter(w -> w.equalsIgnoreCase(node.lowForm())).sorted().map(w -> NodeCorrector.rawReplace(node.textRange(), w)).toList()).withMessage("Did you mean the programming language?");
            }
            return null;
        })).andNot(NodePattern.N.noSpaceAround()).andNot(NodePattern.N.noSpaceAfter().directlyBefore(CommonPatterns.dot.noSpaceAfter().directlyBefore(NodePattern.N.form("\\p{L}.*")))).andNot(flatDotName);
    }

    private static NodePattern fixWordCase(String ideal, String whatWasMeant) {
        return NodePattern.N.form(ideal.toLowerCase(Locale.ROOT)).noFormCaseSensitive(ideal).andNot(CommonPatterns.upperCase).correct(NodeCorrector.replace(ideal)).message("Did you mean " + whatWasMeant + "?");
    }

    private static NodePattern ensureCapitalized(String ... patterns) {
        NodePattern alreadyCapitalized = NodePattern.N.formCaseSensitive(patterns[0]);
        for (int i = 1; i < patterns.length; ++i) {
            alreadyCapitalized = alreadyCapitalized.and(NodePattern.N.withNeighbor(i, NodePattern.N.formCaseSensitive(patterns[i])));
        }
        return NodePattern.N.inFormSequence(0, (String[])StreamEx.of((Object[])patterns).map(w -> w.toLowerCase(Locale.ROOT)).toArray(String.class)).and((node, match) -> {
            List ideal = IntStreamEx.range((int)0, (int)patterns.length).mapToObj(i -> StringTools.uppercaseFirstChar((String)node.neighbor(i).form())).toList();
            NodeCorrector corrector = null;
            for (int i2 = 0; i2 < patterns.length; ++i2) {
                if (node.neighbor(i2).form().equals(ideal.get(i2))) continue;
                NodeCorrector replace = NodeCorrector.replace(node.neighbor(i2), (String)ideal.get(i2));
                corrector = corrector == null ? replace : corrector.join(replace);
            }
            if (corrector == null) {
                return null;
            }
            return match.withCorrector(corrector).withMessage(PROPER_NAMES_SHOULD_BE_CAPITALIZED);
        });
    }

    static NodePattern numberEnding() {
        String regex = "([1-9]+\\d*)[a-z]{2}";
        Pattern pattern = Pattern.compile(regex);
        NodePattern wrongEnding = NodePattern.N.formCaseSensitive(regex).noFormCaseSensitive("\\d+(bn|[ap]m|yo|((da|[QRYZEPTGMkhdcm\u03bcnf])?(s|m|g|A|K|mol|cd|rad|sr|Hz|N|Pa|J|W|V|F|\u03a9|S|Wb|T|lm|lx|Bq|Sv|kat|L|l|M)|MMBtu|lux|rad|grad|pt|mp[gh]|[ndkmgt](b|hz)|ms|px|[kdcm]m|[kmhc]g|[md]l|b?hp|cc|lb|ft|hr|min|sec|[symw]|[rf]p[smhdy])|xx)").andNot(NodePattern.N.withHead(NodePattern.N.label("LOCATION"))).andNot(NodePattern.N.directlyAfter(NodePattern.or(CommonPatterns.withNumberLikeForm, NodePattern.N.form("[$\u00a3\u20ac\u00a5\u20bd]")))).and((node, match) -> {
            Matcher m = pattern.matcher(node.form());
            if (!m.matches()) {
                return null;
            }
            String number = m.group(1);
            String replacement = number + SpellingRules.expectedSuffix(number);
            if (replacement.equalsIgnoreCase(node.form())) {
                return null;
            }
            if (KnownPhrases.forLanguage(Language.ENGLISH).isPartOfValidPhrase(node)) {
                return null;
            }
            match = match.withCorrector(NodeCorrector.replace(node, replacement));
            String actualSuffix = node.form().substring(m.end(1));
            if (actualSuffix.length() == 2 && node.tree().treeSupport().tagToken(actualSuffix).hasPos("IN|CC")) {
                match = match.withCorrector(NodeCorrector.replace(node, number + " " + actualSuffix));
            }
            return match;
        }).message("Incorrect ordinal number ending");
        NodePattern separateEnding = numberWithSeparateSuffix.directlyBefore(CommonPatterns.forceConcatWithPrev).message("The ordinal suffix should go directly after the number");
        return NodePattern.or(wrongEnding, separateEnding);
    }

    static String expectedSuffix(String number) {
        return SpellingRules.expectedSuffix(Integer.parseInt(number.length() > 2 ? number.substring(number.length() - 2) : number));
    }

    static String expectedSuffix(int number) {
        int lastTwoDigits = number % 100;
        if (lastTwoDigits > 3 && lastTwoDigits < 21) {
            return "th";
        }
        return switch (lastTwoDigits % 10) {
            case 1 -> "st";
            case 2 -> "nd";
            case 3 -> "rd";
            default -> "th";
        };
    }

    private static NodePattern diacriticRegex(List<KnownPhrases.Phrase> phrases, String message) {
        NodePattern continuingNer = NodePattern.N.directlyBefore(NodePattern.N.label("GEO_POLITICAL_ENTITY|LOCATION|ORGANIZATION"));
        MostlySingularMultiMap entries = new MostlySingularMultiMap(StreamEx.of(phrases).groupingBy(SpellingRules::diacriticKey));
        return NodePattern.custom((node, match) -> {
            List candidates = entries.getList((Object)Diacritics.removeDiacritics(node.lowForm()));
            if (candidates == null) {
                return null;
            }
            for (KnownPhrases.Phrase phrase : candidates) {
                Node last;
                if (!SpellingRules.shouldCorrectDiacritics(phrase, node) || continuingNer.matches(last = node.neighbor(SpellingRules.words(phrase).length - 1))) continue;
                return match.withReportedRange(node.startOffset(), last.endOffset(), node.tree()).withCorrector(NodeCorrector.replaceNodes(node, last, phrase.phrase())).withMessage(String.format(message, phrase.source()));
            }
            return null;
        });
    }

    private static String[] words(KnownPhrases.Phrase phrase) {
        return WORD_SPLIT_PATTERN.split(phrase.phrase());
    }

    private static String diacriticKey(KnownPhrases.Phrase phrase) {
        return Diacritics.removeDiacritics(SpellingRules.words(phrase)[0].toLowerCase(Locale.ROOT));
    }

    private static boolean shouldCorrectDiacritics(KnownPhrases.Phrase phrase, Node node) {
        Object[] words = SpellingRules.words(phrase);
        List wordsInText = ((StreamEx)node.forward().limit((long)words.length)).map(n -> n.lowForm().replace('\'', '\u2019')).toList();
        List wordsLow = StreamEx.of((Object[])words).map(s -> s.toLowerCase(Locale.ROOT)).toList();
        List bareExpected = StreamEx.of((Collection)wordsLow).map(Diacritics::removeDiacritics).toList();
        return !wordsLow.equals(wordsInText) && bareExpected.equals(wordsInText.stream().map(Diacritics::removeDiacritics).toList());
    }

    static NodePattern missingDiacritic() {
        return NodePattern.or(SpellingRules.geoDiacritics(), SpellingRules.foreignDiacriticExpressions(), multiWord.diacriticPattern("This word usually has diacritics", "This phrase usually has diacritics"));
    }

    private static NodePattern foreignDiacriticExpressions() {
        KnownPhrases knownPhrases = KnownPhrases.forLanguage(Language.ENGLISH);
        return SpellingRules.diacriticRegex(knownPhrases.phrasesFromFile(knownPhrases.diacriticsPath()), LOAN_MSG).andNot(NodePattern.or(CommonPatterns.capitalized.inFlatTree().andOr(NodePattern.N.directlyBefore(CommonPatterns.capitalized), CommonPatterns.afterSkipping(EnglishTreePatterns.apostropheS, CommonPatterns.capitalized)), NodePattern.N.label("ORGANIZATION|LOCATION|PERSON"), NodePattern.N.form("a").directlyBefore(NodePattern.or(NodePattern.N.label("ORGANIZATION|LOCATION|PRODUCT|MISC"), CommonPatterns.capitalized.inFlatTree())), CommonPatterns.upperCase, NodePattern.N.lemma("resume").andOr(Articles.nounWithoutDeterminer.andNot(CommonPatterns.lowerCase.directlyAfter(NodePattern.N.pos("DT|PRP\\$"))), NodePattern.N.noPos("NN"), EnglishTreePatterns.compound, NodePattern.N.directlyAfter(NodePattern.N.form("to"))), NodePattern.N.form("nee").andNot(NodePattern.N.directlyBefore(NodePattern.N.label("PERSON"))), NodePattern.N.inFormSequence(0, "cr[\u00e8e]me", "fraiche"), NodePattern.N.inFormSequence(0, "caf[\u00e8e]", "latte|cremes?")));
    }

    private static NodePattern geoDiacritics() {
        NodePattern singleWordUnlabeled = NodePattern.custom((node, match) -> node.nerLabel() == null && match.correctors().stream().allMatch(c -> c.calcChangeRange().end() <= node.endOffset()) ? match : null);
        return CommonPatterns.capitalized.andOr(NodePattern.N.label(NER_GEO_LABELS).andNot(NodePattern.N.directlyAfter(NodePattern.N.label("GEO_POLITICAL_ENTITY|LOCATION|ORGANIZATION"))), NodePattern.N.noLabel(".*").noPos().directlyBefore(CommonPatterns.capitalized.noPos()).andNot(NodePattern.N.directlyAfter(CommonPatterns.capitalized))).noDependents(".*", NodePattern.N.inFormSequence(1, "[ea]t", "al")).noHeadRelation("nummod|dep").noDependents("det").andNot(NodePattern.N.inFormSequence(2, "kingdom", "of", "god")).andNot(NodePattern.N.form("Que").inSentenceWith(NodePattern.N.form("canada|montr[\u00e9e]al"))).and(SpellingRules.diacriticRegex(KnownPhrases.forLanguage(Language.ENGLISH).phrasesFromFile(KnownPhrases.forLanguage(Language.ENGLISH).geoDiacriticsPath()), GEO_MSG)).andNot(singleWordUnlabeled).andNot(NodePattern.N.formCaseSensitive("[A-Z]{2,4}"));
    }

    static NodePattern multiWord() {
        return NodePattern.or(SpellingRules.misspelledColloquial(), SpellingRules.honorific(), multiWord.nonDiacriticPattern("Did you mean '%s'?", "The standard spelling is '%s'").andNot(NodePattern.N.inFormSequence(0, "intellij", "ideal", "plugin")).andNot(NodePattern.N.inFormSequence(0, "london", EnglishTreePatterns.apostropheS.getFormRegex(), "underground").withNeighbor(3, NodePattern.N.pos("NN.*"))).andNot(NodePattern.N.inFormSequence(0, "Google", "and")).andNot(NodePattern.N.inFormSequence(0, "anda", "luc[i\u00ed]a")).andNot(NodePattern.N.inFormSequence(0, "in", "the", "mean", "time").withNeighbor(3, NodePattern.N.noHeadRelation("obl"))).andNot(NodePattern.N.inFormSequence(0, "visual", "studios").directlyAfter(NodePattern.N.potentialPos("JJ.*|VBN"))).andNot(NodePattern.N.form("andalucia").noLabel(NER_GEO_LABELS)).noFormCaseSensitive("[Uu]s").andNot(NodePattern.N.inFormSequence(0, "open", "office").andOr(NodePattern.N.inFlatTree().after(NodePattern.N.pos("DT")), NodePattern.N.withNeighbor(1, NodePattern.N.withDependent("det(:poss)?")), NodePattern.N.withNeighbor(2, NodePattern.N.pos("NNS?").noLemma("program(me)?|software|tool|file|project|template|format|document|download|plugin|(present|install)ation|calc|draw|writer|online|portable|alternative|(spread)?sheet")))).andNot(NodePattern.N.inFormSequence(0, ".*", "-", "Asian|American|European|African|Australian|Russian")).noForm("macs|gota").andNot(NodePattern.N.directlyBefore(NodePattern.N.form("sea").andOr(NodePattern.N.directlyBefore(NodePattern.N.pos("NN.*")), NodePattern.N.withNeighbor(-2, NodePattern.N.pos("DT|RB").noForm("the"))))).andNot(NodePattern.N.inFormSequence(0, "you", "track").andNot(CommonPatterns.capitalizedMiddle)).andNot(NodePattern.N.formCaseSensitive("Google").directlyBefore(EnglishTreePatterns.apostropheS)));
    }

    private static NodePattern misspelledColloquial() {
        return NodePattern.or(NodePattern.N.form("gon|wan").noSpaceAfter().directlyBefore(NodePattern.N.form("['\u2019`\u2018]")).and((node, match) -> {
            String replacement = node.hasForm("gon") ? "gonna" : "wanna";
            return match.withCorrector(NodeCorrector.replaceNodes(node, node.neighbor(1), replacement)).withMessage("Did you mean '" + replacement + "'?");
        }), NodePattern.N.form("goann?a|gona?").andNot(NodePattern.N.inFormSequence(0, "gon", "na")).and(EnglishTreePatterns.typoReplacement("gonna")), NodePattern.N.form("duno").and(EnglishTreePatterns.typoReplacement("dunno")), NodePattern.N.form("goatta").and(EnglishTreePatterns.typoReplacement("gotta")), NodePattern.N.form("leme").and(EnglishTreePatterns.typoReplacement("lemme")), NodePattern.N.form("ott?a").and(EnglishTreePatterns.typoReplacement("outta")), NodePattern.N.form("w[ao]na|wonna").and(EnglishTreePatterns.typoReplacement("wanna")));
    }

    private static NodePattern honorific() {
        return NodePattern.N.form("(mr|dr|lt|mr?s|mme|mlle|pres|prof|sen)").andNot(CommonPatterns.capitalized).and(CommonPatterns.beforeSkipping(CommonPatterns.dot, CommonPatterns.capitalized.andNot(CommonPatterns.upperCase))).and(CommonPatterns.capitalize).message("The honorific should be capitalized");
    }
}

