/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.PsiColumn;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.ComputedInsertPolicy;
import com.intellij.sql.inspections.IdentityInsertPolicy;
import com.intellij.sql.inspections.SqlInsertIntoGeneratedColumnInspection;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.inspections.SqlInspectionUtilsKt;
import com.intellij.sql.psi.SqlBatchBlock;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlInsertDmlInstruction;
import com.intellij.sql.psi.SqlInsertOverridingClause;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSetStatement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlPsiUtilKt;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/intellij/sql/inspections/SqlInsertIntoGeneratedColumnInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "<init>", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "SurroundWithSetIdentityFix", "intellij.database.sql.impl"})
public final class SqlInsertIntoGeneratedColumnInspection
extends SqlInspectionBase {
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        ComputedInsertPolicy computedPolicy = SqlInspectionUtilsKt.getComputedInsertPolicy((Dbms)dbms2);
        IdentityInsertPolicy identityPolicy = SqlInspectionUtilsKt.getIdentityInsertPolicy((Dbms)dbms2);
        if (computedPolicy == ComputedInsertPolicy.ALWAYS && identityPolicy == IdentityInsertPolicy.ALWAYS) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result, computedPolicy, identityPolicy, onTheFly){
            final /* synthetic */ ComputedInsertPolicy $computedPolicy;
            final /* synthetic */ IdentityInsertPolicy $identityPolicy;
            final /* synthetic */ boolean $onTheFly;
            {
                this.$computedPolicy = $computedPolicy;
                this.$identityPolicy = $identityPolicy;
                this.$onTheFly = $onTheFly;
                super($manager, (SqlLanguageDialect)$dialect, (Collection)$result);
            }

            public void visitSqlInsertStatement(SqlInsertStatement o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                SqlInsertDmlInstruction sqlInsertDmlInstruction = o.getDmlInstruction();
                if (sqlInsertDmlInstruction == null) {
                    return;
                }
                SqlInsertDmlInstruction dmlInstruction = sqlInsertDmlInstruction;
                SqlTableColumnsList columnsList = dmlInstruction.getColumnsList();
                SqlTableType targetType = dmlInstruction.getTargetType();
                int n = targetType.getColumnCount();
                for (int index = 0; index < n; ++index) {
                    PsiColumn column;
                    Object object;
                    PsiElement psiElement = targetType.getColumnElement(index);
                    SqlReferenceExpression sqlReferenceExpression = psiElement instanceof SqlReferenceExpression ? (SqlReferenceExpression)psiElement : null;
                    if (sqlReferenceExpression != null) {
                        PsiElement it = psiElement = sqlReferenceExpression;
                        boolean bl = false;
                        object = PsiTreeUtil.isAncestor((PsiElement)((PsiElement)columnsList), (PsiElement)it, (boolean)true) ? psiElement : null;
                    } else {
                        object = null;
                    }
                    PsiElement columnRef = object;
                    PsiElement psiElement2 = targetType.getSourceColumnElement(index);
                    if ((psiElement2 instanceof PsiColumn ? (PsiColumn)psiElement2 : null) == null) continue;
                    column = column;
                    if (SqlImplUtil.isComputedVal((DasColumn)((DasColumn)column))) {
                        this.checkComputed((SqlReferenceExpression)columnRef, dmlInstruction, index);
                        continue;
                    }
                    if (!SqlImplUtil.isAutoVal((DasColumn)((DasColumn)column))) continue;
                    this.checkIdentity(column, (SqlReferenceExpression)columnRef, dmlInstruction, index);
                }
            }

            private final void checkComputed(SqlReferenceExpression columnRef, SqlInsertDmlInstruction dmlInstruction, int index) {
                switch (createAnnotationVisitor.WhenMappings.$EnumSwitchMapping$0[this.$computedPolicy.ordinal()]) {
                    case 1: {
                        String string = SqlBundle.message((String)"inspection.message.insertion.into.generated.column.not.supported", (Object[])new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        this.reportOnColumnOrTableRef(string, columnRef, dmlInstruction);
                        break;
                    }
                    case 2: {
                        String string = SqlBundle.message((String)"inspection.message.only.default.may.be.inserted.into.generated.column", (Object[])new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        this.checkDefault(string, dmlInstruction, index, columnRef);
                        break;
                    }
                    case 3: {
                        return;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }

            private final void checkDefault(@InspectionMessage String message, SqlInsertDmlInstruction dmlInstruction, int index, SqlReferenceExpression columnRef) {
                SqlValuesExpression sqlValuesExpression = dmlInstruction.getValuesExpression();
                if (sqlValuesExpression != null && (sqlValuesExpression = sqlValuesExpression.getExpressions()) != null) {
                    Iterable $this$forEach$iv = (Iterable)sqlValuesExpression;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        boolean isDefaultExpr;
                        SqlExpression it = (SqlExpression)element$iv;
                        boolean bl = false;
                        Object object = it instanceof SqlExpressionList ? (SqlExpressionList)it : null;
                        SqlExpression columnExpr = object != null && (object = object.getExpressionList()) != null ? (SqlExpression)CollectionsKt.getOrNull((List)object, (int)index) : null;
                        boolean bl2 = isDefaultExpr = columnExpr instanceof SqlLiteralExpression && Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)((SqlLiteralExpression)columnExpr).getFirstChild()), (Object)SqlCommonKeywords.SQL_DEFAULT);
                        if (columnExpr == null || isDefaultExpr) continue;
                        createAnnotationVisitor.1.reportIssue$default(this, (SqlElement)columnExpr, message, ProblemHighlightType.GENERIC_ERROR, null, 8, null);
                    }
                }
                if (columnRef != null) {
                    createAnnotationVisitor.1.reportIssue$default(this, (SqlElement)columnRef, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null, 8, null);
                }
            }

            private final void checkIdentity(PsiColumn column, SqlReferenceExpression columnRef, SqlInsertDmlInstruction dmlInstruction, int index) {
                String string = SqlBundle.message((String)"inspection.message.insertion.into.identity.autoincrement.column.not.supported", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String errorMessage = string;
                switch (createAnnotationVisitor.WhenMappings.$EnumSwitchMapping$1[this.$identityPolicy.ordinal()]) {
                    case 1: {
                        this.reportOnColumnOrTableRef(errorMessage, columnRef, dmlInstruction);
                        break;
                    }
                    case 2: {
                        if (columnRef == null || this.hasSetIdentityInsert(dmlInstruction)) {
                            return;
                        }
                        this.reportIssue((SqlElement)columnRef, errorMessage, ProblemHighlightType.GENERIC_ERROR, SurroundWithSetIdentityFix.INSTANCE);
                        break;
                    }
                    case 3: {
                        if (PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)dmlInstruction), SqlInsertOverridingClause.class) != null) {
                            return;
                        }
                        if (!this.isForcedAutoVal(column)) {
                            return;
                        }
                        String string2 = SqlBundle.message((String)"inspection.message.only.default.may.be.inserted.into.identity.autoincrement.column", (Object[])new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                        this.checkDefault(string2, dmlInstruction, index, columnRef);
                        break;
                    }
                    case 4: {
                        return;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }

            /*
             * WARNING - void declaration
             */
            private final boolean isForcedAutoVal(PsiColumn $this$isForcedAutoVal) {
                boolean bl;
                block7: {
                    Object v1;
                    block6: {
                        void $this$firstOrNull$iv;
                        if (!($this$isForcedAutoVal instanceof SqlColumnDefinition)) {
                            return false;
                        }
                        JBIterable jBIterable = SqlImplUtil.sqlChildren((PsiElement)((PsiElement)$this$isForcedAutoVal));
                        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"sqlChildren(...)");
                        Iterable iterable = (Iterable)jBIterable;
                        boolean $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            PsiElement it = (PsiElement)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)it), (Object)SqlCompositeElementTypes.SQL_COLUMN_GENERATED_AS_IDENTITY_CLAUSE)) continue;
                            v1 = element$iv;
                            break block6;
                        }
                        v1 = null;
                    }
                    PsiElement psiElement = v1;
                    if (psiElement == null) {
                        return false;
                    }
                    PsiElement identityClause = psiElement;
                    JBIterable jBIterable = SqlImplUtil.sqlChildren((PsiElement)identityClause);
                    Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"sqlChildren(...)");
                    Iterable $this$any$iv = (Iterable)jBIterable;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            PsiElement it = (PsiElement)element$iv;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)it), (Object)SqlCommonKeywords.SQL_ALWAYS)) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                }
                return bl;
            }

            private final boolean hasSetIdentityInsert(SqlInsertDmlInstruction dmlInstruction) {
                PsiElement currentContext = dmlInstruction.getParent();
                while (currentContext != null && !(currentContext instanceof SqlBatchBlock) && !(currentContext instanceof SqlFile)) {
                    Object v1;
                    block3: {
                        JBIterable jBIterable = SqlImplUtil.revSiblingsNoDummy((PsiElement)currentContext);
                        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"revSiblingsNoDummy(...)");
                        Iterable $this$firstOrNull$iv = (Iterable)jBIterable;
                        boolean $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            PsiElement it = (PsiElement)element$iv;
                            boolean bl = false;
                            Intrinsics.checkNotNull((Object)it);
                            if (!this.isSetIdentityInsert(it, dmlInstruction)) continue;
                            v1 = element$iv;
                            break block3;
                        }
                        v1 = null;
                    }
                    PsiElement setClause = v1;
                    if (setClause != null) {
                        return Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)setClause.getLastChild()), (Object)SqlCommonKeywords.SQL_ON);
                    }
                    currentContext = SqlImplUtil.sqlParent((PsiElement)currentContext);
                }
                return false;
            }

            private final boolean isSetIdentityInsert(PsiElement element, SqlInsertDmlInstruction dmlInstruction) {
                if (!(element instanceof SqlSetStatement)) {
                    return false;
                }
                PsiElement psiElement = ((SqlSetStatement)element).getFirstChild();
                if (psiElement == null) {
                    return false;
                }
                PsiElement anchor = psiElement;
                PsiElement psiElement2 = PsiTreeUtil.findSiblingForward((PsiElement)anchor, (IElementType)((IElementType)SqlCommonKeywords.SQL_IDENTITY_INSERT), (boolean)true, null);
                if (psiElement2 == null) {
                    return false;
                }
                PsiElement identityInsert = psiElement2;
                PsiElement psiElement3 = PsiTreeUtil.findSiblingForward((PsiElement)identityInsert, (IElementType)((IElementType)SqlCompositeElementTypes.SQL_TABLE_REFERENCE), (boolean)true, null);
                SqlReferenceExpression sqlReferenceExpression = psiElement3 instanceof SqlReferenceExpression ? (SqlReferenceExpression)psiElement3 : null;
                if (sqlReferenceExpression == null) {
                    return false;
                }
                SqlReferenceExpression tableRef = sqlReferenceExpression;
                SqlExpression sqlExpression = dmlInstruction.getTargetExpression();
                SqlReferenceExpression sqlReferenceExpression2 = sqlExpression instanceof SqlReferenceExpression ? (SqlReferenceExpression)sqlExpression : null;
                if (sqlReferenceExpression2 == null) {
                    return false;
                }
                SqlReferenceExpression insertTableRef = sqlReferenceExpression2;
                PsiElement psiElement4 = tableRef.resolve();
                if (psiElement4 == null) {
                    return false;
                }
                PsiElement affectedTable = psiElement4;
                PsiElement psiElement5 = insertTableRef.resolve();
                if (psiElement5 == null) {
                    return false;
                }
                PsiElement insertTable = psiElement5;
                return Intrinsics.areEqual((Object)affectedTable, (Object)insertTable);
            }

            private final void reportOnColumnOrTableRef(@InspectionMessage String message, SqlReferenceExpression columnRef, SqlInsertDmlInstruction dmlInstruction) {
                SqlExpression anchor;
                SqlReferenceExpression sqlReferenceExpression = columnRef;
                SqlExpression sqlExpression = anchor = sqlReferenceExpression != null ? (SqlExpression)sqlReferenceExpression : dmlInstruction.getTargetExpression();
                if (anchor != null) {
                    createAnnotationVisitor.1.reportIssue$default(this, (SqlElement)anchor, message, ProblemHighlightType.GENERIC_ERROR, null, 8, null);
                }
            }

            private final void reportIssue(SqlElement element, @InspectionMessage String message, ProblemHighlightType level, LocalQuickFix fix) {
                this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)element, message, fix, level, this.$onTheFly));
            }

            static /* synthetic */ void reportIssue$default(createAnnotationVisitor.1 var0, SqlElement sqlElement, String string, ProblemHighlightType problemHighlightType, LocalQuickFix localQuickFix, int n, Object object) {
                if ((n & 8) != 0) {
                    localQuickFix = null;
                }
                var0.reportIssue(sqlElement, string, problemHighlightType, localQuickFix);
            }
        };
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/inspections/SqlInsertIntoGeneratedColumnInspection$SurroundWithSetIdentityFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.database.sql.impl"})
    public static final class SurroundWithSetIdentityFix
    implements LocalQuickFix,
    DumbAware {
        @NotNull
        public static final SurroundWithSetIdentityFix INSTANCE = new SurroundWithSetIdentityFix();

        private SurroundWithSetIdentityFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message((String)"intention.family.name.surround.with.set.identity.insert", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            SqlInsertStatement sqlInsertStatement = (SqlInsertStatement)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), SqlInsertStatement.class);
            if (sqlInsertStatement == null) {
                return;
            }
            SqlInsertStatement insertStatement = sqlInsertStatement;
            SqlInsertDmlInstruction sqlInsertDmlInstruction = insertStatement.getDmlInstruction();
            if (sqlInsertDmlInstruction == null || (sqlInsertDmlInstruction = sqlInsertDmlInstruction.getTargetExpression()) == null) {
                return;
            }
            SqlInsertDmlInstruction targetExpression = sqlInsertDmlInstruction;
            PsiElement psiElement = insertStatement.getParent();
            if (psiElement == null) {
                return;
            }
            PsiElement parent = psiElement;
            PsiFile file = parent.getContainingFile();
            PsiElement psiElement2 = PsiTreeUtil.skipWhitespacesForward((PsiElement)((PsiElement)insertStatement));
            LeafPsiElement leafPsiElement = psiElement2 instanceof LeafPsiElement ? (LeafPsiElement)psiElement2 : null;
            if (leafPsiElement != null) {
                PsiElement it = psiElement2 = leafPsiElement;
                boolean bl = false;
                object = Intrinsics.areEqual((Object)it.getText(), (Object)DbSqlUtil.getDelimiterAt((PsiFile)file, (int)insertStatement.getTextOffset())) ? psiElement2 : null;
            } else {
                object = null;
            }
            PsiElement delimiter = object;
            SqlLanguageDialectEx dialect = SqlPsiUtilKt.getSqlDialect((PsiElement)((PsiElement)file));
            DdlBuilder builder = new DdlBuilder().configureBuilder(project, (SqlLanguageDialect)dialect).withDialect(dialect.getDatabaseDialect());
            String string = builder.keyword("SET IDENTITY_INSERT ").plain(targetExpression.getText()).keyword(" ON").getStatement();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStatement(...)");
            String setOnText = string;
            builder.clear();
            String string2 = builder.keyword("SET IDENTITY_INSERT ").plain(targetExpression.getText()).keyword(" OFF").getStatement();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStatement(...)");
            String setOffText = string2;
            SqlStatement sqlStatement = SqlPsiElementFactory.createStatementFromText((String)setOnText, (SqlLanguageDialect)((SqlLanguageDialect)dialect), (Project)project, null);
            Intrinsics.checkNotNull((Object)sqlStatement);
            SqlStatement it = sqlStatement;
            boolean bl = false;
            PsiElement setOnStatement = parent.addBefore((PsiElement)it, (PsiElement)insertStatement);
            SqlStatement sqlStatement2 = SqlPsiElementFactory.createStatementFromText((String)setOffText, (SqlLanguageDialect)((SqlLanguageDialect)dialect), (Project)project, null);
            Intrinsics.checkNotNull((Object)sqlStatement2);
            SqlStatement it2 = sqlStatement2;
            boolean bl2 = false;
            PsiElement psiElement3 = (PsiElement)it2;
            PsiElement psiElement4 = delimiter;
            if (psiElement4 == null) {
                psiElement4 = insertStatement;
            }
            PsiElement setOffStatement = parent.addAfter(psiElement3, psiElement4);
            if (delimiter != null) {
                parent.addAfter(delimiter, setOnStatement);
                parent.addAfter(delimiter, setOffStatement);
            }
        }
    }
}

