/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.unattendedHost.connection;

import com.intellij.codeWithMe.ClientId;
import com.intellij.idea.AppMode;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.remoteController.UnattendedHostPasswordUtil;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rdserver.startup.SecureClientData;
import com.jetbrains.rdserver.unattendedHost.connection.Token;
import com.jetbrains.rdserver.unattendedHost.connection.UnattendedHostTokenService$StoredPasswordData$;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ByteArraySerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 \u001e2\u00020\u0001:\u0003\u001e\u001f B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nJ\b\u0010\u0010\u001a\u00020\bH\u0002J\u0006\u0010\u0011\u001a\u00020\nJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\fJ\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006!"}, d2={"Lcom/jetbrains/rdserver/unattendedHost/connection/UnattendedHostTokenService;", "", "<init>", "()V", "storedPassword", "Lcom/jetbrains/rdserver/unattendedHost/connection/UnattendedHostTokenService$StoredPasswordData;", "currentTokenRef", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/jetbrains/rdserver/unattendedHost/connection/Token;", "lastClientFingerprintToUseValidToken", "", "lastClientIdToUseValidToken", "Lcom/intellij/codeWithMe/ClientId;", "setLocalTestToken", "", "token", "createSingleUseConnectionToken", "createOrGetSingleUseConnectionToken", "verifySingleUseConnectionToken", "", "data", "Lcom/jetbrains/rdserver/startup/SecureClientData;", "hasClientUsedValidTokenPreviously", "wasClientJoinedViaToken", "client", "hasPassword", "getHasPassword", "()Z", "createPasswordRequest", "Lcom/jetbrains/rdserver/unattendedHost/connection/UnattendedHostTokenService$PasswordRequest;", "Companion", "PasswordRequest", "StoredPasswordData", "intellij.platform.remoteController.backend"})
@SourceDebugExtension(value={"SMAP\nUnattendedHostTokenService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnattendedHostTokenService.kt\ncom/jetbrains/rdserver/unattendedHost/connection/UnattendedHostTokenService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,149:1\n1#2:150\n13#3:151\n*S KotlinDebug\n*F\n+ 1 UnattendedHostTokenService.kt\ncom/jetbrains/rdserver/unattendedHost/connection/UnattendedHostTokenService\n*L\n30#1:151\n*E\n"})
public final class UnattendedHostTokenService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private StoredPasswordData storedPassword;
    @NotNull
    private final AtomicReference<Token> currentTokenRef;
    @Nullable
    private String lastClientFingerprintToUseValidToken;
    @Nullable
    private ClientId lastClientIdToUseValidToken;
    @NotNull
    private static final Json mapper = JsonKt.Json$default(null, UnattendedHostTokenService::mapper$lambda$0, (int)1, null);
    @NotNull
    private static final Logger logger;

    public UnattendedHostTokenService() {
        Path pathToStoredPassword = PathManager.getConfigDir().resolve("cwm-passwd");
        String passwordInEnv = System.getenv("CWM_HOST_PASSWORD");
        CharSequence charSequence = passwordInEnv;
        if (!(charSequence == null || charSequence.length() == 0)) {
            StoredPasswordData data;
            logger.info("Setting new RemoteDev password from env vav");
            charSequence = UnattendedHostPasswordUtil.INSTANCE.hashPasswordCreateSalt(passwordInEnv);
            byte[] hash = (byte[])charSequence.component1();
            byte[] salt = (byte[])charSequence.component2();
            this.storedPassword = data = new StoredPasswordData(1, hash, salt);
            File file = pathToStoredPassword.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            FilesKt.writeText$default((File)file, (String)mapper.encodeToString((SerializationStrategy)StoredPasswordData.Companion.serializer(), (Object)data), null, (int)2, null);
        } else {
            Intrinsics.checkNotNull((Object)pathToStoredPassword);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(pathToStoredPassword, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                logger.info("Loading RemoteDev password from " + pathToStoredPassword);
                DeserializationStrategy deserializationStrategy = (DeserializationStrategy)StoredPasswordData.Companion.serializer();
                File file = pathToStoredPassword.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                StoredPasswordData storedData = (StoredPasswordData)mapper.decodeFromString(deserializationStrategy, FilesKt.readText$default((File)file, null, (int)1, null));
                if (storedData.getVersion() == 1) {
                    this.storedPassword = storedData;
                }
            }
        }
        this.currentTokenRef = new AtomicReference<Object>(null);
    }

    public final void setLocalTestToken(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        if (!AppMode.isRemoteDevHost()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.currentTokenRef.set(new Token(token));
    }

    private final Token createSingleUseConnectionToken() {
        if (!AppMode.isRemoteDevHost()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return new Token(string);
    }

    @NotNull
    public final String createOrGetSingleUseConnectionToken() {
        if (!AppMode.isRemoteDevHost()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Token token = this.currentTokenRef.get();
        if (token != null) {
            Token it = token;
            boolean bl = false;
            return it.getToken();
        }
        Token token2 = this.createSingleUseConnectionToken();
        Token oldToken = this.currentTokenRef.compareAndExchange(null, token2);
        Token token3 = oldToken;
        if (token3 == null) {
            token3 = token2;
        }
        return token3.getToken();
    }

    public final boolean verifySingleUseConnectionToken(@NotNull SecureClientData data) {
        byte[] tokenBytes;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Token currentToken = this.currentTokenRef.get();
        String string = data.getSingleUseToken();
        if (string != null) {
            String string2 = string;
            byte[] byArray = string2.getBytes(Charsets.UTF_8);
            v2 = byArray;
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        } else {
            v2 = tokenBytes = null;
        }
        if (currentToken == null || tokenBytes == null) {
            return false;
        }
        if (MessageDigest.isEqual(tokenBytes, currentToken.getTokenBytes())) {
            this.currentTokenRef.compareAndSet(currentToken, null);
            this.lastClientFingerprintToUseValidToken = data.getClientFingerprint();
            this.lastClientIdToUseValidToken = data.getClientId();
            return true;
        }
        return false;
    }

    public final boolean hasClientUsedValidTokenPreviously(@NotNull SecureClientData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return Intrinsics.areEqual((Object)data.getClientFingerprint(), (Object)this.lastClientFingerprintToUseValidToken);
    }

    public final boolean wasClientJoinedViaToken(@NotNull ClientId client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        return Intrinsics.areEqual((Object)client, (Object)this.lastClientIdToUseValidToken);
    }

    public final boolean getHasPassword() {
        return this.storedPassword != null;
    }

    @Nullable
    public final PasswordRequest createPasswordRequest() {
        PasswordRequest passwordRequest;
        StoredPasswordData storedPasswordData = this.storedPassword;
        if (storedPasswordData != null) {
            StoredPasswordData tph = storedPasswordData;
            boolean bl = false;
            Pair pair = UnattendedHostPasswordUtil.INSTANCE.hashPasswordCreateSalt(tph.getHash());
            byte[] targetHash = (byte[])pair.component1();
            byte[] newSalt = (byte[])pair.component2();
            passwordRequest = new PasswordRequest(targetHash, tph.getSalt(), newSalt);
        } else {
            passwordRequest = null;
        }
        return passwordRequest;
    }

    private static final Unit mapper$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setPrettyPrint(true);
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(UnattendedHostTokenService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        UnattendedHostTokenService.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rdserver/unattendedHost/connection/UnattendedHostTokenService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rdserver/unattendedHost/connection/UnattendedHostTokenService;", "mapper", "Lkotlinx/serialization/json/Json;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.remoteController.backend"})
    @SourceDebugExtension(value={"SMAP\nUnattendedHostTokenService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnattendedHostTokenService.kt\ncom/jetbrains/rdserver/unattendedHost/connection/UnattendedHostTokenService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,149:1\n30#2,2:150\n*S KotlinDebug\n*F\n+ 1 UnattendedHostTokenService.kt\ncom/jetbrains/rdserver/unattendedHost/connection/UnattendedHostTokenService$Companion\n*L\n23#1:150,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final UnattendedHostTokenService getInstance() {
            ComponentManager $this$service$iv = (ComponentManager)ApplicationKt.getApplication();
            boolean $i$f$service = false;
            Class<UnattendedHostTokenService> serviceClass$iv = UnattendedHostTokenService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (UnattendedHostTokenService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/unattendedHost/connection/UnattendedHostTokenService$PasswordRequest;", "", "targetResponse", "", "baseSalt", "tokenSalt", "<init>", "([B[B[B)V", "getBaseSalt", "()[B", "getTokenSalt", "checkResponse", "", "response", "intellij.platform.remoteController.backend"})
    public static final class PasswordRequest {
        @NotNull
        private final byte[] targetResponse;
        @NotNull
        private final byte[] baseSalt;
        @NotNull
        private final byte[] tokenSalt;

        public PasswordRequest(@NotNull byte[] targetResponse, @NotNull byte[] baseSalt, @NotNull byte[] tokenSalt) {
            Intrinsics.checkNotNullParameter((Object)targetResponse, (String)"targetResponse");
            Intrinsics.checkNotNullParameter((Object)baseSalt, (String)"baseSalt");
            Intrinsics.checkNotNullParameter((Object)tokenSalt, (String)"tokenSalt");
            this.targetResponse = targetResponse;
            this.baseSalt = baseSalt;
            this.tokenSalt = tokenSalt;
        }

        @NotNull
        public final byte[] getBaseSalt() {
            return this.baseSalt;
        }

        @NotNull
        public final byte[] getTokenSalt() {
            return this.tokenSalt;
        }

        public final boolean checkResponse(@NotNull byte[] response) {
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            return MessageDigest.isEqual(response, this.targetResponse);
        }
    }

    @Serializable
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0083\b\u0018\u0000 %2\u00020\u0001:\u0002$%B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB7\b\u0010\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u0007\u0010\fJ\u0014\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0096\u0082\u0004J\n\u0010\u0015\u001a\u00020\u0003H\u0096\u0080\u0004J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\n\u0010\u001a\u001a\u00020\u001bH\u00d6\u0081\u0004J%\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0001\u00a2\u0006\u0002\b#R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006&"}, d2={"Lcom/jetbrains/rdserver/unattendedHost/connection/UnattendedHostTokenService$StoredPasswordData;", "", "version", "", "hash", "", "salt", "<init>", "(I[B[B)V", "seen0", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(II[B[BLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getVersion", "()I", "getHash", "()[B", "getSalt", "equals", "", "other", "hashCode", "component1", "component2", "component3", "copy", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_platform_remoteController_backend", "$serializer", "Companion", "intellij.platform.remoteController.backend"})
    private static final class StoredPasswordData {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int version;
        @NotNull
        private final byte[] hash;
        @NotNull
        private final byte[] salt;

        public StoredPasswordData(int version, @NotNull byte[] hash, @NotNull byte[] salt) {
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
            this.version = version;
            this.hash = hash;
            this.salt = salt;
        }

        public final int getVersion() {
            return this.version;
        }

        @NotNull
        public final byte[] getHash() {
            return this.hash;
        }

        @NotNull
        public final byte[] getSalt() {
            return this.salt;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Object object2 = other;
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.jetbrains.rdserver.unattendedHost.connection.UnattendedHostTokenService.StoredPasswordData");
            StoredPasswordData cfr_ignored_0 = (StoredPasswordData)object2;
            if (this.version != ((StoredPasswordData)other).version) {
                return false;
            }
            if (!Arrays.equals(this.hash, ((StoredPasswordData)other).hash)) {
                return false;
            }
            return Arrays.equals(this.salt, ((StoredPasswordData)other).salt);
        }

        public int hashCode() {
            int result = this.version;
            result = 31 * result + Arrays.hashCode(this.hash);
            result = 31 * result + Arrays.hashCode(this.salt);
            return result;
        }

        public final int component1() {
            return this.version;
        }

        @NotNull
        public final byte[] component2() {
            return this.hash;
        }

        @NotNull
        public final byte[] component3() {
            return this.salt;
        }

        @NotNull
        public final StoredPasswordData copy(int version, @NotNull byte[] hash, @NotNull byte[] salt) {
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
            return new StoredPasswordData(version, hash, salt);
        }

        public static /* synthetic */ StoredPasswordData copy$default(StoredPasswordData storedPasswordData, int n, byte[] byArray, byte[] byArray2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = storedPasswordData.version;
            }
            if ((n2 & 2) != 0) {
                byArray = storedPasswordData.hash;
            }
            if ((n2 & 4) != 0) {
                byArray2 = storedPasswordData.salt;
            }
            return storedPasswordData.copy(n, byArray, byArray2);
        }

        @NotNull
        public String toString() {
            return "StoredPasswordData(version=" + this.version + ", hash=" + Arrays.toString(this.hash) + ", salt=" + Arrays.toString(this.salt) + ")";
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$intellij_platform_remoteController_backend(StoredPasswordData self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeIntElement(serialDesc, 0, self.version);
            output.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)ByteArraySerializer.INSTANCE, (Object)self.hash);
            output.encodeSerializableElement(serialDesc, 2, (SerializationStrategy)ByteArraySerializer.INSTANCE, (Object)self.salt);
        }

        public /* synthetic */ StoredPasswordData(int seen0, int version, byte[] hash, byte[] salt, SerializationConstructorMarker serializationConstructorMarker) {
            if (7 != (7 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)7, (SerialDescriptor)StoredPasswordData$$serializer.INSTANCE.getDescriptor());
            }
            this.version = version;
            this.hash = hash;
            this.salt = salt;
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rdserver/unattendedHost/connection/UnattendedHostTokenService$StoredPasswordData$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/jetbrains/rdserver/unattendedHost/connection/UnattendedHostTokenService$StoredPasswordData;", "intellij.platform.remoteController.backend"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<StoredPasswordData> serializer() {
                return (KSerializer)StoredPasswordData$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

