/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.task.ui;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.view.ExternalProjectsViewImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.impl.ContentImpl;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractExternalSystemToolWindowFactory
implements ToolWindowFactory,
DumbAware {
    @NotNull
    private final ProjectSystemId externalSystemId;

    protected AbstractExternalSystemToolWindowFactory(@NotNull ProjectSystemId id) {
        if (id == null) {
            AbstractExternalSystemToolWindowFactory.$$$reportNull$$$0(0);
        }
        this.externalSystemId = id;
    }

    @NotNull
    protected abstract AbstractExternalSystemSettings<?, ?, ?> getSettings(@NotNull Project var1);

    public boolean shouldBeAvailable(@NotNull Project project) {
        if (project == null) {
            AbstractExternalSystemToolWindowFactory.$$$reportNull$$$0(1);
        }
        return !this.getSettings(project).getLinkedProjectsSettings().isEmpty();
    }

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            AbstractExternalSystemToolWindowFactory.$$$reportNull$$$0(2);
        }
        if (toolWindow == null) {
            AbstractExternalSystemToolWindowFactory.$$$reportNull$$$0(3);
        }
        toolWindow.setTitle(this.externalSystemId.getReadableName());
        ContentManager contentManager = toolWindow.getContentManager();
        contentManager.addContent((Content)new ContentImpl((JComponent)this.createInitializingLabel(), "", false));
        ExternalProjectsManager.getInstance((Project)project).runWhenInitialized(() -> {
            ExternalProjectsViewImpl projectView = new ExternalProjectsViewImpl(toolWindow.getDisposable(), project, (ToolWindowEx)toolWindow, this.externalSystemId);
            ExternalProjectsManagerImpl.getInstance(project).registerView(projectView);
            ContentImpl taskContent = new ContentImpl((JComponent)((Object)projectView), "", true);
            contentManager.removeAllContents(true);
            contentManager.addContent((Content)taskContent);
        });
    }

    @NotNull
    private JLabel createInitializingLabel() {
        JLabel label = new JLabel(ExternalSystemBundle.message((String)"initializing.0.projects.data", (Object[])new Object[]{this.externalSystemId.getReadableName()}), 0);
        label.setOpaque(true);
        JLabel jLabel = label;
        if (jLabel == null) {
            AbstractExternalSystemToolWindowFactory.$$$reportNull$$$0(4);
        }
        return jLabel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/task/ui/AbstractExternalSystemToolWindowFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/task/ui/AbstractExternalSystemToolWindowFactory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createInitializingLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "shouldBeAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createToolWindowContent";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

