/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.executor.util.encoding;

import com.intellij.openapi.util.text.StringUtil;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a.\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a$\u0010\u0000\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00052\f\b\u0002\u0010\u0007\u001a\u00060\bj\u0002`\t\u001a.\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a$\u0010\n\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00052\f\b\u0002\u0010\u0007\u001a\u00060\bj\u0002`\t\u001a\u001e\u0010\n\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00022\f\b\u0002\u0010\u0007\u001a\u00060\bj\u0002`\tH\u0002\u001a0\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00012\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0018\u0010\u000b\u001a\u00020\u00022\b\u0010\u0006\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\f"}, d2={"smartEncode", "Lkotlin/Pair;", "", "keyValue", "isEncodingEnabled", "", "s", "charset", "Ljava/nio/charset/Charset;", "Lio/ktor/utils/io/charsets/Charset;", "smartDecode", "smartFormEncode", "intellij.httpClient.executor"})
public final class EncodingUtilsKt {
    @NotNull
    public static final Pair<String, String> smartEncode(@NotNull Pair<String, String> keyValue, boolean isEncodingEnabled) {
        Intrinsics.checkNotNullParameter(keyValue, (String)"keyValue");
        return TuplesKt.to((Object)EncodingUtilsKt.smartEncode$default((String)keyValue.getFirst(), isEncodingEnabled, null, 4, null), (Object)EncodingUtilsKt.smartEncode$default((String)keyValue.getSecond(), isEncodingEnabled, null, 4, null));
    }

    @NotNull
    public static final String smartEncode(@NotNull String s, boolean isEncodingEnabled, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        if (!isEncodingEnabled) {
            return s;
        }
        String decoded = EncodingUtilsKt.smartDecode(s, charset);
        String string = URLEncoder.encode(decoded, charset);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(...)");
        return string;
    }

    public static /* synthetic */ String smartEncode$default(String string, boolean bl, Charset charset, int n, Object object) {
        if ((n & 4) != 0) {
            charset = Charsets.UTF_8;
        }
        return EncodingUtilsKt.smartEncode(string, bl, charset);
    }

    @NotNull
    public static final Pair<String, String> smartDecode(@NotNull Pair<String, String> keyValue, boolean isEncodingEnabled) {
        Intrinsics.checkNotNullParameter(keyValue, (String)"keyValue");
        return TuplesKt.to((Object)EncodingUtilsKt.smartDecode$default((String)keyValue.getFirst(), isEncodingEnabled, null, 4, null), (Object)EncodingUtilsKt.smartDecode$default((String)keyValue.getSecond(), isEncodingEnabled, null, 4, null));
    }

    @NotNull
    public static final String smartDecode(@NotNull String s, boolean isEncodingEnabled, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        if (!isEncodingEnabled) {
            return s;
        }
        return EncodingUtilsKt.smartDecode(s, charset);
    }

    public static /* synthetic */ String smartDecode$default(String string, boolean bl, Charset charset, int n, Object object) {
        if ((n & 4) != 0) {
            charset = Charsets.UTF_8;
        }
        return EncodingUtilsKt.smartDecode(string, bl, charset);
    }

    private static final String smartDecode(String s, Charset charset) {
        String stringWithoutPlus = StringsKt.replace$default((String)s, (String)"+", (String)"%2B", (boolean)false, (int)4, null);
        String string = URLDecoder.decode(stringWithoutPlus, charset);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decode(...)");
        return string;
    }

    static /* synthetic */ String smartDecode$default(String string, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        return EncodingUtilsKt.smartDecode(string, charset);
    }

    @NotNull
    public static final Pair<String, String> smartFormEncode(@NotNull Pair<String, String> keyValue, boolean isEncodingEnabled) {
        Intrinsics.checkNotNullParameter(keyValue, (String)"keyValue");
        return TuplesKt.to((Object)EncodingUtilsKt.smartFormEncode((String)keyValue.getFirst(), isEncodingEnabled), (Object)EncodingUtilsKt.smartFormEncode((String)keyValue.getSecond(), isEncodingEnabled));
    }

    @NotNull
    public static final String smartFormEncode(@Nullable String s, boolean isEncodingEnabled) {
        if (s == null || !isEncodingEnabled) {
            String string = s;
            if (string == null) {
                string = "";
            }
            return string;
        }
        Object[] objectArray = new String[]{"%%", "%&", "%=", "%+"};
        List list2 = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"%25", "%26", "%3D", "%2B"};
        String string = StringUtil.replace((String)s, (List)list2, (List)CollectionsKt.listOf((Object[])objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"replace(...)");
        String ourEscapesReplaced = string;
        String decoded = URLDecoder.decode(ourEscapesReplaced, Charsets.UTF_8);
        String string2 = URLEncoder.encode(decoded, Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encode(...)");
        return string2;
    }
}

