/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.codeInsight.include;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpRequestNameSupport;
import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.httpClient.http.request.HttpRequestSearcherKt;
import com.intellij.httpClient.http.request.codeInsight.include.AddRunImportFix;
import com.intellij.httpClient.http.request.environment.HttpRequestInfoProviderKt;
import com.intellij.httpClient.http.request.psi.HttpImportBlock;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/httpClient/http/request/codeInsight/include/HttpClientRunRequestNameInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "registerProblemIfExists", "", "requestName", "Lcom/intellij/httpClient/http/request/psi/HttpRequestName;", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpClientRunRequestNameInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClientRunRequestNameInspection.kt\ncom/intellij/httpClient/http/request/codeInsight/include/HttpClientRunRequestNameInspection\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,60:1\n18#2:61\n777#3:62\n873#3,2:63\n1586#3:65\n1661#3,3:66\n37#4,2:69\n*S KotlinDebug\n*F\n+ 1 HttpClientRunRequestNameInspection.kt\ncom/intellij/httpClient/http/request/codeInsight/include/HttpClientRunRequestNameInspection\n*L\n29#1:61\n37#1:62\n37#1:63,2\n45#1:65\n45#1:66,3\n45#1:69,2\n*E\n"})
public final class HttpClientRunRequestNameInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new PsiElementVisitor(this, holder){
            final /* synthetic */ HttpClientRunRequestNameInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (!(element instanceof HttpRequestName)) {
                    return;
                }
                HttpClientRunRequestNameInspection.access$registerProblemIfExists(this.this$0, (HttpRequestName)element, this.$holder);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final void registerProblemIfExists(HttpRequestName requestName, ProblemsHolder holder) {
        void $this$toTypedArray$iv;
        Collection<AddRunImportFix> collection;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        void $this$filterTo$iv$iv;
        Project project = requestName.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        PsiFile $this$asSafely$iv = requestName.getContainingFile();
        boolean $i$f$asSafely = false;
        PsiFile psiFile = $this$asSafely$iv;
        if (!(psiFile instanceof HttpRequestPsiFile)) {
            psiFile = null;
        }
        HttpRequestPsiFile httpRequestPsiFile = (HttpRequestPsiFile)psiFile;
        if (httpRequestPsiFile == null) {
            return;
        }
        HttpRequestPsiFile file = httpRequestPsiFile;
        List<HttpImportBlock> imports = HttpRequestInfoProviderKt.getImports(file);
        List<HttpRequest> requests2 = HttpRequestInfoProviderKt.getRequestsFromImports(requestName, imports);
        if (!((Collection)requests2).isEmpty()) {
            return;
        }
        List<HttpRequest> namedRequests = HttpRequestSearcherKt.getAllNamedRequests(project2);
        String string = requestName.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String name = string;
        Iterable $this$filter$iv = namedRequests;
        boolean $i$f$filter22 = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            HttpRequest it = (HttpRequest)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)HttpRequestNameSupport.getDeclaredName(it), (Object)name)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List found = (List)destination$iv$iv;
        if (found.isEmpty()) {
            return;
        }
        Iterable $i$f$filter22 = found;
        TextRange textRange = new TextRange(1, name.length() + 1);
        ProblemHighlightType problemHighlightType = ProblemHighlightType.WEAK_WARNING;
        String string2 = RestClientBundle.message("http.client.code.style.inspection.add.run.named.request.import.message", new Object[0]);
        PsiElement psiElement = (PsiElement)requestName;
        ProblemsHolder problemsHolder = holder;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            HttpRequest bl = (HttpRequest)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            String string3 = it.getContainingFile().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            collection.add(new AddRunImportFix(string3));
        }
        collection = (List)destination$iv$iv2;
        $this$map$iv = collection;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        AddRunImportFix[] addRunImportFixArray = thisCollection$iv.toArray(new AddRunImportFix[0]);
        problemsHolder.registerProblem(psiElement, string2, problemHighlightType, textRange, (LocalQuickFix[])Arrays.copyOf(addRunImportFixArray, addRunImportFixArray.length));
    }

    public static final /* synthetic */ void access$registerProblemIfExists(HttpClientRunRequestNameInspection $this, HttpRequestName requestName, ProblemsHolder holder) {
        $this.registerProblemIfExists(requestName, holder);
    }
}

