/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.index;

import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.httpClient.http.request.HttpRequestPsiUtils;
import com.intellij.httpClient.http.request.index.HttpRequestFilesInputFilter;
import com.intellij.httpClient.http.request.psi.HttpHost;
import com.intellij.httpClient.http.request.psi.HttpPort;
import com.intellij.httpClient.http.request.psi.HttpRequestBlock;
import com.intellij.httpClient.http.request.psi.HttpRequestTarget;
import com.intellij.httpClient.http.request.psi.HttpScheme;
import com.intellij.ide.scratch.ScratchesSearchScope;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.VoidDataExternalizer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class HttpRequestHostIndex
extends FileBasedIndexExtension<String, Void> {
    public static final ID<String, Void> KEY = ID.create((String)"http.request.completion.host");

    @NotNull
    public ID<String, Void> getName() {
        ID<String, Void> iD = KEY;
        if (iD == null) {
            HttpRequestHostIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        return new DataIndexer<String, Void, FileContent>(this){

            @NotNull
            public Map<String, Void> map(@NotNull FileContent inputData) {
                PsiFile file;
                if (inputData == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!((file = inputData.getPsiFile()) instanceof HttpRequestPsiFile)) {
                    Map<String, Void> map2 = Collections.emptyMap();
                    if (map2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return map2;
                }
                HashMap<String, Void> result2 = new HashMap<String, Void>();
                for (String s : HttpRequestHostIndex.getHostNames((HttpRequestPsiFile)file)) {
                    result2.put(s, null);
                }
                HashMap<String, Void> hashMap = result2;
                if (hashMap == null) {
                    1.$$$reportNull$$$0(2);
                }
                return hashMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/httpClient/http/request/index/HttpRequestHostIndex$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/httpClient/http/request/index/HttpRequestHostIndex$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    public static Set<String> getHostNames(@NotNull HttpRequestPsiFile file) {
        if (file == null) {
            HttpRequestHostIndex.$$$reportNull$$$0(1);
        }
        return HttpRequestHostIndex.getHostNames(file, true);
    }

    public static Set<String> getHostNames(@NotNull HttpRequestPsiFile file, boolean withScheme) {
        HttpRequestBlock[] requestBlocks;
        if (file == null) {
            HttpRequestHostIndex.$$$reportNull$$$0(2);
        }
        HashSet<String> hosts = new HashSet<String>();
        for (HttpRequestBlock block : requestBlocks = HttpRequestPsiUtils.getRequestBlocks((PsiFile)file)) {
            HttpPort port;
            HttpRequestTarget target = block != null ? block.getRequest().getRequestTarget() : null;
            HttpHost host = target != null ? target.getHost() : null;
            HttpScheme scheme = target != null ? target.getScheme() : null;
            HttpPort httpPort = port = target != null ? target.getPort() : null;
            if (host == null) continue;
            hosts.add((String)(withScheme && scheme != null ? scheme.getText() + "://" : "") + host.getText() + (String)(port != null ? ":" + port.getText() : ""));
        }
        return hosts;
    }

    @NotNull
    public static Collection<String> getHostsFromIndex(@NotNull Project project) {
        if (project == null) {
            HttpRequestHostIndex.$$$reportNull$$$0(3);
        }
        GlobalSearchScope scope = ProjectScope.getContentScope((Project)project).uniteWith(ScratchesSearchScope.getScratchesScope((Project)project));
        FileBasedIndex index = FileBasedIndex.getInstance();
        Collection collection = index.getAllKeys(KEY, project).stream().filter(key -> !index.getContainingFiles(KEY, key, scope).isEmpty()).collect(Collectors.toSet());
        if (collection == null) {
            HttpRequestHostIndex.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            HttpRequestHostIndex.$$$reportNull$$$0(5);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<Void> getValueExternalizer() {
        VoidDataExternalizer voidDataExternalizer = VoidDataExternalizer.INSTANCE;
        if (voidDataExternalizer == null) {
            HttpRequestHostIndex.$$$reportNull$$$0(6);
        }
        return voidDataExternalizer;
    }

    public int getVersion() {
        return 5;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new HttpRequestFilesInputFilter();
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/index/HttpRequestHostIndex";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/index/HttpRequestHostIndex";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHostsFromIndex";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getHostNames";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getHostsFromIndex";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

