/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.info;

import com.intellij.httpClient.execution.HttpClientExecutorBundle;
import com.intellij.httpClient.http.request.HttpRequestPlaceholderUtil;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutor;
import com.intellij.httpClient.http.request.psi.HttpCommonScriptHandler;
import com.intellij.httpClient.http.request.psi.HttpPreRequestHandler;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpResponseHandler;
import com.intellij.httpClient.http.request.run.HttpClientResponseHandler;
import com.intellij.httpClient.http.request.run.HttpRequestExecutionHelperService;
import com.intellij.httpClient.http.request.run.HttpRequestPostProcessor;
import com.intellij.httpClient.http.request.run.info.HttpRunRequestInfo;
import com.intellij.httpClient.http.request.run.info.RequestHandlerProviderKt;
import com.intellij.httpClient.http.request.run.preScript.HttpClientPreRequestHandler;
import com.intellij.httpClient.http.request.run.preScript.HttpClientRequestElementsProvider;
import com.intellij.httpClient.http.request.substitutor.HttpRequestVariableSessionSubstitutor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006\u001a0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a8\u0006\r"}, d2={"httpClientRequestElementsProvider", "Lcom/intellij/httpClient/http/request/run/preScript/HttpClientRequestElementsProvider;", "requestPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/httpClient/http/request/psi/HttpRequest;", "substitutor", "Lcom/intellij/httpClient/http/request/substitutor/HttpRequestVariableSessionSubstitutor;", "createHttpRunRequestInfo", "Lcom/intellij/httpClient/http/request/run/info/HttpRunRequestInfo;", "psiRequest", "pointerToOriginalElement", "commonScriptHandler", "Lcom/intellij/httpClient/http/request/psi/HttpCommonScriptHandler;", "intellij.httpClient.executor"})
@SourceDebugExtension(value={"SMAP\nHttpRunRequestInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRunRequestInfo.kt\ncom/intellij/httpClient/http/request/run/info/HttpRunRequestInfoKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1#2:79\n*E\n"})
public final class HttpRunRequestInfoKt {
    @NotNull
    public static final HttpClientRequestElementsProvider httpClientRequestElementsProvider(@NotNull SmartPsiElementPointer<HttpRequest> requestPointer, @NotNull HttpRequestVariableSessionSubstitutor substitutor2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(requestPointer, (String)"requestPointer");
        Intrinsics.checkNotNullParameter((Object)substitutor2, (String)"substitutor");
        HttpRequest element = (HttpRequest)requestPointer.getElement();
        boolean bl2 = bl = element != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        HttpRequest httpRequest = element;
        Intrinsics.checkNotNull((Object)httpRequest);
        String string = httpRequest.getHttpMethod();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHttpMethod(...)");
        return new HttpClientRequestElementsProvider(requestPointer, substitutor2, string);
    }

    @NotNull
    public static final HttpRunRequestInfo createHttpRunRequestInfo(@NotNull HttpRequest psiRequest, @NotNull SmartPsiElementPointer<HttpRequest> pointerToOriginalElement, @NotNull HttpRequestVariableSessionSubstitutor substitutor2, @Nullable HttpCommonScriptHandler commonScriptHandler) {
        String string;
        String originalURL;
        String string2;
        Object processor;
        HttpClientResponseHandler httpClientResponseHandler;
        HttpClientPreRequestHandler httpClientPreRequestHandler;
        Intrinsics.checkNotNullParameter((Object)psiRequest, (String)"psiRequest");
        Intrinsics.checkNotNullParameter(pointerToOriginalElement, (String)"pointerToOriginalElement");
        Intrinsics.checkNotNullParameter((Object)substitutor2, (String)"substitutor");
        HttpPreRequestHandler httpPreRequestHandler = psiRequest.getPreRequestHandler();
        if (httpPreRequestHandler != null) {
            HttpPreRequestHandler it = httpPreRequestHandler;
            boolean bl = false;
            httpClientPreRequestHandler = RequestHandlerProviderKt.createPreRequestHandler(it, commonScriptHandler);
        } else {
            httpClientPreRequestHandler = null;
        }
        HttpClientPreRequestHandler preRequestHandler = httpClientPreRequestHandler;
        String string3 = psiRequest.getHttpMethod();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getHttpMethod(...)");
        String method = string3;
        HttpResponseHandler httpResponseHandler = psiRequest.getResponseHandler();
        if (httpResponseHandler != null) {
            HttpResponseHandler it = httpResponseHandler;
            boolean bl = false;
            httpClientResponseHandler = RequestHandlerProviderKt.createResponseHandler(it, pointerToOriginalElement, substitutor2, method, commonScriptHandler);
        } else {
            httpClientResponseHandler = null;
        }
        HttpClientResponseHandler responseHandler = httpClientResponseHandler;
        PsiFile file = psiRequest.getContainingFile();
        HttpRequestExecutionHelperService service = HttpRequestExecutionHelperService.getInstance();
        Object object = service;
        if (object == null || (object = object.getProcessor(file, pointerToOriginalElement)) == null) {
            object = processor = HttpRequestPostProcessor.EMPTY_PROCESSOR;
        }
        if ((string2 = psiRequest.getHttpUrl(HttpRequestVariableSubstitutor.empty())) == null) {
            string2 = originalURL = "";
        }
        if (HttpRequestPlaceholderUtil.containsPlaceholder(psiRequest)) {
            Object[] objectArray = new Object[]{originalURL};
            string = HttpClientExecutorBundle.message("http.request.placeholder.run.ignore", objectArray);
        } else {
            string = null;
        }
        String message = string;
        String string4 = psiRequest.getScheme();
        Intrinsics.checkNotNull((Object)processor);
        return new HttpRunRequestInfo(method, string4, responseHandler, preRequestHandler, (HttpRequestPostProcessor)processor, pointerToOriginalElement, message, substitutor2);
    }

    public static /* synthetic */ HttpRunRequestInfo createHttpRunRequestInfo$default(HttpRequest httpRequest, SmartPsiElementPointer smartPsiElementPointer, HttpRequestVariableSessionSubstitutor httpRequestVariableSessionSubstitutor, HttpCommonScriptHandler httpCommonScriptHandler, int n, Object object) {
        if ((n & 8) != 0) {
            httpCommonScriptHandler = null;
        }
        return HttpRunRequestInfoKt.createHttpRunRequestInfo(httpRequest, (SmartPsiElementPointer<HttpRequest>)smartPsiElementPointer, httpRequestVariableSessionSubstitutor, httpCommonScriptHandler);
    }
}

