/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.v2;

import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.httpClient.http.request.HttpRequestPsiUtils;
import com.intellij.httpClient.http.request.psi.HttpClientExecutionBlock;
import com.intellij.httpClient.http.request.psi.HttpIncludeFilePath;
import com.intellij.httpClient.http.request.psi.HttpMethod;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestBlock;
import com.intellij.httpClient.http.request.psi.HttpRequestCompositeElement;
import com.intellij.httpClient.http.request.psi.HttpRequestTarget;
import com.intellij.httpClient.http.request.psi.HttpRunBlock;
import com.intellij.httpClient.http.request.psi.HttpScheme;
import com.intellij.httpClient.http.request.run.HttpRequestActionsProvider;
import com.intellij.httpClient.http.request.run.HttpRequestLineMarkerProvider;
import com.intellij.httpClient.http.request.run.v2.CurrentMarkerInfo;
import com.intellij.httpClient.http.request.run.v2.HttpRequestRunLineMarkerV2;
import com.intellij.httpClient.http.request.run.v2.HttpRequestRunLineMarkerV2ProviderKt;
import com.intellij.httpClient.http.request.run.v2.MarkerUpdater;
import com.intellij.httpClient.http.request.run.v2.NewMarkerInfo;
import com.intellij.httpClient.http.request.run.v2.TemporaryInvalidMarkersCache;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001BC\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 J\u0012\u0010\"\u001a\u0004\u0018\u00010!2\u0006\u0010#\u001a\u00020$H\u0002J(\u0010%\u001a\u00020!2\u000e\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u00020(0'2\u0006\u0010)\u001a\u00020*2\u0006\u0010#\u001a\u00020$H\u0002J,\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00052\n\b\u0002\u0010)\u001a\u0004\u0018\u00010*2\u000e\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u00020(0'H\u0002J&\u0010.\u001a\u0018\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020(0'\u0012\u0006\u0012\u0004\u0018\u00010*0/2\u0006\u0010#\u001a\u00020$H\u0002J\u0012\u00100\u001a\u0004\u0018\u00010*2\u0006\u00101\u001a\u000202H\u0002J\u0012\u00100\u001a\u0004\u0018\u00010(2\u0006\u00103\u001a\u000204H\u0002R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\n \u001e*\u0004\u0018\u00010\u001d0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/intellij/httpClient/http/request/run/v2/HttpRequestRunLineMarkerV2InformationProvider;", "", "currentMarkers", "Ljava/util/TreeMap;", "", "Lcom/intellij/httpClient/http/request/run/v2/CurrentMarkerInfo;", "markerUpdater", "Lcom/intellij/httpClient/http/request/run/v2/MarkerUpdater;", "temporaryInvalidMarkersCache", "Lcom/intellij/httpClient/http/request/run/v2/TemporaryInvalidMarkersCache;", "file", "Lcom/intellij/httpClient/http/request/HttpRequestPsiFile;", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Ljava/util/TreeMap;Lcom/intellij/httpClient/http/request/run/v2/MarkerUpdater;Lcom/intellij/httpClient/http/request/run/v2/TemporaryInvalidMarkersCache;Lcom/intellij/httpClient/http/request/HttpRequestPsiFile;Lcom/intellij/openapi/progress/ProgressIndicator;Lcom/intellij/openapi/editor/Editor;)V", "getCurrentMarkers", "()Ljava/util/TreeMap;", "getMarkerUpdater", "()Lcom/intellij/httpClient/http/request/run/v2/MarkerUpdater;", "getTemporaryInvalidMarkersCache", "()Lcom/intellij/httpClient/http/request/run/v2/TemporaryInvalidMarkersCache;", "getFile", "()Lcom/intellij/httpClient/http/request/HttpRequestPsiFile;", "getProgress", "()Lcom/intellij/openapi/progress/ProgressIndicator;", "pointerManager", "Lcom/intellij/psi/SmartPointerManager;", "kotlin.jvm.PlatformType", "getLineMarkerInfos", "", "Lcom/intellij/httpClient/http/request/run/v2/NewMarkerInfo;", "getInfo", "block", "Lcom/intellij/httpClient/http/request/psi/HttpClientExecutionBlock;", "createNewMarker", "pointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/httpClient/http/request/psi/HttpRequestCompositeElement;", "anchor", "Lcom/intellij/psi/PsiElement;", "updateMarker", "", "existingMarker", "createPointerAndAnchor", "Lkotlin/Pair;", "anchorElement", "request", "Lcom/intellij/httpClient/http/request/psi/HttpRequest;", "runBlock", "Lcom/intellij/httpClient/http/request/psi/HttpRunBlock;", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpRequestRunLineMarkerV2Provider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRequestRunLineMarkerV2Provider.kt\ncom/intellij/httpClient/http/request/run/v2/HttpRequestRunLineMarkerV2InformationProvider\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,429:1\n12033#2,10:430\n14060#2:440\n14061#2:442\n12043#2:443\n1#3:441\n1#3:449\n1586#4:444\n1661#4,3:445\n18#5:448\n*S KotlinDebug\n*F\n+ 1 HttpRequestRunLineMarkerV2Provider.kt\ncom/intellij/httpClient/http/request/run/v2/HttpRequestRunLineMarkerV2InformationProvider\n*L\n353#1:430,10\n353#1:440\n353#1:442\n353#1:443\n353#1:441\n385#1:444\n385#1:445,3\n411#1:448\n*E\n"})
final class HttpRequestRunLineMarkerV2InformationProvider {
    @NotNull
    private final TreeMap<Integer, CurrentMarkerInfo> currentMarkers;
    @NotNull
    private final MarkerUpdater markerUpdater;
    @NotNull
    private final TemporaryInvalidMarkersCache temporaryInvalidMarkersCache;
    @NotNull
    private final HttpRequestPsiFile file;
    @NotNull
    private final ProgressIndicator progress;
    @NotNull
    private final Editor editor;
    private final SmartPointerManager pointerManager;

    public HttpRequestRunLineMarkerV2InformationProvider(@NotNull TreeMap<Integer, CurrentMarkerInfo> currentMarkers, @NotNull MarkerUpdater markerUpdater, @NotNull TemporaryInvalidMarkersCache temporaryInvalidMarkersCache, @NotNull HttpRequestPsiFile file, @NotNull ProgressIndicator progress, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter(currentMarkers, (String)"currentMarkers");
        Intrinsics.checkNotNullParameter((Object)markerUpdater, (String)"markerUpdater");
        Intrinsics.checkNotNullParameter((Object)temporaryInvalidMarkersCache, (String)"temporaryInvalidMarkersCache");
        Intrinsics.checkNotNullParameter((Object)((Object)file), (String)"file");
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.currentMarkers = currentMarkers;
        this.markerUpdater = markerUpdater;
        this.temporaryInvalidMarkersCache = temporaryInvalidMarkersCache;
        this.file = file;
        this.progress = progress;
        this.editor = editor2;
        this.pointerManager = SmartPointerManager.getInstance((Project)this.file.getProject());
    }

    @NotNull
    public final TreeMap<Integer, CurrentMarkerInfo> getCurrentMarkers() {
        return this.currentMarkers;
    }

    @NotNull
    public final MarkerUpdater getMarkerUpdater() {
        return this.markerUpdater;
    }

    @NotNull
    public final TemporaryInvalidMarkersCache getTemporaryInvalidMarkersCache() {
        return this.temporaryInvalidMarkersCache;
    }

    @NotNull
    public final HttpRequestPsiFile getFile() {
        return this.file;
    }

    @NotNull
    public final ProgressIndicator getProgress() {
        return this.progress;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<NewMarkerInfo> getLineMarkerInfos() {
        void $this$mapNotNullTo$iv$iv;
        HttpClientExecutionBlock[] blocks;
        HttpClientExecutionBlock[] httpClientExecutionBlockArray = HttpRequestPsiUtils.getExecutionBlocks((PsiFile)this.file);
        Intrinsics.checkNotNullExpressionValue((Object)httpClientExecutionBlockArray, (String)"getExecutionBlocks(...)");
        HttpClientExecutionBlock[] $this$mapNotNull$iv = blocks = httpClientExecutionBlockArray;
        boolean $i$f$mapNotNull = false;
        HttpClientExecutionBlock[] httpClientExecutionBlockArray2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            NewMarkerInfo it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void block = element$iv$iv;
            boolean bl2 = false;
            this.progress.checkCanceled();
            Intrinsics.checkNotNull((Object)block);
            if (this.getInfo((HttpClientExecutionBlock)block) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final NewMarkerInfo getInfo(HttpClientExecutionBlock block) {
        Pair<SmartPsiElementPointer<? extends HttpRequestCompositeElement>, PsiElement> pair = this.createPointerAndAnchor(block);
        SmartPsiElementPointer pointer = (SmartPsiElementPointer)pair.component1();
        PsiElement anchor = (PsiElement)pair.component2();
        Segment segment = pointer.getRange();
        if (segment == null) {
            return null;
        }
        Segment pointerRange = segment;
        CurrentMarkerInfo existingMarker = this.currentMarkers.get(pointerRange.getStartOffset());
        if (existingMarker != null && this.pointerManager.pointToTheSameElement(existingMarker.getPointer(), pointer)) {
            this.updateMarker(existingMarker, anchor, (SmartPsiElementPointer<? extends HttpRequestCompositeElement>)pointer);
            return null;
        }
        return existingMarker == null && anchor != null ? this.createNewMarker((SmartPsiElementPointer<? extends HttpRequestCompositeElement>)pointer, anchor, block) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final NewMarkerInfo createNewMarker(SmartPsiElementPointer<? extends HttpRequestCompositeElement> pointer, PsiElement anchor, HttpClientExecutionBlock block) {
        Pair pair;
        SmartPointerManager smartPointerManager = this.pointerManager;
        Intrinsics.checkNotNullExpressionValue((Object)smartPointerManager, (String)"pointerManager");
        Pair cache = this.temporaryInvalidMarkersCache.retrieveFromCache(smartPointerManager, pointer);
        if (cache != null) {
            this.pointerManager.removePointer(pointer);
            pair = cache;
        } else {
            void $this$mapTo$iv$iv;
            HttpRequestActionsProvider.HttpRequestActionsProviderStrategy httpRequestActionsProviderStrategy = HttpRequestActionsProvider.getActionsProvider();
            Intrinsics.checkNotNullExpressionValue((Object)httpRequestActionsProviderStrategy, (String)"getActionsProvider(...)");
            HttpRequestActionsProvider.HttpRequestActionsProviderStrategy strategy = httpRequestActionsProviderStrategy;
            List<AnAction> list2 = strategy.provideActions(block, CollectionsKt.emptyList());
            Intrinsics.checkNotNullExpressionValue(list2, (String)"provideActions(...)");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                AnAction anAction = (AnAction)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(HttpRequestRunLineMarkerV2ProviderKt.access$wrapAction(anchor, (AnAction)it));
            }
            List actions = (List)destination$iv$iv;
            Editor editor2 = this.editor;
            Intrinsics.checkNotNull((Object)editor2, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
            pair = TuplesKt.to(pointer, (Object)new HttpRequestRunLineMarkerV2(actions, (EditorEx)editor2, (Function0<String>)((Function0)new Function0<String>((Object)strategy){

                public final String invoke() {
                    return ((HttpRequestActionsProvider.HttpRequestActionsProviderStrategy)this.receiver).getTooltip();
                }
            })));
        }
        Pair pair2 = pair;
        SmartPsiElementPointer requestPointer = (SmartPsiElementPointer)pair2.component1();
        HttpRequestRunLineMarkerV2 marker = (HttpRequestRunLineMarkerV2)pair2.component2();
        TextRange textRange = anchor.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        return new NewMarkerInfo((SmartPsiElementPointer<? extends HttpRequestCompositeElement>)requestPointer, textRange, marker);
    }

    private final void updateMarker(CurrentMarkerInfo existingMarker, PsiElement anchor, SmartPsiElementPointer<? extends HttpRequestCompositeElement> pointer) {
        Map map2 = this.currentMarkers;
        Segment segment = pointer.getRange();
        Integer n = segment != null ? Integer.valueOf(segment.getStartOffset()) : null;
        TypeIntrinsics.asMutableMap((Object)map2).remove(n);
        if (anchor != null && !TextRange.areSegmentsEqual((Segment)((Segment)anchor.getTextRange()), (Segment)((Segment)existingMarker.getRangeHighlighter()))) {
            TextRange textRange = anchor.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            this.markerUpdater.update(existingMarker, textRange);
        }
        if (anchor == null) {
            this.temporaryInvalidMarkersCache.cache(existingMarker.getPointer(), existingMarker.getMarker());
            this.markerUpdater.remove(existingMarker, false);
        }
        this.pointerManager.removePointer(pointer);
    }

    static /* synthetic */ void updateMarker$default(HttpRequestRunLineMarkerV2InformationProvider httpRequestRunLineMarkerV2InformationProvider, CurrentMarkerInfo currentMarkerInfo, PsiElement psiElement, SmartPsiElementPointer smartPsiElementPointer, int n, Object object) {
        if ((n & 2) != 0) {
            psiElement = null;
        }
        httpRequestRunLineMarkerV2InformationProvider.updateMarker(currentMarkerInfo, psiElement, (SmartPsiElementPointer<? extends HttpRequestCompositeElement>)smartPsiElementPointer);
    }

    private final Pair<SmartPsiElementPointer<? extends HttpRequestCompositeElement>, PsiElement> createPointerAndAnchor(HttpClientExecutionBlock block) {
        HttpRequest request;
        HttpClientExecutionBlock $this$asSafely$iv = block;
        boolean $i$f$asSafely2 = false;
        HttpClientExecutionBlock httpClientExecutionBlock = $this$asSafely$iv;
        if (!(httpClientExecutionBlock instanceof HttpRequestBlock)) {
            httpClientExecutionBlock = null;
        }
        HttpRequestBlock httpRequestBlock = (HttpRequestBlock)httpClientExecutionBlock;
        HttpRequest httpRequest = request = httpRequestBlock != null ? httpRequestBlock.getRequest() : null;
        if (request != null) {
            Object object;
            SmartPsiElementPointer smartPsiElementPointer = this.pointerManager.createSmartPsiElementPointer((PsiElement)request);
            PsiElement psiElement = this.anchorElement(request);
            if (psiElement != null) {
                PsiElement psiElement2;
                PsiElement $i$f$asSafely2 = psiElement2 = psiElement;
                SmartPsiElementPointer smartPsiElementPointer2 = smartPsiElementPointer;
                boolean bl = false;
                boolean bl2 = HttpRequestLineMarkerProvider.canBeExecuted(request);
                smartPsiElementPointer = smartPsiElementPointer2;
                object = bl2 ? psiElement2 : null;
            } else {
                object = null;
            }
            return TuplesKt.to((Object)smartPsiElementPointer, object);
        }
        Intrinsics.checkNotNull((Object)block, (String)"null cannot be cast to non-null type com.intellij.httpClient.http.request.psi.HttpRunBlock");
        HttpRunBlock runBlock = (HttpRunBlock)block;
        return TuplesKt.to((Object)this.pointerManager.createSmartPsiElementPointer((PsiElement)runBlock), (Object)this.anchorElement(runBlock));
    }

    private final PsiElement anchorElement(HttpRequest request) {
        Object object;
        HttpMethod httpMethod = request.getMethod();
        if (httpMethod != null) {
            object = (PsiElement)httpMethod;
        } else {
            HttpRequestCompositeElement httpRequestCompositeElement;
            HttpRequestTarget httpRequestTarget = request.getRequestTarget();
            HttpScheme httpScheme = httpRequestTarget != null ? httpRequestTarget.getScheme() : null;
            object = httpScheme != null ? (PsiElement)httpScheme : ((httpRequestCompositeElement = request.getRequestTarget()) != null && (httpRequestCompositeElement = httpRequestCompositeElement.getHost()) != null ? httpRequestCompositeElement.getFirstChild() : null);
        }
        return object;
    }

    private final HttpRequestCompositeElement anchorElement(HttpRunBlock runBlock) {
        HttpIncludeFilePath httpIncludeFilePath = runBlock.getIncludeFilePath();
        return httpIncludeFilePath != null ? (HttpRequestCompositeElement)httpIncludeFilePath : (HttpRequestCompositeElement)runBlock.getRequestName();
    }
}

