/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.checkout;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.welcomeScreen.cloneableProjects.CloneableProjectsService;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.checkout.PerforceCloneParams;
import org.jetbrains.idea.perforce.checkout.PerforceCloneRunnerFactory;
import org.jetbrains.idea.perforce.perforce.ExecResult;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/idea/perforce/checkout/PerforceCloneTask;", "Lcom/intellij/openapi/wm/impl/welcomeScreen/cloneableProjects/CloneableProjectsService$CloneTask;", "project", "Lcom/intellij/openapi/project/Project;", "params", "Lorg/jetbrains/idea/perforce/checkout/PerforceCloneParams;", "listener", "Lcom/intellij/openapi/vcs/CheckoutProvider$Listener;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/idea/perforce/checkout/PerforceCloneParams;Lcom/intellij/openapi/vcs/CheckoutProvider$Listener;)V", "taskInfo", "Lcom/intellij/openapi/wm/impl/welcomeScreen/cloneableProjects/CloneableProjectsService$CloneTaskInfo;", "run", "Lcom/intellij/openapi/wm/impl/welcomeScreen/cloneableProjects/CloneableProjectsService$CloneStatus;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "writeP4Config", "", "targetDir", "Ljava/io/File;", "intellij.vcs.perforce"})
@SourceDebugExtension(value={"SMAP\nPerforceCloneTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerforceCloneTask.kt\norg/jetbrains/idea/perforce/checkout/PerforceCloneTask\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,100:1\n57#2:101\n35#2,2:102\n57#2:104\n35#2,2:105\n*S KotlinDebug\n*F\n+ 1 PerforceCloneTask.kt\norg/jetbrains/idea/perforce/checkout/PerforceCloneTask\n*L\n74#1:101\n74#1:102,2\n96#1:104\n96#1:105,2\n*E\n"})
public final class PerforceCloneTask
implements CloneableProjectsService.CloneTask {
    @NotNull
    private final Project project;
    @NotNull
    private final PerforceCloneParams params;
    @NotNull
    private final CheckoutProvider.Listener listener;

    public PerforceCloneTask(@NotNull Project project, @NotNull PerforceCloneParams params, @NotNull CheckoutProvider.Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.project = project;
        this.params = params;
        this.listener = listener2;
    }

    @NotNull
    public CloneableProjectsService.CloneTaskInfo taskInfo() {
        String string = PerforceBundle.message("checkout.progress.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = PerforceBundle.message("checkout.progress.cancel", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String string3 = PerforceBundle.message("checkout.task.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        String string4 = PerforceBundle.message("checkout.task.tooltip", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        String string5 = PerforceBundle.message("checkout.task.failed", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        String string6 = PerforceBundle.message("checkout.task.canceled", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
        String string7 = PerforceBundle.message("checkout.stop.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"message(...)");
        Object[] objectArray = new Object[]{this.params.getServer()};
        String string8 = PerforceBundle.message("checkout.stop.description", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"message(...)");
        return new CloneableProjectsService.CloneTaskInfo(string, string2, string3, string4, string5, string6, string7, string8);
    }

    @NotNull
    public CloneableProjectsService.CloneStatus run(@NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Object[] objectArray = new Object[]{this.params.getDirectory()};
        indicator.setText(PerforceBundle.message("checkout.progress.syncing", objectArray));
        File targetDir = new File(this.params.getDirectory());
        if (!targetDir.exists()) {
            targetDir.mkdirs();
        }
        try {
            PerforceRunner runner = PerforceCloneRunnerFactory.INSTANCE.createRunner(this.project, this.params, targetDir);
            P4File p4File = P4File.create(targetDir);
            Intrinsics.checkNotNullExpressionValue((Object)p4File, (String)"create(...)");
            P4File p4File2 = p4File;
            ExecResult result = runner.sync(p4File2, true);
            String string = result.getStderr();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStderr(...)");
            String stderr = string;
            if (result.getExitCode() != 0 && !StringsKt.isBlank((CharSequence)stderr) && !StringsKt.contains$default((CharSequence)stderr, (CharSequence)"file(s) up-to-date.", (boolean)false, (int)2, null)) {
                return CloneableProjectsService.CloneStatus.FAILURE;
            }
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(targetDir);
            if (virtualFile != null) {
                virtualFile.refresh(true, true);
            }
            this.writeP4Config(targetDir);
            this.listener.directoryCheckedOut(targetDir, PerforceVcs.getKey());
            this.listener.checkoutCompleted();
            return CloneableProjectsService.CloneStatus.SUCCESS;
        }
        catch (VcsException e) {
            String string = FileUtil.toSystemIndependentName((String)targetDir.getAbsolutePath());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
            String projectPath = string;
            boolean $i$f$fileLogger = false;
            boolean $i$f$currentClassLogger = false;
            Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
            Logger logger = Logger.getInstance(clazz$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Cannot clone project " + projectPath, (Throwable)e);
            return CloneableProjectsService.CloneStatus.FAILURE;
        }
    }

    private final void writeP4Config(File targetDir) {
        StringBuilder stringBuilder;
        File configFile = FilesKt.resolve((File)targetDir, (String)"p4config.txt");
        if (configFile.exists()) {
            return;
        }
        StringBuilder $this$writeP4Config_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$writeP4Config_u24lambda_u240.append("P4PORT=" + this.params.getServer()).append('\n');
        $this$writeP4Config_u24lambda_u240.append("P4USER=" + this.params.getUser()).append('\n');
        $this$writeP4Config_u24lambda_u240.append("P4CLIENT=" + this.params.getClient()).append('\n');
        $this$writeP4Config_u24lambda_u240.append("P4IGNORE=.p4ignore.txt;.gitignore");
        String configContent = stringBuilder.toString();
        try {
            FileUtil.writeToFile((File)configFile, (String)configContent);
        }
        catch (IOException e) {
            boolean $i$f$fileLogger = false;
            boolean $i$f$currentClassLogger = false;
            Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
            Logger logger = Logger.getInstance(clazz$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Cannot create p4config in " + targetDir, (Throwable)e);
        }
    }
}

