/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.core.fileIndex.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.EntityPointer;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.impl.indices.VirtualFileIndex;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlIndex;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.URLUtil;
import com.intellij.workspaceModel.core.fileIndex.EntityStorageKind;
import com.intellij.workspaceModel.core.fileIndex.impl.EntityChangeStorage;
import com.intellij.workspaceModel.core.fileIndex.impl.NonExistingFileSetData;
import com.intellij.workspaceModel.core.fileIndex.impl.NonExistingFileSetKind;
import com.intellij.workspaceModel.core.fileIndex.impl.NonExistingWorkspaceRootsRegistryKt;
import com.intellij.workspaceModel.core.fileIndex.impl.StoredFileSet;
import com.intellij.workspaceModel.core.fileIndex.impl.VfsChangeApplier;
import com.intellij.workspaceModel.core.fileIndex.impl.VfsChangeApplierImpl;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexDataImpl;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J&\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J,\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u00182\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u001e\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J$\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\n2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u00182\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\nJ\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u001e2\u0006\u0010\u001c\u001a\u00020\nJH\u0010\u001f\u001a\u00020\u000f\"\u0004\b\u0000\u0010 \"\u0004\b\u0001\u0010!*\u000e\u0012\u0004\u0012\u0002H \u0012\u0004\u0012\u0002H!0\t2\u0006\u0010\"\u001a\u0002H 2\u0014\b\u0004\u0010#\u001a\u000e\u0012\u0004\u0012\u0002H!\u0012\u0004\u0012\u00020%0$H\u0082\b\u00a2\u0006\u0002\u0010&J\u001e\u0010'\u001a\u0004\u0018\u00010(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\u0006\u0010,\u001a\u00020-J\u001a\u0010.\u001a\u0004\u0018\u00010\n2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\nH\u0002J:\u00102\u001a\u00020\u000f2\u0006\u00101\u001a\u00020\n2\b\u00103\u001a\u0004\u0018\u0001042\u0006\u00105\u001a\u0002062\u0006\u0010/\u001a\u0002002\u0006\u00107\u001a\u00020%2\u0006\u0010,\u001a\u00020-H\u0002J2\u00108\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\n2\b\u00103\u001a\u0004\u0018\u0001042\u0006\u00107\u001a\u00020%2\u0006\u00105\u001a\u0002062\u0006\u0010,\u001a\u00020-H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\b\u001a#\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\f0\f0\t\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/intellij/workspaceModel/core/fileIndex/impl/NonExistingWorkspaceRootsRegistry;", "", "project", "Lcom/intellij/openapi/project/Project;", "virtualFileManager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;)V", "nonExistingFiles", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "kotlin.jvm.PlatformType", "Lcom/intellij/workspaceModel/core/fileIndex/impl/NonExistingFileSetData;", "Lorg/jetbrains/annotations/NotNull;", "registerUrl", "", "root", "entity", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "storageKind", "Lcom/intellij/workspaceModel/core/fileIndex/EntityStorageKind;", "fileSetKind", "Lcom/intellij/workspaceModel/core/fileIndex/impl/NonExistingFileSetKind;", "reference", "Lcom/intellij/platform/workspace/storage/EntityPointer;", "unregisterUrl", "fileUrl", "removeUrl", "url", "getFileSetKindsFor", "", "removeValueIf", "K", "V", "key", "valuePredicate", "Lkotlin/Function1;", "", "(Lcom/intellij/util/containers/MultiMap;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "analyzeVfsChanges", "Lcom/intellij/workspaceModel/core/fileIndex/impl/VfsChangeApplier;", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "indexData", "Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileIndexDataImpl;", "getIncludingJarDirectory", "storage", "Lcom/intellij/platform/workspace/storage/EntityStorage;", "virtualFileUrl", "calculateEntityChangesIfNeeded", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "entityChanges", "Lcom/intellij/workspaceModel/core/fileIndex/impl/EntityChangeStorage;", "allRootsWereRemoved", "collectAffectedEntities", "intellij.platform.projectModel.impl"})
@SourceDebugExtension(value={"SMAP\nNonExistingWorkspaceRootsRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NonExistingWorkspaceRootsRegistry.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/NonExistingWorkspaceRootsRegistry\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,291:1\n63#1,6:292\n63#1,6:298\n1661#2,3:304\n1915#2,2:309\n1915#2,2:311\n1342#3,2:307\n*S KotlinDebug\n*F\n+ 1 NonExistingWorkspaceRootsRegistry.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/NonExistingWorkspaceRootsRegistry\n*L\n41#1:292,6\n47#1:298,6\n59#1:304,3\n143#1:309,2\n169#1:311,2\n136#1:307,2\n*E\n"})
public final class NonExistingWorkspaceRootsRegistry {
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFileUrlManager virtualFileManager;
    @NotNull
    private final MultiMap<VirtualFileUrl, NonExistingFileSetData> nonExistingFiles;

    public NonExistingWorkspaceRootsRegistry(@NotNull Project project, @NotNull VirtualFileUrlManager virtualFileManager) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFileManager, (String)"virtualFileManager");
        this.project = project;
        this.virtualFileManager = virtualFileManager;
        MultiMap multiMap = MultiMap.createConcurrent();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"createConcurrent(...)");
        this.nonExistingFiles = multiMap;
    }

    public final void registerUrl(@NotNull VirtualFileUrl root, @NotNull WorkspaceEntity entity, @NotNull EntityStorageKind storageKind, @NotNull NonExistingFileSetKind fileSetKind) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)((Object)storageKind), (String)"storageKind");
        Intrinsics.checkNotNullParameter((Object)((Object)fileSetKind), (String)"fileSetKind");
        this.registerUrl(root, (EntityPointer<? extends WorkspaceEntity>)entity.createPointer(), storageKind, fileSetKind);
    }

    public final void registerUrl(@NotNull VirtualFileUrl root, @NotNull EntityPointer<? extends WorkspaceEntity> reference, @NotNull EntityStorageKind storageKind, @NotNull NonExistingFileSetKind fileSetKind) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)((Object)storageKind), (String)"storageKind");
        Intrinsics.checkNotNullParameter((Object)((Object)fileSetKind), (String)"fileSetKind");
        this.nonExistingFiles.putValue((Object)root, (Object)new NonExistingFileSetData(reference, storageKind, fileSetKind));
    }

    /*
     * WARNING - void declaration
     */
    public final void unregisterUrl(@NotNull VirtualFileUrl fileUrl, @NotNull WorkspaceEntity entity, @NotNull EntityStorageKind storageKind) {
        void $this$removeValueIf$iv;
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)((Object)storageKind), (String)"storageKind");
        NonExistingWorkspaceRootsRegistry nonExistingWorkspaceRootsRegistry = this;
        MultiMap<VirtualFileUrl, NonExistingFileSetData> multiMap = this.nonExistingFiles;
        VirtualFileUrl key$iv = fileUrl;
        boolean $i$f$removeValueIf = false;
        Collection collection = $this$removeValueIf$iv.get((Object)key$iv);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
        Collection collection$iv = collection;
        Function1 function1 = (Function1)new Function1<NonExistingFileSetData, Boolean>(storageKind, entity){
            final /* synthetic */ EntityStorageKind $storageKind$inlined;
            final /* synthetic */ WorkspaceEntity $entity$inlined;
            {
                this.$storageKind$inlined = entityStorageKind;
                this.$entity$inlined = workspaceEntity;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Boolean invoke(Object it) {
                NonExistingFileSetData nonExistingFileSetData = (NonExistingFileSetData)it;
                boolean bl = false;
                EntityPointer<WorkspaceEntity> reference = nonExistingFileSetData.component1();
                EntityStorageKind kind = nonExistingFileSetData.component2();
                return kind == this.$storageKind$inlined && reference.isPointerTo(this.$entity$inlined);
            }
        };
        collection$iv.removeIf(new Predicate(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ boolean test(Object p0) {
                return (Boolean)this.function.invoke(p0);
            }
        });
        if (collection$iv.isEmpty()) {
            $this$removeValueIf$iv.remove((Object)key$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void unregisterUrl(@NotNull VirtualFileUrl fileUrl, @NotNull EntityPointer<? extends WorkspaceEntity> reference, @NotNull EntityStorageKind storageKind) {
        void $this$removeValueIf$iv;
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        Intrinsics.checkNotNullParameter(reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)((Object)storageKind), (String)"storageKind");
        NonExistingWorkspaceRootsRegistry nonExistingWorkspaceRootsRegistry = this;
        MultiMap<VirtualFileUrl, NonExistingFileSetData> multiMap = this.nonExistingFiles;
        VirtualFileUrl key$iv = fileUrl;
        boolean $i$f$removeValueIf = false;
        Collection collection = $this$removeValueIf$iv.get((Object)key$iv);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
        Collection collection$iv = collection;
        Function1 function1 = (Function1)new Function1<NonExistingFileSetData, Boolean>(storageKind, reference){
            final /* synthetic */ EntityStorageKind $storageKind$inlined;
            final /* synthetic */ EntityPointer $reference$inlined;
            {
                this.$storageKind$inlined = entityStorageKind;
                this.$reference$inlined = entityPointer;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Boolean invoke(Object it) {
                NonExistingFileSetData nonExistingFileSetData = (NonExistingFileSetData)it;
                boolean bl = false;
                EntityPointer<WorkspaceEntity> ref = nonExistingFileSetData.component1();
                EntityStorageKind kind = nonExistingFileSetData.component2();
                return kind == this.$storageKind$inlined && Intrinsics.areEqual(ref, (Object)this.$reference$inlined);
            }
        };
        collection$iv.removeIf(new /* invalid duplicate definition of identical inner class */);
        if (collection$iv.isEmpty()) {
            $this$removeValueIf$iv.remove((Object)key$iv);
        }
    }

    public final void removeUrl(@NotNull VirtualFileUrl url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.nonExistingFiles.remove((Object)url);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<NonExistingFileSetKind> getFileSetKindsFor(@NotNull VirtualFileUrl url) {
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Collection collection = this.nonExistingFiles.get((Object)url);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
        Collection data = collection;
        if (data.isEmpty()) {
            return SetsKt.emptySet();
        }
        Iterable iterable = data;
        EnumSet<NonExistingFileSetKind> enumSet = EnumSet.noneOf(NonExistingFileSetKind.class);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"noneOf(...)");
        Collection destination$iv = enumSet;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            NonExistingFileSetData nonExistingFileSetData = (NonExistingFileSetData)item$iv;
            Collection collection2 = destination$iv;
            boolean bl = false;
            collection2.add(it.getFileSetKind());
        }
        return (Set)destination$iv;
    }

    private final <K, V> void removeValueIf(MultiMap<K, V> $this$removeValueIf, K key, Function1<? super V, Boolean> valuePredicate) {
        boolean $i$f$removeValueIf = false;
        Collection collection = $this$removeValueIf.get(key);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
        Collection collection2 = collection;
        Function1 function1 = new Function1<V, Boolean>(valuePredicate){
            final /* synthetic */ Function1<V, Boolean> $valuePredicate;
            {
                this.$valuePredicate = $valuePredicate;
            }

            public final Boolean invoke(V it) {
                return (Boolean)this.$valuePredicate.invoke(it);
            }
        };
        collection2.removeIf(new /* invalid duplicate definition of identical inner class */);
        if (collection2.isEmpty()) {
            $this$removeValueIf.remove(key);
        }
    }

    @Nullable
    public final VfsChangeApplier analyzeVfsChanges(@NotNull List<? extends VFileEvent> events, @NotNull WorkspaceFileIndexDataImpl indexData) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        Intrinsics.checkNotNullParameter((Object)indexData, (String)"indexData");
        EntityChangeStorage entityChanges = new EntityChangeStorage();
        ImmutableEntityStorage entityStorage = WorkspaceModel.Companion.getInstance(this.project).getCurrentSnapshot();
        for (VFileEvent vFileEvent : events) {
            String newUrl;
            Pair<String, String> pair;
            String oldUrl;
            VFileEvent vFileEvent2 = vFileEvent;
            if (vFileEvent2 instanceof VFileDeleteEvent) {
                String string = ((VFileDeleteEvent)vFileEvent).getFile().getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
                this.calculateEntityChangesIfNeeded(this.virtualFileManager.getOrCreateFromUrl(string), ((VFileDeleteEvent)vFileEvent).getFile(), entityChanges, (EntityStorage)entityStorage, true, indexData);
                continue;
            }
            if (vFileEvent2 instanceof VFileCreateEvent) {
                Object object;
                String parentUrl;
                Intrinsics.checkNotNullExpressionValue((Object)((VFileCreateEvent)vFileEvent).getParent().getUrl(), (String)"getUrl(...)");
                int protocolEnd = StringsKt.indexOf$default((CharSequence)parentUrl, (String)"://", (int)0, (boolean)false, (int)6, null);
                if (protocolEnd != -1) {
                    object = StringsKt.take((String)parentUrl, (int)protocolEnd) + "://" + ((VFileCreateEvent)vFileEvent).getPath();
                } else {
                    String string = VfsUtilCore.pathToUrl((String)((VFileCreateEvent)vFileEvent).getPath());
                    Intrinsics.checkNotNull((Object)string);
                    object = string;
                }
                Object url = object;
                VirtualFileUrl virtualFileUrl = this.virtualFileManager.getOrCreateFromUrl((String)url);
                this.calculateEntityChangesIfNeeded(virtualFileUrl, null, entityChanges, (EntityStorage)entityStorage, false, indexData);
                if (!StringsKt.startsWith$default((String)url, (String)"file", (boolean)false, (int)2, null)) continue;
                if (!((VFileCreateEvent)vFileEvent).isDirectory()) {
                    String string = ((VFileCreateEvent)vFileEvent).getChildName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getChildName(...)");
                    if (!StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null)) continue;
                }
                String suffix = ((VFileCreateEvent)vFileEvent).isDirectory() ? "" : "!/";
                String jarFileUrl = "jar://" + URLUtil.urlToPath((String)url) + suffix;
                VirtualFileUrl jarVirtualFileUrl = this.virtualFileManager.getOrCreateFromUrl(jarFileUrl);
                this.calculateEntityChangesIfNeeded(jarVirtualFileUrl, null, entityChanges, (EntityStorage)entityStorage, false, indexData);
                continue;
            }
            if (vFileEvent2 instanceof VFileCopyEvent) {
                String string = VfsUtilCore.pathToUrl((String)((VFileCopyEvent)vFileEvent).getPath());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathToUrl(...)");
                this.calculateEntityChangesIfNeeded(this.virtualFileManager.getOrCreateFromUrl(string), null, entityChanges, (EntityStorage)entityStorage, false, indexData);
                continue;
            }
            if (!(vFileEvent2 instanceof VFilePropertyChangeEvent) && !(vFileEvent2 instanceof VFileMoveEvent) || Intrinsics.areEqual((Object)(oldUrl = (String)(pair = NonExistingWorkspaceRootsRegistryKt.getOldAndNewUrls(vFileEvent)).component1()), (Object)(newUrl = (String)pair.component2()))) continue;
            this.calculateEntityChangesIfNeeded(this.virtualFileManager.getOrCreateFromUrl(oldUrl), vFileEvent.getFile(), entityChanges, (EntityStorage)entityStorage, true, indexData);
            this.calculateEntityChangesIfNeeded(this.virtualFileManager.getOrCreateFromUrl(newUrl), null, entityChanges, (EntityStorage)entityStorage, false, indexData);
        }
        if (!entityChanges.hasChanges()) {
            return null;
        }
        return new VfsChangeApplierImpl(entityChanges, indexData, this, this.project);
    }

    private final VirtualFileUrl getIncludingJarDirectory(EntityStorage storage, VirtualFileUrl virtualFileUrl) {
        VirtualFileUrl parentVirtualFileUrl;
        VirtualFileUrlIndex virtualFileUrlIndex = storage.getVirtualFileUrlIndex();
        Intrinsics.checkNotNull((Object)virtualFileUrlIndex, (String)"null cannot be cast to non-null type com.intellij.platform.workspace.storage.impl.indices.VirtualFileIndex");
        Set indexedJarDirectories = ((VirtualFileIndex)virtualFileUrlIndex).getIndexedJarDirectories();
        for (parentVirtualFileUrl = virtualFileUrl; parentVirtualFileUrl != null && !indexedJarDirectories.contains(parentVirtualFileUrl); parentVirtualFileUrl = parentVirtualFileUrl.getParent()) {
        }
        return parentVirtualFileUrl != null && indexedJarDirectories.contains(parentVirtualFileUrl) ? parentVirtualFileUrl : null;
    }

    private final void calculateEntityChangesIfNeeded(VirtualFileUrl virtualFileUrl, VirtualFile virtualFile, EntityChangeStorage entityChanges, EntityStorage storage, boolean allRootsWereRemoved, WorkspaceFileIndexDataImpl indexData) {
        VirtualFileUrl includingJarDirectory = this.getIncludingJarDirectory(storage, virtualFileUrl);
        if (includingJarDirectory != null) {
            Sequence $this$forEach$iv = storage.getVirtualFileUrlIndex().findEntitiesByUrl(includingJarDirectory);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WorkspaceEntity it = (WorkspaceEntity)element$iv;
                boolean bl = false;
                entityChanges.addAffectedEntity((EntityPointer<? extends WorkspaceEntity>)it.createPointer(), allRootsWereRemoved);
            }
            return;
        }
        this.collectAffectedEntities(virtualFileUrl, virtualFile, allRootsWereRemoved, entityChanges, indexData);
        List list = virtualFileUrl.getSubTreeFileUrls();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSubTreeFileUrls(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile virtualFile2;
            VirtualFileUrl urlUnder = (VirtualFileUrl)element$iv;
            boolean bl = false;
            if (virtualFile != null) {
                Intrinsics.checkNotNull((Object)urlUnder);
                virtualFile2 = VirtualFileUrls.getVirtualFile((VirtualFileUrl)urlUnder);
            } else {
                virtualFile2 = null;
            }
            VirtualFile fileUnder = virtualFile2;
            Intrinsics.checkNotNull((Object)urlUnder);
            this.collectAffectedEntities(urlUnder, fileUnder, allRootsWereRemoved, entityChanges, indexData);
        }
    }

    private final void collectAffectedEntities(VirtualFileUrl url, VirtualFile virtualFile, boolean allRootsWereRemoved, EntityChangeStorage entityChanges, WorkspaceFileIndexDataImpl indexData) {
        if (virtualFile != null) {
            Ref.BooleanRef hasEntities = new Ref.BooleanRef();
            indexData.processFileSets(virtualFile, (Function1<? super StoredFileSet, Unit>)((Function1)arg_0 -> NonExistingWorkspaceRootsRegistry.collectAffectedEntities$lambda$0(entityChanges, allRootsWereRemoved, hasEntities, arg_0)));
            if (hasEntities.element && allRootsWereRemoved) {
                entityChanges.addFileToInvalidate(VirtualFileUrls.getVirtualFile((VirtualFileUrl)url));
            }
        }
        boolean hasEntities = false;
        Collection collection = this.nonExistingFiles.get((Object)url);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NonExistingFileSetData data = (NonExistingFileSetData)element$iv;
            boolean bl = false;
            if (data.getStorageKind() != EntityStorageKind.MAIN) continue;
            hasEntities = true;
            entityChanges.addAffectedEntity(data.getReference(), allRootsWereRemoved);
        }
        if (hasEntities) {
            entityChanges.addUrlToCleanUp(url);
        }
    }

    private static final Unit collectAffectedEntities$lambda$0(EntityChangeStorage $entityChanges, boolean $allRootsWereRemoved, Ref.BooleanRef $hasEntities, StoredFileSet it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.getEntityStorageKind() == EntityStorageKind.MAIN) {
            $entityChanges.addAffectedEntity(it.getEntityPointer(), $allRootsWereRemoved);
        }
        $hasEntities.element = true;
        return Unit.INSTANCE;
    }
}

