/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.config;

import com.intellij.icons.AllIcons;
import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDEventImpl;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.IconUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.ui.tree.TreeUtil;
import com.jetbrains.plugins.webDeployment.DeploymentConfigChangeListener;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.WebServerConfigsChangedListener;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.GroupedServersComparer;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerGroupingWrap;
import com.jetbrains.plugins.webDeployment.statistic.ServerSettingsUsageTriggerCollector;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurableForm;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurableTab;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurableTabProvider;
import com.jetbrains.plugins.webDeployment.ui.config.GroupConfigurableForm;
import com.jetbrains.plugins.webDeployment.ui.config.SettingsDeployable;
import com.jetbrains.plugins.webDeployment.ui.config.SettingsGroup;
import com.jetbrains.plugins.webDeployment.ui.config.SettingsGroupedDeployable;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DeploymentServersEditor
extends MasterDetailsComponent {
    private static final Key<String> DEFAULT_SERVER_OR_GROUP_NAME = Key.create((String)"default_server_or_group_name");
    @NonNls
    private static final String DELETE_SERVERS_SILENTLY_KEY = "webDeployment.deleteServersSilently";
    @NotNull
    private final Comparator<MasterDetailsComponent.MyNode> myComparator;
    @NotNull
    private final Project myProject;
    private final List<DeploymentConfigurableTabProvider> myProviders;
    private final UserDataHolder myDataHolder;
    private final List<SettingsGroupedDeployable> myItems;
    private final List<SettingsGroupedDeployable> myOriginalItems;
    private int myTabIndex;
    private List<SettingsGroupedDeployable> myResultItems;
    private final Disposable myDisposable;

    DeploymentServersEditor(@NotNull List<DeploymentConfigurableTabProvider> providers, UserDataHolder dataHolder, @NotNull Project project) {
        if (providers == null) {
            DeploymentServersEditor.$$$reportNull$$$0(0);
        }
        if (project == null) {
            DeploymentServersEditor.$$$reportNull$$$0(1);
        }
        this.myItems = new ArrayList<SettingsGroupedDeployable>();
        this.myTabIndex = -1;
        this.myDisposable = Disposer.newDisposable((String)DeploymentServersEditor.class.getName());
        List<SettingsGroupedDeployable> items = DeploymentServersEditor.getServersWithCredentials(project);
        this.myOriginalItems = items;
        this.myResultItems = items;
        this.myProject = project;
        this.myComparator = new NodeComparator(this.myProject);
        this.myProviders = providers;
        this.myDataHolder = dataHolder;
        this.reset();
        this.initTree();
        this.getTree().getEmptyText().setText(WDBundle.message("deployment.not.configured", new Object[0]));
        TreeUIHelper.getInstance().installTreeSpeedSearch((JTree)this.getTree());
        MessageBus bus = project.isDefault() ? ApplicationManager.getApplication().getMessageBus() : project.getMessageBus();
        bus.connect(this.myDisposable).subscribe(SshConfigManager.SSH_CONFIGS, (Object)new SshConfigManager.Listener(){

            public void sshConfigsChanged() {
                SshConfigManager manager = SshConfigManager.getInstance((Project)DeploymentServersEditor.this.myProject);
                for (SettingsGroupedDeployable item : DeploymentServersEditor.this.myItems) {
                    DeploymentServersEditor.updateSshConfig(item, manager);
                }
            }
        });
    }

    private static void updateSshConfig(SettingsGroupedDeployable item, SshConfigManager manager) {
        for (SettingsDeployable deployable : item.getDeployables()) {
            deployable.updateSshConfig(manager);
        }
    }

    protected void initTree() {
        super.initTree();
        DnDManager.getInstance().registerTarget((DnDTarget)new MyDnDTarget(), (JComponent)this.myTree);
        DnDManager.getInstance().registerSource((DnDSource)new MyDnDSource(this.myTree), (JComponent)this.myTree);
    }

    private NamedConfigurable createConfigurable(SettingsDeployable item) {
        return new DeploymentConfigurableForm(item, this.myProject, this.TREE_UPDATER){

            @Override
            protected void setUpComponent() {
                ArrayList<DeploymentConfigurableTab> tabs = new ArrayList<DeploymentConfigurableTab>();
                for (DeploymentConfigurableTabProvider provider : DeploymentServersEditor.this.myProviders) {
                    DeploymentConfigurableTab tab = provider.createTab(DeploymentServersEditor.this.myProject, this, DeploymentServersEditor.this.myDataHolder);
                    if (tab == null) continue;
                    tabs.add(tab);
                }
                tabs.sort(Comparator.comparingInt(DeploymentConfigurableTab::getWeight));
                for (DeploymentConfigurableTab tab : tabs) {
                    this.addTab(tab);
                }
                this.addTabChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        DeploymentServersEditor.this.myTabIndex = this.getSelectedTabIndex();
                    }
                });
                if (DeploymentServersEditor.this.myTabIndex != -1) {
                    this.setSelectedTabIndex(DeploymentServersEditor.this.myTabIndex);
                }
                this.addListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        DeploymentServersEditor.this.runUpdater();
                    }
                }, this);
                this.reset();
            }

            @Nullable
            public JComponent getPreferredFocusedComponent() {
                return this.getPreferredFocusedComponent(DeploymentServersEditor.this.myTabIndex);
            }
        };
    }

    protected GroupConfigurableForm createGroupedConfigurable(SettingsGroupedDeployable item) {
        return new GroupConfigurableForm(item, this, this.TREE_UPDATER, this.myDataHolder, this.myProject);
    }

    @NlsContexts.ConfigurableName
    public String getDisplayName() {
        return WDBundle.message("deployment.configurable.name", new Object[0]);
    }

    public void apply() throws ConfigurationException {
        super.apply();
        List<SettingsGroupedDeployable> settingsGroupedDeployables = this.myResultItems = this.myItems;
        ArrayList<WebServerGroupingWrap> groupedServers = new ArrayList<WebServerGroupingWrap>(settingsGroupedDeployables.size());
        for (SettingsGroupedDeployable deployable : settingsGroupedDeployables) {
            groupedServers.add(deployable.computeGroupedDeployable());
        }
        WebServerConfig.fixDuplicatingNames(groupedServers);
        GroupedServersConfigManager.getInstance(this.myProject).setGroupedServers(groupedServers);
        String defaultServerName = this.getDefaultServerOrGroupName();
        PublishConfig config = PublishConfig.getInstance(this.myProject);
        boolean found = false;
        if (defaultServerName != null) {
            block1: for (SettingsGroupedDeployable settingsGroupedDeployable : settingsGroupedDeployables) {
                if (StringUtil.equals((CharSequence)settingsGroupedDeployable.getName(), (CharSequence)defaultServerName)) {
                    found = true;
                    break;
                }
                if (settingsGroupedDeployable.isSingleServer()) continue;
                for (SettingsDeployable deployable : settingsGroupedDeployable.getDeployables()) {
                    if (!StringUtil.equals((CharSequence)deployable.getName(), (CharSequence)defaultServerName)) continue;
                    found = true;
                    continue block1;
                }
            }
        }
        config.setDefaultGroupOrServerName(found ? defaultServerName : null);
        for (DeploymentConfigurableTabProvider provider : this.myProviders) {
            provider.apply(this.myProject, settingsGroupedDeployables, this.myDataHolder);
        }
        ((WebServerConfigsChangedListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(WebDeploymentTopics.WEB_SERVER_CONFIGS)).serverConfigsChanged();
        ((DeploymentConfigChangeListener)this.myProject.getMessageBus().syncPublisher(WebDeploymentTopics.DEPLOYMENT_CONFIG)).optionsChanged();
    }

    public void reset() {
        for (TreeNode next : TreeUtil.treeNodeTraverser((TreeNode)this.myRoot)) {
            if (!(next instanceof MasterDetailsComponent.MyNode)) continue;
            ((MasterDetailsComponent.MyNode)next).getConfigurable().disposeUIResources();
        }
        PublishConfig publishConfig2 = PublishConfig.getInstance(this.myProject);
        this.setDefaultServerOrGroupName(publishConfig2.getDefaultServerOrGroupName());
        for (DeploymentConfigurableTabProvider provider : this.myProviders) {
            provider.reset(this.myProject, this.myDataHolder);
        }
        this.myResultItems = this.myOriginalItems;
        this.myItems.clear();
        this.clearChildren();
        for (SettingsGroupedDeployable item : this.myOriginalItems) {
            this.addNewNode(this.cloneGroup(item));
        }
        super.reset();
        TreeUtil.expandAll((JTree)this.myTree);
    }

    public boolean isModified() {
        if (this.myResultItems.size() != this.myItems.size()) {
            return true;
        }
        for (int i = 0; i < this.myItems.size(); ++i) {
            if (this.areGroupsEqual(this.myItems.get(i), this.myResultItems.get(i))) continue;
            return true;
        }
        if (super.isModified()) {
            return true;
        }
        if (!this.myProject.isDefault()) {
            PublishConfig config = PublishConfig.getInstance(this.myProject);
            if (!Objects.equals(this.getDefaultServerOrGroupName(), config.getDefaultServerOrGroupName())) {
                return true;
            }
        }
        return false;
    }

    protected String getEmptySelectionString() {
        return WDBundle.message(this.getCurrentItems().isEmpty() ? "deployment.config.welcome.message" : "deployment.config.unselected.message", new Object[0]);
    }

    void selectNamedItem(String name, boolean requestFocus) {
        if (StringUtil.isEmpty((String)name)) {
            return;
        }
        this.selectNodeInTree((DefaultMutableTreeNode)DeploymentServersEditor.findNodeByCondition((TreeNode)this.myRoot, configurable -> name.equals(configurable.getDisplayName())), requestFocus);
    }

    void onItemCreated(SettingsDeployable newItem, @Nullable SettingsGroupedDeployable groupToAdd) {
        List<SettingsGroupedDeployable> items = this.getCurrentItems();
        if (items.isEmpty()) {
            this.setDefaultServerOrGroupName(newItem.getName());
        }
        for (DeploymentConfigurableTabProvider provider : this.myProviders) {
            provider.onItemCreated(this.myProject, newItem, this.myDataHolder);
        }
        this.myTabIndex = 0;
        if (groupToAdd != null && !groupToAdd.isSingleServer()) {
            groupToAdd.addServer(newItem);
        }
        this.addNewNode(newItem, groupToAdd);
        this.selectNodeInTree(newItem);
    }

    private void onGroupCreated(SettingsGroupedDeployable newItem) {
        List<SettingsGroupedDeployable> items = this.getCurrentItems();
        if (items.isEmpty()) {
            this.setDefaultServerOrGroupName(newItem.getName());
        }
        this.myTabIndex = 0;
        this.addNewNode(newItem);
        this.selectNodeInTree(newItem);
    }

    protected void onItemDeleted(Object item) {
        String name;
        UnnamedConfigurable c = this.getItemConfigurable(item);
        if (c != null) {
            c.disposeUIResources();
        }
        if (item instanceof SettingsDeployable) {
            SettingsDeployable server = (SettingsDeployable)item;
            name = server.getName();
            boolean found = false;
            for (SettingsGroupedDeployable group : this.myItems) {
                if (group.isSingleServer()) {
                    if (!group.contains(server)) continue;
                    this.myItems.remove(group);
                    found = true;
                    break;
                }
                if (!group.removeServer(server)) continue;
                found = true;
                break;
            }
            LOG.assertTrue(found, (Object)("Didn't find parent group " + String.valueOf(server)));
            for (DeploymentConfigurableTabProvider provider : this.myProviders) {
                provider.onItemDeleted(this.myProject, server, this.myDataHolder);
            }
        } else if (item instanceof SettingsGroupedDeployable) {
            name = ((SettingsGroupedDeployable)item).getName();
            this.myItems.remove(item);
            for (SettingsDeployable deployable : ((SettingsGroupedDeployable)item).getDeployables()) {
                for (DeploymentConfigurableTabProvider provider : this.myProviders) {
                    provider.onItemDeleted(this.myProject, deployable, this.myDataHolder);
                }
            }
        } else {
            throw new IllegalStateException("Inexpected item " + String.valueOf(item));
        }
        if (!this.myProject.isDefault() && Objects.equals(this.getDefaultServerOrGroupName(), name)) {
            this.setDefaultServerOrGroupName(null);
        }
    }

    @Nullable
    protected List<AnAction> createActions(boolean fromPopup) {
        ArrayList<AnAction> result = new ArrayList<AnAction>();
        result.add((AnAction)new AddAction(true));
        result.add((AnAction)new MyCautiousDeleteAction());
        if (fromPopup) {
            result.add((AnAction)new CopyAction());
            result.add(new MyRenameAction());
        }
        result.add((AnAction)new MyToggleDefaultServerAction(fromPopup));
        return result;
    }

    protected void updateSelection(@Nullable NamedConfigurable configurable) {
        if (configurable != null) {
            DeploymentServersEditor.handleEditableObject(configurable, server -> {
                DeploymentConfigurableForm f = this.getServerConfigurable((SettingsDeployable)server);
                LOG.assertTrue(f != null);
                if (this.myTabIndex != -1) {
                    f.setSelectedTabIndex(this.myTabIndex);
                }
                return null;
            }, null);
        }
        super.updateSelection(configurable);
    }

    protected void removeNodes(List<? extends MasterDetailsComponent.MyNode> nodes) {
        if (nodes.size() > 1) {
            ArrayList<? extends MasterDetailsComponent.MyNode> toRemove = new ArrayList<MasterDetailsComponent.MyNode>(nodes.size());
            for (MasterDetailsComponent.MyNode myNode : nodes) {
                if (myNode.getParent() != null && toRemove.contains(myNode.getParent())) continue;
                toRemove.add((MasterDetailsComponent.MyNode)myNode);
            }
            nodes = toRemove;
        }
        super.removeNodes(nodes);
    }

    private static <T> T handleEditableObject(@NotNull NamedConfigurable configurable, @Nullable Function<SettingsDeployable, T> serverFunction, @Nullable Function<SettingsGroupedDeployable, T> groupFunction) {
        Object editableObject;
        if (configurable == null) {
            DeploymentServersEditor.$$$reportNull$$$0(2);
        }
        if ((editableObject = configurable.getEditableObject()) instanceof SettingsDeployable) {
            return serverFunction == null ? null : (T)serverFunction.apply((SettingsDeployable)editableObject);
        }
        if (editableObject instanceof SettingsGroupedDeployable) {
            return groupFunction == null ? null : (T)groupFunction.apply((SettingsGroupedDeployable)editableObject);
        }
        throw new IllegalStateException("Unexpected editable object " + String.valueOf(editableObject));
    }

    protected void addNode(MasterDetailsComponent.MyNode nodeToAdd, MasterDetailsComponent.MyNode parent) {
        String name;
        if (!this.myProject.isDefault() && (name = DeploymentServersEditor.handleEditableObject(nodeToAdd.getConfigurable(), server -> server.getName(), group -> group.getName())) != null && Objects.equals(this.getDefaultServerOrGroupName(), name)) {
            nodeToAdd.setDisplayInBold(true);
        }
        super.addNode(nodeToAdd, parent);
    }

    private void runUpdater() {
        MasterDetailsComponent.MyNode node;
        if (this.myTree.getSelectionPath() != null && (node = (MasterDetailsComponent.MyNode)this.myTree.getSelectionPath().getLastPathComponent()) != null && node.getConfigurable() != null) {
            this.TREE_UPDATER.run();
        }
    }

    protected Comparator<MasterDetailsComponent.MyNode> getNodeComparator() {
        return this.myComparator;
    }

    @Nullable
    String getDefaultServerOrGroupName() {
        return DeploymentServersEditor.getDefaultServerOrGroupName(this.myDataHolder);
    }

    @Nullable
    static String getDefaultServerOrGroupName(@NotNull UserDataHolder dataHolder) {
        if (dataHolder == null) {
            DeploymentServersEditor.$$$reportNull$$$0(3);
        }
        return (String)dataHolder.getUserData(DEFAULT_SERVER_OR_GROUP_NAME);
    }

    static void setDefaultServerOrGroupName(@NotNull UserDataHolder dataHolder, @Nullable String name) {
        if (dataHolder == null) {
            DeploymentServersEditor.$$$reportNull$$$0(4);
        }
        dataHolder.putUserData(DEFAULT_SERVER_OR_GROUP_NAME, (Object)name);
    }

    private void setDefaultServerOrGroupName(@Nullable String name) {
        DeploymentServersEditor.setDefaultServerOrGroupName(this.myDataHolder, name);
        boolean bold = name != null;
        for (TreeNode node : TreeUtil.treeNodeTraverser((TreeNode)this.myRoot).traverse()) {
            if (!(node instanceof MasterDetailsComponent.MyNode) || this.myRoot == node) continue;
            boolean nodeBold = bold;
            if (nodeBold) {
                nodeBold = DeploymentServersEditor.handleEditableObject(((MasterDetailsComponent.MyNode)node).getConfigurable(), s -> name.equals(s.getName()), g -> name.equals(g.getName()));
            }
            ((MasterDetailsComponent.MyNode)node).setDisplayInBold(nodeBold);
        }
        this.runUpdater();
    }

    private void tryUpdateDefaultName(@NotNull String oldDefault, @Nullable String newDefault) {
        if (oldDefault == null) {
            DeploymentServersEditor.$$$reportNull$$$0(5);
        }
        if (!oldDefault.equals(this.getDefaultServerOrGroupName())) {
            return;
        }
        this.setDefaultServerOrGroupName(newDefault);
    }

    protected boolean wasObjectStored(Object editableObject) {
        return true;
    }

    @Nullable
    private String askForServerName(@NlsContexts.DialogTitle String title) {
        return Messages.showInputDialog((String)WDBundle.message("new.server.name", new Object[0]), (String)title, (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)new InputValidator(){

            public boolean checkInput(String s) {
                return !s.isEmpty() && DeploymentServersEditor.this.findDeployableByName(s) == null;
            }

            public boolean canClose(String s) {
                return this.checkInput(s);
            }
        });
    }

    @Nullable
    private String askForGroupName(@NlsContexts.DialogTitle String title) {
        return Messages.showInputDialog((String)WDBundle.message("new.group.name", new Object[0]), (String)title, (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)new InputValidator(){

            public boolean checkInput(String s) {
                return !s.isEmpty() && DeploymentServersEditor.this.findGroupByName(s) == null;
            }

            public boolean canClose(String s) {
                return this.checkInput(s);
            }
        });
    }

    @Nullable
    protected SettingsDeployable findDeployableByName(String name) {
        for (SettingsGroupedDeployable item : this.myItems) {
            for (SettingsDeployable deployable : item.getDeployables()) {
                if (!Objects.equals(name, deployable.getName())) continue;
                return deployable;
            }
        }
        return null;
    }

    @Nullable
    protected SettingsGroupedDeployable findGroupByName(String name) {
        for (SettingsGroupedDeployable item : this.myItems) {
            if (!Objects.equals(name, item.getName())) continue;
            return item;
        }
        return null;
    }

    private void addNewNode(SettingsGroupedDeployable item) {
        MasterDetailsComponent.MyNode root = this.myRoot;
        if (!item.isSingleServer()) {
            MasterDetailsComponent.MyNode groupedNode = new MasterDetailsComponent.MyNode((NamedConfigurable)this.createGroupedConfigurable(item));
            this.addNode(groupedNode, this.myRoot);
            root = groupedNode;
        }
        for (SettingsDeployable deployable : item.getDeployables()) {
            this.addServerNode(deployable, root);
        }
        this.myItems.add(item);
    }

    private void addServerNode(@NotNull SettingsDeployable deployable, @NotNull MasterDetailsComponent.MyNode root) {
        if (deployable == null) {
            DeploymentServersEditor.$$$reportNull$$$0(6);
        }
        if (root == null) {
            DeploymentServersEditor.$$$reportNull$$$0(7);
        }
        this.addNode(new MasterDetailsComponent.MyNode(this.createConfigurable(deployable)), root);
    }

    private void addNewNode(SettingsDeployable newItem, @Nullable SettingsGroupedDeployable groupToAdd) {
        if (groupToAdd == null || groupToAdd.isSingleServer()) {
            this.addNewNode(SettingsGroupedDeployable.wrapDeployable(newItem));
        } else {
            MasterDetailsComponent.MyNode node = DeploymentServersEditor.findNodeByObject((TreeNode)this.myRoot, (Object)groupToAdd);
            LOG.assertTrue(node != null);
            this.addServerNode(newItem, node);
        }
    }

    @Nullable
    private UnnamedConfigurable getItemConfigurable(Object item) {
        MasterDetailsComponent.MyNode node = DeploymentServersEditor.findNodeByObject((TreeNode)this.myRoot, (Object)item);
        if (node != null) {
            return node.getConfigurable();
        }
        return null;
    }

    @Nullable
    DeploymentConfigurableForm getServerConfigurable(SettingsDeployable deployable) {
        UnnamedConfigurable configurable = this.getItemConfigurable(deployable);
        if (!(configurable instanceof DeploymentConfigurableForm)) {
            return null;
        }
        return (DeploymentConfigurableForm)configurable;
    }

    protected List<SettingsGroupedDeployable> getCurrentItems() {
        return Collections.unmodifiableList(this.myItems);
    }

    private void moveServerBetweenGroups(@NotNull SettingsDeployable server, @Nullable SettingsGroupedDeployable targetGroup, @Nullable SettingsGroupedDeployable sourceGroup) {
        MasterDetailsComponent.MyNode parentNode;
        MasterDetailsComponent.MyNode serverNode;
        if (server == null) {
            DeploymentServersEditor.$$$reportNull$$$0(8);
        }
        LOG.assertTrue((serverNode = DeploymentServersEditor.findNodeByObject((TreeNode)this.myRoot, (Object)server)) != null);
        if (sourceGroup == null) {
            Iterator<SettingsGroupedDeployable> iterator = this.myItems.iterator();
            boolean found = false;
            while (iterator.hasNext()) {
                SettingsGroupedDeployable next = iterator.next();
                if (!next.isSingleServer() || !next.contains(server)) continue;
                iterator.remove();
                found = true;
                break;
            }
            LOG.assertTrue(found);
        } else {
            boolean removed = sourceGroup.removeServer(server);
            LOG.assertTrue(removed);
        }
        ((DefaultTreeModel)this.myTree.getModel()).removeNodeFromParent((MutableTreeNode)serverNode);
        if (targetGroup == null) {
            this.myItems.add(SettingsGroupedDeployable.wrapDeployable(server));
            parentNode = this.myRoot;
        } else {
            targetGroup.addServer(server);
            parentNode = DeploymentServersEditor.findNodeByObject((TreeNode)this.myRoot, (Object)targetGroup);
            LOG.assertTrue(parentNode != null);
        }
        super.addNode(serverNode, parentNode);
        TreeUtil.selectInTree((DefaultMutableTreeNode)serverNode, (boolean)true, (JTree)this.myTree);
    }

    private static boolean shouldDeleteServersAndGroupsSilently() {
        return PropertiesComponent.getInstance().getBoolean(DELETE_SERVERS_SILENTLY_KEY, false);
    }

    private static void setDeleteServersAndGroupsSilently() {
        PropertiesComponent.getInstance().setValue(DELETE_SERVERS_SILENTLY_KEY, true);
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myDisposable);
        super.disposeUIResources();
    }

    private DoNotAskOption createAutoUploadDoNotAskOption() {
        return new DoNotAskOption.Adapter(){

            public void rememberChoice(boolean isSelected, int exitCode) {
                PublishConfig.getInstance(DeploymentServersEditor.this.myProject).setShowAutoUploadWarning(!isSelected);
            }
        };
    }

    @NotNull
    private static List<SettingsGroupedDeployable> getServersWithCredentials(@Nullable Project project) {
        List<WebServerGroupingWrap> servers = GroupedServersConfigManager.getInstance(project).getGroupedServers();
        return new MyWrappingList(servers, project);
    }

    private static GroupedServersComparer.ComparisonWrapper wrap(final @NotNull SettingsDeployable deployable) {
        if (deployable == null) {
            DeploymentServersEditor.$$$reportNull$$$0(9);
        }
        return new GroupedServersComparer.ComparisonWrapper(){

            @Override
            @Nullable
            public String getName() {
                return deployable.getName();
            }

            @Override
            public boolean isConfigured(@NotNull PublishConfig config, boolean deploymentOnly) {
                if (config == null) {
                    6.$$$reportNull$$$0(0);
                }
                return config.isConfigured(deployable.computeWebServerConfig(), deploymentOnly);
            }

            @Override
            public boolean isProjectLevel() {
                return deployable.isProjectLevel();
            }

            @Override
            public boolean isGroup() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/jetbrains/plugins/webDeployment/ui/config/DeploymentServersEditor$6", "isConfigured"));
            }
        };
    }

    private static GroupedServersComparer.ComparisonWrapper wrap(final @NotNull SettingsGroupedDeployable group) {
        if (group == null) {
            DeploymentServersEditor.$$$reportNull$$$0(10);
        }
        return new GroupedServersComparer.ComparisonWrapper(){

            @Override
            @Nullable
            public String getName() {
                return group.getName();
            }

            @Override
            public boolean isConfigured(@NotNull PublishConfig config, boolean deploymentOnly) {
                if (config == null) {
                    7.$$$reportNull$$$0(0);
                }
                for (SettingsDeployable deployable : group.getDeployables()) {
                    if (!config.isConfigured(deployable.computeWebServerConfig(), deploymentOnly)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean isProjectLevel() {
                return group.isProjectLevel();
            }

            @Override
            public boolean isGroup() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/jetbrains/plugins/webDeployment/ui/config/DeploymentServersEditor$7", "isConfigured"));
            }
        };
    }

    @NotNull
    private SettingsGroupedDeployable cloneGroup(SettingsGroupedDeployable item) {
        SettingsGroupedDeployable settingsGroupedDeployable = item.cloneGroup(this.myProviders, this.myProject, this.myDataHolder);
        if (settingsGroupedDeployable == null) {
            DeploymentServersEditor.$$$reportNull$$$0(11);
        }
        return settingsGroupedDeployable;
    }

    @NotNull
    private SettingsDeployable copyDeployable(SettingsDeployable item) {
        SettingsDeployable copy = item.clone();
        copy.setId(WebServerConfig.getNextId());
        DeploymentConfigurableForm f = this.getServerConfigurable(item);
        LOG.assertTrue(f != null);
        f.createComponent();
        this.ensureInitialized(f);
        f.applyTo(copy, false);
        SettingsDeployable settingsDeployable = copy;
        if (settingsDeployable == null) {
            DeploymentServersEditor.$$$reportNull$$$0(12);
        }
        return settingsDeployable;
    }

    private boolean areServersEqual(SettingsDeployable o1, SettingsDeployable o2) {
        if (!Objects.equals(o1.getName(), o2.getName())) {
            return false;
        }
        for (DeploymentConfigurableTabProvider provider : this.myProviders) {
            if (provider.dataIsEqual(this.myProject, o1, o2, this.myDataHolder)) continue;
            return false;
        }
        return true;
    }

    private boolean areGroupsEqual(SettingsGroupedDeployable o1, SettingsGroupedDeployable o2) {
        if (!Objects.equals(o1.getName(), o2.getName())) {
            return false;
        }
        if (o1.isSingleServer() != o2.isSingleServer()) {
            return false;
        }
        List<SettingsDeployable> o1Deployables = o1.getDeployables();
        List<SettingsDeployable> o2Deployables = o2.getDeployables();
        if (o1Deployables.size() != o2Deployables.size()) {
            return false;
        }
        for (int i = 0; i < o1Deployables.size(); ++i) {
            if (this.areServersEqual(o1Deployables.get(i), o2Deployables.get(i))) continue;
            return false;
        }
        return true;
    }

    AnAction createAddServerAction(@NotNull AccessType type, @Nullable SettingsGroupedDeployable groupedDeployable) {
        if (type == null) {
            DeploymentServersEditor.$$$reportNull$$$0(13);
        }
        return new AddServerAction(type, groupedDeployable);
    }

    @Nullable
    private static Pair<SettingsGroupedDeployable, SettingsDeployable> getGroupAndServer(@Nullable TreePath path, @NotNull Object root) {
        if (root == null) {
            DeploymentServersEditor.$$$reportNull$$$0(14);
        }
        if (path == null) {
            return null;
        }
        Object component = path.getLastPathComponent();
        Pair groupAndServer = null;
        if (component instanceof MasterDetailsComponent.MyNode) {
            if (component == root) {
                return Pair.create(null, null);
            }
            groupAndServer = DeploymentServersEditor.handleEditableObject(((MasterDetailsComponent.MyNode)component).getConfigurable(), s -> {
                Object editableObject;
                Object parentPathLastPathComponent;
                TreePath parentPath = path.getParentPath();
                if (parentPath != null && (parentPathLastPathComponent = parentPath.getLastPathComponent()) instanceof MasterDetailsComponent.MyNode && !(parentPathLastPathComponent instanceof MasterDetailsComponent.MyRootNode) && (editableObject = ((MasterDetailsComponent.MyNode)parentPathLastPathComponent).getConfigurable().getEditableObject()) instanceof SettingsGroupedDeployable) {
                    return Pair.create((Object)((SettingsGroupedDeployable)editableObject), (Object)s);
                }
                return Pair.create(null, (Object)s);
            }, g -> Pair.create((Object)g, null));
        }
        return groupAndServer;
    }

    @Nullable
    private static Pair<SettingsGroupedDeployable, SettingsDeployable> getTransferredDara(DnDEvent event) {
        try {
            Object attachedObject = event.getTransferData(DnDEventImpl.ourDataFlavor);
            if (!(attachedObject instanceof Pair)) {
                return null;
            }
            Object first = ((Pair)attachedObject).first;
            if (first != null && !(first instanceof SettingsGroupedDeployable)) {
                return null;
            }
            Object second = ((Pair)attachedObject).second;
            if (second != null && !(second instanceof SettingsDeployable)) {
                return null;
            }
            if (first == null && second == null) {
                return null;
            }
            return (Pair)attachedObject;
        }
        catch (UnsupportedFlavorException | IOException exception) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataHolder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldDefault";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deployable";
                break;
            }
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/ui/config/DeploymentServersEditor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/config/DeploymentServersEditor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneGroup";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "copyDeployable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "handleEditableObject";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultServerOrGroupName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultServerOrGroupName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "tryUpdateDefaultName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addServerNode";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "moveServerBetweenGroups";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 11: 
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createAddServerAction";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getGroupAndServer";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12 -> new IllegalStateException(string);
        };
    }

    private static final class NodeComparator
    implements Comparator<MasterDetailsComponent.MyNode> {
        private final PublishConfig myConfig;

        private NodeComparator(@Nullable Project project) {
            this.myConfig = project == null ? null : PublishConfig.getInstance(project);
        }

        @Override
        public int compare(MasterDetailsComponent.MyNode o1, MasterDetailsComponent.MyNode o2) {
            NamedConfigurable configurable1 = o1.getConfigurable();
            Object object1 = configurable1.getEditableObject();
            NamedConfigurable configurable2 = o2.getConfigurable();
            Object object2 = configurable2.getEditableObject();
            if (object1 == null && object2 == null || this.myConfig == null) {
                return o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName());
            }
            if (object1 == null) {
                return 1;
            }
            if (object2 == null) {
                return -1;
            }
            GroupedServersComparer.ComparisonWrapper wrap1 = DeploymentServersEditor.handleEditableObject(configurable1, s -> DeploymentServersEditor.wrap(s), g -> DeploymentServersEditor.wrap(g));
            GroupedServersComparer.ComparisonWrapper wrap2 = DeploymentServersEditor.handleEditableObject(configurable2, s -> DeploymentServersEditor.wrap(s), g -> DeploymentServersEditor.wrap(g));
            return GroupedServersComparer.compareServers(wrap1, wrap2, this.myConfig);
        }
    }

    private class MyDnDTarget
    implements DnDTarget {
        private MyDnDTarget() {
        }

        public void drop(DnDEvent event) {
            Pair<SettingsGroupedDeployable, SettingsDeployable> draggedGroupAndServer = DeploymentServersEditor.getTransferredDara(event);
            if (draggedGroupAndServer == null || draggedGroupAndServer.second == null) {
                return;
            }
            SettingsDeployable server = (SettingsDeployable)draggedGroupAndServer.second;
            TreePath targetPath = this.getTargetPath(event);
            Pair<SettingsGroupedDeployable, SettingsDeployable> targetGroupAndServer = DeploymentServersEditor.getGroupAndServer(targetPath, DeploymentServersEditor.this.myRoot);
            if (targetGroupAndServer == null) {
                return;
            }
            if (draggedGroupAndServer.first == null && targetGroupAndServer.first == null || draggedGroupAndServer.first != null && draggedGroupAndServer.first == targetGroupAndServer.first) {
                return;
            }
            DeploymentServersEditor.this.moveServerBetweenGroups(server, (SettingsGroupedDeployable)targetGroupAndServer.first, (SettingsGroupedDeployable)draggedGroupAndServer.first);
        }

        public boolean update(DnDEvent event) {
            boolean dropPossible;
            boolean bl = dropPossible = DeploymentServersEditor.this.myTree == event.getHandlerComponent();
            if (dropPossible) {
                Pair<SettingsGroupedDeployable, SettingsDeployable> draggedGroupAndServer = DeploymentServersEditor.getTransferredDara(event);
                if (draggedGroupAndServer == null) {
                    dropPossible = false;
                } else {
                    TreePath targetPath = this.getTargetPath(event);
                    Pair<SettingsGroupedDeployable, SettingsDeployable> targetGroupAndServer = DeploymentServersEditor.getGroupAndServer(targetPath, DeploymentServersEditor.this.myRoot);
                    if (targetGroupAndServer == null) {
                        dropPossible = false;
                    }
                    if (dropPossible) {
                        if (draggedGroupAndServer.first == null && targetGroupAndServer.first == null) {
                            dropPossible = false;
                        } else if (draggedGroupAndServer.first != null && draggedGroupAndServer.first == targetGroupAndServer.first) {
                            dropPossible = false;
                        }
                    }
                    if (dropPossible) {
                        RelativeRectangle rectangle;
                        if (targetGroupAndServer.first != null) {
                            TreePath groupPath = targetGroupAndServer.second == null ? targetPath : targetPath.getParentPath();
                            Rectangle bounds = Objects.requireNonNull(DeploymentServersEditor.this.myTree.getPathBounds(groupPath));
                            rectangle = new RelativeRectangle((Component)DeploymentServersEditor.this.myTree, bounds.intersection(DeploymentServersEditor.this.myTree.getVisibleRect()));
                        } else {
                            Rectangle bounds = DeploymentServersEditor.this.myTree.getVisibleRect();
                            rectangle = new RelativeRectangle((Component)DeploymentServersEditor.this.myTree, bounds);
                            event.hideHighlighter();
                        }
                        event.setHighlighting(rectangle, 1);
                    } else {
                        event.hideHighlighter();
                    }
                }
            }
            event.setDropPossible(dropPossible, "result");
            return false;
        }

        private TreePath getTargetPath(DnDEvent event) {
            Point point = event.getPointOn((Component)DeploymentServersEditor.this.myTree);
            TreePath path = DeploymentServersEditor.this.myTree.getPathForLocation(point.x, point.y);
            if (path == null) {
                return new TreePath(DeploymentServersEditor.this.myRoot);
            }
            return path;
        }
    }

    private static final class MyDnDSource
    implements DnDSource {
        private final Tree myTree;

        private MyDnDSource(Tree tree) {
            this.myTree = tree;
        }

        public boolean canStartDragging(DnDAction action, @NotNull Point dragOrigin) {
            if (dragOrigin == null) {
                MyDnDSource.$$$reportNull$$$0(0);
            }
            if (this.myTree != this.myTree.getComponentAt(dragOrigin)) {
                return false;
            }
            return this.myTree.getSelectionCount() == 1;
        }

        public DnDDragStartBean startDragging(DnDAction action, @NotNull Point dragOrigin) {
            TreePath path;
            Pair<SettingsGroupedDeployable, SettingsDeployable> groupAndServer;
            if (dragOrigin == null) {
                MyDnDSource.$$$reportNull$$$0(1);
            }
            if ((groupAndServer = DeploymentServersEditor.getGroupAndServer(path = this.myTree.getSelectionPath(), this.myTree.getModel().getRoot())) != null && groupAndServer.second == null) {
                groupAndServer = null;
            }
            return new DnDDragStartBean((Object)(groupAndServer == null ? null : new MyTransferable(groupAndServer)), dragOrigin);
        }

        @Nullable
        public Pair<Image, Point> createDraggedImage(DnDAction action, Point dragOrigin, @NotNull DnDDragStartBean bean) {
            if (bean == null) {
                MyDnDSource.$$$reportNull$$$0(2);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dragOrigin";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bean";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/config/DeploymentServersEditor$MyDnDSource";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canStartDragging";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "startDragging";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createDraggedImage";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class AddAction
    extends DefaultActionGroup
    implements DumbAware {
        private AddAction(boolean fromPopup) {
            super(WDBundle.message("servers.editor.action.text.add", new Object[0]), fromPopup);
            this.getTemplatePresentation().setIcon(IconUtil.getAddIcon());
            this.registerCustomShortcutSet(CommonShortcuts.getInsert(), (JComponent)DeploymentServersEditor.this.myTree);
            this.add(new AddServerAction(AccessType.SFTP, null));
            this.add(new AddServerAction(AccessType.FTP, null));
            this.add(new AddServerAction(AccessType.FTPS, null));
            this.add(new AddServerAction(AccessType.WEBDAV, null));
            this.add(new AddServerAction(AccessType.MOUNT, null));
            this.add(new AddServerAction(AccessType.LOCAL, null));
            this.addSeparator();
            this.add(new AddGroupAction());
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            if (event == null) {
                AddAction.$$$reportNull$$$0(0);
            }
            ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("DeploymentSettings.Add.Popup", (ActionGroup)this);
            popupMenu.getComponent().show((Component)DeploymentServersEditor.this.myTree, 0, 0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/plugins/webDeployment/ui/config/DeploymentServersEditor$AddAction", "actionPerformed"));
        }
    }

    private class MyCautiousDeleteAction
    extends MasterDetailsComponent.MyDeleteAction {
        private MyCautiousDeleteAction() {
            super((MasterDetailsComponent)DeploymentServersEditor.this);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyCautiousDeleteAction.$$$reportNull$$$0(0);
            }
            if (!DeploymentServersEditor.shouldDeleteServersAndGroupsSilently()) {
                TreePath[] paths = DeploymentServersEditor.this.myTree.getSelectionPaths();
                if (paths == null || paths.length == 0) {
                    return;
                }
                Ref appLevelEntity = Ref.create();
                Ref groupEntity = Ref.create();
                for (TreePath path : paths) {
                    MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)path.getLastPathComponent();
                    DeploymentServersEditor.handleEditableObject(node.getConfigurable(), server -> {
                        if (!server.isProjectLevel()) {
                            appLevelEntity.set(server);
                        }
                        return null;
                    }, group -> {
                        if (!group.isProjectLevel()) {
                            appLevelEntity.set(group);
                        }
                        groupEntity.set(group);
                        return null;
                    });
                }
                if (!appLevelEntity.isNull() || !groupEntity.isNull()) {
                    String message = groupEntity.isNull() ? WDBundle.message("delete.selected.servers", new Object[0]) : (appLevelEntity.isNull() ? WDBundle.message("delete.selected.groups", new Object[0]) : WDBundle.message("delete.selected.servers.and.groups", new Object[0]));
                    boolean yesNo = ((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)WDBundle.message("servers.editor.action.text.delete", new Object[0]), (String)message).doNotAsk(new DoNotAskOption(this){

                        public boolean isToBeShown() {
                            return true;
                        }

                        public void setToBeShown(boolean toBeShown, int exitCode) {
                            if (exitCode == 0 && !toBeShown) {
                                DeploymentServersEditor.setDeleteServersAndGroupsSilently();
                            }
                        }

                        public boolean canBeHidden() {
                            return true;
                        }

                        public boolean shouldSaveOptionsOnCancel() {
                            return false;
                        }

                        @NotNull
                        public String getDoNotShowMessage() {
                            String string = WDBundle.message("deployment.configurable.remove.servers.delete.silently.dont.ask", new Object[0]);
                            if (string == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return string;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/config/DeploymentServersEditor$MyCautiousDeleteAction$1", "getDoNotShowMessage"));
                        }
                    })).ask((Component)DeploymentServersEditor.this.myWholePanel);
                    if (!yesNo) {
                        return;
                    }
                }
            }
            super.actionPerformed(e);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/plugins/webDeployment/ui/config/DeploymentServersEditor$MyCautiousDeleteAction", "actionPerformed"));
        }
    }

    private final class CopyAction
    extends DumbAwareAction {
        private CopyAction() {
            super(WDBundle.message("copy.action.duplicate", new Object[0]), WDBundle.message("copy.action.duplicate", new Object[0]), COPY_ICON);
            this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(68, 128)), (JComponent)DeploymentServersEditor.this.myTree);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                CopyAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            NamedConfigurable configurable;
            if (event == null) {
                CopyAction.$$$reportNull$$$0(1);
            }
            if ((configurable = DeploymentServersEditor.this.getSelectedConfigurable()) == null) {
                return;
            }
            Object clonedNode = DeploymentServersEditor.handleEditableObject(configurable, server -> {
                String profileName = DeploymentServersEditor.this.askForServerName(WDBundle.message("copy.action.duplicate.server", new Object[0]));
                if (profileName == null) {
                    return null;
                }
                SettingsDeployable clone = DeploymentServersEditor.this.copyDeployable((SettingsDeployable)server);
                clone.setName(profileName);
                DeploymentServersEditor.this.addNewNode(clone, null);
                return clone;
            }, group -> {
                SettingsGroupedDeployable clone;
                String profileName = DeploymentServersEditor.this.askForGroupName(WDBundle.message("copy.action.duplicate.group", new Object[0]));
                if (profileName == null) {
                    return null;
                }
                List<SettingsDeployable> deployables = group.getDeployables();
                if (group.isSingleServer()) {
                    SettingsDeployable copyServer = DeploymentServersEditor.this.copyDeployable(deployables.get(0));
                    clone = SettingsGroupedDeployable.wrapDeployable(copyServer);
                } else {
                    clone = new SettingsGroup();
                    clone.setName(profileName);
                    clone.setIsProjectLevel(group.isProjectLevel());
                    for (SettingsDeployable deployable : deployables) {
                        SettingsDeployable item = DeploymentServersEditor.this.copyDeployable(deployable);
                        item.setName(item.getName() + " (" + profileName + ")");
                        clone.addServer(item);
                    }
                }
                DeploymentServersEditor.this.addNewNode(clone);
                return clone;
            });
            if (clonedNode != null) {
                DeploymentServersEditor.this.selectNodeInTree(clonedNode);
            }
        }

        public void update(@NotNull AnActionEvent event) {
            NamedConfigurable configurable;
            boolean enabled;
            if (event == null) {
                CopyAction.$$$reportNull$$$0(2);
            }
            boolean bl = enabled = (configurable = DeploymentServersEditor.this.getSelectedConfigurable()) != null;
            if (enabled) {
                Boolean checkObject = DeploymentServersEditor.handleEditableObject(configurable, server -> true, group -> group.mayChangeLevel());
                enabled = checkObject != null && checkObject != false;
            }
            event.getPresentation().setEnabled(enabled);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/plugins/webDeployment/ui/config/DeploymentServersEditor$CopyAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/config/DeploymentServersEditor$CopyAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private final class MyRenameAction
    extends AnAction
    implements DumbAware {
        private MyRenameAction() {
            super(WDBundle.message("rename.action", new Object[0]));
            this.registerCustomShortcutSet(CommonShortcuts.getRename(), (JComponent)DeploymentServersEditor.this.myTree);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                MyRenameAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyRenameAction.$$$reportNull$$$0(1);
            }
            TreePath[] paths = DeploymentServersEditor.this.myTree.getSelectionPaths();
            e.getPresentation().setEnabled(paths != null && paths.length == 1);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            TreePath[] paths;
            if (e == null) {
                MyRenameAction.$$$reportNull$$$0(2);
            }
            if ((paths = DeploymentServersEditor.this.myTree.getSelectionPaths()) == null || paths.length != 1) {
                return;
            }
            MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)paths[0].getLastPathComponent();
            final Pair pair = DeploymentServersEditor.handleEditableObject(node.getConfigurable(), server -> Pair.create((Object)server.getName(), (Object)"server"), group -> Pair.create((Object)group.getName(), (Object)"group"));
            final String initialName = (String)pair.first;
            final HashSet<String> allNames = new HashSet<String>();
            for (SettingsGroupedDeployable item : DeploymentServersEditor.this.getCurrentItems()) {
                allNames.add(item.getName());
                if (item.isSingleServer()) continue;
                for (SettingsDeployable deployable : item.getDeployables()) {
                    allNames.add(deployable.getName());
                }
            }
            String name = Messages.showInputDialog((Component)DeploymentServersEditor.this.getTree(), (String)WDBundle.message("rename.new.name", new Object[0]), (String)WDBundle.message("rename.action", new Object[0]), null, (String)initialName, (InputValidator)new InputValidatorEx(){

                @Nullable
                public String getErrorText(String inputString) {
                    if (StringUtil.isEmptyOrSpaces((String)inputString)) {
                        return WDBundle.message("rename.provide.a.name.for.the.0", pair.second);
                    }
                    if (this.banned(inputString)) {
                        return WDBundle.message("rename.server.or.group.named.0.already.exists", inputString);
                    }
                    return null;
                }

                public boolean checkInput(String inputString) {
                    return !StringUtil.isEmptyOrSpaces((String)inputString) && !this.banned(inputString);
                }

                public boolean canClose(String inputString) {
                    return !StringUtil.isEmptyOrSpaces((String)inputString) && !this.banned(inputString);
                }

                private boolean banned(@NotNull String inputString) {
                    if (inputString == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return !inputString.equals(initialName) && allNames.contains(inputString);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputString", "com/jetbrains/plugins/webDeployment/ui/config/DeploymentServersEditor$MyRenameAction$1", "banned"));
                }
            });
            if (name == null || name.equals(initialName)) {
                return;
            }
            DeploymentServersEditor.this.tryUpdateDefaultName(initialName, name);
            DeploymentServersEditor.handleEditableObject(node.getConfigurable(), server -> {
                server.setName(name);
                DeploymentConfigurableForm f = DeploymentServersEditor.this.getServerConfigurable((SettingsDeployable)server);
                if (f != null) {
                    f.fireChanged();
                }
                return null;
            }, group -> {
                group.setName(name);
                UnnamedConfigurable configurable = DeploymentServersEditor.this.getItemConfigurable(group);
                assert (configurable instanceof GroupConfigurableForm);
                ((GroupConfigurableForm)configurable).reloadName();
                DeploymentServersEditor.this.runUpdater();
                return null;
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/plugins/webDeployment/ui/config/DeploymentServersEditor$MyRenameAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/config/DeploymentServersEditor$MyRenameAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private final class MyToggleDefaultServerAction
    extends ToggleAction
    implements DumbAware {
        private final boolean myFromPopup;

        private MyToggleDefaultServerAction(boolean fromPopup) {
            super(WDBundle.message("use.as.default.action.text", new Object[0]), WDBundle.message("use.as.default.action.description", new Object[0]), AllIcons.Actions.SetDefault);
            this.myFromPopup = fromPopup;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                MyToggleDefaultServerAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public boolean isAutoUploadEnabled() {
            return PublishConfig.getInstance(DeploymentServersEditor.this.myProject).getAutoUploadStateIncludingTemp() != PublishConfig.AutoUploadState.NEVER;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyToggleDefaultServerAction.$$$reportNull$$$0(1);
            }
            super.update(e);
            Presentation presentation = e.getPresentation();
            if (DeploymentServersEditor.this.myProject.isDefault()) {
                presentation.setEnabledAndVisible(false);
                return;
            }
            String selectedName = this.getSelectedName();
            boolean enabled = selectedName != null;
            boolean selected = this.isSelected(e);
            String text = selected ? WDBundle.message("dont.use.as.default.action.text", new Object[0]) : WDBundle.message("use.as.default.action.text", new Object[0]);
            presentation.setText(text);
            @NotNull Supplier<@Nls(capitalization=Nls.Capitalization.Sentence) String> description = selected ? WDBundle.messagePointer("dont.use.as.default.action.description", new Object[0]) : WDBundle.messagePointer("use.as.default.action.description", new Object[0]);
            presentation.setDescription(description);
            if (this.myFromPopup) {
                presentation.setVisible(enabled);
            }
            presentation.setEnabled(enabled);
        }

        @Nullable
        private String getSelectedName() {
            TreePath[] paths = DeploymentServersEditor.this.myTree.getSelectionPaths();
            if (paths == null || paths.length != 1) {
                return null;
            }
            Object component = paths[0].getLastPathComponent();
            if (!(component instanceof MasterDetailsComponent.MyNode)) {
                return null;
            }
            NamedConfigurable configurable = ((MasterDetailsComponent.MyNode)component).getConfigurable();
            if (configurable == null) {
                return null;
            }
            return DeploymentServersEditor.handleEditableObject(configurable, s -> s.getName(), g -> g.getName());
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            String selectedName;
            if (e == null) {
                MyToggleDefaultServerAction.$$$reportNull$$$0(2);
            }
            return (selectedName = this.getSelectedName()) != null && selectedName.equals(DeploymentServersEditor.this.getDefaultServerOrGroupName());
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                MyToggleDefaultServerAction.$$$reportNull$$$0(3);
            }
            if (state) {
                String defaultServerOrGroupName = DeploymentServersEditor.this.getDefaultServerOrGroupName();
                String name = this.getSelectedName();
                if (defaultServerOrGroupName != null && this.isAutoUploadEnabled()) {
                    if (PublishConfig.getInstance(DeploymentServersEditor.this.myProject).isShowAutoUploadWarning()) {
                        int ok = Messages.showOkCancelDialog((String)WDBundle.message("toggle.default.changed.files.will.now.be.automatically.uploaded.to.0.instead.of.1", name, defaultServerOrGroupName), (String)WDBundle.message("toggle.default.change.default.server", new Object[0]), (String)WDBundle.message("toggle.default.proceed", new Object[0]), (String)Messages.getCancelButton(), null, (DoNotAskOption)DeploymentServersEditor.this.createAutoUploadDoNotAskOption());
                        if (ok != 0) {
                            ServerSettingsUsageTriggerCollector.logDefaultServerSettingWithAutoUploadOn(true, ServerSettingsUsageTriggerCollector.Decision.cancelled);
                            return;
                        }
                        ServerSettingsUsageTriggerCollector.logDefaultServerSettingWithAutoUploadOn(true, ServerSettingsUsageTriggerCollector.Decision.explicit);
                    } else {
                        ServerSettingsUsageTriggerCollector.logDefaultServerSettingWithAutoUploadOn(true, ServerSettingsUsageTriggerCollector.Decision.silent);
                    }
                }
                DeploymentServersEditor.this.setDefaultServerOrGroupName(name);
            } else {
                if (this.isAutoUploadEnabled()) {
                    if (PublishConfig.getInstance(DeploymentServersEditor.this.myProject).isShowAutoUploadWarning()) {
                        int ok = Messages.showOkCancelDialog((String)WDBundle.message("toggle.default.changed.files.will.no.longer.be.automatically.uploaded.to.this.server", new Object[0]), (String)WDBundle.message("toggle.default.stop.using.server.as.default", new Object[0]), (String)WDBundle.message("toggle.default.proceed", new Object[0]), (String)Messages.getCancelButton(), null, (DoNotAskOption)DeploymentServersEditor.this.createAutoUploadDoNotAskOption());
                        if (ok != 0) {
                            ServerSettingsUsageTriggerCollector.logDefaultServerSettingWithAutoUploadOn(false, ServerSettingsUsageTriggerCollector.Decision.cancelled);
                            return;
                        }
                        ServerSettingsUsageTriggerCollector.logDefaultServerSettingWithAutoUploadOn(false, ServerSettingsUsageTriggerCollector.Decision.explicit);
                    } else {
                        ServerSettingsUsageTriggerCollector.logDefaultServerSettingWithAutoUploadOn(false, ServerSettingsUsageTriggerCollector.Decision.silent);
                    }
                }
                DeploymentServersEditor.this.setDefaultServerOrGroupName(null);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/plugins/webDeployment/ui/config/DeploymentServersEditor$MyToggleDefaultServerAction";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/config/DeploymentServersEditor$MyToggleDefaultServerAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static final class MyWrappingList
    extends AbstractList<SettingsGroupedDeployable> {
        @NotNull
        private final List<WebServerGroupingWrap> myList;
        private final Project myProject;
        private final Map<WebServerGroupingWrap, SettingsGroupedDeployable> myWraps;

        private MyWrappingList(@NotNull List<WebServerGroupingWrap> list, @Nullable Project project) {
            if (list == null) {
                MyWrappingList.$$$reportNull$$$0(0);
            }
            this.myWraps = new HashMap<WebServerGroupingWrap, SettingsGroupedDeployable>();
            this.myList = list;
            this.myProject = project;
        }

        @Override
        public SettingsGroupedDeployable get(int index) {
            WebServerGroupingWrap serverConfig = this.myList.get(index);
            SettingsGroupedDeployable settingsDeployable = this.myWraps.get(serverConfig);
            if (settingsDeployable == null) {
                settingsDeployable = SettingsGroupedDeployable.wrap(serverConfig, this.myProject);
                this.myWraps.put(serverConfig, settingsDeployable);
            }
            return settingsDeployable;
        }

        @Override
        public int size() {
            return this.myList.size();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/jetbrains/plugins/webDeployment/ui/config/DeploymentServersEditor$MyWrappingList", "<init>"));
        }
    }

    private final class AddServerAction
    extends AnAction
    implements DumbAware {
        final AccessType myAccessType;
        @Nullable
        private final SettingsGroupedDeployable myPredefinedParentGroup;

        private AddServerAction(@Nullable AccessType type, SettingsGroupedDeployable groupedDeployable) {
            if (type == null) {
                AddServerAction.$$$reportNull$$$0(0);
            }
            super(type.getTitle(), null, type.getIcon());
            this.myAccessType = type;
            this.myPredefinedParentGroup = groupedDeployable;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Object editableObject;
            Object component;
            TreePath path;
            SettingsGroupedDeployable groupToAdd;
            String name;
            if (e == null) {
                AddServerAction.$$$reportNull$$$0(1);
            }
            if ((name = DeploymentServersEditor.this.askForServerName(WDBundle.message("add.server.create.new.server", new Object[0]))) == null) {
                return;
            }
            WebServerConfig server = new WebServerConfig(WebServerConfig.getNextId());
            server.initializeNewCreatedServer(DeploymentServersEditor.this.myProject.isDefault());
            server.setName(name);
            server.getFileTransferConfig().setAccessType(this.myAccessType);
            server.getFileTransferConfig().setPort(this.myAccessType.getDefaultPort());
            if (this.myAccessType == AccessType.MOUNT) {
                server.setUrl("http://localhost");
            }
            if ((groupToAdd = this.myPredefinedParentGroup) == null && (path = DeploymentServersEditor.this.myTree.getSelectionPath()) != null && (component = path.getLastPathComponent()) instanceof MasterDetailsComponent.MyNode && (editableObject = ((MasterDetailsComponent.MyNode)component).getConfigurable().getEditableObject()) instanceof SettingsGroupedDeployable && !((SettingsGroupedDeployable)editableObject).isSingleServer()) {
                groupToAdd = (SettingsGroupedDeployable)editableObject;
            }
            SettingsDeployable newItem = SettingsDeployable.create(server, groupToAdd != null, null);
            DeploymentServersEditor.this.onItemCreated(newItem, groupToAdd);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/config/DeploymentServersEditor$AddServerAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyTransferable
    implements Transferable {
        @NotNull
        private final Pair<SettingsGroupedDeployable, SettingsDeployable> myGroupAndServer;

        MyTransferable(@NotNull Pair<SettingsGroupedDeployable, SettingsDeployable> groupAndServer) {
            if (groupAndServer == null) {
                MyTransferable.$$$reportNull$$$0(0);
            }
            this.myGroupAndServer = groupAndServer;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DnDEventImpl.ourDataFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DnDEventImpl.ourDataFlavor == flavor;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (DnDEventImpl.ourDataFlavor.equals(flavor)) {
                return this.myGroupAndServer;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupAndServer", "com/jetbrains/plugins/webDeployment/ui/config/DeploymentServersEditor$MyTransferable", "<init>"));
        }
    }

    private final class AddGroupAction
    extends AnAction
    implements DumbAware {
        private AddGroupAction() {
            super(WDBundle.messagePointer("add.group.server.group", new Object[0]), AllIcons.Webreferences.Server);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            String name;
            if (e == null) {
                AddGroupAction.$$$reportNull$$$0(0);
            }
            if ((name = DeploymentServersEditor.this.askForGroupName(WDBundle.message("add.group.create.new.group", new Object[0]))) == null) {
                return;
            }
            SettingsGroup group = new SettingsGroup();
            group.setName(name);
            if (DeploymentServersEditor.this.myProject.isDefault()) {
                group.setIsProjectLevel(false);
            }
            DeploymentServersEditor.this.onGroupCreated(group);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/plugins/webDeployment/ui/config/DeploymentServersEditor$AddGroupAction", "actionPerformed"));
        }
    }
}

