/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.debugger;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.helper.JupyterHelper;
import com.intellij.jupyter.py.debugger.JupyterCellSourcePosition;
import com.intellij.jupyter.py.debugger.JupyterDebugCellId;
import com.intellij.jupyter.py.debugger.JupyterDebugProcess;
import com.intellij.jupyter.py.debugger.JupyterDebuggerUtilsKt;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.DigestUtil;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u000f\b\u0007\u0018\u0000 72\u00020\u0001:\u00017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u000eJ\u001e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001bH\u0002J\u001f\u0010\u001c\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u000b\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0015\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\n\u00a2\u0006\u0004\b\"\u0010#J\u0015\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u000e\u00a2\u0006\u0004\b&\u0010'J\u000e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0011J\u0015\u0010+\u001a\u00020)2\u0006\u0010*\u001a\u00020\u000b\u00a2\u0006\u0004\b,\u0010-J\u0018\u0010.\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u000eH\u0002J\u001f\u0010/\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b0\u00101J\u0010\u00102\u001a\u00020\u00112\u0006\u00103\u001a\u00020\u0011H\u0002J\u0010\u00104\u001a\u00020\u00112\u0006\u00103\u001a\u00020\u0011H\u0002J\u0010\u00105\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\u0011H\u0002J\b\u00106\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/intellij/jupyter/py/debugger/JupyterDebugCellIdManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "cellPositionToCellId", "", "Lcom/intellij/jupyter/py/debugger/JupyterCellSourcePosition;", "Lcom/intellij/jupyter/py/debugger/JupyterDebugCellId;", "cellIdToCellPosition", "cellToCellPosition", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "indexedFiles", "", "", "updatePositions", "", "virtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "latestExecutedCell", "updateCellToCellPositionMap", "originalFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "cells", "", "getCellPositionByCellId", "cellId", "getCellPositionByCellId-uHQkgfc", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)Lcom/intellij/jupyter/py/debugger/JupyterCellSourcePosition;", "getCellIdByPosition", "cellPosition", "getCellIdByPosition-AG_RinQ", "(Lcom/intellij/jupyter/py/debugger/JupyterCellSourcePosition;)Ljava/lang/String;", "getCellIdByCell", "cell", "getCellIdByCell-AG_RinQ", "(Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;)Ljava/lang/String;", "isFileIndexed", "", "filepath", "isCellId", "isCellId-nnF9l_Q", "(Ljava/lang/String;)Z", "updateCellIds", "generateCellId", "generateCellId-B93LMzM", "(Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;)Ljava/lang/String;", "computeCellContentHash", "cellText", "removeCellIdentifierLines", "cleanPositionsForFile", "dispose", "Companion", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterDebugCellIdManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterDebugCellIdManager.kt\ncom/intellij/jupyter/py/debugger/JupyterDebugCellIdManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,158:1\n1915#2,2:159\n1915#2,2:161\n3938#3:163\n4474#3,2:164\n540#4:166\n525#4,6:167\n540#4:173\n525#4,6:174\n540#4:180\n525#4,6:181\n*S KotlinDebug\n*F\n+ 1 JupyterDebugCellIdManager.kt\ncom/intellij/jupyter/py/debugger/JupyterDebugCellIdManager\n*L\n39#1:159,2\n49#1:161,2\n110#1:163\n110#1:164,2\n114#1:166\n114#1:167,6\n115#1:173\n115#1:174,6\n116#1:180\n116#1:181,6\n*E\n"})
public final class JupyterDebugCellIdManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private Map<JupyterCellSourcePosition, JupyterDebugCellId> cellPositionToCellId;
    @NotNull
    private Map<JupyterDebugCellId, JupyterCellSourcePosition> cellIdToCellPosition;
    @NotNull
    private Map<NotebookIntervalPointer, JupyterCellSourcePosition> cellToCellPosition;
    @NotNull
    private Set<String> indexedFiles;
    @NotNull
    private static final String DEBUG_PREFIX = "# pydev_debug_cell";
    @NotNull
    private static final Logger LOG;

    public JupyterDebugCellIdManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.cellPositionToCellId = new LinkedHashMap();
        this.cellIdToCellPosition = new LinkedHashMap();
        this.cellToCellPosition = new LinkedHashMap();
        this.indexedFiles = new LinkedHashSet();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final synchronized void updatePositions(@NotNull Project project, @NotNull BackedNotebookVirtualFile virtualFile, @Nullable NotebookIntervalPointer latestExecutedCell) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        VirtualFile originalFile = virtualFile.getOriginFile();
        String string = originalFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String filePath = string;
        this.cleanPositionsForFile(filePath);
        this.indexedFiles.add(filePath);
        List cells = JupyterHelper.INSTANCE.getIntervalPointers(project, virtualFile);
        this.updateCellToCellPositionMap(originalFile, cells);
        Iterable $this$forEach$iv = cells;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NotebookIntervalPointer cell = (NotebookIntervalPointer)element$iv;
            boolean bl = false;
            this.updateCellIds(virtualFile, cell);
        }
        if (latestExecutedCell != null) {
            this.updateCellIds(virtualFile, latestExecutedCell);
        }
    }

    public static /* synthetic */ void updatePositions$default(JupyterDebugCellIdManager jupyterDebugCellIdManager, Project project, BackedNotebookVirtualFile backedNotebookVirtualFile, NotebookIntervalPointer notebookIntervalPointer, int n, Object object) {
        if ((n & 4) != 0) {
            notebookIntervalPointer = null;
        }
        jupyterDebugCellIdManager.updatePositions(project, backedNotebookVirtualFile, notebookIntervalPointer);
    }

    private final void updateCellToCellPositionMap(VirtualFile originalFile, List<? extends NotebookIntervalPointer> cells) {
        Iterable $this$forEach$iv = cells;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JupyterCellSourcePosition cellSourcePosition;
            NotebookIntervalPointer cell = (NotebookIntervalPointer)element$iv;
            boolean bl = false;
            if (JupyterDebuggerUtilsKt.getCellPositionForJupyterCell(originalFile, cell) == null) {
                JupyterDebugCellIdManager it = this;
                boolean bl2 = false;
                LOG.warn("Cell position is null for " + cell);
                continue;
            }
            this.cellToCellPosition.put(cell, cellSourcePosition);
        }
    }

    @Nullable
    public final synchronized JupyterCellSourcePosition getCellPositionByCellId-uHQkgfc(@NotNull Project project, @NotNull String cellId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cellId, (String)"cellId");
        JupyterCellSourcePosition position = this.cellIdToCellPosition.get(JupyterDebugCellId.box-impl(cellId));
        if (position == null) {
            JupyterDebugProcess.Companion.showCellEditedDuringSession(project);
        }
        return position;
    }

    @NotNull
    public final synchronized String getCellIdByPosition-AG_RinQ(@NotNull JupyterCellSourcePosition cellPosition) {
        Intrinsics.checkNotNullParameter((Object)cellPosition, (String)"cellPosition");
        JupyterDebugCellId jupyterDebugCellId = this.cellPositionToCellId.get(cellPosition);
        String string = jupyterDebugCellId != null ? jupyterDebugCellId.unbox-impl() : null;
        if (string == null) {
            string = JupyterDebugCellId.constructor-impl("");
        }
        return string;
    }

    @NotNull
    public final synchronized String getCellIdByCell-AG_RinQ(@NotNull NotebookIntervalPointer cell) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        JupyterDebugCellId jupyterDebugCellId = this.cellPositionToCellId.get(this.cellToCellPosition.get(cell));
        String string = jupyterDebugCellId != null ? jupyterDebugCellId.unbox-impl() : null;
        if (string == null) {
            string = JupyterDebugCellId.constructor-impl("");
        }
        return string;
    }

    public final synchronized boolean isFileIndexed(@NotNull String filepath) {
        Intrinsics.checkNotNullParameter((Object)filepath, (String)"filepath");
        return this.indexedFiles.contains(filepath);
    }

    public final boolean isCellId-nnF9l_Q(@NotNull String filepath) {
        Intrinsics.checkNotNullParameter((Object)filepath, (String)"filepath");
        return this.cellIdToCellPosition.containsKey(JupyterDebugCellId.box-impl(filepath));
    }

    private final void updateCellIds(BackedNotebookVirtualFile virtualFile, NotebookIntervalPointer cell) {
        String cellId = this.generateCellId-B93LMzM(virtualFile, cell);
        JupyterCellSourcePosition cellPosition = this.cellToCellPosition.get(cell);
        if (cellPosition != null) {
            this.cellPositionToCellId.put(cellPosition, JupyterDebugCellId.box-impl(cellId));
            this.cellIdToCellPosition.put(JupyterDebugCellId.box-impl(cellId), cellPosition);
        }
    }

    private final String generateCellId-B93LMzM(BackedNotebookVirtualFile virtualFile, NotebookIntervalPointer cell) {
        String cellText = Companion.extractCellTextAndRemoveFirstEmptyLine$intellij_jupyter_py(virtualFile, cell);
        String id = this.computeCellContentHash(cellText);
        return JupyterDebugCellId.constructor-impl(id);
    }

    private final String computeCellContentHash(String cellText) {
        String filteredCellContent = this.removeCellIdentifierLines(cellText);
        byte[] byArray = filteredCellContent.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return DigestUtil.sha256Hex((byte[])byArray);
    }

    /*
     * WARNING - void declaration
     */
    private final String removeCellIdentifierLines(String cellText) {
        void $this$filterTo$iv$iv;
        String[] lines;
        String[] stringArray = StringUtil.splitByLinesKeepSeparators((String)cellText);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"splitByLinesKeepSeparators(...)");
        String[] $this$filter$iv = lines = stringArray;
        boolean $i$f$filter = false;
        String[] stringArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void text = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            Intrinsics.checkNotNull((Object)text);
            if (!(!StringsKt.contains$default((CharSequence)((CharSequence)text), (CharSequence)"#%%", (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    private final void cleanPositionsForFile(String filepath) {
        boolean bl;
        Map.Entry<Object, Object> it;
        Map<JupyterDebugCellId, JupyterCellSourcePosition> $this$filterTo$iv$iv;
        Map<JupyterDebugCellId, JupyterCellSourcePosition> $this$filter$iv;
        Map<JupyterCellSourcePosition, JupyterDebugCellId> map = this.cellPositionToCellId;
        JupyterDebugCellIdManager jupyterDebugCellIdManager = this;
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        for (Map.Entry entry : $this$filterTo$iv$iv.entrySet()) {
            it = entry;
            bl = false;
            if (!(!Intrinsics.areEqual((Object)((JupyterCellSourcePosition)it.getKey()).getStart().getFile().getPath(), (Object)filepath))) continue;
            destination$iv$iv.put(entry.getKey(), entry.getValue());
        }
        jupyterDebugCellIdManager.cellPositionToCellId = MapsKt.toMutableMap((Map)destination$iv$iv);
        $this$filter$iv = this.cellIdToCellPosition;
        jupyterDebugCellIdManager = this;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        $i$f$filterTo = false;
        for (Map.Entry<Object, Object> entry : $this$filterTo$iv$iv.entrySet()) {
            it = entry;
            bl = false;
            if (!(!Intrinsics.areEqual((Object)((JupyterCellSourcePosition)it.getValue()).getStart().getFile().getPath(), (Object)filepath))) continue;
            destination$iv$iv.put(entry.getKey(), entry.getValue());
        }
        jupyterDebugCellIdManager.cellIdToCellPosition = MapsKt.toMutableMap((Map)destination$iv$iv);
        $this$filter$iv = this.cellToCellPosition;
        jupyterDebugCellIdManager = this;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        $i$f$filterTo = false;
        for (Map.Entry<Object, Object> entry : $this$filterTo$iv$iv.entrySet()) {
            it = entry;
            bl = false;
            if (!(!Intrinsics.areEqual((Object)((JupyterCellSourcePosition)it.getValue()).getStart().getFile().getPath(), (Object)filepath))) continue;
            destination$iv$iv.put(entry.getKey(), entry.getValue());
        }
        jupyterDebugCellIdManager.cellToCellPosition = MapsKt.toMutableMap((Map)destination$iv$iv);
    }

    public void dispose() {
        this.cellPositionToCellId.clear();
        this.cellIdToCellPosition.clear();
        this.cellToCellPosition.clear();
    }

    static {
        Logger logger = Logger.getInstance(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001d\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u000eR\u000e\u0010\u000f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/jupyter/py/debugger/JupyterDebugCellIdManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/jupyter/py/debugger/JupyterDebugCellIdManager;", "project", "Lcom/intellij/openapi/project/Project;", "extractCellTextAndRemoveFirstEmptyLine", "", "virtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "cell", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "extractCellTextAndRemoveFirstEmptyLine$intellij_jupyter_py", "DEBUG_PREFIX", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.jupyter.py"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JupyterDebugCellIdManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(JupyterDebugCellIdManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (JupyterDebugCellIdManager)object;
        }

        @NotNull
        public final String extractCellTextAndRemoveFirstEmptyLine$intellij_jupyter_py(@NotNull BackedNotebookVirtualFile virtualFile, @NotNull NotebookIntervalPointer cell) {
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
            String string = (String)ActionsKt.runReadAction(() -> Companion.extractCellTextAndRemoveFirstEmptyLine$lambda$0(cell, virtualFile));
            if (string == null) {
                return "";
            }
            String cellText = string;
            Object[] objectArray = StringUtil.splitByLinesKeepSeparators((String)cellText);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"splitByLinesKeepSeparators(...)");
            Object[] lines = objectArray;
            if (!(lines.length == 0)) {
                String string2 = lines[0];
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"get(...)");
                if (StringsKt.isBlank((CharSequence)string2)) {
                    lines[0] = JupyterDebugCellIdManager.DEBUG_PREFIX + (String)lines[0];
                }
            }
            return ((Object)StringsKt.trimEnd((CharSequence)ArraysKt.joinToString$default((Object[])lines, (CharSequence)"", null, null, (int)0, null, null, (int)62, null))).toString() + "\n";
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private static final String extractCellTextAndRemoveFirstEmptyLine$lambda$0(NotebookIntervalPointer $cell, BackedNotebookVirtualFile $virtualFile) {
            NotebookCellLines.Interval interval = $cell.get();
            return interval != null ? interval.getContentText($virtualFile.getFile()) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

