/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.debugger.remote;

import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterConfiguredServerConfig;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterManagedServerConfig;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterServerConfig;
import com.intellij.jupyter.py.debugger.JupyterEditorSourcePosition;
import com.intellij.jupyter.py.debugger.JupyterPositionConverter;
import com.intellij.jupyter.py.debugger.remote.JupyterRemoteDebuggerAdapter;
import com.intellij.jupyter.py.debugger.remote.JupyterRemotePositionConverter;
import com.intellij.jupyter.py.debugger.remote.JupyterRemotePyStackFrame;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.PyLocalPositionConverter;
import com.jetbrains.python.debugger.PyStackFrameInfo;
import com.jetbrains.python.debugger.PyThreadInfo;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/jupyter/py/debugger/remote/JupyterRemoteExecutionStack;", "Lcom/intellij/xdebugger/frame/XExecutionStack;", "frameAccessor", "Lcom/jetbrains/python/debugger/PyFrameAccessor;", "threadInfo", "Lcom/jetbrains/python/debugger/PyThreadInfo;", "debuggerAdapter", "Lcom/intellij/jupyter/py/debugger/remote/JupyterRemoteDebuggerAdapter;", "<init>", "(Lcom/jetbrains/python/debugger/PyFrameAccessor;Lcom/jetbrains/python/debugger/PyThreadInfo;Lcom/intellij/jupyter/py/debugger/remote/JupyterRemoteDebuggerAdapter;)V", "getTopFrame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "computeStackFrames", "", "firstFrameIndex", "", "container", "Lcom/intellij/xdebugger/frame/XExecutionStack$XStackFrameContainer;", "getSourcePosition", "Lcom/intellij/jupyter/py/debugger/JupyterEditorSourcePosition;", "frameInfo", "Lcom/jetbrains/python/debugger/PyStackFrameInfo;", "getPositionConverter", "Lcom/jetbrains/python/debugger/PyLocalPositionConverter;", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterRemoteExecutionStack.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterRemoteExecutionStack.kt\ncom/intellij/jupyter/py/debugger/remote/JupyterRemoteExecutionStack\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,51:1\n1915#2,2:52\n1#3:54\n*S KotlinDebug\n*F\n+ 1 JupyterRemoteExecutionStack.kt\ncom/intellij/jupyter/py/debugger/remote/JupyterRemoteExecutionStack\n*L\n29#1:52,2\n*E\n"})
public final class JupyterRemoteExecutionStack
extends XExecutionStack {
    @NotNull
    private final PyFrameAccessor frameAccessor;
    @NotNull
    private final PyThreadInfo threadInfo;
    @NotNull
    private final JupyterRemoteDebuggerAdapter debuggerAdapter;

    public JupyterRemoteExecutionStack(@NotNull PyFrameAccessor frameAccessor, @NotNull PyThreadInfo threadInfo, @NotNull JupyterRemoteDebuggerAdapter debuggerAdapter) {
        Intrinsics.checkNotNullParameter((Object)frameAccessor, (String)"frameAccessor");
        Intrinsics.checkNotNullParameter((Object)threadInfo, (String)"threadInfo");
        Intrinsics.checkNotNullParameter((Object)debuggerAdapter, (String)"debuggerAdapter");
        super(threadInfo.getName());
        this.frameAccessor = frameAccessor;
        this.threadInfo = threadInfo;
        this.debuggerAdapter = debuggerAdapter;
    }

    @Nullable
    public XStackFrame getTopFrame() {
        List list = this.threadInfo.getFrames();
        if (list == null || (list = (PyStackFrameInfo)CollectionsKt.firstOrNull((List)list)) == null) {
            return null;
        }
        List topFrameInfo = list;
        Project project = this.frameAccessor.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        return (XStackFrame)new JupyterRemotePyStackFrame(project2, this.frameAccessor, (PyStackFrameInfo)topFrameInfo, this.getSourcePosition((PyStackFrameInfo)topFrameInfo));
    }

    public void computeStackFrames(int firstFrameIndex, @NotNull XExecutionStack.XStackFrameContainer container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Project project = this.frameAccessor.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        List stackFrames = new ArrayList();
        List list = this.threadInfo.getFrames();
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PyStackFrameInfo frameInfo = (PyStackFrameInfo)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)frameInfo);
                stackFrames.add(new JupyterRemotePyStackFrame(project2, this.frameAccessor, frameInfo, this.getSourcePosition(frameInfo)));
            }
        }
        container.addStackFrames(stackFrames, true);
    }

    private final JupyterEditorSourcePosition getSourcePosition(PyStackFrameInfo frameInfo) {
        JupyterEditorSourcePosition jupyterEditorSourcePosition;
        PyLocalPositionConverter pyLocalPositionConverter = this.getPositionConverter();
        if (pyLocalPositionConverter == null) {
            return null;
        }
        PyLocalPositionConverter positionConverter = pyLocalPositionConverter;
        XSourcePosition xSourcePosition = positionConverter.convertFromPython(frameInfo.getPosition(), frameInfo.getName());
        if (xSourcePosition != null) {
            XSourcePosition position = xSourcePosition;
            boolean bl = false;
            jupyterEditorSourcePosition = new JupyterEditorSourcePosition(position);
        } else {
            jupyterEditorSourcePosition = null;
        }
        return jupyterEditorSourcePosition;
    }

    private final PyLocalPositionConverter getPositionConverter() {
        PyLocalPositionConverter pyLocalPositionConverter;
        JupyterServerConfig jupyterServerConfig = this.debuggerAdapter.getServerConfigs$intellij_jupyter_py();
        if (jupyterServerConfig instanceof JupyterManagedServerConfig) {
            JupyterPositionConverter jupyterPositionConverter;
            Project project = this.frameAccessor.getProject();
            if (project != null) {
                Project it = project;
                boolean bl = false;
                jupyterPositionConverter = new JupyterPositionConverter(it);
            } else {
                jupyterPositionConverter = null;
            }
            pyLocalPositionConverter = jupyterPositionConverter;
        } else {
            pyLocalPositionConverter = jupyterServerConfig instanceof JupyterConfiguredServerConfig ? (PyLocalPositionConverter)new JupyterRemotePositionConverter() : (jupyterServerConfig == null ? null : null);
        }
        return pyLocalPositionConverter;
    }
}

