/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.api;

import com.intellij.openapi.util.text.StringUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\f\u001a\u00020\rJ\u0011\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0000H\u0086\u0002J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u0013\u001a\u00020\u00142\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0015\u001a\u00020\u0005H\u00d6\u0081\u0004J\n\u0010\u0016\u001a\u00020\rH\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/intellij/indexing/shared/platform/api/SharedIndexStats;", "", "sizeInBytes", "", "chunks", "", "<init>", "(JI)V", "getSizeInBytes", "()J", "getChunks", "()I", "toLogMessage", "", "plus", "other", "component1", "component2", "copy", "equals", "", "hashCode", "toString", "intellij.indexing.shared"})
public final class SharedIndexStats {
    private final long sizeInBytes;
    private final int chunks;

    public SharedIndexStats(long sizeInBytes, int chunks) {
        this.sizeInBytes = sizeInBytes;
        this.chunks = chunks;
    }

    public final long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public final int getChunks() {
        return this.chunks;
    }

    @NotNull
    public final String toLogMessage() {
        if (this.chunks < 0) {
            return "<failed to compute stats>";
        }
        if (this.chunks == 0) {
            return "<empty>";
        }
        return this.chunks + " chunk(s), " + StringUtil.formatFileSize((long)this.sizeInBytes);
    }

    @NotNull
    public final SharedIndexStats plus(@NotNull SharedIndexStats other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new SharedIndexStats(this.sizeInBytes + other.sizeInBytes, this.chunks + other.chunks);
    }

    public final long component1() {
        return this.sizeInBytes;
    }

    public final int component2() {
        return this.chunks;
    }

    @NotNull
    public final SharedIndexStats copy(long sizeInBytes, int chunks) {
        return new SharedIndexStats(sizeInBytes, chunks);
    }

    public static /* synthetic */ SharedIndexStats copy$default(SharedIndexStats sharedIndexStats, long l, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            l = sharedIndexStats.sizeInBytes;
        }
        if ((n2 & 2) != 0) {
            n = sharedIndexStats.chunks;
        }
        return sharedIndexStats.copy(l, n);
    }

    @NotNull
    public String toString() {
        return "SharedIndexStats(sizeInBytes=" + this.sizeInBytes + ", chunks=" + this.chunks + ")";
    }

    public int hashCode() {
        int result = Long.hashCode(this.sizeInBytes);
        result = result * 31 + Integer.hashCode(this.chunks);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SharedIndexStats)) {
            return false;
        }
        SharedIndexStats sharedIndexStats = (SharedIndexStats)other;
        if (this.sizeInBytes != sharedIndexStats.sizeInBytes) {
            return false;
        }
        return this.chunks == sharedIndexStats.chunks;
    }
}

