/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl.layout;

import com.intellij.codeWithMe.ClientId;
import com.intellij.indexing.shared.metadata.SharedIndexMetadata;
import com.intellij.indexing.shared.platform.api.layout.SharedChunkLocation;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHashEnumerator;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHashProvider;
import com.intellij.indexing.shared.platform.hash.SharedIndexHashProviders;
import com.intellij.indexing.shared.platform.hash.SharedIndexHashStorages;
import com.intellij.indexing.shared.platform.impl.EmptyIndexEnumerator;
import com.intellij.indexing.shared.platform.impl.layout.FileBasedSharedIndexLocation;
import com.intellij.indexing.shared.platform.impl.layout.FileBasedSharedStubIndexLocation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.indexing.IndexId;
import java.io.Closeable;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J2\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\t0\u0007\"\u0004\b\u0000\u0010\b\"\u0004\b\u0001\u0010\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\t0\u000bJ4\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\t0\u0007\"\u0004\b\u0000\u0010\b\"\u0004\b\u0001\u0010\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\t0\u000bH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\"\u0010\u0017\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u00180\u000e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\n\u0010\u001d\u001a\u00020\u000fH\u0096\u0080\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/indexing/shared/platform/impl/layout/FileBasedSharedChunkLocation;", "Lcom/intellij/indexing/shared/platform/api/layout/SharedChunkLocation;", "chunkRoot", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "getIndexLocation", "Lcom/intellij/indexing/shared/platform/impl/layout/FileBasedSharedIndexLocation;", "K", "V", "indexId", "Lcom/intellij/util/indexing/IndexId;", "getNonStubIndexLocation", "getIndexIds", "", "", "getStubIndexLocation", "Lcom/intellij/indexing/shared/platform/impl/layout/FileBasedSharedStubIndexLocation;", "readEmptyIndexes", "", "readEmptyStubIndexes", "readSharedIndexMetadata", "Lcom/intellij/indexing/shared/metadata/SharedIndexMetadata;", "createContentHashEnumerators", "Lkotlin/Pair;", "Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHashProvider;", "Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHashEnumerator;", "disposable", "Lcom/intellij/openapi/Disposable;", "toString", "intellij.indexing.shared"})
@SourceDebugExtension(value={"SMAP\nFileBasedSharedChunkLocation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileBasedSharedChunkLocation.kt\ncom/intellij/indexing/shared/platform/impl/layout/FileBasedSharedChunkLocation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n1586#2:72\n1661#2,3:73\n1642#2,10:76\n1915#2:86\n1916#2:92\n1652#2:93\n42#3,3:87\n23#4:90\n1#5:91\n*S KotlinDebug\n*F\n+ 1 FileBasedSharedChunkLocation.kt\ncom/intellij/indexing/shared/platform/impl/layout/FileBasedSharedChunkLocation\n*L\n35#1:72\n35#1:73,3\n56#1:76,10\n56#1:86\n56#1:92\n56#1:93\n58#1:87,3\n64#1:90\n56#1:91\n*E\n"})
public final class FileBasedSharedChunkLocation
implements SharedChunkLocation {
    @NotNull
    private final Path chunkRoot;

    public FileBasedSharedChunkLocation(@NotNull Path chunkRoot) {
        Intrinsics.checkNotNullParameter((Object)chunkRoot, (String)"chunkRoot");
        this.chunkRoot = chunkRoot;
    }

    @NotNull
    public final <K, V> FileBasedSharedIndexLocation<K, V> getIndexLocation(@NotNull IndexId<K, V> indexId) {
        Intrinsics.checkNotNullParameter(indexId, (String)"indexId");
        if (Intrinsics.areEqual(indexId, (Object)StubUpdatingIndex.INDEX_ID)) {
            FileBasedSharedStubIndexLocation fileBasedSharedStubIndexLocation = this.getStubIndexLocation();
            Intrinsics.checkNotNull((Object)fileBasedSharedStubIndexLocation, (String)"null cannot be cast to non-null type com.intellij.indexing.shared.platform.impl.layout.FileBasedSharedIndexLocation<K of com.intellij.indexing.shared.platform.impl.layout.FileBasedSharedChunkLocation.getIndexLocation, V of com.intellij.indexing.shared.platform.impl.layout.FileBasedSharedChunkLocation.getIndexLocation>");
            return fileBasedSharedStubIndexLocation;
        }
        return this.getNonStubIndexLocation((IndexId)indexId);
    }

    @NotNull
    public <K, V> FileBasedSharedIndexLocation<K, V> getNonStubIndexLocation(@NotNull IndexId<K, V> indexId) {
        Intrinsics.checkNotNullParameter(indexId, (String)"indexId");
        Path path = this.chunkRoot.resolve(indexId.getName());
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return new FileBasedSharedIndexLocation(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> getIndexIds() {
        List list;
        Closeable closeable = Files.newDirectoryStream(this.chunkRoot);
        Throwable throwable = null;
        try {
            void $this$mapTo$iv$iv;
            DirectoryStream stream = (DirectoryStream)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)stream);
            Iterable $this$map$iv = stream;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void dir;
                Path path = (Path)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(((Object)dir.getFileName()).toString());
            }
            list = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return list;
    }

    @Override
    @NotNull
    public FileBasedSharedStubIndexLocation getStubIndexLocation() {
        Path path = this.chunkRoot.resolve(StubUpdatingIndex.INDEX_ID.getName());
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return new FileBasedSharedStubIndexLocation(path);
    }

    @Override
    @NotNull
    public Set<String> readEmptyIndexes() {
        Set<String> set = EmptyIndexEnumerator.readEmptyIndexes(this.chunkRoot);
        Intrinsics.checkNotNullExpressionValue(set, (String)"readEmptyIndexes(...)");
        return set;
    }

    @Override
    @NotNull
    public Set<String> readEmptyStubIndexes() {
        Set<String> set = EmptyIndexEnumerator.readEmptyStubIndexes(this.chunkRoot);
        Intrinsics.checkNotNullExpressionValue(set, (String)"readEmptyStubIndexes(...)");
        return set;
    }

    @Override
    @Nullable
    public SharedIndexMetadata readSharedIndexMetadata() {
        return SharedIndexMetadata.Companion.readSharedIndexMetadata(this.chunkRoot);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Pair<SharedIndexContentHashProvider, SharedIndexContentHashEnumerator>> createContentHashEnumerators(@NotNull Disposable disposable) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Iterable $this$mapNotNull$iv = SharedIndexHashProviders.getSortedSharedIndexHashingProviders();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            block6: {
                Pair pair2;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                SharedIndexContentHashProvider it = (SharedIndexContentHashProvider)element$iv$iv;
                boolean bl2 = false;
                try {
                    boolean $i$f$service = false;
                    Class<SharedIndexHashStorages> serviceClass$iv = SharedIndexHashStorages.class;
                    Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                    if (object == null) {
                        throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                    }
                    SharedIndexContentHashEnumerator enumerator = ((SharedIndexHashStorages)object).openHashEnumerator(this.chunkRoot, it.getInfo(), disposable);
                    if (enumerator == null) {
                        pair = null;
                        break block6;
                    }
                    pair2 = TuplesKt.to((Object)it, (Object)enumerator);
                }
                catch (Throwable t) {
                    if (t instanceof ControlFlowException) {
                        throw t;
                    }
                    FileBasedSharedChunkLocation $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(FileBasedSharedChunkLocation.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.warn("Failed to open enumerator for " + it.getInfo().getProviderId() + " from " + this.chunkRoot + ". " + t.getMessage(), t);
                    pair2 = null;
                }
                pair = pair2;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public String toString() {
        return "FileBasedSharedChunkLocation(chunkRoot=" + this.chunkRoot + ")";
    }
}

