/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.com.github.weisj.jsvg.geometry.path;

import java.awt.geom.Path2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.relocated.com.github.weisj.jsvg.geometry.path.BuildHistory;
import org.jetbrains.relocated.com.github.weisj.jsvg.geometry.path.PathCommand;

final class Vertical
extends PathCommand {
    private final float y;

    public Vertical(boolean isRelative, float y2) {
        super(isRelative, 2);
        this.y = y2;
    }

    @Override
    public void appendPath(@NotNull Path2D path2, @NotNull BuildHistory hist) {
        float xOff = hist.lastPoint.x;
        float yOff = this.isRelative() ? hist.lastPoint.y : 0.0f;
        path2.lineTo(xOff, this.y + yOff);
        hist.setLastPoint(path2.getCurrentPoint());
        hist.setLastKnot(path2.getCurrentPoint());
    }

    public String toString() {
        return "V " + this.y;
    }
}

