/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.quickfixes;

import com.intellij.codeInsight.intention.EventTrackingIntentionAction;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.choice.ChoiceTitleIntentionAction;
import com.intellij.codeInsight.intention.choice.ChoiceVariantIntentionAction;
import com.intellij.codeInsight.intention.choice.DefaultIntentionActionWithChoice;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.spellchecker.quickfixes.LazySuggestions;
import com.intellij.spellchecker.statistics.SpellcheckerActionStatistics;
import com.intellij.spellchecker.statistics.SpellcheckerRateTracker;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u001f2\u00020\u00012\u00020\u0002:\u0004\u001f !\"B?\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0010\b\u0002\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0007\u001a\u00020\u001eH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u000f\u001a\u0015\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00060\u00060\u0010\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/spellchecker/quickfixes/ChangeTo;", "Lcom/intellij/codeInsight/intention/choice/DefaultIntentionActionWithChoice;", "Lcom/intellij/spellchecker/quickfixes/LazySuggestions;", "typo", "", "element", "Lcom/intellij/psi/PsiElement;", "range", "Lcom/intellij/openapi/util/TextRange;", "tracker", "Lcom/intellij/spellchecker/statistics/SpellcheckerRateTracker;", "suggestions", "", "<init>", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;Lcom/intellij/spellchecker/statistics/SpellcheckerRateTracker;Ljava/util/Set;)V", "pointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getTitle", "Lcom/intellij/codeInsight/intention/choice/ChoiceTitleIntentionAction;", "getVariants", "", "Lcom/intellij/codeInsight/intention/choice/ChoiceVariantIntentionAction;", "removeHighlightersWithExactRange", "", "document", "Lcom/intellij/openapi/editor/Document;", "project", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/openapi/util/Segment;", "Companion", "ChangeToTitleAction", "ChangeToVariantAction", "ForPreview", "intellij.spellchecker"})
@SourceDebugExtension(value={"SMAP\nChangeTo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeTo.kt\ncom/intellij/spellchecker/quickfixes/ChangeTo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,143:1\n1586#2:144\n1661#2,3:145\n*S KotlinDebug\n*F\n+ 1 ChangeTo.kt\ncom/intellij/spellchecker/quickfixes/ChangeTo\n*L\n120#1:144\n120#1:145,3\n*E\n"})
public final class ChangeTo
extends LazySuggestions
implements DefaultIntentionActionWithChoice {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TextRange range;
    @Nullable
    private final SpellcheckerRateTracker tracker;
    @NotNull
    private final SmartPsiElementPointer<PsiElement> pointer;
    @NotNull
    private static final Lazy<String> fixName$delegate = LazyKt.lazy(ChangeTo::fixName_delegate$lambda$0);

    @JvmOverloads
    public ChangeTo(@NotNull String typo, @NotNull PsiElement element, @NotNull TextRange range, @Nullable SpellcheckerRateTracker tracker, @Nullable Set<String> suggestions) {
        Intrinsics.checkNotNullParameter((Object)typo, (String)"typo");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        super(typo, suggestions);
        this.range = range;
        this.tracker = tracker;
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer(element, element.getContainingFile());
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createSmartPsiElementPointer(...)");
        this.pointer = smartPsiElementPointer;
    }

    public /* synthetic */ ChangeTo(String string, PsiElement psiElement, TextRange textRange, SpellcheckerRateTracker spellcheckerRateTracker, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            spellcheckerRateTracker = null;
        }
        if ((n & 0x10) != 0) {
            set = null;
        }
        this(string, psiElement, textRange, spellcheckerRateTracker, set);
    }

    @NotNull
    public ChoiceTitleIntentionAction getTitle() {
        return ChangeToTitleAction.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ChoiceVariantIntentionAction> getVariants() {
        void $this$mapTo$iv$iv;
        int limit = Registry.Companion.intValue("spellchecker.corrections.limit");
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)limit);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ChangeToVariantAction(this, (int)it, this.tracker));
        }
        return (List)destination$iv$iv;
    }

    private final void removeHighlightersWithExactRange(Document document, Project project, Segment range) {
        if (IntentionPreviewUtils.isIntentionPreviewActive()) {
            return;
        }
        ThreadingAssertions.assertEventDispatchThread();
        MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)document, (Project)project, (boolean)false);
        if (markupModel == null) {
            return;
        }
        MarkupModel model = markupModel;
        RangeHighlighter[] rangeHighlighterArray = model.getAllHighlighters();
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterArray, (String)"getAllHighlighters(...)");
        for (RangeHighlighter rangeHighlighter : rangeHighlighterArray) {
            Intrinsics.checkNotNull((Object)rangeHighlighter);
            RangeHighlighter highlighter = rangeHighlighter;
            if (!TextRange.areSegmentsEqual((Segment)range, (Segment)((Segment)highlighter))) continue;
            model.removeHighlighter(highlighter);
        }
    }

    @JvmOverloads
    public ChangeTo(@NotNull String typo, @NotNull PsiElement element, @NotNull TextRange range, @Nullable SpellcheckerRateTracker tracker) {
        Intrinsics.checkNotNullParameter((Object)typo, (String)"typo");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        this(typo, element, range, tracker, null, 16, null);
    }

    @JvmOverloads
    public ChangeTo(@NotNull String typo, @NotNull PsiElement element, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)typo, (String)"typo");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        this(typo, element, range, null, null, 24, null);
    }

    private static final String fixName_delegate$lambda$0() {
        return SpellCheckerBundle.message("change.to.title", new Object[0]);
    }

    @NotNull
    public static final String getFixName() {
        return Companion.getFixName();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/spellchecker/quickfixes/ChangeTo$ChangeToTitleAction;", "Lcom/intellij/codeInsight/intention/choice/ChoiceTitleIntentionAction;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "intellij.spellchecker"})
    private static final class ChangeToTitleAction
    extends ChoiceTitleIntentionAction
    implements HighPriorityAction,
    DumbAware {
        @NotNull
        public static final ChangeToTitleAction INSTANCE = new ChangeToTitleAction();

        private ChangeToTitleAction() {
            super(Companion.getFixName(), Companion.getFixName());
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0092\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u001b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000f\u001a\u00020\rH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016J\b\u0010\u0011\u001a\u00020\rH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\"\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\"\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0018\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0004J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001aH\u0016J\b\u0010%\u001a\u00020\u0013H\u0016J \u0010&\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\f\u001a\t\u0018\u00010\r\u00a2\u0006\u0002\b\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/spellchecker/quickfixes/ChangeTo$ChangeToVariantAction;", "Lcom/intellij/codeInsight/intention/choice/ChoiceVariantIntentionAction;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "Lcom/intellij/codeInsight/intention/EventTrackingIntentionAction;", "index", "", "tracker", "Lcom/intellij/spellchecker/statistics/SpellcheckerRateTracker;", "<init>", "(Lcom/intellij/spellchecker/quickfixes/ChangeTo;ILcom/intellij/spellchecker/statistics/SpellcheckerRateTracker;)V", "getIndex", "()I", "suggestion", "", "Lcom/intellij/openapi/util/NlsSafe;", "getName", "getTooltipText", "getFamilyName", "isShowSubmenu", "", "isAvailable", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "applyFix", "", "performFix", "getRange", "Lcom/intellij/openapi/util/TextRange;", "document", "Lcom/intellij/openapi/editor/Document;", "getFileModifierForPreview", "Lcom/intellij/codeInsight/intention/FileModifier;", "target", "startInWriteAction", "suggestionShown", "intellij.spellchecker"})
    @SourceDebugExtension(value={"SMAP\nChangeTo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeTo.kt\ncom/intellij/spellchecker/quickfixes/ChangeTo$ChangeToVariantAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,143:1\n1#2:144\n*E\n"})
    private class ChangeToVariantAction
    extends ChoiceVariantIntentionAction
    implements HighPriorityAction,
    EventTrackingIntentionAction {
        private final int index;
        @Nullable
        private final SpellcheckerRateTracker tracker;
        @Nullable
        private String suggestion;
        final /* synthetic */ ChangeTo this$0;

        public ChangeToVariantAction(ChangeTo this$0, @Nullable int index, SpellcheckerRateTracker tracker) {
            this.this$0 = this$0;
            this.index = index;
            this.tracker = tracker;
        }

        public /* synthetic */ ChangeToVariantAction(ChangeTo changeTo, int n, SpellcheckerRateTracker spellcheckerRateTracker, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                spellcheckerRateTracker = null;
            }
            this(changeTo, n, spellcheckerRateTracker);
        }

        public int getIndex() {
            return this.index;
        }

        @NotNull
        public String getName() {
            String string = this.suggestion;
            if (string == null) {
                string = "";
            }
            return string;
        }

        @NotNull
        public String getTooltipText() {
            Object[] objectArray = new Object[]{this.getName()};
            return SpellCheckerBundle.message("change.to.tooltip", objectArray);
        }

        @NotNull
        public String getFamilyName() {
            return Companion.getFixName();
        }

        public boolean isShowSubmenu() {
            return true;
        }

        public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile psiFile) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            List<String> list = this.this$0.getSuggestions(project);
            Intrinsics.checkNotNullExpressionValue(list, (String)"getSuggestions(...)");
            List<String> suggestions = list;
            if (suggestions.size() <= this.getIndex()) {
                return false;
            }
            Document document = psiFile.getViewProvider().getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            if (this.getRange(document) == null) {
                return false;
            }
            this.suggestion = suggestions.get(this.getIndex());
            return true;
        }

        public void applyFix(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            SpellcheckerRateTracker spellcheckerRateTracker = this.tracker;
            if (spellcheckerRateTracker != null) {
                SpellcheckerRateTracker spellcheckerRateTracker2 = spellcheckerRateTracker;
                ChangeTo changeTo = this.this$0;
                SpellcheckerRateTracker it = spellcheckerRateTracker2;
                boolean bl = false;
                SpellcheckerActionStatistics.changeToPerformed(it, this.getIndex(), changeTo.getSuggestions(project).size());
            }
            this.performFix(project, psiFile);
        }

        protected final void performFix(@NotNull Project project, @NotNull PsiFile psiFile) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            String string = this.suggestion;
            if (string == null) {
                return;
            }
            String suggestion = string;
            Document document = psiFile.getViewProvider().getDocument();
            Intrinsics.checkNotNull((Object)document);
            TextRange textRange = this.getRange(document);
            if (textRange == null) {
                return;
            }
            TextRange myRange = textRange;
            this.this$0.removeHighlightersWithExactRange(document, project, (Segment)myRange);
            document.replaceString(myRange.getStartOffset(), myRange.getEndOffset(), (CharSequence)suggestion);
        }

        private final TextRange getRange(Document document) {
            PsiElement psiElement = this.this$0.pointer.getElement();
            if (psiElement == null) {
                return null;
            }
            PsiElement element = psiElement;
            TextRange textRange = this.this$0.range.shiftRight(PsiTreeUtilKt.getStartOffset((PsiElement)element));
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftRight(...)");
            TextRange range = textRange;
            if (range.getStartOffset() < 0 || range.getEndOffset() > document.getTextLength()) {
                return null;
            }
            String string = document.getText(range);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String text = string;
            if (!Intrinsics.areEqual((Object)text, (Object)this.this$0.typo)) {
                return null;
            }
            return range;
        }

        @NotNull
        public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            return (FileModifier)this.this$0.new ForPreview();
        }

        public boolean startInWriteAction() {
            return true;
        }

        public void suggestionShown(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            if (this.tracker != null && this.tracker.markShown()) {
                SpellcheckerActionStatistics.suggestionShown(this.tracker);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R!\u0010\u0004\u001a\u00020\u00058FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\t\u0010\n\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/intellij/spellchecker/quickfixes/ChangeTo$Companion;", "", "<init>", "()V", "fixName", "", "getFixName$annotations", "getFixName", "()Ljava/lang/String;", "fixName$delegate", "Lkotlin/Lazy;", "intellij.spellchecker"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getFixName() {
            Lazy lazy = fixName$delegate;
            return (String)lazy.getValue();
        }

        @JvmStatic
        public static /* synthetic */ void getFixName$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0092\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/spellchecker/quickfixes/ChangeTo$ForPreview;", "Lcom/intellij/spellchecker/quickfixes/ChangeTo$ChangeToVariantAction;", "Lcom/intellij/spellchecker/quickfixes/ChangeTo;", "<init>", "(Lcom/intellij/spellchecker/quickfixes/ChangeTo;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.spellchecker"})
    private class ForPreview
    extends ChangeToVariantAction {
        public ForPreview() {
            super(ChangeTo.this, -1, null, 2, null);
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            this.performFix(project, psiFile);
        }
    }
}

