/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.DataBus;
import com.intellij.database.Dbms;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.console.JdbcEngineUtils;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.dataSource.connection.statements.CallableStatementData;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.datagrid.mutating.DmlMutationContext;
import com.intellij.database.datagrid.mutating.RowQueryData;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.ReflectionUtil;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;

public class DataRequest
extends UserDataHolderBase
implements GridDataRequest {
    public static final TxMarker NONE = DataRequest.newTxMarker("NONE", null, false);
    public static final TxMarker AUTO_COMMIT = DataRequest.newTxMarker("AUTO_COMMIT", null, false);
    public static final TxMarker START_NEW = DataRequest.newTxMarker("START_NEW", null, false);
    public static final TxMarker IN_PROGRESS = DataRequest.newTxMarker("IN_PROGRESS", null, true);
    public final Owner owner;
    public final SearchPath path;
    private final AsyncPromise<Void> promise;
    private final NotNullLazyValue<TxMarker> myMarker;

    protected DataRequest(@NotNull Owner owner, @NotNull TxMarker txMarker) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(0);
        }
        if (txMarker == null) {
            DataRequest.$$$reportNull$$$0(1);
        }
        this.promise = new AsyncPromise();
        this.owner = owner;
        this.myMarker = NotNullLazyValue.createConstantValue((Object)txMarker);
        this.path = owner instanceof CustomSearchPathOwner ? ((CustomSearchPathOwner)owner).getSearchPath() : null;
    }

    protected DataRequest(@NotNull Owner owner) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(2);
        }
        this(owner, owner instanceof CustomSearchPathOwner ? ((CustomSearchPathOwner)owner).getSearchPath() : null);
    }

    protected DataRequest(@NotNull Owner owner, @Nullable SearchPath path) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(3);
        }
        this.promise = new AsyncPromise();
        this.owner = owner;
        this.myMarker = NotNullLazyValue.createValue(() -> owner instanceof OwnerEx ? ((OwnerEx)owner).getCurrentTx() : NONE);
        this.path = path;
    }

    @NotNull
    public AsyncPromise<Void> getPromise() {
        AsyncPromise<Void> asyncPromise = this.promise;
        if (asyncPromise == null) {
            DataRequest.$$$reportNull$$$0(4);
        }
        return asyncPromise;
    }

    @NotNull
    public Owner getOwner() {
        Owner owner = this.owner;
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(5);
        }
        return owner;
    }

    @NotNull
    public TxMarker getTxMarker() {
        TxMarker txMarker = (TxMarker)this.myMarker.getValue();
        if (txMarker == null) {
            DataRequest.$$$reportNull$$$0(6);
        }
        return txMarker;
    }

    public void accept(Visitor visitor) {
        visitor.visitRequest(this);
    }

    public boolean isAsyncFriendly() {
        return true;
    }

    @NotNull
    public static Owner newOwner() {
        final @NlsSafe String title = "Owner:" + Objects.requireNonNull(ReflectionUtil.findCallerClass((int)2)).getSimpleName();
        return new Owner(){

            public void dispose() {
            }

            @NotNull
            public String getDisplayName() {
                String string = title;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataRequest$1", "getDisplayName"));
            }
        };
    }

    @NotNull
    public static TxMarker getInitialTxMarker(boolean autoCommit) {
        TxMarker txMarker = autoCommit ? AUTO_COMMIT : START_NEW;
        if (txMarker == null) {
            DataRequest.$$$reportNull$$$0(7);
        }
        return txMarker;
    }

    @NotNull
    public static TxMarker newTxMarker(@NotNull String title, @Nullable Owner owner) {
        if (title == null) {
            DataRequest.$$$reportNull$$$0(8);
        }
        return DataRequest.newTxMarker(title, owner, false);
    }

    @NotNull
    public static TxMarker newTxMarker(final @NotNull String title, final @Nullable Owner owner, final boolean txInProgress) {
        if (title == null) {
            DataRequest.$$$reportNull$$$0(9);
        }
        return new TxMarker(){

            @Override
            public Owner getOwner() {
                return owner;
            }

            @Override
            @NotNull
            public String toString() {
                String string = title;
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public boolean isTransactionInProgress() {
                return owner != null || txInProgress;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataRequest$2", "toString"));
            }
        };
    }

    @NotNull
    public static GridDataRequest newCallRequest(@NotNull OwnerEx owner, @NotNull List<CallRequest.Statement> statements, @Nullable SearchPath path) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(10);
        }
        if (statements == null) {
            DataRequest.$$$reportNull$$$0(11);
        }
        return new CallRequest(owner, statements, path);
    }

    @NotNull
    public static GridDataRequest newLimitlessRequest(@NotNull OwnerEx owner, @NotNull String query) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(12);
        }
        if (query == null) {
            DataRequest.$$$reportNull$$$0(13);
        }
        return new QueryRequest(owner, query, DataRequest.newConstraints(0, -1, 0, -1, -1), null);
    }

    @NotNull
    public static DataRequest newRequest(@NotNull OwnerEx owner, @NotNull String query, @Nullable Dbms dbms) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(14);
        }
        if (query == null) {
            DataRequest.$$$reportNull$$$0(15);
        }
        return new QueryRequest(owner, query, DataRequest.newConstraints(dbms), null);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static GridDataRequest newRequest(@NotNull OwnerEx owner, @NotNull String query, int offset, int queryOffset, int pageSize, int resultSetIndex) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(16);
        }
        if (query == null) {
            DataRequest.$$$reportNull$$$0(17);
        }
        return DataRequest.newRequest(owner, query, offset, queryOffset, pageSize, resultSetIndex, resultSetIndex);
    }

    @NotNull
    public static GridDataRequest newRequest(@NotNull OwnerEx owner, @NotNull String query, int offset, int queryOffset, int pageSize, int subQueryIndex, int resultSetIndex) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(18);
        }
        if (query == null) {
            DataRequest.$$$reportNull$$$0(19);
        }
        return new QueryRequest(owner, query, DataRequest.newConstraints(offset, pageSize, queryOffset, subQueryIndex, resultSetIndex), null);
    }

    @NotNull
    public static GridDataRequest newRequest(@NotNull Owner owner, @NotNull TxMarker txMarker, @NotNull String query, @NotNull Constraints constraints) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(20);
        }
        if (txMarker == null) {
            DataRequest.$$$reportNull$$$0(21);
        }
        if (query == null) {
            DataRequest.$$$reportNull$$$0(22);
        }
        if (constraints == null) {
            DataRequest.$$$reportNull$$$0(23);
        }
        return new QueryRequest(owner, txMarker, query, constraints, null);
    }

    @NotNull
    public static DmlRequest newInsertRequest(@NotNull OwnerEx owner, @NotNull DmlMutationContext context) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(24);
        }
        if (context == null) {
            DataRequest.$$$reportNull$$$0(25);
        }
        return new InsertRequest(owner, context);
    }

    @NotNull
    public static DmlRequest newUpdateRequest(@NotNull OwnerEx owner, @NotNull DmlMutationContext context) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(26);
        }
        if (context == null) {
            DataRequest.$$$reportNull$$$0(27);
        }
        return new UpdateRequest(owner, context);
    }

    @NotNull
    public static DmlRequest newDeleteRequest(@NotNull OwnerEx owner, @NotNull DmlMutationContext context) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(28);
        }
        if (context == null) {
            DataRequest.$$$reportNull$$$0(29);
        }
        return new DeleteRequest(owner, context);
    }

    public static GridDataRequest newCompositeRequest(@NotNull OwnerEx owner, @NotNull List<DmlRequest> requests) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(30);
        }
        if (requests == null) {
            DataRequest.$$$reportNull$$$0(31);
        }
        return new CompositeRequest(owner, requests);
    }

    @NotNull
    public static GridDataRequest newTxCommit(@NotNull OwnerEx owner) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(32);
        }
        return new TxRequest(owner, TxCommand.COMMIT);
    }

    @NotNull
    public static GridDataRequest newTxRollback(@NotNull OwnerEx owner) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(33);
        }
        return new TxRequest(owner, TxCommand.ROLLBACK);
    }

    @NotNull
    public static GridDataRequest newSchemaSwitchRequest(@NotNull OwnerEx owner, @NotNull SearchPath schema, boolean forced) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(34);
        }
        if (schema == null) {
            DataRequest.$$$reportNull$$$0(35);
        }
        return new SchemaSwitchRequest(owner, schema, forced);
    }

    @NotNull
    public static Context newContext(@NotNull OwnerEx owner, @Nullable DataProducer producer, String query) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(36);
        }
        return new Context(producer, DataRequest.newOutputHandler(), DataRequest.newRequest(owner, query, null), NONE);
    }

    public static OutputHandler newOutputHandler() {
        return new OutputHandler(){};
    }

    public static Constraints newConstraints() {
        return DataRequest.newConstraints(null);
    }

    public static Constraints newConstraints(@Nullable Dbms dbms) {
        return DataRequest.newConstraints(0, DbImplUtilCore.getPageSize(dbms), 0, 0, 0);
    }

    public static Constraints newConstraints(int offset, int limit, int queryOffset, int subQueryIndex, int resultSetIndex) {
        return DataRequest.newConstraints(offset, limit, queryOffset, subQueryIndex, resultSetIndex, DatabaseSettings.getSettings().getBytesLimitPerValue());
    }

    public static Constraints newConstraints(int offset, int limit, int queryOffset, int subQueryIndex, int resultSetIndex, int maxLobLength) {
        return new Constraints(offset, limit, queryOffset, "", subQueryIndex, resultSetIndex, Collections.emptyList(), maxLobLength);
    }

    public static int getStartIdx(@NotNull Constraints constraints, int size) {
        if (constraints == null) {
            DataRequest.$$$reportNull$$$0(37);
        }
        if (constraints.absolutePosition >= 0) {
            return constraints.absolutePosition + 1;
        }
        return size + constraints.absolutePosition + 2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "txMarker";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/DataRequest";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 23: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraints";
                break;
            }
            case 25: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requests";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/DataRequest";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPromise";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwner";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTxMarker";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialTxMarker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "newTxMarker";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "newCallRequest";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "newLimitlessRequest";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "newRequest";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "newInsertRequest";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "newUpdateRequest";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "newDeleteRequest";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "newCompositeRequest";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "newTxCommit";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "newTxRollback";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "newSchemaSwitchRequest";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "newContext";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getStartIdx";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }

    public static interface Owner
    extends GridDataRequest.GridDataRequestOwner {
    }

    public static interface CustomSearchPathOwner
    extends OwnerEx {
        @Nullable
        public SearchPath getSearchPath();

        default public boolean cleanup() {
            return true;
        }
    }

    public static interface TxMarker {
        @Nullable
        public Owner getOwner();

        @NotNull
        public String toString();

        public boolean isTransactionInProgress();
    }

    public static abstract class Visitor {
        public void visitRequest(DataRequest r) {
        }

        public void visitCancel(Cancel r) {
            this.visitRequest(r);
        }

        public void visitTx(TxRequest r) {
            this.visitRequest(r);
        }

        public void visitDml(DmlRequest r) {
            this.visitRequest(r);
        }

        public void visitInsert(InsertRequest r) {
            this.visitDml(r);
        }

        public void visitUpdate(UpdateRequest r) {
            this.visitDml(r);
        }

        public void visitDelete(DeleteRequest r) {
            this.visitDml(r);
        }

        public void visitComposite(CompositeRequest r) {
            this.visitRequest(r);
        }

        public void visitRaw(RawRequest r) {
            this.visitRequest(r);
        }

        public void visitQuery(QueryRequest r) {
            this.visitRequest(r);
        }

        public void visitCall(CallRequest r) {
            this.visitRequest(r);
        }

        public void visitSchemaSwitch(SchemaSwitchRequest r) {
            this.visitRequest(r);
        }

        public void visitDisconnect(Disconnect r) {
            this.visitRequest(r);
        }
    }

    public static class CallRequest
    extends DataRequest {
        public final List<Statement> queries;

        protected CallRequest(@NotNull OwnerEx owner, @NotNull List<Statement> statements, @Nullable SearchPath path) {
            if (owner == null) {
                CallRequest.$$$reportNull$$$0(0);
            }
            if (statements == null) {
                CallRequest.$$$reportNull$$$0(1);
            }
            super((Owner)owner, path);
            this.queries = statements;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitCall(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "statements";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/datagrid/DataRequest$CallRequest";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        public static final class Statement {
            public final String statement;
            public final List<CallableStatementData.SimpleOutParameter<?>> outParameters;
            public final Int2ObjectMap inParameters;

            public Statement(@NotNull String statement) {
                if (statement == null) {
                    Statement.$$$reportNull$$$0(0);
                }
                this(statement, new ArrayList());
            }

            public Statement(@NotNull String statement, @NotNull List<CallableStatementData.SimpleOutParameter<?>> outParameters) {
                if (statement == null) {
                    Statement.$$$reportNull$$$0(1);
                }
                if (outParameters == null) {
                    Statement.$$$reportNull$$$0(2);
                }
                this(statement, outParameters, (Int2ObjectMap)new Int2ObjectOpenHashMap());
            }

            public Statement(@NotNull String statement, @NotNull List<CallableStatementData.SimpleOutParameter<?>> outParameters, @NotNull Int2ObjectMap inParameters) {
                if (statement == null) {
                    Statement.$$$reportNull$$$0(3);
                }
                if (outParameters == null) {
                    Statement.$$$reportNull$$$0(4);
                }
                if (inParameters == null) {
                    Statement.$$$reportNull$$$0(5);
                }
                this.statement = statement;
                this.outParameters = outParameters;
                this.inParameters = inParameters;
            }

            @NotNull
            private static List<CallableStatementData.SimpleOutParameter<?>> buildParameters(@NotNull Int2IntMap outParameters) {
                if (outParameters == null) {
                    Statement.$$$reportNull$$$0(6);
                }
                ArrayList metadataList = new ArrayList();
                IntIterator intIterator = outParameters.keySet().iterator();
                while (intIterator.hasNext()) {
                    int index = (Integer)intIterator.next();
                    metadataList.add(new CallableStatementData.SimpleOutParameter(index, outParameters.get(index)));
                }
                ArrayList arrayList = metadataList;
                if (arrayList == null) {
                    Statement.$$$reportNull$$$0(7);
                }
                return arrayList;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 7 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "statement";
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outParameters";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inParameters";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/datagrid/DataRequest$CallRequest$Statement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/datagrid/DataRequest$CallRequest$Statement";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "buildParameters";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "buildParameters";
                        break;
                    }
                    case 7: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 7 -> new IllegalStateException(string);
                };
            }
        }
    }

    public static interface OwnerEx
    extends Owner {
        public DataBus.Consuming getMessageBus();

        @NotNull
        public TxMarker getCurrentTx();

        public void setAutoCommit(boolean var1);

        default public boolean isChildOf(@NotNull Owner owner) {
            if (owner == null) {
                OwnerEx.$$$reportNull$$$0(0);
            }
            return this == owner;
        }

        default public boolean isEphemeral() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/datagrid/DataRequest$OwnerEx", "isChildOf"));
        }
    }

    public static class QueryRequest
    extends DataRequest {
        public final String query;
        public final Constraints constraints;
        public final Object params;

        protected QueryRequest(@NotNull Owner owner, @NotNull String query, @NotNull Constraints constraints, @Nullable Object params) {
            if (owner == null) {
                QueryRequest.$$$reportNull$$$0(0);
            }
            if (query == null) {
                QueryRequest.$$$reportNull$$$0(1);
            }
            if (constraints == null) {
                QueryRequest.$$$reportNull$$$0(2);
            }
            super(owner);
            this.query = query;
            this.constraints = constraints;
            this.params = params;
        }

        protected QueryRequest(@NotNull Owner owner, @NotNull TxMarker marker, @NotNull String query, @NotNull Constraints constraints, @Nullable Object params) {
            if (owner == null) {
                QueryRequest.$$$reportNull$$$0(3);
            }
            if (marker == null) {
                QueryRequest.$$$reportNull$$$0(4);
            }
            if (query == null) {
                QueryRequest.$$$reportNull$$$0(5);
            }
            if (constraints == null) {
                QueryRequest.$$$reportNull$$$0(6);
            }
            super(owner, marker);
            this.query = query;
            this.constraints = constraints;
            this.params = params;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitQuery(this);
        }

        public String toString() {
            return this.query + "@" + this.owner.getDisplayName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "owner";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "query";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[0] = "constraints";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "marker";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/datagrid/DataRequest$QueryRequest";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Constraints {
        public final int absolutePosition;
        public final int limit;
        public final int queryOffset;
        public final String filter;
        public final int subQueryNumber;
        public final int resultSetNumber;
        public final List<RowSortOrder<String>> orders;
        public final int maxLobLength;

        public Constraints(int absolutePosition, int limit, int queryOffset, String filter, int subQueryNumber, int resultSetNumber, List<RowSortOrder<String>> orders, int maxLobLength) {
            this.absolutePosition = absolutePosition;
            this.limit = limit;
            this.queryOffset = queryOffset;
            this.filter = filter;
            this.subQueryNumber = subQueryNumber;
            this.resultSetNumber = resultSetNumber;
            this.orders = orders;
            this.maxLobLength = maxLobLength;
        }
    }

    public static class InsertRequest
    extends DmlRequest {
        InsertRequest(OwnerEx owner, DmlMutationContext context) {
            super(owner, context);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitInsert(this);
        }
    }

    public static class UpdateRequest
    extends DmlRequest {
        UpdateRequest(OwnerEx owner, DmlMutationContext context) {
            super(owner, context);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitUpdate(this);
        }
    }

    public static class DeleteRequest
    extends DmlRequest {
        DeleteRequest(OwnerEx owner, DmlMutationContext context) {
            super(owner, context);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitDelete(this);
        }
    }

    public static class CompositeRequest
    extends DataRequest {
        public final List<DmlRequest> requests;

        CompositeRequest(OwnerEx owner, List<DmlRequest> requests) {
            super(owner);
            this.requests = List.copyOf(requests);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitComposite(this);
        }
    }

    public static class TxRequest
    extends DataRequest {
        public final TxCommand command;

        protected TxRequest(Owner owner, TxMarker marker, TxCommand command) {
            super(owner, marker);
            this.command = command;
        }

        protected TxRequest(OwnerEx owner, TxCommand command) {
            super(owner);
            this.command = command;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitTx(this);
        }
    }

    public static enum TxCommand {
        COMMIT,
        ROLLBACK;

    }

    public static class SchemaSwitchRequest
    extends DataRequest {
        public final SearchPath pathToSwitch;
        public final boolean forced;

        protected SchemaSwitchRequest(@NotNull OwnerEx owner, @NotNull SearchPath path, boolean forced) {
            if (owner == null) {
                SchemaSwitchRequest.$$$reportNull$$$0(0);
            }
            if (path == null) {
                SchemaSwitchRequest.$$$reportNull$$$0(1);
            }
            super(owner);
            this.pathToSwitch = path;
            this.forced = forced;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitSchemaSwitch(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "path";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/datagrid/DataRequest$SchemaSwitchRequest";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Context
    extends UserDataHolderBase
    implements GridDataRequest.DatabaseContext {
        public final DataProducer producer;
        public final OutputHandler outputHandler;
        @NotNull
        public final DataRequest request;
        public final TxMarker txMarker;
        public final ConcurrentLinkedDeque<StatementContext> statementContext;

        public Context(@Nullable DataProducer producer, @NotNull OutputHandler outputHandler, @NotNull DataRequest request, @NotNull TxMarker txMarker) {
            if (outputHandler == null) {
                Context.$$$reportNull$$$0(0);
            }
            if (request == null) {
                Context.$$$reportNull$$$0(1);
            }
            if (txMarker == null) {
                Context.$$$reportNull$$$0(2);
            }
            this.statementContext = new ConcurrentLinkedDeque();
            this.producer = producer;
            this.outputHandler = outputHandler;
            this.request = request;
            this.txMarker = txMarker;
        }

        @Nullable
        public StatementContext getStatementContext() {
            return this.statementContext.peek();
        }

        @NlsSafe
        @NotNull
        public String getQuery() {
            StatementContext top = this.statementContext.peek();
            return top != null ? top.getSql() : (this.request instanceof QueryRequest ? ((QueryRequest)this.request).query : "");
        }

        @Nullable
        public SearchPath getSearchPath() {
            return null;
        }

        public String toString() {
            return String.valueOf((Object)this.request) + " in " + String.valueOf(this.txMarker);
        }

        public final void print(@NlsContexts.NotificationContent @Nullable String message) {
            this.outputHandler.print(this, message);
        }

        public final void error(@NlsContexts.NotificationContent @NotNull String message) {
            if (message == null) {
                Context.$$$reportNull$$$0(3);
            }
            this.outputHandler.error(this, message);
        }

        public final void error(@NotNull Throwable th) {
            if (th == null) {
                Context.$$$reportNull$$$0(4);
            }
            this.outputHandler.error(this, th);
        }

        public final void warn(@NlsContexts.NotificationContent @NotNull String message, boolean isUserOutput) {
            if (message == null) {
                Context.$$$reportNull$$$0(5);
            }
            this.outputHandler.warn(this, message, isUserOutput);
        }

        public final void warn(@NotNull Throwable th) {
            if (th == null) {
                Context.$$$reportNull$$$0(6);
            }
            this.outputHandler.warn(this, th);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputHandler";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "txMarker";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "th";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/datagrid/DataRequest$Context";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "error";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "warn";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface OutputHandler {
        default public void print(@NotNull Context context, @NlsContexts.NotificationContent @Nullable String message) {
            if (context == null) {
                OutputHandler.$$$reportNull$$$0(0);
            }
        }

        default public void error(@NotNull Context context, @NlsContexts.NotificationContent @NotNull String message) {
            if (context == null) {
                OutputHandler.$$$reportNull$$$0(1);
            }
            if (message == null) {
                OutputHandler.$$$reportNull$$$0(2);
            }
        }

        default public void error(@NotNull Context context, @NotNull Throwable th) {
            if (context == null) {
                OutputHandler.$$$reportNull$$$0(3);
            }
            if (th == null) {
                OutputHandler.$$$reportNull$$$0(4);
            }
        }

        default public void warn(@NotNull Context context, @NlsContexts.NotificationContent @NotNull String message, boolean isUserOutput) {
            if (context == null) {
                OutputHandler.$$$reportNull$$$0(5);
            }
            if (message == null) {
                OutputHandler.$$$reportNull$$$0(6);
            }
        }

        default public void warn(@NotNull Context context, @NotNull Throwable th) {
            if (context == null) {
                OutputHandler.$$$reportNull$$$0(7);
            }
            if (th == null) {
                OutputHandler.$$$reportNull$$$0(8);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "th";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/datagrid/DataRequest$OutputHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "print";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "error";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "warn";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class TxContext
    extends Context {
        private static final int UNDEFINED = -2;
        private volatile int myIsolation;

        public TxContext(@Nullable DataProducer producer, @NotNull OutputHandler auditor, @NotNull DataRequest request, @NotNull TxMarker txMarker) {
            if (auditor == null) {
                TxContext.$$$reportNull$$$0(0);
            }
            if (request == null) {
                TxContext.$$$reportNull$$$0(1);
            }
            if (txMarker == null) {
                TxContext.$$$reportNull$$$0(2);
            }
            super(producer, auditor, request, txMarker);
            this.myIsolation = -2;
        }

        public void setIsolation(int isolation) {
            this.myIsolation = isolation;
        }

        public void updateIsolation(@NotNull TxIsolationOwner owner) {
            if (owner == null) {
                TxContext.$$$reportNull$$$0(3);
            }
            if (this.myIsolation != -2) {
                owner.setTxIsolation(this.myIsolation);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "auditor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "txMarker";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/datagrid/DataRequest$TxContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateIsolation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface StatementContext {
        @NotNull
        public String getSql();
    }

    public static interface CoupledWithEditor {
        @Nullable
        public Editor getEditor();

        @Nullable
        public TextRange getRange();

        @NotNull
        public GridDataRequest getRequest();

        @Nullable
        public ErrorNavigator onError(@NotNull ErrorInfo var1);

        public void onWarning(@NotNull JdbcEngineUtils.EngineWarningExceptionInfo var1);

        public static interface ErrorNavigator {
            public void navigate();

            public boolean canNavigate();
        }
    }

    public static interface TxIsolationOwner
    extends OwnerEx {
        public int getTxIsolation();

        public void setTxIsolation(int var1);
    }

    public static interface DepartmentHolder {
        @NotNull
        public DatabaseDepartment getDepartment();
    }

    public static interface CrossSessionOwner
    extends CustomSearchPathOwner {
        @NotNull
        public Disposable getTxDisposable();

        @NotNull
        public Owner getParentOwner();
    }

    public static interface DasDataSourceProvider {
        @Nullable
        public DasDataSource getDataSource();
    }

    public static abstract class RawQueryRequest
    extends IsolatedQueryRequest {
        protected RawQueryRequest(Owner owner, String query, Constraints constraints) {
            super(owner, query, constraints, null);
        }
    }

    public static abstract class IsolatedQueryRequest
    extends QueryRequest
    implements DataConsumer {
        protected IsolatedQueryRequest(@NotNull Owner owner, @NotNull String query, @NotNull Constraints constraints, @Nullable Object params) {
            if (owner == null) {
                IsolatedQueryRequest.$$$reportNull$$$0(0);
            }
            if (query == null) {
                IsolatedQueryRequest.$$$reportNull$$$0(1);
            }
            if (constraints == null) {
                IsolatedQueryRequest.$$$reportNull$$$0(2);
            }
            super(owner, query, constraints, params);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "query";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "constraints";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/datagrid/DataRequest$IsolatedQueryRequest";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class DmlRequest
    extends DataRequest {
        public final DmlMutationContext context;

        DmlRequest(OwnerEx owner, DmlMutationContext context) {
            super(owner);
            this.context = context;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitDml(this);
        }
    }

    public static abstract class ConditionQueryRequest
    extends RawQueryRequest {
        @NotNull
        public final RowQueryData rowQueryData;
        @Nullable
        public final DasObject table;

        protected ConditionQueryRequest(@NotNull OwnerEx owner, @NotNull RowQueryData rowQueryData, @NotNull Constraints constraints, @Nullable DasObject table) {
            if (owner == null) {
                ConditionQueryRequest.$$$reportNull$$$0(0);
            }
            if (rowQueryData == null) {
                ConditionQueryRequest.$$$reportNull$$$0(1);
            }
            if (constraints == null) {
                ConditionQueryRequest.$$$reportNull$$$0(2);
            }
            super(owner, rowQueryData.getSql(), constraints);
            this.rowQueryData = rowQueryData;
            this.table = table;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rowQueryData";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "constraints";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/datagrid/DataRequest$ConditionQueryRequest";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class RawRequest
    extends DataRequest {
        protected RawRequest(OwnerEx owner) {
            super(owner);
        }

        public abstract void processRaw(Context var1, DatabaseConnectionCore var2) throws Exception;

        @Override
        public void accept(Visitor visitor) {
            visitor.visitRaw(this);
        }
    }

    public static class Disconnect
    extends DataRequest {
        public Disconnect(@NotNull Owner owner) {
            if (owner == null) {
                Disconnect.$$$reportNull$$$0(0);
            }
            super(owner);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitDisconnect(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/datagrid/DataRequest$Disconnect", "<init>"));
        }
    }

    public static class Cancel
    extends DataRequest {
        public Cancel(@NotNull OwnerEx owner) {
            if (owner == null) {
                Cancel.$$$reportNull$$$0(0);
            }
            super(owner);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitCancel(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/datagrid/DataRequest$Cancel", "<init>"));
        }
    }
}

