/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.model.ElementCache;
import com.intellij.database.model.ElementSearchCache;
import com.intellij.database.model.ElementSearcher;
import com.intellij.database.model.basic.BasicElement;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0002*\u0004\b\u0002\u0010\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00040\u0005B@\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0005\u0012#\u0010\u0007\u001a\u001f\u0012\u0004\u0012\u00028\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u00050\b\u00a2\u0006\u0002\b\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\u001fJ\u0017\u0010 \u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001e\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010!R.\u0010\u0007\u001a\u001f\u0012\u0004\u0012\u00028\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u00050\b\u00a2\u0006\u0002\b\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R(\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0002\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006\""}, d2={"Lcom/intellij/database/model/ParentFamilySearcher;", "T", "Lcom/intellij/database/model/basic/BasicElement;", "P", "D", "Lcom/intellij/database/model/ElementSearcher;", "parentSearcher", "searcherGetter", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "<init>", "(Lcom/intellij/database/model/ElementSearcher;Lkotlin/jvm/functions/Function1;)V", "getSearcherGetter", "()Lkotlin/jvm/functions/Function1;", "cacheHolder", "Lcom/intellij/database/model/ElementSearchCache;", "getCacheHolder", "()Lcom/intellij/database/model/ElementSearchCache;", "parent", "Lcom/intellij/database/model/ElementCache;", "getParent", "()Lcom/intellij/database/model/ElementCache;", "searcher", "getSearcher", "()Lcom/intellij/database/model/ElementSearcher;", "setSearcher", "(Lcom/intellij/database/model/ElementSearcher;)V", "check", "", "e", "data", "(Lcom/intellij/database/model/basic/BasicElement;Ljava/lang/Object;)Z", "find", "(Ljava/lang/Object;)Lcom/intellij/database/model/basic/BasicElement;", "intellij.database.core.impl"})
public final class ParentFamilySearcher<T extends BasicElement, P extends BasicElement, D>
implements ElementSearcher<T, D> {
    @NotNull
    private final Function1<P, ElementSearcher<T, D>> searcherGetter;
    @NotNull
    private final ElementCache<P, D> parent;
    @Nullable
    private ElementSearcher<T, D> searcher;

    public ParentFamilySearcher(@NotNull ElementSearcher<P, D> parentSearcher, @NotNull Function1<? super P, ? extends ElementSearcher<T, D>> searcherGetter) {
        Intrinsics.checkNotNullParameter(parentSearcher, (String)"parentSearcher");
        Intrinsics.checkNotNullParameter(searcherGetter, (String)"searcherGetter");
        this.searcherGetter = searcherGetter;
        this.parent = parentSearcher.cache();
    }

    @NotNull
    public final Function1<P, ElementSearcher<T, D>> getSearcherGetter() {
        return this.searcherGetter;
    }

    @Override
    @NotNull
    public ElementSearchCache getCacheHolder() {
        return this.parent.getSearcher().getCacheHolder();
    }

    @NotNull
    public final ElementCache<P, D> getParent() {
        return this.parent;
    }

    @Nullable
    public final ElementSearcher<T, D> getSearcher() {
        return this.searcher;
    }

    public final void setSearcher(@Nullable ElementSearcher<T, D> elementSearcher) {
        this.searcher = elementSearcher;
    }

    @Override
    public boolean check(@NotNull T e, D data) {
        Intrinsics.checkNotNullParameter(e, (String)"e");
        ElementSearcher<T, D> s = this.searcher;
        return s != null && this.parent.check(data) && s.check(e, data);
    }

    @Override
    @Nullable
    public T find(D data) {
        P prev = this.parent.getCurrent();
        P cur = this.parent.find(data);
        if (!Intrinsics.areEqual(cur, prev)) {
            this.searcher = cur != null ? (ElementSearcher)this.searcherGetter.invoke(cur) : null;
        }
        ElementSearcher<T, D> elementSearcher = this.searcher;
        return (T)(elementSearcher != null ? elementSearcher.find(data) : null);
    }
}

