/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.valid;

import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.index.SpatialIndex;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.operation.valid.PolygonTopologyAnalyzer;

class IndexedNestedHoleTester {
    private Polygon polygon;
    private SpatialIndex index;
    private Coordinate nestedPt;

    public IndexedNestedHoleTester(Polygon poly) {
        this.polygon = poly;
        this.loadIndex();
    }

    private void loadIndex() {
        this.index = new STRtree();
        for (int i2 = 0; i2 < this.polygon.getNumInteriorRing(); ++i2) {
            LinearRing hole = this.polygon.getInteriorRingN(i2);
            Envelope env = hole.getEnvelopeInternal();
            this.index.insert(env, hole);
        }
    }

    public Coordinate getNestedPoint() {
        return this.nestedPt;
    }

    public boolean isNested() {
        for (int i2 = 0; i2 < this.polygon.getNumInteriorRing(); ++i2) {
            LinearRing hole = this.polygon.getInteriorRingN(i2);
            List results2 = this.index.query(hole.getEnvelopeInternal());
            for (LinearRing testHole : results2) {
                if (hole == testHole || !testHole.getEnvelopeInternal().covers(hole.getEnvelopeInternal()) || !PolygonTopologyAnalyzer.isRingNested(hole, testHole)) continue;
                this.nestedPt = hole.getCoordinateN(0);
                return true;
            }
        }
        return false;
    }
}

