/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.cli;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.intellij.javascript.nodejs.library.node_modules.NodeModulesDirectoryManager;
import com.intellij.javascript.nodejs.npm.registry.NpmRegistryService;
import com.intellij.javascript.nodejs.packageJson.InstalledPackageVersion;
import com.intellij.javascript.nodejs.packageJson.NodePackageBasicInfo;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.angular2.cli.AngularCliSchematicsRegistryService;
import org.angular2.cli.AngularCliUtil;
import org.angular2.cli.Schematic;
import org.angular2.cli.SchematicsLoaderKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 #2\u00020\u0001:\u0003!\"#B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J \u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J.\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000fH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0006\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\t \n*\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000b\u001a\u001a\u0012\u0004\u0012\u00020\r\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00070\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/angular2/cli/AngularCliSchematicsRegistryServiceImpl;", "Lorg/angular2/cli/AngularCliSchematicsRegistryService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "myNgAddPackages", "Lorg/angular2/cli/AngularCliSchematicsRegistryServiceImpl$CachedValue;", "", "Lcom/intellij/javascript/nodejs/packageJson/NodePackageBasicInfo;", "kotlin.jvm.PlatformType", "myLocalNgAddPackages", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lkotlin/Pair;", "", "", "myNgAddSupportedCache", "getPackagesSupportingNgAdd", "timeout", "supportsNgAdd", "packageName", "versionOrRange", "version", "Lcom/intellij/javascript/nodejs/packageJson/InstalledPackageVersion;", "getSchematics", "Lorg/angular2/cli/Schematic;", "cliFolder", "Lcom/intellij/openapi/vfs/VirtualFile;", "includeHidden", "logErrors", "clearProjectSchematicsCache", "", "CachedSchematics", "CachedValue", "Companion", "intellij.angular.backend"})
@SourceDebugExtension(value={"SMAP\nAngularCliSchematicsRegistryServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AngularCliSchematicsRegistryServiceImpl.kt\norg/angular2/cli/AngularCliSchematicsRegistryServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,321:1\n1807#2,3:322\n*S KotlinDebug\n*F\n+ 1 AngularCliSchematicsRegistryServiceImpl.kt\norg/angular2/cli/AngularCliSchematicsRegistryServiceImpl\n*L\n50#1:322,3\n*E\n"})
public final class AngularCliSchematicsRegistryServiceImpl
extends AngularCliSchematicsRegistryService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CachedValue<List<NodePackageBasicInfo>> myNgAddPackages;
    @NotNull
    private final ConcurrentHashMap<String, Pair<Boolean, Long>> myLocalNgAddPackages;
    @NotNull
    private final ConcurrentHashMap<String, CachedValue<Boolean>> myNgAddSupportedCache;
    @NonNls
    @NotNull
    private static final String USER_AGENT = "JetBrains IDE";
    @NonNls
    @NotNull
    private static final String NG_PACKAGES_URL = "https://raw.githubusercontent.com/JetBrains/intellij-plugins/master/Angular/angular-backend/resources/org/angular2/cli/ng-packages.json";
    @NonNls
    @NotNull
    private static final Logger LOG;
    private static final int CACHE_EXPIRY = 1500000;
    @NonNls
    @NotNull
    private static final ExecutorService ourExecutorService;
    @NonNls
    @NotNull
    private static final Key<CachedSchematics> SCHEMATICS_PUBLIC;
    @NonNls
    @NotNull
    private static final Key<CachedSchematics> SCHEMATICS_ALL;
    @NotNull
    private static final SimpleModificationTracker SCHEMATICS_CACHE_TRACKER;
    @NonNls
    @NotNull
    private static final String NG_PACKAGES_JSON_PATH;
    @NonNls
    @NotNull
    private static final String SCHEMATICS_PROP;
    @NonNls
    @NotNull
    private static final String NG_ADD_SCHEMATIC;

    public AngularCliSchematicsRegistryServiceImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.myNgAddPackages = new CachedValue<List>(AngularCliSchematicsRegistryServiceImpl::myNgAddPackages$lambda$0);
        this.myLocalNgAddPackages = new ConcurrentHashMap();
        this.myNgAddSupportedCache = new ConcurrentHashMap();
    }

    @Override
    @NotNull
    public List<NodePackageBasicInfo> getPackagesSupportingNgAdd(long timeout) {
        List list = this.myNgAddPackages.getValue(timeout);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    public boolean supportsNgAdd(@NotNull String packageName, long timeout) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Iterable $this$any$iv = this.getPackagesSupportingNgAdd(timeout);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    NodePackageBasicInfo pkg = (NodePackageBasicInfo)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)packageName, (Object)pkg.getName())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public boolean supportsNgAdd(@NotNull String packageName, @NotNull String versionOrRange, long timeout) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)versionOrRange, (String)"versionOrRange");
        return this.supportsNgAdd(packageName, timeout) && Intrinsics.areEqual(this.myNgAddSupportedCache.computeIfAbsent(AngularCliSchematicsRegistryServiceImpl.Companion.getKey(packageName, versionOrRange), arg_0 -> AngularCliSchematicsRegistryServiceImpl.supportsNgAdd$lambda$2(arg_0 -> AngularCliSchematicsRegistryServiceImpl.supportsNgAdd$lambda$1(this, packageName, versionOrRange, arg_0), arg_0)).getValue(timeout), (Object)true);
    }

    @Override
    public boolean supportsNgAdd(@NotNull InstalledPackageVersion version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        try {
            VirtualFile packageJson = version.getPackageJson();
            if (packageJson != null) {
                Pair pair = this.myLocalNgAddPackages.compute(packageJson.getPath(), (arg_0, arg_1) -> AngularCliSchematicsRegistryServiceImpl.supportsNgAdd$lambda$4((arg_0, arg_1) -> AngularCliSchematicsRegistryServiceImpl.supportsNgAdd$lambda$3(packageJson, arg_0, arg_1), arg_0, arg_1));
                Intrinsics.checkNotNull((Object)pair);
                return (Boolean)pair.getFirst();
            }
        }
        catch (Exception e) {
            LOG.info("Failed to retrieve schematics info for " + version.getPackageDir().getName(), (Throwable)e);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<Schematic> getSchematics(@NotNull Project project, @NotNull VirtualFile cliFolder, boolean includeHidden, boolean logErrors) {
        List<Schematic> list;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cliFolder, (String)"cliFolder");
        VirtualFile virtualFile = AngularCliUtil.findCliJson(cliFolder);
        if (virtualFile != null) {
            VirtualFile angularJson = virtualFile;
            boolean bl = false;
            PsiFile psiFile = (PsiFile)ReadAction.compute(() -> AngularCliSchematicsRegistryServiceImpl.getSchematics$lambda$0$0(project, angularJson));
            if (psiFile != null) {
                PsiFile angularJson2 = psiFile;
                boolean bl2 = false;
                List<Schematic> list2 = AngularCliSchematicsRegistryServiceImpl.Companion.getCachedSchematics((UserDataHolder)angularJson2, (Key<CachedSchematics>)(includeHidden ? AngularCliSchematicsRegistryServiceImpl.SCHEMATICS_ALL : AngularCliSchematicsRegistryServiceImpl.SCHEMATICS_PUBLIC)).getUpToDateOrCompute(() -> AngularCliSchematicsRegistryServiceImpl.getSchematics$lambda$1$0(angularJson2, includeHidden, logErrors));
                if (list2 != null) {
                    list = list2;
                    return list;
                }
            }
        }
        list = CollectionsKt.emptyList();
        return list;
    }

    @Override
    public void clearProjectSchematicsCache() {
        SCHEMATICS_CACHE_TRACKER.incModificationCount();
    }

    private static final List myNgAddPackages$lambda$0() {
        return AngularCliSchematicsRegistryServiceImpl.Companion.fetchPackagesSupportingNgAdd();
    }

    private static final Boolean supportsNgAdd$lambda$1$0(AngularCliSchematicsRegistryServiceImpl this$0, String $packageName, String $versionOrRange) {
        return AngularCliSchematicsRegistryServiceImpl.Companion.checkForNgAddSupport(this$0.project, $packageName, $versionOrRange);
    }

    private static final CachedValue supportsNgAdd$lambda$1(AngularCliSchematicsRegistryServiceImpl this$0, String $packageName, String $versionOrRange, String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        return new CachedValue<Boolean>(() -> AngularCliSchematicsRegistryServiceImpl.supportsNgAdd$lambda$1$0(this$0, $packageName, $versionOrRange));
    }

    private static final CachedValue supportsNgAdd$lambda$2(Function1 $tmp0, Object p0) {
        return (CachedValue)$tmp0.invoke(p0);
    }

    private static final Pair supportsNgAdd$lambda$3(VirtualFile $packageJson, String string, Pair curValue) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        if (curValue != null && $packageJson.getModificationStamp() == ((Number)curValue.getSecond()).longValue()) {
            return curValue;
        }
        try {
            File schematicsCollection = AngularCliSchematicsRegistryServiceImpl.Companion.getSchematicsCollection(new File($packageJson.getPath()));
            return new Pair((Object)(schematicsCollection != null && AngularCliSchematicsRegistryServiceImpl.Companion.hasNgAddSchematic(schematicsCollection) ? 1 : 0), (Object)$packageJson.getModificationStamp());
        }
        catch (IOException e) {
            return new Pair((Object)false, (Object)$packageJson.getModificationStamp());
        }
    }

    private static final Pair supportsNgAdd$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        return (Pair)$tmp0.invoke(p0, p1);
    }

    private static final PsiFile getSchematics$lambda$0$0(Project $project, VirtualFile $angularJson) {
        return PsiManager.getInstance((Project)$project).findFile($angularJson);
    }

    private static final CachedValueProvider.Result getSchematics$lambda$1$0(PsiFile $angularJson, boolean $includeHidden, boolean $logErrors) {
        Project project = $angularJson.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        VirtualFile virtualFile = $angularJson.getVirtualFile().getParent();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getParent(...)");
        Object[] objectArray = new Object[]{NodeModulesDirectoryManager.getInstance((Project)$angularJson.getProject()).getNodeModulesDirChangeTracker(), SCHEMATICS_CACHE_TRACKER, $angularJson};
        return CachedValueProvider.Result.create(SchematicsLoaderKt.doLoad(project, virtualFile, $includeHidden, $logErrors), (Object[])objectArray);
    }

    @JvmStatic
    public static final boolean hasNgAddSchematic(@NotNull JsonReader reader) throws IOException {
        return Companion.hasNgAddSchematic(reader);
    }

    static {
        Logger logger = Logger.getInstance(AngularCliSchematicsRegistryServiceImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Angular CLI Schematics Registry Pool", (int)5);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplicationPoolExecutor(...)");
        ourExecutorService = executorService;
        SCHEMATICS_PUBLIC = new Key("angular.cli.schematics.public");
        SCHEMATICS_ALL = new Key("angular.cli.schematics.all");
        SCHEMATICS_CACHE_TRACKER = new SimpleModificationTracker();
        NG_PACKAGES_JSON_PATH = "./ng-packages.json";
        SCHEMATICS_PROP = "schematics";
        NG_ADD_SCHEMATIC = "ng-add";
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0018\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\r0\fJ\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0001H\u0002R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0007\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\t0\b\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/angular2/cli/AngularCliSchematicsRegistryServiceImpl$CachedSchematics;", "", "<init>", "()V", "mySchematics", "", "Lorg/angular2/cli/Schematic;", "myTrackers", "Lkotlin/Pair;", "", "getUpToDateOrCompute", "provider", "Ljava/util/function/Supplier;", "Lcom/intellij/psi/util/CachedValueProvider$Result;", "getTimestamp", "dependency", "intellij.angular.backend"})
    @SourceDebugExtension(value={"SMAP\nAngularCliSchematicsRegistryServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AngularCliSchematicsRegistryServiceImpl.kt\norg/angular2/cli/AngularCliSchematicsRegistryServiceImpl$CachedSchematics\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,321:1\n1786#2,3:322\n11705#3:325\n12052#3,3:326\n*S KotlinDebug\n*F\n+ 1 AngularCliSchematicsRegistryServiceImpl.kt\norg/angular2/cli/AngularCliSchematicsRegistryServiceImpl$CachedSchematics\n*L\n121#1:322,3\n126#1:325\n126#1:326,3\n*E\n"})
    private static final class CachedSchematics {
        @Nullable
        private List<Schematic> mySchematics;
        @Nullable
        private List<? extends Pair<? extends Object, Long>> myTrackers;

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final synchronized List<Schematic> getUpToDateOrCompute(@NotNull Supplier<CachedValueProvider.Result<List<Schematic>>> provider) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object[] $this$all$iv;
            Intrinsics.checkNotNullParameter(provider, (String)"provider");
            if (this.mySchematics != null) {
                boolean bl;
                List<? extends Pair<? extends Object, Long>> list = this.myTrackers;
                if (list != null) {
                    boolean bl2;
                    block8: {
                        $this$all$iv = (Object[])list;
                        boolean $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl2 = true;
                        } else {
                            for (Object t : $this$all$iv) {
                                Pair pair = (Pair)t;
                                boolean bl3 = false;
                                if (((Number)pair.getSecond()).longValue() >= 0L && this.getTimestamp(pair.getFirst()) == ((Number)pair.getSecond()).longValue()) continue;
                                bl2 = false;
                                break block8;
                            }
                            bl2 = true;
                        }
                    }
                    bl = bl2;
                } else {
                    bl = false;
                }
                if (bl) {
                    return this.mySchematics;
                }
            }
            CachedValueProvider.Result<List<Schematic>> result = provider.get();
            Intrinsics.checkNotNullExpressionValue(result, (String)"get(...)");
            CachedValueProvider.Result<List<Schematic>> schematics = result;
            this.mySchematics = Collections.unmodifiableList((List)schematics.getValue());
            Object[] objectArray = schematics.getDependencyItems();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getDependencyItems(...)");
            $this$all$iv = objectArray;
            CachedSchematics cachedSchematics = this;
            boolean $i$f$map = false;
            Iterator iterator = $this$map$iv;
            Collection collection = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void obj;
                void item$iv$iv;
                void var11_14 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection2 = collection;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)obj);
                collection2.add(new Pair((Object)obj, (Object)this.getTimestamp(obj)));
            }
            cachedSchematics.myTrackers = (List)collection;
            return this.mySchematics;
        }

        private final long getTimestamp(Object dependency) {
            if (dependency instanceof ModificationTracker) {
                return ((ModificationTracker)dependency).getModificationCount();
            }
            if (dependency instanceof PsiElement) {
                if (!((PsiElement)dependency).isValid()) {
                    return -1L;
                }
                PsiFile containingFile = ((PsiElement)dependency).getContainingFile();
                PsiFile psiFile = containingFile;
                return psiFile != null && (psiFile = psiFile.getVirtualFile()) != null ? psiFile.getModificationStamp() : -1L;
            }
            throw new UnsupportedOperationException(dependency.getClass().toString());
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0017\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\u0010\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0011\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0012R\u0016\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\f\u0012\u0006\b\u0001\u0012\u00028\u0000\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lorg/angular2/cli/AngularCliSchematicsRegistryServiceImpl$CachedValue;", "T", "", "myValueSupplier", "Ljava/util/concurrent/Callable;", "<init>", "(Ljava/util/concurrent/Callable;)V", "myUpdateTime", "", "myCacheComputation", "Ljava/util/concurrent/Future;", "myCachedValue", "Ljava/lang/Object;", "isCacheExpired", "", "()Z", "getValue", "timeout", "(J)Ljava/lang/Object;", "intellij.angular.backend"})
    private static final class CachedValue<T> {
        @NotNull
        private final Callable<? extends T> myValueSupplier;
        private long myUpdateTime;
        @Nullable
        private Future<? extends T> myCacheComputation;
        @Nullable
        private T myCachedValue;

        public CachedValue(@NotNull Callable<? extends T> myValueSupplier) {
            Intrinsics.checkNotNullParameter(myValueSupplier, (String)"myValueSupplier");
            this.myValueSupplier = myValueSupplier;
        }

        private final synchronized boolean isCacheExpired() {
            return this.myUpdateTime + (long)1500000 <= System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final T getValue(long timeout) {
            Object object;
            Future<? extends T> cacheComputation = null;
            CachedValue cachedValue = this;
            synchronized (cachedValue) {
                block14: {
                    boolean bl = false;
                    if (this.myCachedValue == null || this.isCacheExpired()) break block14;
                    T t = this.myCachedValue;
                    return t;
                }
                if (this.myCacheComputation == null) {
                    this.myCachedValue = null;
                    this.myCacheComputation = ourExecutorService.submit(this.myValueSupplier);
                }
                Future<? extends T> future = this.myCacheComputation;
                Intrinsics.checkNotNull(future);
                cacheComputation = future;
                object = Unit.INSTANCE;
            }
            Object result = null;
            result = JSLanguageServiceUtil.awaitFuture(cacheComputation, (long)timeout, (boolean)false, null);
            object = this;
            synchronized (object) {
                boolean bl = false;
                if (this.myCacheComputation != null) {
                    Future<T> future = this.myCacheComputation;
                    Intrinsics.checkNotNull(future);
                    if (future.isDone()) {
                        try {
                            Future<T> future2 = this.myCacheComputation;
                            Intrinsics.checkNotNull(future2);
                            this.myCachedValue = future2.get();
                            result = this.myCachedValue;
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (CancellationException cancellationException) {
                        }
                        catch (ExecutionException e) {
                            LOG.error((Throwable)e);
                        }
                        this.myCacheComputation = null;
                        this.myUpdateTime = System.currentTimeMillis();
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            return (T)result;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001b\u001a\u00020\u0005H\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001dH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\"\u001a\u00020#H\u0007J \u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u0005H\u0002J\u0018\u0010)\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u0005H\u0002J\u001e\u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002R\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0002X\u0083D\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\t8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0015\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\t8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u00058\u0002X\u0083D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u00058\u0002X\u0083D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u00020\u00058\u0002X\u0083D\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/angular2/cli/AngularCliSchematicsRegistryServiceImpl$Companion;", "", "<init>", "()V", "USER_AGENT", "", "NG_PACKAGES_URL", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "CACHE_EXPIRY", "", "ourExecutorService", "Ljava/util/concurrent/ExecutorService;", "SCHEMATICS_PUBLIC", "Lcom/intellij/openapi/util/Key;", "Lorg/angular2/cli/AngularCliSchematicsRegistryServiceImpl$CachedSchematics;", "SCHEMATICS_ALL", "SCHEMATICS_CACHE_TRACKER", "Lcom/intellij/openapi/util/SimpleModificationTracker;", "NG_PACKAGES_JSON_PATH", "SCHEMATICS_PROP", "NG_ADD_SCHEMATIC", "fetchPackagesSupportingNgAdd", "", "Lcom/intellij/javascript/nodejs/packageJson/NodePackageBasicInfo;", "readNgAddPackages", "content", "getSchematicsCollection", "Ljava/io/File;", "packageJson", "hasNgAddSchematic", "", "schematicsCollection", "reader", "Lcom/google/gson/stream/JsonReader;", "checkForNgAddSupport", "project", "Lcom/intellij/openapi/project/Project;", "packageName", "versionOrRange", "getKey", "version", "getCachedSchematics", "dataHolder", "Lcom/intellij/openapi/util/UserDataHolder;", "key", "intellij.angular.backend"})
    @SourceDebugExtension(value={"SMAP\nAngularCliSchematicsRegistryServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AngularCliSchematicsRegistryServiceImpl.kt\norg/angular2/cli/AngularCliSchematicsRegistryServiceImpl$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,321:1\n1586#2:322\n1661#2,3:323\n1#3:326\n*S KotlinDebug\n*F\n+ 1 AngularCliSchematicsRegistryServiceImpl.kt\norg/angular2/cli/AngularCliSchematicsRegistryServiceImpl$Companion\n*L\n244#1:322\n244#1:323,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final List<NodePackageBasicInfo> fetchPackagesSupportingNgAdd() {
            try {
                RequestBuilder builder = HttpRequests.request((String)NG_PACKAGES_URL);
                builder.userAgent(USER_AGENT);
                builder.gzip(true);
                String string = builder.readString(null);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
                return this.readNgAddPackages(string);
            }
            catch (IOException e) {
                LOG.info("Failed to load current list of ng-add compatible packages.", (Throwable)e);
                try {
                    InputStream inputStream = AngularCliSchematicsRegistryServiceImpl.class.getResourceAsStream(NG_PACKAGES_JSON_PATH);
                    Intrinsics.checkNotNull((Object)inputStream);
                    Closeable closeable = inputStream;
                    Throwable throwable = null;
                    try {
                        InputStream is = (InputStream)closeable;
                        boolean bl = false;
                        String string = FileUtil.loadTextAndClose((Reader)new InputStreamReader(is, StandardCharsets.UTF_8));
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadTextAndClose(...)");
                        List<NodePackageBasicInfo> list = Companion.readNgAddPackages(string);
                        return list;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                catch (Exception e1) {
                    LOG.error("Failed to load list of ng-add compatible packages from static file.", (Throwable)e1);
                    return CollectionsKt.emptyList();
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final List<NodePackageBasicInfo> readNgAddPackages(String content) {
            void $this$mapTo$iv$iv;
            JsonElement jsonElement = JsonParser.parseString((String)content);
            Intrinsics.checkNotNull((Object)jsonElement, (String)"null cannot be cast to non-null type com.google.gson.JsonObject");
            JsonObject contents = (JsonObject)jsonElement;
            Set set = contents.get(NG_ADD_SCHEMATIC).getAsJsonObject().entrySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"entrySet(...)");
            Iterable $this$map$iv = set;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void e;
                Map.Entry entry = (Map.Entry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new NodePackageBasicInfo((String)e.getKey(), ((JsonElement)e.getValue()).getAsString()));
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final File getSchematicsCollection(File packageJson) throws IOException {
            Closeable closeable = (Closeable)new JsonReader((Reader)new InputStreamReader((InputStream)new FileInputStream(packageJson), StandardCharsets.UTF_8));
            Throwable throwable = null;
            try {
                JsonReader reader = (JsonReader)closeable;
                boolean bl = false;
                reader.beginObject();
                while (reader.hasNext()) {
                    String key = reader.nextName();
                    if (Intrinsics.areEqual((Object)key, (Object)SCHEMATICS_PROP)) {
                        String path = reader.nextString();
                        String[] stringArray = new String[]{path};
                        File file = Paths.get(packageJson.getParent(), stringArray).normalize().toAbsolutePath().toFile();
                        return file;
                    }
                    reader.skipValue();
                }
                File file = null;
                return file;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean hasNgAddSchematic(File schematicsCollection) throws IOException {
            Closeable closeable = (Closeable)new JsonReader((Reader)new InputStreamReader((InputStream)new FileInputStream(schematicsCollection), StandardCharsets.UTF_8));
            Throwable throwable = null;
            try {
                JsonReader reader = (JsonReader)closeable;
                boolean bl = false;
                boolean bl2 = Companion.hasNgAddSchematic(reader);
                return bl2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        @JvmStatic
        public final boolean hasNgAddSchematic(@NotNull JsonReader reader) throws IOException {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            reader.setLenient(true);
            reader.beginObject();
            while (reader.hasNext()) {
                String key = reader.nextName();
                if (Intrinsics.areEqual((Object)SCHEMATICS_PROP, (Object)key)) {
                    reader.beginObject();
                    while (reader.hasNext()) {
                        String schematicName = reader.nextName();
                        if (Intrinsics.areEqual((Object)schematicName, (Object)NG_ADD_SCHEMATIC)) {
                            return true;
                        }
                        reader.skipValue();
                    }
                    reader.endObject();
                    continue;
                }
                reader.skipValue();
            }
            reader.endObject();
            return false;
        }

        private final boolean checkForNgAddSupport(Project project, String packageName, String versionOrRange) {
            try {
                JsonObject pkgJson;
                CompletableFuture future = NpmRegistryService.Companion.getInstance(project).fetchPackageJsonFuture(packageName, versionOrRange, null);
                JsonObject jsonObject = pkgJson = (JsonObject)future.get(30L, TimeUnit.SECONDS);
                return (jsonObject != null ? jsonObject.get(SCHEMATICS_PROP) : null) != null;
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
                return false;
            }
        }

        private final String getKey(String packageName, String version) {
            return packageName + "@" + version;
        }

        private final CachedSchematics getCachedSchematics(UserDataHolder dataHolder, Key<CachedSchematics> key) {
            Object object = ConcurrencyUtil.computeIfAbsent((UserDataHolder)dataHolder, key, Companion::getCachedSchematics$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"computeIfAbsent(...)");
            return (CachedSchematics)object;
        }

        private static final CachedSchematics getCachedSchematics$lambda$0() {
            return new CachedSchematics();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

