/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceBriefConfig;
import com.intellij.database.diagnostic.DataSourceDiagnosticRecorder;
import com.intellij.database.diagnostic.DiagnosticSectionReference;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseNativeIntrospector;
import com.intellij.database.dialects.base.introspector.IntrospectionQueryContext;
import com.intellij.database.dialects.base.introspector.SchemaLevel;
import com.intellij.database.dialects.postgresbase.PgNoDatabaseXminOption;
import com.intellij.database.dialects.postgresbase.PgSystemSchemasOption;
import com.intellij.database.dialects.postgresbase.PgTemplateDatabaseOption;
import com.intellij.database.dialects.postgresbase.introspector.IntroGuidance;
import com.intellij.database.dialects.postgresbase.introspector.IntroModeCtx;
import com.intellij.database.dialects.postgresbase.introspector.IntroStep;
import com.intellij.database.dialects.postgresbase.introspector.PgAclItem;
import com.intellij.database.dialects.postgresbase.introspector.PgBaseIntroQueries;
import com.intellij.database.dialects.postgresbase.introspector.PgBaseIntrospector$introspectElevation$;
import com.intellij.database.dialects.postgresbase.introspector.PgBaseIntrospectorKt;
import com.intellij.database.dialects.postgresbase.model.PgBaseAggregate;
import com.intellij.database.dialects.postgresbase.model.PgBaseArgument;
import com.intellij.database.dialects.postgresbase.model.PgBaseCast;
import com.intellij.database.dialects.postgresbase.model.PgBaseCatalogObject;
import com.intellij.database.dialects.postgresbase.model.PgBaseDatabase;
import com.intellij.database.dialects.postgresbase.model.PgBaseDefType;
import com.intellij.database.dialects.postgresbase.model.PgBaseDefTypeAttribute;
import com.intellij.database.dialects.postgresbase.model.PgBaseForeignKey;
import com.intellij.database.dialects.postgresbase.model.PgBaseGrantsHolder;
import com.intellij.database.dialects.postgresbase.model.PgBaseKey;
import com.intellij.database.dialects.postgresbase.model.PgBaseLanguage;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeColumn;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeDatabase;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeSchema;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeStoredTable;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeTable;
import com.intellij.database.dialects.postgresbase.model.PgBaseMatView;
import com.intellij.database.dialects.postgresbase.model.PgBaseModelHelper;
import com.intellij.database.dialects.postgresbase.model.PgBaseOperator;
import com.intellij.database.dialects.postgresbase.model.PgBaseRegularTable;
import com.intellij.database.dialects.postgresbase.model.PgBaseRoot;
import com.intellij.database.dialects.postgresbase.model.PgBaseRoutine;
import com.intellij.database.dialects.postgresbase.model.PgBaseSchema;
import com.intellij.database.dialects.postgresbase.model.PgBaseSourceAware;
import com.intellij.database.dialects.postgresbase.model.PgBaseTable;
import com.intellij.database.dialects.postgresbase.model.PgBaseTableColumn;
import com.intellij.database.dialects.postgresbase.model.PgBaseView;
import com.intellij.database.dialects.postgresbase.model.properties.PgCastContext;
import com.intellij.database.dialects.postgresbase.model.properties.PgCastMethod;
import com.intellij.database.dialects.postgresbase.model.properties.PgDataTypeSubKind;
import com.intellij.database.dialects.postgresbase.model.properties.PgDateInputStyle;
import com.intellij.database.dialects.postgresbase.model.properties.PgObjectGrant;
import com.intellij.database.dialects.postgresbase.model.properties.PgObjectGrantController;
import com.intellij.database.dialects.postgresbase.model.properties.PgOperatorKind;
import com.intellij.database.dialects.postgresbase.model.properties.PgPrivilege;
import com.intellij.database.dialects.postgresbase.model.properties.PgRoutineKind;
import com.intellij.database.dialects.postgresbase.model.properties.PgTimeZone;
import com.intellij.database.dialects.postgresbase.model.properties.PgVolatilityKind;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.introspection.IntrospectionMode;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicMixinElement;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModArrangedElement;
import com.intellij.database.model.basic.BasicModColumniation;
import com.intellij.database.model.basic.BasicModDatabase;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModForeignKey;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicModKey;
import com.intellij.database.model.basic.BasicModLikeTable;
import com.intellij.database.model.basic.BasicModMateDatabase;
import com.intellij.database.model.basic.BasicModMixinElement;
import com.intellij.database.model.basic.BasicModMixinNamedElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModMultiDatabaseRoot;
import com.intellij.database.model.basic.BasicModMultiLevelSchema;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModTypedElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModIdentifyingFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.PositioningFamily;
import com.intellij.database.model.meta.BasicResolveAssistant;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.Grants;
import com.intellij.database.model.properties.Level;
import com.intellij.database.model.properties.LevelFun;
import com.intellij.database.model.properties.references.BasicByColumnPositionsReference;
import com.intellij.database.model.properties.references.BasicIdOrNameReference;
import com.intellij.database.model.properties.references.BasicIdReference;
import com.intellij.database.model.properties.references.BasicNameReference;
import com.intellij.database.model.properties.references.BasicParentReference;
import com.intellij.database.remote.jdba.exceptions.DBException;
import com.intellij.database.remote.jdba.sql.Rewriters;
import com.intellij.database.remote.jdba.sql.SqlQuery;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.common.CollectionFun;
import com.intellij.database.util.common.Long2ObjectAutoMap;
import com.intellij.database.util.common.StringFun;
import com.intellij.database.util.sequences.SequenceFun;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ArrayListSet;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.StringKt;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00da\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b&\u0018\u0000 \u00ae\u0001*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u00062\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00050\u0007:\n\u00ae\u0001\u00af\u0001\u00b0\u0001\u00b1\u0001\u00b2\u0001B'\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0018\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0014J\b\u0010;\u001a\u000206H\u0014J\b\u0010<\u001a\u000206H\u0014J\n\u0010=\u001a\u0004\u0018\u00010>H\u0002J\u0010\u0010?\u001a\u0002062\u0006\u0010@\u001a\u00020AH\u0014J\u001d\u0010B\u001a\u0002062\u0006\u0010@\u001a\u00020A2\u0006\u0010C\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010DJ\u0010\u0010E\u001a\u0002062\u0006\u0010@\u001a\u00020AH\u0014J\b\u0010F\u001a\u00020GH\u0002J\b\u0010H\u001a\u00020$H\u0014J$\u0010I\u001a\u000206*\u00020J2\u0006\u0010K\u001a\u00020\u00142\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020MH\u0004J\u0010\u0010O\u001a\u00020M2\u0006\u0010P\u001a\u00020MH\u0002J\u0010\u0010Q\u001a\u00020M2\u0006\u0010L\u001a\u00020MH&J \u0010R\u001a\u0002062\u0006\u0010S\u001a\u00020A2\u0006\u0010T\u001a\u00020$2\u0006\u0010U\u001a\u00020$H\u0002J\u0016\u0010V\u001a\b\u0012\u0004\u0012\u00020X0W2\u0006\u0010S\u001a\u00020AH\u0014J \u0010Y\u001a\u0002062\u0006\u0010@\u001a\u00020A2\u0006\u0010T\u001a\u00020$2\u0006\u0010U\u001a\u00020$H\u0002J \u0010Z\u001a\u0002062\u0006\u0010S\u001a\u00020A2\u0006\u0010T\u001a\u00020$2\u0006\u0010U\u001a\u00020$H\u0014J\u0010\u0010[\u001a\u0002062\u0006\u0010\\\u001a\u00020AH\u0014J\u0010\u0010]\u001a\u0002062\u0006\u0010\\\u001a\u00020AH\u0014J\u0014\u0010^\u001a\u0004\u0018\u00010_2\b\u0010`\u001a\u0004\u0018\u00010MH\u0002J!\u0010a\u001a\u0002062\u0012\u0010b\u001a\n\u0012\u0006\b\u0001\u0012\u00020>0c\"\u00020>H\u0016\u00a2\u0006\u0002\u0010dJ&\u0010e\u001a\b\u0012\u0004\u0012\u00028\u00010f2\u0006\u0010@\u001a\u00020A2\u000e\u0010g\u001a\n\u0012\u0004\u0012\u00020i\u0018\u00010hH\u0014J\"\u0010j\u001a\u000e\u0012\u0004\u0012\u00020l\u0012\u0004\u0012\u00020$0k2\f\u0010m\u001a\b\u0012\u0004\u0012\u00020l0fH\u0014J,\u0010n\u001a\u0002062\u0006\u0010o\u001a\u00020M2\f\u0010p\u001a\b\u0012\u0004\u0012\u00020M0q2\f\u0010r\u001a\b\u0012\u0004\u0012\u00020t0sH\u0004J\u0017\u0010u\u001a\u0004\u0018\u00010\u00142\u0006\u0010@\u001a\u00020AH\u0002\u00a2\u0006\u0002\u0010vJ\b\u0010w\u001a\u00020$H\u0014J%\u0010x\u001a\u0002062\u0006\u0010\\\u001a\u00020A2\u0006\u0010C\u001a\u00028\u00012\u0006\u0010y\u001a\u00028\u0002H\u0014\u00a2\u0006\u0002\u0010zJ&\u0010{\u001a\u0002062\u0006\u0010\\\u001a\u00020A2\u0006\u0010|\u001a\u00020>2\f\u0010}\u001a\b\u0012\u0004\u0012\u00020~0hH\u0014J(\u0010\u007f\u001a\u0005\u0018\u00010\u0080\u00012\b\u0010\u0081\u0001\u001a\u00030\u0082\u00012\b\u0010\u0083\u0001\u001a\u00030\u0084\u00012\u0007\u0010\u0085\u0001\u001a\u00020MH\u0014JU\u0010\u0086\u0001\u001a\u000206\"\n\b\u0003\u0010\u0087\u0001*\u00030\u0088\u00012\b\u0010\u0089\u0001\u001a\u00030\u008a\u00012\u0011\u0010\u008b\u0001\u001a\f\u0012\u0007\b\u0001\u0012\u0003H\u0087\u00010\u008c\u00012\b\u0010\u008d\u0001\u001a\u00030\u008e\u00012\u0017\u0010\u008f\u0001\u001a\u0012\u0012\u0004\u0012\u00020\u0014\u0012\u0007\u0012\u0005\u0018\u00010\u0091\u00010\u0090\u0001H\u0004J1\u0010\u0092\u0001\u001a\u000206\"\n\b\u0003\u0010\u0087\u0001*\u00030\u0088\u00012\b\u0010\u0093\u0001\u001a\u0003H\u0087\u00012\n\u0010\u0094\u0001\u001a\u0005\u0018\u00010\u0095\u0001H\u0016\u00a2\u0006\u0003\u0010\u0096\u0001J?\u0010\u0097\u0001\u001a\u0005\u0018\u00010\u0098\u0001\"\n\b\u0003\u0010\u0099\u0001*\u00030\u009a\u00012\u0007\u0010y\u001a\u0003H\u0099\u00012\n\u0010\u009b\u0001\u001a\u0005\u0018\u00010\u0098\u00012\n\u0010\u009c\u0001\u001a\u0005\u0018\u00010\u0098\u0001H\u0014\u00a2\u0006\u0003\u0010\u009d\u0001J\u0013\u0010\u009e\u0001\u001a\u00020$2\b\u0010\u009f\u0001\u001a\u00030\u00a0\u0001H\u0014J-\u0010\u00a1\u0001\u001a\u00020M2\t\u0010\u00a2\u0001\u001a\u0004\u0018\u00010M2\u0007\u0010\u00a3\u0001\u001a\u00020$2\u000e\u0010\u00a4\u0001\u001a\t\u0012\u0004\u0012\u00020M0\u00a5\u0001H\u0004J\u0014\u0010\u00a6\u0001\u001a\u00020$2\t\u0010\u00a7\u0001\u001a\u0004\u0018\u00010MH\u0004J)\u0010\u00a8\u0001\u001a\u0005\u0018\u00010\u00a9\u00012\u0007\u0010\u00aa\u0001\u001a\u00020\u00142\t\u0010\u00ab\u0001\u001a\u0004\u0018\u00010M2\t\u0010\u00ac\u0001\u001a\u0004\u0018\u00010MJ\u001b\u0010\u00ad\u0001\u001a\u0005\u0018\u00010\u00a9\u0001*\u00020M2\t\u0010\u00ac\u0001\u001a\u0004\u0018\u00010MH\u0002R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u00020\u0016X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0012\u0010\u0019\u001a\u00020\u001aX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001e\u0010\u001d\u001a\u0004\u0018\u00010\u0014X\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\"\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010#\u001a\u00020$X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020$X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010&\"\u0004\b+\u0010(R\u001a\u0010,\u001a\u00020$X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010&\"\u0004\b.\u0010(R \u0010/\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002020100X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104\u00a8\u0006\u00b3\u0001"}, d2={"Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector;", "MR", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseRoot;", "D", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeDatabase;", "SL", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "nature", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$Nature;", "dbms", "Lcom/intellij/database/Dbms;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "<init>", "(Lcom/intellij/database/introspection/DBIntrospectionContext;Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$Nature;Lcom/intellij/database/Dbms;Lcom/intellij/database/model/ModelFactory;)V", "affectedKeySchemaIds", "Lcom/intellij/util/containers/ArrayListSet;", "", "helper", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseModelHelper;", "getHelper", "()Lcom/intellij/database/dialects/postgresbase/model/PgBaseModelHelper;", "queries", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries;", "getQueries", "()Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries;", "introspectionXid", "getIntrospectionXid", "()Ljava/lang/Long;", "setIntrospectionXid", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "showTemplateDbs", "", "getShowTemplateDbs", "()Z", "setShowTemplateDbs", "(Z)V", "showSystemScs", "getShowSystemScs", "setShowSystemScs", "noDbXmin", "getNoDbXmin", "setNoDbXmin", "renameHandlingRequests", "Lcom/intellij/database/util/common/Long2ObjectAutoMap;", "Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector$RenameInfo;", "getRenameHandlingRequests", "()Lcom/intellij/database/util/common/Long2ObjectAutoMap;", "initSpecificThings", "", "model", "Lcom/intellij/database/model/basic/BasicModModel;", "dsConfig", "Lcom/intellij/database/dataSource/DataSourceBriefConfig;", "introspectSpecificSessionInfo", "dropSpecificSessionInfo", "connectionDatabase", "Lcom/intellij/database/model/basic/BasicDatabase;", "introspectPreDatabaseObjects", "tran", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "postProcessDatabase", "database", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeDatabase;)V", "introspectServerObjectsInner", "getServerIntrospectionMode", "Lcom/intellij/database/introspection/IntrospectionMode;", "loadNewServerObjects", "setTx", "Lcom/intellij/database/dialects/base/introspector/IntrospectionQueryContext;", "stateNumber", "tx", "", "txage", "mapNegativeAgeToMax", "age", "generateDbAge", "introspectServerObjects", "trans", "detectDropped", "loadNew", "steps", "", "Lcom/intellij/database/dialects/postgresbase/introspector/IntroStep;", "retrieveAcls", "retrieveComments", "retrieveSettings", "transaction", "retrieveTimeZones", "parseDateStyle", "Lcom/intellij/database/dialects/postgresbase/model/properties/PgDateInputStyle;", "s", "introspectDatabaseSchemas", "databases", "", "([Lcom/intellij/database/model/basic/BasicDatabase;)V", "getDatabasesToIntrospect", "", "namespaces", "", "Lcom/intellij/database/model/basic/BasicNamespace;", "checkElementsUptodate", "", "Lcom/intellij/database/model/basic/BasicElement;", "elements", "freezeOnWrapAround", "param", "memory", "", "ageComputable", "Lkotlin/Function0;", "", "getCurrentXid", "(Lcom/intellij/database/layoutedQueries/DBTransaction;)Ljava/lang/Long;", "isItPossibleToRetrieveCurrentXid", "performFragmentIntrospectionPreceders", "schema", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeDatabase;Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeSchema;)V", "introspectElevation", "db", "schemasToElevateLevels", "Lcom/intellij/database/dialects/base/introspector/SchemaLevel;", "parseAclItem", "Lcom/intellij/database/dialects/postgresbase/introspector/PgAclItem;", "lex", "Lcom/intellij/lexer/Lexer;", "ns", "Lcom/intellij/database/script/generator/NamingService;", "item", "processArgs", "T", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseArgument;", "r", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$ArgumentNameHolder;", "family", "Lcom/intellij/database/model/families/ModPositioningNamingFamily;", "routine", "Lcom/intellij/database/model/basic/BasicModRoutine;", "getTypeByOid", "Lkotlin/Function1;", "Lcom/intellij/database/types/DasType;", "processArgExtra", "argument", "argMode", "", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseArgument;Ljava/lang/Character;)V", "preventDuplicatedRelationForSchema", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeStoredTable;", "S", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;", "newRelation", "existing", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeStoredTable;Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeStoredTable;)Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeStoredTable;", "isNameSurrogate", "columniation", "Lcom/intellij/database/model/basic/BasicModColumniation;", "surrogateKeyName", "tableName", "primary", "colNames", "", "isColumnNameSurrogate", "it", "createIdOrQNameRef", "Lcom/intellij/database/model/properties/BasicReference;", "id", "name", "pDefault", "parseNameRef", "Companion", "RenameInfo", "DatabaseRetriever", "NativeRetriever", "SchemaRetriever", "intellij.database.dialects.postgresbase"})
@SourceDebugExtension(value={"SMAP\nPgBaseIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PgBaseIntrospector.kt\ncom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector\n+ 2 DataSourceBriefConfig.kt\ncom/intellij/database/dataSource/DataSourceBriefConfigs\n+ 3 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 7 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 8 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 9 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 10 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1881:1\n41#2,2:1882\n39#2:1884\n41#2,2:1885\n39#2:1887\n41#2,2:1888\n39#2:1890\n521#3:1891\n502#3,18:1892\n521#3:1910\n502#3,18:1911\n521#3:1929\n502#3,2:1930\n505#3,15:1937\n521#3:1981\n502#3,18:1982\n1661#4,3:1932\n1021#4,2:1935\n1807#4,3:1954\n1786#4,3:1957\n1915#4,2:1960\n1915#4,2:1962\n1234#4,2:2004\n1266#4,4:2006\n1915#4,2:2010\n37#5,2:1952\n37#5,2:2000\n479#6:1964\n1#7:1965\n1#7:1970\n1#7:1977\n1010#8:1966\n1021#8:1967\n1207#8,2:1968\n1209#8:1971\n1022#8:1972\n1010#8:1973\n1021#8:1974\n1207#8,2:1975\n1209#8:1978\n1022#8:1979\n18#9:1980\n14060#10,2:2002\n*S KotlinDebug\n*F\n+ 1 PgBaseIntrospector.kt\ncom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector\n*L\n85#1:1882,2\n85#1:1884\n86#1:1885,2\n86#1:1887\n87#1:1888,2\n87#1:1890\n192#1:1891\n192#1:1892,18\n218#1:1910\n218#1:1911,18\n225#1:1929\n225#1:1930,2\n225#1:1937,15\n94#1:1981\n94#1:1982,18\n227#1:1932,3\n230#1:1935,2\n265#1:1954,3\n268#1:1957,3\n277#1:1960,2\n288#1:1962,2\n239#1:2004,2\n239#1:2006,4\n293#1:2010,2\n260#1:1952,2\n123#1:2000,2\n332#1:1964\n550#1:1970\n553#1:1977\n550#1:1966\n550#1:1967\n550#1:1968,2\n550#1:1971\n550#1:1972\n553#1:1973\n553#1:1974\n553#1:1975,2\n553#1:1978\n553#1:1979\n626#1:1980\n204#1:2002,2\n*E\n"})
public abstract class PgBaseIntrospector<MR extends PgBaseRoot, D extends PgBaseLikeDatabase, SL extends PgBaseLikeSchema>
extends BaseMultiDatabaseIntrospector<MR, D, SL> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ArrayListSet<Long> affectedKeySchemaIds;
    @Nullable
    private Long introspectionXid;
    private boolean showTemplateDbs;
    private boolean showSystemScs;
    private boolean noDbXmin;
    @NotNull
    private final Long2ObjectAutoMap<Long2ObjectMap<RenameInfo>> renameHandlingRequests;
    @Deprecated
    public static final int FROZEN_TXID = 2;

    public PgBaseIntrospector(@NotNull DBIntrospectionContext context, @NotNull BaseIntrospector.Nature nature, @NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)nature, (String)"nature");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        super(context, nature, dbms, modelFactory);
        this.affectedKeySchemaIds = new ArrayListSet();
        this.renameHandlingRequests = new Long2ObjectAutoMap(PgBaseIntrospector::renameHandlingRequests$lambda$0);
    }

    @NotNull
    protected abstract PgBaseModelHelper getHelper();

    @NotNull
    protected abstract PgBaseIntroQueries getQueries();

    @Nullable
    protected final Long getIntrospectionXid() {
        return this.introspectionXid;
    }

    protected final void setIntrospectionXid(@Nullable Long l) {
        this.introspectionXid = l;
    }

    protected final boolean getShowTemplateDbs() {
        return this.showTemplateDbs;
    }

    protected final void setShowTemplateDbs(boolean bl) {
        this.showTemplateDbs = bl;
    }

    protected final boolean getShowSystemScs() {
        return this.showSystemScs;
    }

    protected final void setShowSystemScs(boolean bl) {
        this.showSystemScs = bl;
    }

    protected final boolean getNoDbXmin() {
        return this.noDbXmin;
    }

    protected final void setNoDbXmin(boolean bl) {
        this.noDbXmin = bl;
    }

    @NotNull
    protected final Long2ObjectAutoMap<Long2ObjectMap<RenameInfo>> getRenameHandlingRequests() {
        return this.renameHandlingRequests;
    }

    protected void initSpecificThings(@NotNull BasicModModel model, @NotNull DataSourceBriefConfig dsConfig) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)dsConfig, (String)"dsConfig");
        super.initSpecificThings(model, dsConfig);
        DataSourceBriefConfig $this$getBooleanOptionValue_u24default$iv = dsConfig;
        boolean default$iv = false;
        boolean $i$f$getBooleanOptionValue = false;
        DataSourceBriefConfig $this$getOptionValue$iv$iv = $this$getBooleanOptionValue_u24default$iv;
        boolean $i$f$getOptionValue = false;
        Boolean bl = (Boolean)$this$getOptionValue$iv$iv.getProvidedOptionValue(PgTemplateDatabaseOption.class);
        this.showTemplateDbs = bl != null ? bl : default$iv;
        $this$getBooleanOptionValue_u24default$iv = dsConfig;
        default$iv = false;
        $i$f$getBooleanOptionValue = false;
        $this$getOptionValue$iv$iv = $this$getBooleanOptionValue_u24default$iv;
        $i$f$getOptionValue = false;
        Boolean bl2 = (Boolean)$this$getOptionValue$iv$iv.getProvidedOptionValue(PgSystemSchemasOption.class);
        this.showSystemScs = bl2 != null ? bl2 : default$iv;
        $this$getBooleanOptionValue_u24default$iv = dsConfig;
        default$iv = false;
        $i$f$getBooleanOptionValue = false;
        $this$getOptionValue$iv$iv = $this$getBooleanOptionValue_u24default$iv;
        $i$f$getOptionValue = false;
        Boolean bl3 = (Boolean)$this$getOptionValue$iv$iv.getProvidedOptionValue(PgNoDatabaseXminOption.class);
        this.noDbXmin = bl3 != null ? bl3 : default$iv;
    }

    protected void introspectSpecificSessionInfo() {
        super.introspectSpecificSessionInfo();
        this.inTransactionUnit(arg_0 -> PgBaseIntrospector.introspectSpecificSessionInfo$lambda$0(this, arg_0));
    }

    protected void dropSpecificSessionInfo() {
        super.dropSpecificSessionInfo();
        this.renameHandlingRequests.removeAll();
    }

    private final BasicDatabase connectionDatabase() {
        String databaseName = this.getDbConnectionInfo().databaseName;
        return databaseName == null ? null : (BasicDatabase)((BasicModMultiDatabaseRoot)this.getRoot()).findDatabaseByName(databaseName);
    }

    protected void introspectPreDatabaseObjects(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        super.introspectPreDatabaseObjects(tran);
        this.introspectServerObjectsInTran(tran);
    }

    protected void postProcessDatabase(@NotNull DBTransaction tran, @NotNull D database) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        Intrinsics.checkNotNullParameter(database, (String)"database");
        this.handleErrors("Detect and handle cross-schema foreign keys", () -> PgBaseIntrospector.postProcessDatabase$lambda$0(this, tran, database));
    }

    protected void introspectServerObjectsInner(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        IntrospectionMode mode = this.getServerIntrospectionMode();
        long stateNumber = mode.increment ? ((PgBaseRoot)this.getRoot()).getIntrospectionStateNumber() : 0L;
        boolean detectDropped = mode.increment;
        boolean loadNew = mode.full || this.loadNewServerObjects();
        this.setTx((IntrospectionQueryContext)this, stateNumber, "tx", "TXAGE");
        String string = IntrospectionMode.INCREMENT.code;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"code");
        this.setQueryParameter(string, mode.increment);
        this.introspectServerObjects(tran, detectDropped, loadNew);
    }

    private final IntrospectionMode getServerIntrospectionMode() {
        return ((PgBaseRoot)this.getRoot()).getIntrospectionStateNumber() != 0L && !this.getForbidIncremental() ? IntrospectionMode.INCREMENT : IntrospectionMode.FULL;
    }

    protected boolean loadNewServerObjects() {
        Long l = this.introspectionXid;
        long l2 = ((PgBaseRoot)this.getRoot()).getIntrospectionStateNumber();
        return l == null || l != l2;
    }

    protected final void setTx(@NotNull IntrospectionQueryContext $this$setTx, long stateNumber, @NotNull String tx, @NotNull String txage) {
        Intrinsics.checkNotNullParameter((Object)$this$setTx, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        Intrinsics.checkNotNullParameter((Object)txage, (String)"txage");
        $this$setTx.setQueryParameter(tx, (Object)stateNumber);
        $this$setTx.setQueryParameter(txage, (Object)this.mapNegativeAgeToMax(this.generateDbAge(":" + tx)));
    }

    private final String mapNegativeAgeToMax(String age) {
        return "coalesce(nullif(greatest(" + age + ", -1), -1), 2147483647)";
    }

    @NotNull
    public abstract String generateDbAge(@NotNull String var1);

    private final void introspectServerObjects(DBTransaction trans, boolean detectDropped, boolean loadNew) {
        block1: {
            List<IntroStep> steps = this.steps(trans);
            CollectionsKt.sort(steps);
            for (IntroStep step : steps) {
                step.getPerform().invoke((Object)new IntroModeCtx.Raw(detectDropped, detectDropped, loadNew));
            }
            Long l = this.introspectionXid;
            if (l == null) break block1;
            long xid = ((Number)l).longValue();
            boolean bl = false;
            this.inModel(arg_0 -> PgBaseIntrospector.introspectServerObjects$lambda$0$0(xid, arg_0));
        }
    }

    @NotNull
    protected List<IntroStep> steps(@NotNull DBTransaction trans) {
        Intrinsics.checkNotNullParameter((Object)trans, (String)"trans");
        return PgBaseIntrospectorKt.add$default(PgBaseIntrospectorKt.add$default(PgBaseIntrospectorKt.add$default(PgBaseIntrospectorKt.add$default(new ArrayList(), 20, null, null, arg_0 -> PgBaseIntrospector.steps$lambda$0(this, trans, arg_0), 6, null), 30, null, null, arg_0 -> PgBaseIntrospector.steps$lambda$1(this, trans, arg_0), 6, null), 40, null, null, arg_0 -> PgBaseIntrospector.steps$lambda$2(this, trans, arg_0), 6, null), 100, null, null, arg_0 -> PgBaseIntrospector.steps$lambda$3(this, trans, arg_0), 6, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void retrieveAcls(DBTransaction tran, boolean detectDropped, boolean loadNew) {
        this.reportRetrieving("ACL", "introspection.retrieve.ACL");
        BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)this;
        boolean $i$f$continueOnDbError = false;
        BaseNativeIntrospector baseNativeIntrospector = this_$iv;
        Object whatsDoing$iv$iv = null;
        boolean $i$f$continueOnDbError2 = false;
        try {
            boolean bl = false;
            this.inModel(arg_0 -> PgBaseIntrospector.retrieveAcls$lambda$0$0(detectDropped, loadNew, this, tran, arg_0));
        }
        catch (DBException e$iv$iv) {
            StringBuilder stringBuilder;
            void this_$iv$iv;
            boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
            StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
            $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
            $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
            String message$iv$iv = stringBuilder.toString();
            if (expected$iv$iv) {
                this_$iv$iv.trace(message$iv$iv);
            } else {
                IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
            }
            this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
        }
    }

    protected void retrieveComments(@NotNull DBTransaction trans, boolean detectDropped, boolean loadNew) {
        Intrinsics.checkNotNullParameter((Object)trans, (String)"trans");
    }

    /*
     * WARNING - void declaration
     */
    protected void retrieveSettings(@NotNull DBTransaction transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)this;
        boolean $i$f$continueOnDbError = false;
        BaseNativeIntrospector baseNativeIntrospector = this_$iv;
        Object whatsDoing$iv$iv = null;
        boolean $i$f$continueOnDbError2 = false;
        try {
            boolean bl = false;
            String dateStyle = (String)this.performQuery(transaction, this.getQueries().getRetrieveDateStyle());
            this.inModel(arg_0 -> PgBaseIntrospector.retrieveSettings$lambda$0$0(this, dateStyle, arg_0));
        }
        catch (DBException e$iv$iv) {
            StringBuilder stringBuilder;
            void this_$iv$iv;
            boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
            StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
            $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
            $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
            String message$iv$iv = stringBuilder.toString();
            if (expected$iv$iv) {
                this_$iv$iv.trace(message$iv$iv);
            } else {
                IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
            }
            this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void retrieveTimeZones(@NotNull DBTransaction transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)this;
        boolean $i$f$continueOnDbError = false;
        BaseNativeIntrospector baseNativeIntrospector = this_$iv;
        Object whatsDoing$iv$iv = null;
        boolean $i$f$continueOnDbError2 = false;
        try {
            Iterable iterable;
            boolean bl = false;
            try {
                void $this$mapTo$iv;
                Object object = this.performQuery(transaction, this.getQueries().getRetrieveTimeZones());
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"performQuery(...)");
                iterable = (Iterable)object;
                Collection destination$iv = new ArrayList();
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it;
                    PgBaseIntroQueries.OneTimeZone oneTimeZone = (PgBaseIntroQueries.OneTimeZone)item$iv;
                    Collection collection = destination$iv;
                    boolean bl2 = false;
                    collection.add(new PgTimeZone(it.name, it.is_dst));
                }
                iterable = destination$iv;
                ArrayList $this$retrieveTimeZones_u24lambda_u240_u241 = (ArrayList)iterable;
                boolean bl3 = false;
                List $this$sortBy$iv = $this$retrieveTimeZones_u24lambda_u240_u241;
                boolean $i$f$sortBy = false;
                if ($this$sortBy$iv.size() > 1) {
                    CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            PgTimeZone it = (PgTimeZone)a;
                            boolean bl = false;
                            Comparable comparable = (Comparable)((Object)it.getName());
                            it = (PgTimeZone)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                        }
                    });
                }
                iterable = (List)iterable;
            }
            catch (Exception e) {
                int[] nArray = new int[]{10};
                if (this.getServerVersion().isOrGreater(nArray)) {
                    throw e;
                }
                this.log.warn((Throwable)e);
                iterable = CollectionsKt.emptyList();
            }
            Iterable zones = iterable;
            this.inModel(arg_0 -> PgBaseIntrospector.retrieveTimeZones$lambda$0$2((List)zones, arg_0));
        }
        catch (DBException e$iv$iv) {
            StringBuilder stringBuilder;
            void this_$iv$iv;
            boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
            StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
            $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
            $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
            String message$iv$iv = stringBuilder.toString();
            if (expected$iv$iv) {
                this_$iv$iv.trace(message$iv$iv);
            } else {
                IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
            }
            this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final PgDateInputStyle parseDateStyle(String s) {
        if (s == null) {
            return null;
        }
        int i2 = StringsKt.indexOf$default((CharSequence)s, (String)",", (int)0, (boolean)false, (int)6, null);
        if (i2 < 0) {
            return null;
        }
        String string = s.substring(i2 + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String string2 = StringUtil.toUpperCase((String)((Object)StringsKt.trim((CharSequence)string)).toString());
        if (string2 == null) return null;
        int n = -1;
        switch (string2.hashCode()) {
            case 67824: {
                if (string2.equals("DMY")) {
                    n = 1;
                }
                break;
            }
            case 87984: {
                if (string2.equals("YMD")) {
                    n = 2;
                }
                break;
            }
            case 76194: {
                if (string2.equals("MDY")) {
                    n = 3;
                }
                break;
            }
        }
        switch (n) {
            case 1: {
                PgDateInputStyle pgDateInputStyle = PgDateInputStyle.DMY;
                return pgDateInputStyle;
            }
            case 3: {
                PgDateInputStyle pgDateInputStyle = PgDateInputStyle.MDY;
                return pgDateInputStyle;
            }
            case 2: {
                PgDateInputStyle pgDateInputStyle = PgDateInputStyle.YMD;
                return pgDateInputStyle;
            }
            default: {
                return null;
            }
        }
    }

    public void introspectDatabaseSchemas(BasicDatabase ... databases) {
        Intrinsics.checkNotNullParameter((Object)databases, (String)"databases");
        Iterable dbs = (Iterable)this.inTransaction(arg_0 -> PgBaseIntrospector.introspectDatabaseSchemas$lambda$0(this, databases, arg_0));
        Collection $this$toTypedArray$iv = CollectionsKt.toList((Iterable)dbs);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        BasicDatabase[] basicDatabaseArray = thisCollection$iv.toArray(new BasicDatabase[0]);
        super.introspectDatabaseSchemas(Arrays.copyOf(basicDatabaseArray, basicDatabaseArray.length));
    }

    @NotNull
    protected Iterable<D> getDatabasesToIntrospect(@NotNull DBTransaction tran, @Nullable Collection<? extends BasicNamespace> namespaces) {
        BasicDatabase connectionDatabase;
        block20: {
            block19: {
                boolean bl;
                block16: {
                    List databases;
                    List list;
                    block18: {
                        block17: {
                            boolean bl2;
                            block15: {
                                Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
                                List list2 = namespaces;
                                if (list2 == null || list2.isEmpty()) break block17;
                                Iterable $this$any$iv = namespaces;
                                boolean $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    bl2 = false;
                                } else {
                                    for (Object element$iv : $this$any$iv) {
                                        BasicNamespace it = (BasicNamespace)element$iv;
                                        boolean bl3 = false;
                                        if (!(it instanceof PgBaseDatabase)) continue;
                                        bl2 = true;
                                        break block15;
                                    }
                                    bl2 = false;
                                }
                            }
                            if (!bl2) break block18;
                        }
                        this.introspectNamespacesInTran(tran);
                    }
                    if ((list = namespaces) == null || (list = CollectionsKt.filterIsInstance((Iterable)list, PgBaseDatabase.class)) == null) {
                        list = databases = CollectionsKt.emptyList();
                    }
                    if ((connectionDatabase = this.connectionDatabase()) == null) break block19;
                    if (!(!((Collection)databases).isEmpty())) break block20;
                    Iterable $this$all$iv = databases;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            PgBaseDatabase it = (PgBaseDatabase)element$iv;
                            boolean bl4 = false;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)connectionDatabase.getName())) continue;
                            bl = false;
                            break block16;
                        }
                        bl = true;
                    }
                }
                if (!bl) break block20;
            }
            JBIterable jBIterable = JBIterable.empty();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
            return (Iterable)jBIterable;
        }
        JBIterable jBIterable = JBIterable.of((Object)((PgBaseLikeDatabase)connectionDatabase));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"of(...)");
        return (Iterable)jBIterable;
    }

    @NotNull
    protected Map<BasicElement, Boolean> checkElementsUptodate(@NotNull Iterable<? extends BasicElement> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        BasicElement basicElement = (BasicElement)CollectionsKt.firstOrNull(elements);
        if (basicElement == null || (basicElement = basicElement.getDatabase()) == null) {
            return MapsKt.emptyMap();
        }
        BasicElement database = basicElement;
        LinkedHashMap<Object, Object> ids = new LinkedHashMap<Object, Object>();
        Iterable<? extends BasicElement> $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        Iterator<? extends BasicElement> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            BasicElement element$iv;
            BasicElement it = element$iv = iterator.next();
            boolean bl = false;
            if (!PgBaseIntrospectorKt.canCheckOutdated(it)) continue;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.intellij.database.dialects.postgresbase.model.PgBaseCatalogObject");
            PgBaseCatalogObject cfr_ignored_0 = (PgBaseCatalogObject)it;
            if (!Intrinsics.areEqual((Object)database, (Object)((PgBaseCatalogObject)it).getDatabase())) {
                this.log.error("Element from different database");
            }
            ((Map)ids).put(((PgBaseCatalogObject)it).getObjectId(), it);
        }
        if (ids.isEmpty()) {
            return MapsKt.emptyMap();
        }
        BaseNativeIntrospector baseNativeIntrospector = (BaseNativeIntrospector)this;
        SqlQuery sqlQuery = this.getQueries().getRetrieveStates().rewrite(arg_0 -> PgBaseIntrospector.checkElementsUptodate$lambda$1(ids, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)sqlQuery, (String)"rewrite(...)");
        List states = (List)BaseNativeIntrospector.performQuery$default((BaseNativeIntrospector)baseNativeIntrospector, (SqlQuery)sqlQuery, null, (int)2, null);
        LinkedHashMap res = new LinkedHashMap();
        ids.forEach((arg_0, arg_1) -> PgBaseIntrospector.checkElementsUptodate$lambda$3((arg_0, arg_1) -> PgBaseIntrospector.checkElementsUptodate$lambda$2(res, arg_0, arg_1), arg_0, arg_1));
        Intrinsics.checkNotNull((Object)states);
        Iterable $this$forEach$iv2 = states;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            PgBaseCatalogObject obj;
            PgBaseIntroQueries.OneState s = (PgBaseIntroQueries.OneState)element$iv;
            boolean bl = false;
            if ((PgBaseCatalogObject)ids.get(s.oid) == null) continue;
            ((Map)res).put(obj, obj.getStateNumber() == s.xmin);
        }
        this.inModel(arg_0 -> PgBaseIntrospector.checkElementsUptodate$lambda$5(res, arg_0));
        return res;
    }

    protected final void freezeOnWrapAround(@NotNull String param, @NotNull Set<String> memory, @NotNull Function0<Integer> ageComputable) {
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        Intrinsics.checkNotNullParameter(memory, (String)"memory");
        Intrinsics.checkNotNullParameter(ageComputable, (String)"ageComputable");
        if (memory.contains(param)) {
            return;
        }
        int age = ((Number)ageComputable.invoke()).intValue();
        if (age >= 0 && age != Integer.MAX_VALUE) {
            return;
        }
        this.setQueryParameter(param, 2);
        ((Collection)memory).add(param);
    }

    private final Long getCurrentXid(DBTransaction tran) {
        return this.isItPossibleToRetrieveCurrentXid() ? (Long)this.performQuery(tran, this.getQueries().currentXid) : null;
    }

    protected boolean isItPossibleToRetrieveCurrentXid() {
        return true;
    }

    protected void performFragmentIntrospectionPreceders(@NotNull DBTransaction transaction, @NotNull D database, @NotNull SL schema) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter(database, (String)"database");
        Intrinsics.checkNotNullParameter(schema, (String)"schema");
        if (!(database instanceof PgBaseDatabase)) {
            return;
        }
        if (((PgBaseDatabase)database).getLanguages().isNotEmpty()) {
            return;
        }
        BaseMultiDatabaseIntrospector.BaseDatabaseRetriever dbRetriever = this.createDatabaseRetriever(transaction, (BasicModMateDatabase)database);
        dbRetriever.retrieveAuxiliaryObjects();
    }

    /*
     * WARNING - void declaration
     */
    protected void introspectElevation(@NotNull DBTransaction transaction, @NotNull BasicDatabase db, @NotNull Collection<SchemaLevel> schemasToElevateLevels) {
        void $this$filterIsInstance$iv;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Intrinsics.checkNotNullParameter(schemasToElevateLevels, (String)"schemasToElevateLevels");
        PgBaseLikeDatabase cfr_ignored_0 = (PgBaseLikeDatabase)db;
        Sequence sequence = SequencesKt.map((Sequence)((Sequence)SequenceFun.asSequence(schemasToElevateLevels)), PgBaseIntrospector::introspectElevation$lambda$0);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)introspectElevation$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        List schemas = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)sequence2, PgBaseIntrospector::introspectElevation$lambda$1));
        this.introspectSchemasByLevels(transaction, (BasicModDatabase)db, schemas, false, schemasToElevateLevels, null);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    protected PgAclItem parseAclItem(@NotNull Lexer lex, @NotNull NamingService ns, @NotNull String item) {
        Intrinsics.checkNotNullParameter((Object)lex, (String)"lex");
        Intrinsics.checkNotNullParameter((Object)ns, (String)"ns");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        gp = "group ";
        isGroup = StringsKt.startsWith$default((String)item, (String)gp, (boolean)false, (int)2, null);
        v0 = so = isGroup != false ? gp.length() : 0;
        if (StringsKt.startsWith$default((CharSequence)item, (char)'=', (boolean)false, (int)2, null)) {
            v1 = 0;
        } else {
            lex.start((CharSequence)item, so, item.length());
            var9_7 = lex.getTokenEnd();
            it = ((Number)var9_7).intValue();
            $i$a$-takeIf-PgBaseIntrospector$parseAclItem$eq$1 = false;
            v1 = item.charAt(it) == '=' != false ? var9_7 : null;
            if (v1 == null) {
                var9_7 = StringsKt.indexOf$default((CharSequence)item, (char)'=', (int)0, (boolean)false, (int)6, null);
                it = ((Number)var9_7).intValue();
                $i$a$-takeIf-PgBaseIntrospector$parseAclItem$eq$2 = false;
                v1 = eq = it != -1 != false ? var9_7 : null;
            }
        }
        if (eq == null) {
            return null;
        }
        it = StringsKt.indexOf$default((CharSequence)item, (char)'/', (int)eq, (boolean)false, (int)4, null);
        it = ((Number)it).intValue();
        $i$a$-takeIf-PgBaseIntrospector$parseAclItem$sl$1 = false;
        v2 = it != -1 != false ? it : null;
        sl = v2 != null ? v2.intValue() : item.length();
        v3 = item.substring(so, eq);
        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"substring(...)");
        it = v3;
        $i$a$-let-PgBaseIntrospector$parseAclItem$grantee$1 = false;
        it = StringsKt.startsWith$default((CharSequence)it, (char)'\\', (boolean)false, (int)2, null) ? StringUtil.unescapeStringCharacters((String)it) : it;
        $i$a$-let-PgBaseIntrospector$parseAclItem$grantee$2 = false;
        Intrinsics.checkNotNull((Object)it);
        v4 = StringKt.nullize$default((String)ns.unquoteIdentifier(it), (boolean)false, (int)1, null);
        if (v4 == null) {
            v4 = "public";
        }
        grantee = v4;
        v5 = this.getModel().getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getRoot(...)");
        v6 = PgObjectGrantController.INSTANCE.findGranteeId((BasicElement)v5, grantee);
        granteeId = v6 != null ? v6 : -9223372036854775807L;
        v7 = item.substring(eq + 1, sl);
        Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"substring(...)");
        privilegesText = v7;
        $this$mapIndexedNotNull$iv = privilegesText;
        $i$f$mapIndexedNotNull = false;
        var16_21 = $this$mapIndexedNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapIndexedNotNullTo = false;
        $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
        $i$f$forEachIndexed = false;
        index$iv$iv$iv = 0;
        for (var22_31 = 0; var22_31 < $this$forEachIndexed$iv$iv$iv.length(); ++var22_31) {
            block13: {
                item$iv$iv$iv = $this$forEachIndexed$iv$iv$iv.charAt(var22_31);
                v8 = index$iv$iv$iv++;
                var24_33 = item$iv$iv$iv;
                index$iv$iv = v8;
                $i$a$-forEachIndexed-StringsKt___StringsKt$mapIndexedNotNullTo$1$iv$iv = false;
                var27_36 = element$iv$iv;
                i = index$iv$iv;
                $i$a$-mapIndexedNotNull-PgBaseIntrospector$parseAclItem$privileges$1 = false;
                if (c == 42) ** GOTO lbl-1000
                v9 = StringsKt.getOrNull((CharSequence)privilegesText, (int)(i + 1));
                var30_39 = '*';
                if (v9 != null && v9.charValue() == var30_39) lbl-1000:
                // 2 sources

                {
                    v10 = null;
                } else {
                    var31_40 = PgPrivilege.values();
                    var33_45 = var31_40.length;
                    for (var32_42 = 0; var32_42 < var33_45; ++var32_42) {
                        it = var34_46 = var31_40[var32_42];
                        $i$a$-find-PgBaseIntrospector$parseAclItem$privileges$1$1 = false;
                        if (!(it.getCode() == c)) continue;
                        v10 = var34_46;
                        break block13;
                    }
                    v10 = null;
                }
            }
            if (v10 == null) continue;
            it$iv$iv = v10;
            $i$a$-let-StringsKt___StringsKt$mapIndexedNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        privileges = (List)destination$iv$iv;
        $this$mapIndexedNotNull$iv = privilegesText;
        $i$f$mapIndexedNotNull = false;
        destination$iv$iv = $this$mapIndexedNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapIndexedNotNullTo = false;
        $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
        $i$f$forEachIndexed = false;
        index$iv$iv$iv = 0;
        for (var23_32 = 0; var23_32 < $this$forEachIndexed$iv$iv$iv.length(); ++var23_32) {
            block14: {
                item$iv$iv$iv = $this$forEachIndexed$iv$iv$iv.charAt(var23_32);
                v11 = index$iv$iv$iv++;
                index$iv$iv = item$iv$iv$iv;
                index$iv$iv = v11;
                $i$a$-forEachIndexed-StringsKt___StringsKt$mapIndexedNotNullTo$1$iv$iv = false;
                i = element$iv$iv;
                i = index$iv$iv;
                $i$a$-mapIndexedNotNull-PgBaseIntrospector$parseAclItem$grantablePrivileges$1 = false;
                if (c == 42) ** GOTO lbl-1000
                v12 = StringsKt.getOrNull((CharSequence)privilegesText, (int)(i + 1));
                var31_41 = '*';
                if (v12 == null || v12.charValue() != var31_41) lbl-1000:
                // 2 sources

                {
                    v13 = null;
                } else {
                    var32_44 = PgPrivilege.values();
                    var34_47 = var32_44.length;
                    for (var33_45 = 0; var33_45 < var34_47; ++var33_45) {
                        it = var35_48 = var32_44[var33_45];
                        $i$a$-find-PgBaseIntrospector$parseAclItem$grantablePrivileges$1$1 = false;
                        if (!(it.getCode() == c)) continue;
                        v13 = var35_48;
                        break block14;
                    }
                    v13 = null;
                }
            }
            if (v13 == null) continue;
            it$iv$iv = v13;
            $i$a$-let-StringsKt___StringsKt$mapIndexedNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        grantablePrivileges = (List)destination$iv$iv;
        return new PgAclItem(granteeId, privileges, grantablePrivileges);
    }

    protected final <T extends PgBaseArgument> void processArgs(@NotNull PgBaseIntroQueries.ArgumentNameHolder r, @NotNull ModPositioningNamingFamily<? extends T> family, @NotNull BasicModRoutine routine, @NotNull Function1<? super Long, ? extends DasType> getTypeByOid) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter(family, (String)"family");
        Intrinsics.checkNotNullParameter((Object)routine, (String)"routine");
        Intrinsics.checkNotNullParameter(getTypeByOid, (String)"getTypeByOid");
        NamingService namingService = NamingServices.getNamingService$default((Dbms)this.dbms, null, null, (int)6, null);
        String[] argNames = r.getArgNames();
        char[] argModes = PgBaseIntrospectorKt.stringsToChars(r.getArgModes());
        int argTypeIdsSize = r.getNArgs();
        int argNamesCount = argNames != null ? argNames.length : 0;
        int n = Math.max(Math.max(argNamesCount, argModes.length), argTypeIdsSize);
        String resultType = null;
        StringBuilder resultArguments = null;
        for (int i2 = 0; i2 < n; ++i2) {
            String string;
            ArgumentDirection direction;
            Character argMode;
            Character c;
            Character c2 = c = (argMode = ArraysKt.getOrNull((char[])argModes, (int)i2));
            char c3 = 'b';
            if (c2 != null && c2.charValue() == c3) {
                v1 = ArgumentDirection.INOUT;
            } else {
                Character c4 = c;
                c3 = 'o';
                if (c4 != null && c4.charValue() == c3) {
                    v1 = ArgumentDirection.OUT;
                } else {
                    Character c5 = c;
                    c3 = 't';
                    v1 = direction = c5 != null && c5.charValue() == c3 ? ArgumentDirection.RESULT : ArgumentDirection.IN;
                }
            }
            if (i2 < argNamesCount) {
                Intrinsics.checkNotNull((Object)argNames);
                string = argNames[i2];
            } else {
                string = null;
            }
            String argName = string;
            DasType dasType = (DasType)DasTypeSystemBase.UNKNOWN;
            if (r instanceof PgBaseIntroQueries.ArgumentHolder && i2 < argTypeIdsSize) {
                DasType dt;
                long[] lArray = ((PgBaseIntroQueries.ArgumentHolder)r).getArgTypes();
                if (lArray != null) {
                    long it = lArray[i2];
                    boolean bl = false;
                    v6 = (DasType)getTypeByOid.invoke((Object)it);
                } else {
                    v6 = dt = null;
                }
                if (dt != null) {
                    dasType = dt;
                }
            }
            if (r instanceof PgBaseIntroQueries.OneRoutine && ((PgBaseIntroQueries.OneRoutine)r).ret_set && direction == ArgumentDirection.RESULT) {
                if (resultType == null || resultArguments == null) {
                    resultType = "table";
                    resultArguments = new StringBuilder();
                } else {
                    resultArguments.append(", ");
                }
                if (argName != null) {
                    resultArguments.append(namingService.enquote(argName, ObjectKind.ARGUMENT)).append(' ');
                }
                resultArguments.append(dasType.getSpecification());
                continue;
            }
            if (direction == ArgumentDirection.RESULT) continue;
            short position = (short)(i2 + 1);
            PgBaseArgument argument = (PgBaseArgument)family.getByNaturalPosition(position);
            if (argument == null) {
                argument = (PgBaseArgument)family.createNewOne();
                ((BasicModArrangedElement)argument).setPosition(position);
            } else {
                ((BasicModMixinElement)argument).resetSyncPending();
            }
            ((BasicModMixinNamedElement)argument).setRealName(argName);
            ((BasicModArgument)argument).setArgumentDirection(direction);
            ((BasicModTypedElement)argument).setStoredType(dasType);
            this.processArgExtra(argument, argMode);
        }
        PgBaseIntroQueries.ArgumentNameHolder $this$asSafely$iv = r;
        boolean $i$f$asSafely = false;
        PgBaseIntroQueries.ArgumentNameHolder argumentNameHolder = $this$asSafely$iv;
        if (!(argumentNameHolder instanceof PgBaseIntroQueries.OneRoutine)) {
            argumentNameHolder = null;
        }
        PgBaseIntroQueries.OneRoutine oneRoutine = (PgBaseIntroQueries.OneRoutine)argumentNameHolder;
        boolean bl = oneRoutine != null ? oneRoutine.kind == 'p' : false;
        if (bl) {
            $this$asSafely$iv = routine.getReturnArgument();
            BasicModArgument basicModArgument = $this$asSafely$iv instanceof BasicModArgument ? (BasicModArgument)$this$asSafely$iv : null;
            if (basicModArgument != null) {
                basicModArgument.drop();
            }
        } else {
            BasicModArgument basicModArgument = routine.createOrGetReturnArgument();
            Intrinsics.checkNotNullExpressionValue((Object)basicModArgument, (String)"createOrGetReturnArgument(...)");
            BasicModArgument returns = basicModArgument;
            if (r instanceof PgBaseIntroQueries.ArgumentHolder) {
                if (resultType != null) {
                    StringBuilder stringBuilder = resultArguments;
                    Intrinsics.checkNotNull(stringBuilder);
                    DataType dataType = DataTypeFactory.ofArgs(null, resultType, (String)stringBuilder.toString(), (boolean)false);
                    Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"ofArgs(...)");
                    DataType resultDataType = dataType;
                    returns.setArgumentDirection(ArgumentDirection.RESULT);
                    returns.setStoredType(DasUnresolvedTypeReference.Companion.of(resultDataType));
                } else if (((PgBaseIntroQueries.ArgumentHolder)r).getReturnType() != 0L) {
                    DasType retType;
                    returns.setArgumentDirection(ArgumentDirection.RETURN);
                    DasType dasType = (DasType)getTypeByOid.invoke((Object)((PgBaseIntroQueries.ArgumentHolder)r).getReturnType());
                    if (dasType == null) {
                        dasType = retType = (DasType)DasTypeSystemBase.UNKNOWN;
                    }
                    if (((PgBaseIntroQueries.ArgumentHolder)r).getReturnsSet()) {
                        DataType dataType = DataTypeFactory.of((String)("setof " + retType.getSpecification()));
                        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
                        retType = DasUnresolvedTypeReference.Companion.of(dataType);
                    }
                    returns.setStoredType(retType);
                }
            }
            returns.setRealName(null);
            returns.setPosition((short)0);
            returns.setDefaultExpression(null);
        }
    }

    public <T extends PgBaseArgument> void processArgExtra(@NotNull T argument, @Nullable Character argMode) {
        Intrinsics.checkNotNullParameter(argument, (String)"argument");
    }

    @Nullable
    protected <S extends PgBaseSchema> PgBaseLikeStoredTable preventDuplicatedRelationForSchema(@NotNull S schema, @Nullable PgBaseLikeStoredTable newRelation, @Nullable PgBaseLikeStoredTable existing) {
        block0: {
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            PgBaseLikeStoredTable pgBaseLikeStoredTable = existing;
            if (pgBaseLikeStoredTable == null) break block0;
            pgBaseLikeStoredTable.drop();
        }
        return newRelation;
    }

    protected boolean isNameSurrogate(@NotNull BasicModColumniation columniation) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)columniation, (String)"columniation");
        BasicModColumniation basicModColumniation = columniation;
        if (basicModColumniation instanceof PgBaseKey) {
            String string = ((PgBaseKey)columniation).getName();
            DasTable dasTable = ((PgBaseKey)columniation).getTable();
            String string2 = dasTable != null ? dasTable.getName() : null;
            boolean bl2 = ((PgBaseKey)columniation).isPrimary();
            List list = ((PgBaseKey)columniation).getColNames();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getColNames(...)");
            bl = Intrinsics.areEqual((Object)string, (Object)this.surrogateKeyName(string2, bl2, list));
        } else if (basicModColumniation instanceof PgBaseForeignKey) {
            String string = ((PgBaseForeignKey)columniation).getName();
            DasTable dasTable = ((PgBaseForeignKey)columniation).getTable();
            String string3 = dasTable != null ? dasTable.getName() : null;
            List list = ((PgBaseForeignKey)columniation).getColNames();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getColNames(...)");
            bl = Intrinsics.areEqual((Object)string, (Object)(string3 + "_" + CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"_", null, null, (int)0, null, null, (int)62, null) + "_fkey"));
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    protected final String surrogateKeyName(@Nullable String tableName, boolean primary, @NotNull List<String> colNames) {
        Intrinsics.checkNotNullParameter(colNames, (String)"colNames");
        return tableName + "_" + (String)(primary ? "pkey" : CollectionsKt.joinToString$default((Iterable)colNames, (CharSequence)"_", null, null, (int)0, null, null, (int)62, null) + "_key");
    }

    protected final boolean isColumnNameSurrogate(@Nullable String it) {
        return it != null && StringsKt.startsWith$default((String)it, (String)"?", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)it, (String)"?", (boolean)false, (int)2, null);
    }

    @Nullable
    public final BasicReference createIdOrQNameRef(long id, @Nullable String name2, @Nullable String pDefault) {
        String string = name2;
        return BasicIdOrNameReference.create((BasicIdReference)BasicIdReference.create((long)PgBaseIntrospectorKt.nullizeOid(id)), string != null ? this.parseNameRef(string, pDefault) : null);
    }

    private final BasicReference parseNameRef(String $this$parseNameRef, String pDefault) {
        NamingService ns = NamingServices.getNamingService$default((Dbms)this.dbms, null, null, (int)6, null);
        Lexer lexer = this.getSqlHelper().createLexer();
        Pair pair = BasicParentReference.parseNameRef((String)$this$parseNameRef, (NamingService)ns, (Lexer)lexer);
        Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"parseNameRef(...)");
        Pair p = pair;
        String string = (String)p.first;
        if (string == null) {
            string = pDefault;
        }
        Object object = p.second;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"second");
        return BasicParentReference.create((String)string, (BasicReference)((BasicReference)BasicNameReference.create((String)ns.unquoteIdentifier((String)object))));
    }

    private static final Long2ObjectMap renameHandlingRequests$lambda$0(long it) {
        return (Long2ObjectMap)new Long2ObjectOpenHashMap();
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit introspectSpecificSessionInfo$lambda$0(PgBaseIntrospector this$0, DBTransaction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.introspectionXid = null;
        BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)this$0;
        boolean $i$f$continueOnDbError = false;
        BaseNativeIntrospector baseNativeIntrospector = this_$iv;
        Object whatsDoing$iv$iv = null;
        boolean $i$f$continueOnDbError2 = false;
        try {
            boolean bl = false;
            Long stateNumber = (Long)BaseNativeIntrospector.performQuery$default((BaseNativeIntrospector)((BaseNativeIntrospector)this$0), this$0.getQueries().stateNumber, null, (int)2, null);
            Long l = stateNumber;
            if (l == null) {
                l = this$0.getCurrentXid(it);
            }
            this$0.introspectionXid = l;
        }
        catch (DBException e$iv$iv) {
            StringBuilder stringBuilder;
            void this_$iv$iv;
            boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
            StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
            $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
            $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
            String message$iv$iv = stringBuilder.toString();
            if (expected$iv$iv) {
                this_$iv$iv.trace(message$iv$iv);
            } else {
                IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
            }
            this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
        }
        return Unit.INSTANCE;
    }

    private static final Unit postProcessDatabase$lambda$0(PgBaseIntrospector this$0, DBTransaction $tran, PgBaseLikeDatabase $database) {
        if (!((Collection)this$0.affectedKeySchemaIds).isEmpty()) {
            String signs = StringFun.replicate((String)"?", (int)this$0.affectedKeySchemaIds.size(), (String)",", (String)"null");
            SqlQuery sqlQuery = this$0.getQueries().getListReferencingSchemas().rewrite(Rewriters.replace((String)"SCHEMAIDS", (String)signs));
            Intrinsics.checkNotNullExpressionValue((Object)sqlQuery, (String)"rewrite(...)");
            SqlQuery query = sqlQuery;
            Collection $this$toTypedArray$iv = (Collection)this$0.affectedKeySchemaIds;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Long[] longArray = thisCollection$iv.toArray(new Long[0]);
            long[] referencingSchemaIds = (long[])$tran.query(query).withParams((Object[])Arrays.copyOf(longArray, longArray.length)).runOnce();
            Intrinsics.checkNotNull((Object)referencingSchemaIds);
            if (referencingSchemaIds.length == 0) {
                return Unit.INSTANCE;
            }
            this$0.getModel().modify((BasicElement)$database, PgBaseDatabase.class, new ModelModifier(referencingSchemaIds, this$0){
                final /* synthetic */ long[] $referencingSchemaIds;
                final /* synthetic */ PgBaseIntrospector<MR, D, SL> this$0;
                {
                    this.$referencingSchemaIds = $referencingSchemaIds;
                    this.this$0 = $receiver;
                }

                public final void perform(PgBaseDatabase database) {
                    for (PgBaseSchema schema : database.getSchemas()) {
                        Object object = this.$referencingSchemaIds;
                        Intrinsics.checkNotNull((Object)object);
                        if (!ArraysKt.contains((long[])object, (long)schema.getObjectId())) continue;
                        object = schema.getTables().iterator();
                        while (object.hasNext()) {
                            PgBaseForeignKey fk;
                            PgBaseRegularTable table = (PgBaseRegularTable)object.next();
                            Iterator iterator = table.getForeignKeys().iterator();
                            while (iterator.hasNext() && (fk = (PgBaseForeignKey)iterator.next()).getRefTable() != null) {
                                BasicTable refTable;
                                if (Intrinsics.areEqual((Object)schema, (Object)refTable.getSchema())) continue;
                                PgBaseModelHelper pgBaseModelHelper = this.this$0.getHelper();
                                Intrinsics.checkNotNull((Object)fk);
                                pgBaseModelHelper.resolveReference(fk, refTable);
                            }
                        }
                    }
                }
            });
        }
        return Unit.INSTANCE;
    }

    private static final Unit introspectServerObjects$lambda$0$0(long $xid, PgBaseRoot it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setIntrospectionStateNumber($xid);
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$0(PgBaseIntrospector this$0, DBTransaction $trans, IntroModeCtx $this$add) {
        Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
        this$0.retrieveSettings($trans);
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$1(PgBaseIntrospector this$0, DBTransaction $trans, IntroModeCtx $this$add) {
        Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
        this$0.retrieveTimeZones($trans);
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$2(PgBaseIntrospector this$0, DBTransaction $trans, IntroModeCtx $this$add) {
        Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
        IntroGuidance $this$steps_u24lambda_u242_u240 = $this$add.getGuidanceForOthers();
        boolean bl = false;
        this$0.retrieveComments($trans, $this$steps_u24lambda_u242_u240.getDetectDropped(), $this$steps_u24lambda_u242_u240.getLoadNew());
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$3(PgBaseIntrospector this$0, DBTransaction $trans, IntroModeCtx $this$add) {
        Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
        IntroGuidance $this$steps_u24lambda_u243_u240 = $this$add.getGuidanceForOthers();
        boolean bl = false;
        this$0.retrieveAcls($trans, $this$steps_u24lambda_u243_u240.getDetectDropped(), $this$steps_u24lambda_u243_u240.getLoadNew());
        return Unit.INSTANCE;
    }

    private static final boolean retrieveAcls$lambda$0$0$0(Grants.Controller $ctl, PgBaseRoot $r, PgObjectGrant it) {
        Grants.Grant grant = it;
        BasicElement basicElement = (BasicElement)$r;
        BasicResolveAssistant basicResolveAssistant = BasicResolveAssistant.DEFAULT;
        Intrinsics.checkNotNullExpressionValue((Object)basicResolveAssistant, (String)"DEFAULT");
        return $ctl.findTarget(grant, basicElement, basicResolveAssistant) == null;
    }

    private static final boolean retrieveAcls$lambda$0$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit retrieveAcls$lambda$0$0$3(PgBaseIntrospector this$0, Lexer $lexer, NamingService $ns, List $newGrants, PgBaseIntroQueries.OneAcl acl) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)acl, (String)"acl");
            if (acl.acl == null) break block1;
            String[] $this$forEach$iv = acl.acl;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int j = 0; j < n; ++j) {
                String element$iv;
                String it = element$iv = $this$forEach$iv[j];
                boolean bl = false;
                PgAclItem pgAclItem = this$0.parseAclItem($lexer, $ns, it);
                if (pgAclItem == null) continue;
                pgAclItem.toGrants(acl.object_id, $newGrants);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit retrieveAcls$lambda$0$0(boolean $detectDropped, boolean $loadNew, PgBaseIntrospector this$0, DBTransaction $tran, PgBaseRoot r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Grants.Controller ctl = ((PgBaseGrantsHolder)r).getGrants().getController();
        List newGrants = ((PgBaseGrantsHolder)r).getGrants().toMutableList();
        if ($detectDropped) {
            newGrants.removeIf(arg_0 -> PgBaseIntrospector.retrieveAcls$lambda$0$0$1(arg_0 -> PgBaseIntrospector.retrieveAcls$lambda$0$0$0(ctl, r, arg_0), arg_0));
        }
        if ($loadNew) {
            Long l = r.getIntrospectionStateNumber();
            long it = ((Number)l).longValue();
            boolean bl = false;
            Long tx = $detectDropped ? l : null;
            Lexer lexer = this$0.getSqlHelper().createLexer();
            NamingService ns = NamingServices.getNamingService$default((Dbms)this$0.dbms, (BasicModel)((BasicModel)this$0.getModel()), null, (int)4, null);
            this$0.getQueries().processObjectAcls($tran, r, tx, this$0.noDbXmin, (Function1<? super PgBaseIntroQueries.OneAcl, Unit>)((Function1)arg_0 -> PgBaseIntrospector.retrieveAcls$lambda$0$0$3(this$0, lexer, ns, newGrants, arg_0)));
        }
        ((PgBaseGrantsHolder)r).setGrants((Grants<PgObjectGrant>)((PgBaseGrantsHolder)r).getGrants().with((Iterable)newGrants));
        return Unit.INSTANCE;
    }

    private static final Unit retrieveSettings$lambda$0$0(PgBaseIntrospector this$0, String $dateStyle, PgBaseRoot root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        root.setDateStyle(this$0.parseDateStyle($dateStyle));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit retrieveTimeZones$lambda$0$2(List $zones, PgBaseRoot root) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Iterable iterable = $zones;
        PgBaseRoot pgBaseRoot = root;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var5_6 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            PgTimeZone pgTimeZone = (PgTimeZone)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            PgTimeZone it = (PgTimeZone)element$iv$iv;
            String string = StringUtil.toLowerCase((String)it.getName());
            boolean bl2 = false;
            PgTimeZone pgTimeZone2 = new PgTimeZone(it.getName(), it.isDST());
            map.put(string, pgTimeZone2);
        }
        pgBaseRoot.setTimeZones(destination$iv$iv);
        return Unit.INSTANCE;
    }

    private static final Iterable introspectDatabaseSchemas$lambda$0(PgBaseIntrospector this$0, BasicDatabase[] $databases, DBTransaction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.getDatabasesToIntrospect(it, ArraysKt.toList((Object[])$databases));
    }

    private static final CharSequence checkElementsUptodate$lambda$1$0(Long it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return String.valueOf(it);
    }

    private static final String checkElementsUptodate$lambda$1(LinkedHashMap $ids, String s) {
        Intrinsics.checkNotNull((Object)s);
        Set set = $ids.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        return StringsKt.replace$default((String)s, (String)"OIDS", (String)CollectionsKt.joinToString$default((Iterable)set, null, null, null, (int)0, null, PgBaseIntrospector::checkElementsUptodate$lambda$1$0, (int)31, null), (boolean)false, (int)4, null);
    }

    private static final Unit checkElementsUptodate$lambda$2(LinkedHashMap $res, Long l, PgBaseCatalogObject v) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        ((Map)$res).put(v, false);
        return Unit.INSTANCE;
    }

    private static final void checkElementsUptodate$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit checkElementsUptodate$lambda$5(LinkedHashMap $res, PgBaseRoot it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Set set = $res.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)entry);
            Object k = entry.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
            BasicElement obj = (BasicElement)k;
            Object v = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"component2(...)");
            Boolean ok = (Boolean)v;
            Intrinsics.checkNotNull((Object)obj, (String)"null cannot be cast to non-null type com.intellij.database.model.basic.BasicModElement");
            ((BasicModElement)obj).setOutdated(ok == false);
        }
        return Unit.INSTANCE;
    }

    private static final BasicSchema introspectElevation$lambda$0(SchemaLevel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getSchema();
    }

    private static final PgBaseLikeSchema introspectElevation$lambda$1(PgBaseLikeSchema it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector$Companion;", "", "<init>", "()V", "FROZEN_TXID", "", "intellij.database.dialects.postgresbase"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\b\u0094\u0004\u0018\u0000*\b\b\u0003\u0010\u0001*\u00020\u00022\u001e\u0012\u0004\u0012\u0002H\u00010\u0003R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u0006\u0010\u0012\u001a\u00020\u000eJ\b\u0010\u0013\u001a\u00020\u000eH\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\b\u0010\u0019\u001a\u00020\u000eH\u0002J\b\u0010\u001a\u001a\u00020\u0010H\u0014J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0014J\u0018\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0014J\u0018\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0014J)\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00028\u00032\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&H\u0014\u00a2\u0006\u0002\u0010'J\u0018\u0010(\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0014J\u0018\u0010)\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0014J\b\u0010*\u001a\u00020\u000eH\u0016J\u0012\u0010+\u001a\u00020\u00102\b\u0010,\u001a\u0004\u0018\u00010\fH\u0002R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector$DatabaseRetriever;", "D", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseDatabase;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$BaseDatabaseRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;", "tran", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "<init>", "(Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/postgresbase/model/PgBaseDatabase;)V", "myFrozen", "", "", "retrieveAcls", "", "detectDropped", "", "loadNew", "retrieveAuxiliaryObjects", "beforeServerAndDatabaseObjectsRetrieval", "getDatabaseIntrospectionMode", "Lcom/intellij/database/introspection/IntrospectionMode;", "removeDroppedDatabaseComments", "ids", "Lit/unimi/dsi/fastutil/longs/LongSet;", "introspectDatabase", "loadNewIntrospectDatabase", "steps", "", "Lcom/intellij/database/dialects/postgresbase/introspector/IntroStep;", "introspectDatabaseObjects", "introspectComments", "findObjectById", "Lcom/intellij/database/model/basic/BasicModNamedElement;", "db", "kind", "", "id", "", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseDatabase;Ljava/lang/Character;J)Lcom/intellij/database/model/basic/BasicModNamedElement;", "retrieveLanguages", "retrieveCasts", "retrieveSchemas", "isSystem", "name", "intellij.database.dialects.postgresbase"})
    @SourceDebugExtension(value={"SMAP\nPgBaseIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PgBaseIntrospector.kt\ncom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector$DatabaseRetriever\n+ 2 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n+ 7 ModelFun.kt\ncom/intellij/database/model/ModelFun\n*L\n1#1,1881:1\n521#2:1882\n502#2,2:1883\n505#2,15:1886\n521#2:1901\n502#2,18:1902\n521#2:1928\n502#2,2:1929\n505#2,15:1933\n521#2:1955\n502#2,2:1956\n505#2,15:1960\n1#3:1885\n14060#4,2:1920\n14088#4,2:1931\n14088#4,2:1958\n1915#5,2:1922\n1915#5:1980\n1916#5:1983\n179#6,4:1924\n183#6,3:1948\n179#6,4:1951\n183#6,3:1975\n460#7,2:1978\n462#7,2:1981\n464#7,3:1984\n*S KotlinDebug\n*F\n+ 1 PgBaseIntrospector.kt\ncom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector$DatabaseRetriever\n*L\n350#1:1882\n350#1:1883,2\n350#1:1886,15\n416#1:1901\n416#1:1902,18\n445#1:1928\n445#1:1929,2\n445#1:1933,15\n475#1:1955\n475#1:1956,2\n475#1:1960,15\n362#1:1920,2\n447#1:1931,2\n477#1:1958,2\n387#1:1922,2\n512#1:1980\n512#1:1983\n444#1:1924,4\n444#1:1948,3\n474#1:1951,4\n474#1:1975,3\n512#1:1978,2\n512#1:1981,2\n512#1:1984,3\n*E\n"})
    protected static class DatabaseRetriever<D extends PgBaseDatabase>
    extends BaseMultiDatabaseIntrospector.BaseDatabaseRetriever<D> {
        @NotNull
        private final Set<String> myFrozen;
        final /* synthetic */ PgBaseIntrospector<MR, D, SL> this$0;

        public DatabaseRetriever(@NotNull DBTransaction tran, D database) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter(database, (String)"database");
            this.this$0 = this$0;
            super((BaseMultiDatabaseIntrospector)this$0, tran, (BasicModMateDatabase)database);
            this.myFrozen = new HashSet();
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveAcls(boolean detectDropped, boolean loadNew) {
            void this_$iv;
            this.this$0.reportRetrieving("ACL", "introspection.retrieve.ACL");
            BaseNativeIntrospector baseNativeIntrospector = (BaseNativeIntrospector)this.this$0;
            PgBaseIntrospector pgBaseIntrospector = this.this$0;
            boolean $i$f$continueOnDbError = false;
            void var6_6 = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl = false;
                Grants.Controller ctl = ((PgBaseGrantsHolder)this.getDatabase()).getGrants().getController();
                List newGrants = ((PgBaseGrantsHolder)this.getDatabase()).getGrants().toMutableList();
                if (detectDropped) {
                    newGrants.removeIf(arg_0 -> DatabaseRetriever.retrieveAcls$lambda$0$1(arg_0 -> DatabaseRetriever.retrieveAcls$lambda$0$0(ctl, this, arg_0), arg_0));
                }
                if (loadNew) {
                    Long l = ((PgBaseDatabase)this.getDatabase()).getIntrospectionStateNumber();
                    long it = ((Number)l).longValue();
                    boolean bl2 = false;
                    Long tx = detectDropped ? l : null;
                    Lexer lexer = pgBaseIntrospector.getSqlHelper().createLexer();
                    NamingService ns = NamingServices.getNamingService((Dbms)pgBaseIntrospector.dbms, (BasicModel)((BasicModel)this.getModel()), (BasicDatabase)((BasicDatabase)this.getDatabase()));
                    pgBaseIntrospector.getQueries().processObjectAcls(this.getTransaction(), (PgBaseDatabase)this.getDatabase(), tx, (Function1<? super PgBaseIntroQueries.OneAcl, Unit>)((Function1)arg_0 -> DatabaseRetriever.retrieveAcls$lambda$0$3(newGrants, pgBaseIntrospector, lexer, ns, arg_0)));
                }
                ((PgBaseGrantsHolder)this.getDatabase()).setGrants((Grants<PgObjectGrant>)((PgBaseGrantsHolder)this.getDatabase()).getGrants().with((Iterable)newGrants));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
        }

        public final void retrieveAuxiliaryObjects() {
            block0: {
                super.retrieveAuxiliaryObjects();
                this.introspectDatabase();
                Long l = this.this$0.getIntrospectionXid();
                if (l == null) break block0;
                long xid = ((Number)l).longValue();
                boolean bl = false;
                this.inDatabase(arg_0 -> DatabaseRetriever.retrieveAuxiliaryObjects$lambda$0$0(xid, arg_0));
            }
        }

        protected void beforeServerAndDatabaseObjectsRetrieval() {
            IntrospectionMode mode = this.getDatabaseIntrospectionMode();
            this.this$0.setTx((IntrospectionQueryContext)this, ((PgBaseDatabase)this.getDatabase()).getIntrospectionStateNumber(), "tx", "TXAGE");
            String string = IntrospectionMode.INCREMENT.code;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"code");
            this.setQueryParameter(string, mode.increment);
        }

        private final IntrospectionMode getDatabaseIntrospectionMode() {
            return ((PgBaseDatabase)this.getDatabase()).getIntrospectionStateNumber() != 0L && !this.this$0.getForbidIncremental() ? IntrospectionMode.INCREMENT : IntrospectionMode.FULL;
        }

        protected void removeDroppedDatabaseComments(@NotNull LongSet ids) {
            Intrinsics.checkNotNullParameter((Object)ids, (String)"ids");
            this.inDatabase(arg_0 -> DatabaseRetriever.removeDroppedDatabaseComments$lambda$0(ids, arg_0));
        }

        private final void introspectDatabase() {
            IntrospectionMode mode = this.getDatabaseIntrospectionMode();
            boolean detectDropped = mode.increment;
            boolean loadNew = mode.full || this.loadNewIntrospectDatabase();
            this.introspectDatabaseObjects(detectDropped, loadNew);
        }

        protected boolean loadNewIntrospectDatabase() {
            Long l = this.this$0.getIntrospectionXid();
            long l2 = ((PgBaseDatabase)this.getDatabase()).getIntrospectionStateNumber();
            return l == null || l != l2;
        }

        @NotNull
        protected List<IntroStep> steps() {
            return PgBaseIntrospectorKt.add$default(PgBaseIntrospectorKt.add$default(PgBaseIntrospectorKt.add$default(PgBaseIntrospectorKt.add$default(new ArrayList(), 10, null, null, arg_0 -> DatabaseRetriever.steps$lambda$0(this, arg_0), 6, null), 20, null, null, arg_0 -> DatabaseRetriever.steps$lambda$1(this, arg_0), 6, null), 30, null, null, arg_0 -> DatabaseRetriever.steps$lambda$2(this, arg_0), 6, null), 40, null, null, arg_0 -> DatabaseRetriever.steps$lambda$3(this, arg_0), 6, null);
        }

        protected void introspectDatabaseObjects(boolean detectDropped, boolean loadNew) {
            List<IntroStep> steps = this.steps();
            CollectionsKt.sort(steps);
            for (IntroStep step : steps) {
                step.getPerform().invoke((Object)new IntroModeCtx.Raw(detectDropped, detectDropped, loadNew));
            }
        }

        /*
         * WARNING - void declaration
         */
        protected void introspectComments(boolean detectDropped, boolean loadNew) {
            void this_$iv;
            this.this$0.reportRetrieving("comments", "introspection.retrieve.comments");
            BaseNativeIntrospector baseNativeIntrospector = (BaseNativeIntrospector)this.this$0;
            PgBaseIntrospector pgBaseIntrospector = this.this$0;
            boolean $i$f$continueOnDbError = false;
            void var6_6 = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl = false;
                LongOpenHashSet commentsIds = detectDropped ? new LongOpenHashSet((long[])this.performQuery(pgBaseIntrospector.getQueries().getListExistentDatabaseComments())) : new LongOpenHashSet();
                this.removeDroppedDatabaseComments((LongSet)commentsIds);
                if (loadNew) {
                    this.inDatabase(arg_0 -> DatabaseRetriever.introspectComments$lambda$0$0(this, pgBaseIntrospector, arg_0));
                }
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
        }

        @Nullable
        protected BasicModNamedElement findObjectById(@NotNull D db, @Nullable Character kind, long id) {
            Object object;
            Character c;
            Intrinsics.checkNotNullParameter(db, (String)"db");
            Character c2 = c = kind;
            char c3 = 'L';
            if (c2 != null && c2.charValue() == c3) {
                object = (BasicModNamedElement)db.getLanguages().getByObjectId(id);
            } else {
                Character c4 = c;
                c3 = 'C';
                object = c4 != null && c4.charValue() == c3 ? (BasicModNamedElement)db.getCasts().getByObjectId(id) : null;
            }
            return object;
        }

        protected void retrieveLanguages(boolean detectDropped, boolean loadNew) {
            this.inDatabase(arg_0 -> DatabaseRetriever.retrieveLanguages$lambda$0(this.this$0, detectDropped, this, loadNew, arg_0));
        }

        protected void retrieveCasts(boolean detectDropped, boolean loadNew) {
            ObjectKind objectKind = ObjectKind.CAST;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"CAST");
            this.this$0.reportRetrieving(objectKind);
            this.inDatabase(arg_0 -> DatabaseRetriever.retrieveCasts$lambda$0(this.this$0, detectDropped, this, loadNew, arg_0));
        }

        public void retrieveSchemas() {
            super.retrieveSchemas();
            if (!Intrinsics.areEqual((Object)((PgBaseDatabase)this.getDatabase()).getName(), (Object)((PgBaseIntrospector)this.this$0).getDbConnectionInfo().databaseName)) {
                return;
            }
            List scs = (List)this.performQuery(this.this$0.getQueries().getListSchemas());
            this.inDatabase(arg_0 -> DatabaseRetriever.retrieveSchemas$lambda$0(scs, this.this$0, this, arg_0));
        }

        private final boolean isSystem(String name2) {
            return name2 != null && (StringsKt.startsWith$default((String)name2, (String)"pg_temp", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name2, (String)"pg_toast", (boolean)false, (int)2, null));
        }

        private static final boolean retrieveAcls$lambda$0$3$0(PgBaseIntroQueries.OneAcl $acl, PgObjectGrant it) {
            return it.getObjectId() == $acl.object_id;
        }

        private static final boolean retrieveAcls$lambda$0$3$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean retrieveAcls$lambda$0$0(Grants.Controller $ctl, DatabaseRetriever this$0, PgObjectGrant it) {
            Grants.Grant grant = it;
            BasicElement basicElement = (BasicElement)this$0.getDatabase();
            BasicResolveAssistant basicResolveAssistant = BasicResolveAssistant.DEFAULT;
            Intrinsics.checkNotNullExpressionValue((Object)basicResolveAssistant, (String)"DEFAULT");
            return $ctl.findTarget(grant, basicElement, basicResolveAssistant) == null;
        }

        private static final boolean retrieveAcls$lambda$0$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final Unit retrieveAcls$lambda$0$3(List $newGrants, PgBaseIntrospector this$0, Lexer $lexer, NamingService $ns, PgBaseIntroQueries.OneAcl acl) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)acl, (String)"acl");
                $newGrants.removeIf(arg_0 -> DatabaseRetriever.retrieveAcls$lambda$0$3$1(arg_0 -> DatabaseRetriever.retrieveAcls$lambda$0$3$0(acl, arg_0), arg_0));
                if (acl.acl == null) break block1;
                String[] $this$forEach$iv = acl.acl;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int j = 0; j < n; ++j) {
                    String element$iv;
                    String it = element$iv = $this$forEach$iv[j];
                    boolean bl = false;
                    PgAclItem pgAclItem = this$0.parseAclItem($lexer, $ns, it);
                    if (pgAclItem == null) continue;
                    pgAclItem.toGrants(acl.object_id, $newGrants);
                }
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveAuxiliaryObjects$lambda$0$0(long $xid, PgBaseDatabase it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            it.setIntrospectionStateNumber($xid);
            return Unit.INSTANCE;
        }

        private static final Unit removeDroppedDatabaseComments$lambda$0(LongSet $ids, PgBaseDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            ModNamingIdentifyingFamily<? extends PgBaseLanguage> modNamingIdentifyingFamily = db.getLanguages();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getLanguages(...)");
            Iterable $this$forEach$iv = (Iterable)modNamingIdentifyingFamily;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PgBaseLanguage it = (PgBaseLanguage)element$iv;
                boolean bl = false;
                if ($ids.contains(it.getObjectId())) continue;
                it.setComment(null);
            }
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$0(DatabaseRetriever this$0, IntroModeCtx $this$add) {
            Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
            IntroGuidance $this$steps_u24lambda_u240_u240 = $this$add.getGuidanceForOthers();
            boolean bl = false;
            this$0.retrieveLanguages($this$steps_u24lambda_u240_u240.getDetectDropped(), $this$steps_u24lambda_u240_u240.getLoadNew());
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$1(DatabaseRetriever this$0, IntroModeCtx $this$add) {
            Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
            IntroGuidance $this$steps_u24lambda_u241_u240 = $this$add.getGuidanceForOthers();
            boolean bl = false;
            this$0.introspectComments($this$steps_u24lambda_u241_u240.getDetectDropped(), $this$steps_u24lambda_u241_u240.getLoadNew());
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$2(DatabaseRetriever this$0, IntroModeCtx $this$add) {
            Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
            IntroGuidance $this$steps_u24lambda_u242_u240 = $this$add.getGuidanceForOthers();
            boolean bl = false;
            this$0.retrieveAcls($this$steps_u24lambda_u242_u240.getDetectDropped(), $this$steps_u24lambda_u242_u240.getLoadNew());
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$3(DatabaseRetriever this$0, IntroModeCtx $this$add) {
            Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
            IntroGuidance $this$steps_u24lambda_u243_u240 = $this$add.getGuidanceForOthers();
            boolean bl = false;
            this$0.retrieveCasts($this$steps_u24lambda_u243_u240.getDetectDropped(), $this$steps_u24lambda_u243_u240.getLoadNew());
            return Unit.INSTANCE;
        }

        private static final Unit introspectComments$lambda$0$0$0(DatabaseRetriever this$0, PgBaseDatabase $db, PgBaseIntroQueries.OneComment it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            BasicModNamedElement basicModNamedElement = this$0.findObjectById($db, it.kind, it.id);
            if (basicModNamedElement == null) {
                return Unit.INSTANCE;
            }
            BasicModNamedElement obj = basicModNamedElement;
            obj.setComment(it.description);
            return Unit.INSTANCE;
        }

        private static final Unit introspectComments$lambda$0$0(DatabaseRetriever this$0, PgBaseIntrospector this$1, PgBaseDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default((BaseNativeIntrospector.AbstractRetriever)((BaseNativeIntrospector.AbstractRetriever)this$0), this$1.getQueries().getRetrieveDatabaseComments(), (int)0, arg_0 -> DatabaseRetriever.introspectComments$lambda$0$0$0(this$0, db, arg_0), (int)2, null);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveLanguages$lambda$0$0$0$1(ModNamingIdentifyingFamily $languages, PgBaseIntroQueries.OneLanguage it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            BasicModNamedElement basicModNamedElement = $languages.renew(it.id, it.name);
            Intrinsics.checkNotNullExpressionValue((Object)basicModNamedElement, (String)"renew(...)");
            BasicModNamedElement basicModNamedElement2 = basicModNamedElement;
            PgBaseLanguage $this$retrieveLanguages_u24lambda_u240_u240_u240_u241_u240 = (PgBaseLanguage)basicModNamedElement2;
            boolean bl = false;
            $this$retrieveLanguages_u24lambda_u240_u240_u240_u241_u240.setStateNumber(it.state_number);
            $this$retrieveLanguages_u24lambda_u240_u240_u240_u241_u240.setTrusted(it.trusted);
            $this$retrieveLanguages_u24lambda_u240_u240_u240_u241_u240.setHandlerName(it.handler);
            $this$retrieveLanguages_u24lambda_u240_u240_u240_u241_u240.setHandlerSchema(it.handlerSchema);
            $this$retrieveLanguages_u24lambda_u240_u240_u240_u241_u240.setInlineHandlerName(it.inline);
            $this$retrieveLanguages_u24lambda_u240_u240_u240_u241_u240.setInlineHandlerSchema(it.inlineSchema);
            $this$retrieveLanguages_u24lambda_u240_u240_u240_u241_u240.setValidatorName(it.validator);
            $this$retrieveLanguages_u24lambda_u240_u240_u240_u241_u240.setValidatorSchema(it.validatorSchema);
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveLanguages$lambda$0(PgBaseIntrospector this$0, boolean $detectDropped, DatabaseRetriever this$1, boolean $loadNew, PgBaseDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            ModFamily $this$modifyAndCleanup_u24default$iv = (ModFamily)db.getLanguages();
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingIdentifyingFamily languages = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)this$0;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl2 = false;
                if ($detectDropped) {
                    long[] $this$forEach$iv = (long[])this$1.performQuery(this$0.getQueries().getListExistentLanguages());
                    boolean $i$f$forEach = false;
                    int n = $this$forEach$iv.length;
                    for (int j = 0; j < n; ++j) {
                        long element$iv;
                        long it = element$iv = $this$forEach$iv[j];
                        boolean bl3 = false;
                        PgBaseLanguage pgBaseLanguage = (PgBaseLanguage)languages.getByObjectId(it);
                        if (pgBaseLanguage != null) {
                            ((BasicModMixinElement)pgBaseLanguage).resetSyncPending();
                        }
                    }
                }
                if ($loadNew) {
                    BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default((BaseNativeIntrospector.AbstractRetriever)((BaseNativeIntrospector.AbstractRetriever)this$1), this$0.getQueries().getListLanguages(), (int)0, arg_0 -> DatabaseRetriever.retrieveLanguages$lambda$0$0$0$1(languages, arg_0), (int)2, null);
                }
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl4 = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
            return Unit.INSTANCE;
        }

        private static final Unit retrieveCasts$lambda$0$0$0$1(ModNamingIdentifyingFamily $casts, PgBaseIntrospector this$0, PgBaseIntroQueries.OneCast m) {
            Intrinsics.checkNotNullParameter((Object)m, (String)"m");
            BasicModElement basicModElement = $casts.createOrGet(m.oid);
            Intrinsics.checkNotNullExpressionValue((Object)basicModElement, (String)"createOrGet(...)");
            PgBaseCast cast = (PgBaseCast)basicModElement;
            cast.setStateNumber(m.state_number);
            cast.setSourceTypeRef(this$0.createIdOrQNameRef(m.castsource_id, m.castsource_name, ((PgBaseIntrospector)this$0).getDbConnectionInfo().schemaName));
            cast.setTargetTypeRef(this$0.createIdOrQNameRef(m.casttarget_id, m.casttarget_name, ((PgBaseIntrospector)this$0).getDbConnectionInfo().schemaName));
            cast.setCastFunctionRef(this$0.createIdOrQNameRef(m.castfunc_id, m.castfunc_name, ((PgBaseIntrospector)this$0).getDbConnectionInfo().schemaName));
            cast.setMethod(switch (m.castmethod) {
                case 'f' -> PgCastMethod.FUNCTION;
                case 'i' -> PgCastMethod.IO;
                case 'b' -> PgCastMethod.BINARY;
                default -> null;
            });
            cast.setContext(switch (m.castcontext) {
                case 'e' -> PgCastContext.EXPLICIT;
                case 'a' -> PgCastContext.ASSIGNMENT;
                case 'i' -> PgCastContext.IMPLICIT;
                default -> null;
            });
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveCasts$lambda$0(PgBaseIntrospector this$0, boolean $detectDropped, DatabaseRetriever this$1, boolean $loadNew, PgBaseDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            ModFamily $this$modifyAndCleanup_u24default$iv = (ModFamily)db.getCasts();
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingIdentifyingFamily casts = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)this$0;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl2 = false;
                if ($detectDropped) {
                    long[] $this$forEach$iv = (long[])this$1.performQuery(this$0.getQueries().getListExistentCasts());
                    boolean $i$f$forEach = false;
                    int n = $this$forEach$iv.length;
                    for (int j = 0; j < n; ++j) {
                        long element$iv;
                        long it = element$iv = $this$forEach$iv[j];
                        boolean bl3 = false;
                        PgBaseCast pgBaseCast = (PgBaseCast)casts.getByObjectId(it);
                        if (pgBaseCast != null) {
                            ((BasicModMixinElement)pgBaseCast).resetSyncPending();
                        }
                    }
                }
                if ($loadNew) {
                    BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default((BaseNativeIntrospector.AbstractRetriever)((BaseNativeIntrospector.AbstractRetriever)this$1), this$0.getQueries().getListCasts(), (int)0, arg_0 -> DatabaseRetriever.retrieveCasts$lambda$0$0$0$1(casts, this$0, arg_0), (int)2, null);
                }
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl4 = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveSchemas$lambda$0(List $scs, PgBaseIntrospector this$0, DatabaseRetriever this$1, PgBaseDatabase db) {
            void $this$applySchemasImpl$iv;
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            ModNamingIdentifyingFamily<? extends PgBaseSchema> modNamingIdentifyingFamily = db.getSchemas();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getSchemas(...)");
            ModNamingFamily modNamingFamily = (ModNamingFamily)modNamingIdentifyingFamily;
            List scs$iv = $scs;
            boolean $i$f$applySchemasImpl = false;
            $this$applySchemasImpl$iv.markChildrenAsSyncPending();
            Iterable $this$forEach$iv$iv = scs$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv.iterator();
            while (iterator.hasNext()) {
                BasicModNamedElement basicModNamedElement;
                void sc;
                Object element$iv$iv;
                Object sc$iv = element$iv$iv = iterator.next();
                boolean bl = false;
                PgBaseIntroQueries.IdNameCommentOwner idNameCommentOwner = (PgBaseIntroQueries.IdNameCommentOwner)sc$iv;
                void $this$retrieveSchemas_u24lambda_u240_u240 = $this$applySchemasImpl$iv;
                boolean bl2 = false;
                if (!this$0.getShowSystemScs() && this$1.isSystem(sc.name)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)db.getSchemas().renew(sc.id, sc.name), (String)"renew(...)");
                PgBaseSchema $this$retrieveSchemas_u24lambda_u240_u240_u240 = (PgBaseSchema)basicModNamedElement;
                boolean bl3 = false;
                $this$retrieveSchemas_u24lambda_u240_u240_u240.setStateNumber(sc.state_number);
                $this$retrieveSchemas_u24lambda_u240_u240_u240.setComment(sc.description);
                $this$retrieveSchemas_u24lambda_u240_u240_u240.setOwnerRef((BasicReference)BasicNameReference.create((String)sc.getOwnerName()));
                PgBaseIntroQueries.IdNameCommentOwner idNameCommentOwner2 = (PgBaseIntroQueries.IdNameCommentOwner)CollectionsKt.firstOrNull((List)$scs);
                $this$retrieveSchemas_u24lambda_u240_u240_u240.setCurrent(idNameCommentOwner2 != null ? idNameCommentOwner2.id == $this$retrieveSchemas_u24lambda_u240_u240_u240.getObjectId() : false);
            }
            $this$applySchemasImpl$iv.removeSyncPendingChildren();
            $this$applySchemasImpl$iv.sort();
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0094\u0004\u0018\u0000*\b\b\u0003\u0010\u0001*\u00020\u00022\u001e\u0012\u0004\u0012\u0002H\u00010\u0003R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0003\u00a2\u0006\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector$NativeRetriever;", "D", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeDatabase;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$BaseNativeRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;", "tran", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "<init>", "(Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeDatabase;)V", "intellij.database.dialects.postgresbase"})
    protected static class NativeRetriever<D extends PgBaseLikeDatabase>
    extends BaseMultiDatabaseIntrospector.BaseNativeRetriever<D> {
        final /* synthetic */ PgBaseIntrospector<MR, D, SL> this$0;

        public NativeRetriever(@NotNull DBTransaction tran, D database) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter(database, (String)"database");
            this.this$0 = this$0;
            super((BaseMultiDatabaseIntrospector)this$0, tran, (BasicModMateDatabase)database);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u00d6\u0081\u0004J\n\u0010\u0012\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector$RenameInfo;", "", "oldName", "", "newName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getOldName", "()Ljava/lang/String;", "getNewName", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.database.dialects.postgresbase"})
    public static final class RenameInfo {
        @NotNull
        private final String oldName;
        @NotNull
        private final String newName;

        public RenameInfo(@NotNull String oldName, @NotNull String newName) {
            Intrinsics.checkNotNullParameter((Object)oldName, (String)"oldName");
            Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
            this.oldName = oldName;
            this.newName = newName;
        }

        @NotNull
        public final String getOldName() {
            return this.oldName;
        }

        @NotNull
        public final String getNewName() {
            return this.newName;
        }

        @NotNull
        public final String component1() {
            return this.oldName;
        }

        @NotNull
        public final String component2() {
            return this.newName;
        }

        @NotNull
        public final RenameInfo copy(@NotNull String oldName, @NotNull String newName) {
            Intrinsics.checkNotNullParameter((Object)oldName, (String)"oldName");
            Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
            return new RenameInfo(oldName, newName);
        }

        public static /* synthetic */ RenameInfo copy$default(RenameInfo renameInfo, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = renameInfo.oldName;
            }
            if ((n & 2) != 0) {
                string2 = renameInfo.newName;
            }
            return renameInfo.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "RenameInfo(oldName=" + this.oldName + ", newName=" + this.newName + ")";
        }

        public int hashCode() {
            int result = this.oldName.hashCode();
            result = result * 31 + this.newName.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RenameInfo)) {
                return false;
            }
            RenameInfo renameInfo = (RenameInfo)other;
            if (!Intrinsics.areEqual((Object)this.oldName, (Object)renameInfo.oldName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.newName, (Object)renameInfo.newName);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00ec\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\f\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010&\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00a4\u0004\u0018\u0000*\b\b\u0003\u0010\u0001*\u00020\u00022\u001e\u0012\u0004\u0012\u0002H\u00010\u0003R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004B\u0019\b\u0014\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\u001c\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u001e\u0018\u00010\u001dH\u0004\u00a2\u0006\u0002\u0010\u001fJ\"\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000b2\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u000bH\u0016J%\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00028\u00032\u0006\u0010(\u001a\u00020)H\u0014\u00a2\u0006\u0002\u0010*J\b\u0010+\u001a\u00020!H\u0014J\b\u0010,\u001a\u00020!H\u0014J#\u0010-\u001a\u00020!2\u0006\u0010.\u001a\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0016\u00a2\u0006\u0002\u00101J\b\u00102\u001a\u00020!H\u0004J\u0006\u00103\u001a\u00020!J\b\u00104\u001a\u00020!H\u0016J\b\u00105\u001a\u00020!H\u0014J(\u00106\u001a\u00020!2\u0012\u00107\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002090\u001d082\n\b\u0002\u0010.\u001a\u0004\u0018\u00010/H\u0002J\u0014\u0010:\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002090\u001d08H$J$\u0010;\u001a\u00020!2\u0012\u00107\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002090\u001d082\u0006\u0010<\u001a\u00020=H\u0014J#\u0010>\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020=0?0\u001d2\u0006\u0010\u0007\u001a\u00028\u0003H\u0014\u00a2\u0006\u0002\u0010@J\b\u0010A\u001a\u00020!H\u0014J\b\u0010B\u001a\u00020!H\u0014J\b\u0010C\u001a\u00020\u000bH\u0014J\b\u0010D\u001a\u00020\u000bH\u0014J\u000e\u0010I\u001a\b\u0012\u0004\u0012\u00020K0JH\u0014J \u0010L\u001a\u00020!2\u0006\u0010M\u001a\u00020\u000b2\u0006\u0010N\u001a\u00020\u000b2\u0006\u0010O\u001a\u00020\u000bH\u0002J\u0016\u0010P\u001a\u00020!2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020R0JH\u0002J \u0010S\u001a\u00020!*\b\u0012\u0004\u0012\u00020U0T2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020R0JH\u0002J<\u0010S\u001a\u00020!*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020W\u0012\u0004\u0012\u00020X0V0T2\u0006\u0010Y\u001a\u00020\u000e2\u0006\u0010Z\u001a\u00020\u000e2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020R0JH\u0002J \u0010[\u001a\u00020!2\u0006\u0010M\u001a\u00020\u000b2\u0006\u0010N\u001a\u00020\u000b2\u0006\u0010O\u001a\u00020\u000bH\u0014J%\u0010\\\u001a\u00020!2\u0006\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020`2\u0006\u0010\u0007\u001a\u00028\u0003H\u0014\u00a2\u0006\u0002\u0010aJ \u0010b\u001a\u00020!2\u0006\u0010M\u001a\u00020\u000b2\u0006\u0010N\u001a\u00020\u000b2\u0006\u0010O\u001a\u00020\u000bH\u0002J#\u0010c\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020e0d0\u001d2\u0006\u0010f\u001a\u00028\u0003H\u0014\u00a2\u0006\u0002\u0010gJ\u0015\u0010h\u001a\u00020!2\u0006\u0010\u0007\u001a\u00028\u0003H\u0014\u00a2\u0006\u0002\u0010iJ\u001d\u0010j\u001a\u00020!2\u0006\u0010\u0007\u001a\u00028\u00032\u0006\u0010k\u001a\u00020lH\u0004\u00a2\u0006\u0002\u0010mJ%\u0010j\u001a\u00020!2\u0006\u0010n\u001a\u00020e2\u0006\u0010\u0007\u001a\u00028\u00032\u0006\u0010o\u001a\u00020lH\u0014\u00a2\u0006\u0002\u0010pJ/\u0010q\u001a\u0004\u0018\u00010e2\u0006\u0010\u0007\u001a\u00028\u00032\u0006\u0010r\u001a\u00020s2\u0006\u0010Y\u001a\u00020\u000e2\u0006\u0010t\u001a\u00020\u001eH\u0002\u00a2\u0006\u0002\u0010uJ/\u0010v\u001a\u0004\u0018\u00010e2\u0006\u0010\u0007\u001a\u00028\u00032\u0006\u0010r\u001a\u00020s2\u0006\u0010Y\u001a\u00020\u000e2\u0006\u0010t\u001a\u00020\u001eH\u0014\u00a2\u0006\u0002\u0010uJ\u0010\u0010w\u001a\u00020\u000b2\u0006\u0010x\u001a\u00020sH\u0014J\b\u0010y\u001a\u00020!H\u0014J\b\u0010z\u001a\u00020!H\u0014J \u0010{\u001a\u00020!2\u0006\u0010M\u001a\u00020\u000b2\u0006\u0010N\u001a\u00020\u000b2\u0006\u0010O\u001a\u00020\u000bH\u0014J\u001e\u0010|\u001a\u00020}2\u0006\u0010\u0007\u001a\u00028\u00032\u0006\u0010~\u001a\u00020\u007fH\u0014\u00a2\u0006\u0003\u0010\u0080\u0001J!\u0010\u0081\u0001\u001a\u00020!2\u0006\u0010M\u001a\u00020\u000b2\u0006\u0010N\u001a\u00020\u000b2\u0006\u0010O\u001a\u00020\u000bH\u0014J\u001d\u0010\u0082\u0001\u001a\u00020!2\b\u0010\u0083\u0001\u001a\u00030\u0084\u00012\b\u0010\u0085\u0001\u001a\u00030\u0086\u0001H\u0014J!\u0010\u0087\u0001\u001a\u00020!2\u0006\u0010M\u001a\u00020\u000b2\u0006\u0010N\u001a\u00020\u000b2\u0006\u0010O\u001a\u00020\u000bH\u0014J\u001d\u0010\u0088\u0001\u001a\u00020!2\b\u0010\u0089\u0001\u001a\u00030\u008a\u00012\b\u0010\u008b\u0001\u001a\u00030\u008c\u0001H\u0014J\t\u0010\u008d\u0001\u001a\u00020!H\u0002J'\u0010\u008e\u0001\u001a\u00020!2\u000e\u0010\u008f\u0001\u001a\t\u0012\u0005\u0012\u00030\u0090\u00010J2\u0006\u0010\u0007\u001a\u00028\u0003H\u0014\u00a2\u0006\u0003\u0010\u0091\u0001J-\u0010\u0092\u0001\u001a\u0005\u0018\u0001H\u0093\u0001\"\u0005\b\u0004\u0010\u0093\u0001*\t\u0012\u0005\u0012\u0003H\u0093\u0001082\u0007\u0010\u0094\u0001\u001a\u00020\u000eH\u0004\u00a2\u0006\u0003\u0010\u0095\u0001J8\u0010\u0096\u0001\u001a\u00020!2\b\u0010\u0097\u0001\u001a\u00030\u0090\u00012\b\u0010\u0098\u0001\u001a\u00030\u0099\u00012\u0011\u0010\u009a\u0001\u001a\f\u0012\u0007\b\u0001\u0012\u00030\u0099\u00010\u009b\u00012\u0006\u0010n\u001a\u00020eH\u0014J\u001c\u0010\u009c\u0001\u001a\u00020s2\u0006\u0010x\u001a\u00020s2\t\u0010\u009d\u0001\u001a\u0004\u0018\u00010\u001eH\u0014J*\u0010\u009e\u0001\u001a\u0004\u0018\u00010e2\u0006\u0010\u0007\u001a\u00028\u00032\u0006\u0010r\u001a\u00020s2\u0007\u0010\u009f\u0001\u001a\u00020\u000eH\u0014\u00a2\u0006\u0003\u0010\u00a0\u0001J#\u0010\u00a1\u0001\u001a\u00020!2\u0006\u0010n\u001a\u00020e2\u0007\u0010\u00a2\u0001\u001a\u00020\u001e2\u0007\u0010\u00a3\u0001\u001a\u00020\u001eH\u0014J,\u0010\u00a1\u0001\u001a\u00020!2\u0006\u0010n\u001a\u00020e2\u0007\u0010\u00a4\u0001\u001a\u00020/2\u0007\u0010\u00a2\u0001\u001a\u00020\u001e2\u0007\u0010\u00a5\u0001\u001a\u00020\u001eH\u0014J!\u0010\u00a6\u0001\u001a\u00020!2\u0006\u0010M\u001a\u00020\u000b2\u0006\u0010N\u001a\u00020\u000b2\u0006\u0010O\u001a\u00020\u000bH\u0002J\"\u0010\u00a7\u0001\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030d0\u001d2\u0007\u0010n\u001a\u00030\u00a8\u0001H\u0014\u00a2\u0006\u0003\u0010\u00a9\u0001J&\u0010\u00aa\u0001\u001a\u00020!2\b\u0010\u0094\u0001\u001a\u00030\u00ab\u00012\u0007\u0010n\u001a\u00030\u00a8\u00012\b\u0010\u00ac\u0001\u001a\u00030\u00ad\u0001H\u0014J\u001c\u0010\u00ae\u0001\u001a\u00020!2\u0007\u0010n\u001a\u00030\u00a8\u00012\b\u0010\u00ac\u0001\u001a\u00030\u00ad\u0001H\u0014J4\u0010\u00af\u0001\u001a\u00020!2\b\u0010\u00b0\u0001\u001a\u00030\u00b1\u00012\u0007\u0010n\u001a\u00030\u00a8\u00012\b\u0010\u00ac\u0001\u001a\u00030\u00ad\u00012\u0006\u0010\u0007\u001a\u00028\u0003H\u0014\u00a2\u0006\u0003\u0010\u00b2\u0001J\u0013\u0010\u00b3\u0001\u001a\u00020\u000b2\b\u0010\u00ac\u0001\u001a\u00030\u00ad\u0001H\u0014J6\u0010\u00b4\u0001\u001a\b\u0012\u0004\u0012\u00020\u001e0T2\t\u0010\u00b5\u0001\u001a\u0004\u0018\u00010\u001e2\u0007\u0010\u00b6\u0001\u001a\u00020\u001e2\u0011\u0010\u009a\u0001\u001a\f\u0012\u0007\b\u0001\u0012\u00030\u00b8\u00010\u00b7\u0001H\u0004J\"\u0010\u00b9\u0001\u001a\u0004\u0018\u00010\u001e*\f\u0012\u0007\b\u0001\u0012\u00030\u00b8\u00010\u00b7\u00012\u0007\u0010\u00ba\u0001\u001a\u000209H\u0004J+\u0010\u00bb\u0001\u001a\u00020!2\u0006\u0010M\u001a\u00020\u000b2\u0006\u0010N\u001a\u00020\u000b2\u0006\u0010O\u001a\u00020\u000b2\b\u0010.\u001a\u0004\u0018\u00010/H\u0014J\u001f\u0010\u00bc\u0001\u001a\u00020!2\u0006\u0010\u0007\u001a\u00028\u00032\u0006\u0010.\u001a\u00020/H\u0002\u00a2\u0006\u0003\u0010\u00bd\u0001J\u0010\u0010\u00be\u0001\u001a\t\u0012\u0005\u0012\u00030\u00bf\u00010TH\u0014J'\u0010\u00c0\u0001\u001a\u00020!2\u0006\u0010N\u001a\u00020\u000b2\u0006\u0010O\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00028\u0003H\u0002\u00a2\u0006\u0003\u0010\u00c1\u0001J4\u0010\u00c2\u0001\u001a\u00020!2\u0006\u0010\u0007\u001a\u00028\u00032\u001b\u0010\u00c3\u0001\u001a\u0016\u0012\u0004\u0012\u00020\u000e\u0012\u000b\u0012\t\u0012\u0005\u0012\u00030\u00bf\u00010T0\u00c4\u0001H\u0002\u00a2\u0006\u0003\u0010\u00c5\u0001J-\u0010\u00c6\u0001\u001a\u0005\u0018\u00010\u00c7\u00012\u0006\u0010\u0007\u001a\u00028\u00032\b\u0010x\u001a\u0004\u0018\u00010s2\u0007\u0010\u00c8\u0001\u001a\u00020\u000eH\u0014\u00a2\u0006\u0003\u0010\u00c9\u0001J\t\u0010\u00ca\u0001\u001a\u00020!H\u0002J\u001f\u0010\u00cb\u0001\u001a\u00020!2\t\u0010\u00cc\u0001\u001a\u0004\u0018\u00010e2\t\u0010\u00cd\u0001\u001a\u0004\u0018\u00010\u001eH\u0014J\t\u0010\u00ce\u0001\u001a\u00020!H\u0014J\u001c\u0010\u00cf\u0001\u001a\u00020!2\u0007\u0010\u00d0\u0001\u001a\u00020}2\b\u0010\u00d1\u0001\u001a\u00030\u00d2\u0001H\u0002J\u001c\u0010\u00d3\u0001\u001a\u00020!2\u0007\u0010\u00d0\u0001\u001a\u00020}2\b\u0010\u00d1\u0001\u001a\u00030\u00d2\u0001H\u0014J\u0016\u0010\u00d4\u0001\u001a\u0005\u0018\u00010\u00d5\u00012\b\u0010\u00d1\u0001\u001a\u00030\u00d2\u0001H\u0014J\u0019\u0010\u00d6\u0001\u001a\u00020!*\u00030\u00d7\u00012\t\u0010\u00cd\u0001\u001a\u0004\u0018\u00010\u001eH\u0002J\t\u0010\u00d8\u0001\u001a\u00020\u000bH\u0004J\t\u0010\u00d9\u0001\u001a\u00020\u000bH\u0014J\t\u0010\u00da\u0001\u001a\u00020\u000bH\u0014J\u0019\u0010\u00db\u0001\u001a\u00020!2\u0006\u0010n\u001a\u00020e2\u0006\u0010k\u001a\u00020lH$J\u001a\u0010\u00dc\u0001\u001a\u00020!2\u0007\u0010n\u001a\u00030\u00a8\u00012\u0006\u0010k\u001a\u00020lH$R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010E\u001a\b\u0012\u0004\u0012\u00020/0FX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010H\u00a8\u0006\u00dd\u0001"}, d2={"Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector$SchemaRetriever;", "S", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractMultiLevelSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "<init>", "(Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;)V", "recommendLoadNew", "", "myTypes", "", "", "Lcom/intellij/database/types/DasType;", "getMyTypes", "()Ljava/util/Map;", "setMyTypes", "(Ljava/util/Map;)V", "wasStructures", "wasTables", "wasViews", "wasMatViews", "getWasMatViews", "()Z", "setWasMatViews", "(Z)V", "getFragmentNamesOrNull", "", "", "()[Ljava/lang/String;", "setup", "", "majorModificationsFound", "mode", "Lcom/intellij/database/introspection/IntrospectionMode;", "withL3", "isPossibleToIntrospectSchemaIncrementally", "tran", "level", "Lcom/intellij/database/model/properties/Level;", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;Lcom/intellij/database/model/properties/Level;)Z", "processLevel2Imp", "processLevel3Imp", "retrieveNamedFragments", "fragmentKind", "Lcom/intellij/database/model/ObjectKind;", "fragmentNames", "(Lcom/intellij/database/model/ObjectKind;[Ljava/lang/String;)V", "doIntroSteps", "prepareParameters", "processPreliminaryPhase", "analyzeBriefInfo", "removeDroppedComments", "existentComments", "Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;", "", "listExistentComments", "removeComments", "e", "Lcom/intellij/database/model/basic/BasicModIdentifiedElement;", "getSchemaChildrenToDrop", "Lcom/intellij/database/model/families/ModIdentifyingFamily;", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;)[Lcom/intellij/database/model/families/ModIdentifyingFamily;", "retrieveMainContent", "performNonIncrementalPart", "incrementalViewSources", "incrementalColAcl", "tablesAndViews", "", "getTablesAndViews", "()Ljava/util/Set;", "steps", "", "Lcom/intellij/database/dialects/postgresbase/introspector/IntroStep;", "retrieveAcls", "removeUnaffected", "detectDropped", "loadNew", "retrieveColumnAcl", "newGrants", "Lcom/intellij/database/dialects/postgresbase/model/properties/PgObjectGrant;", "toGrants", "", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$AttrAcl;", "Lkotlin/Pair;", "", "Lcom/intellij/database/dialects/postgresbase/introspector/PgAclItem;", "objectId", "granteeId", "retrieveDataTypes", "processDataType", "dataType", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseDefType;", "oneType", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneDataType;", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseDefType;Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneDataType;Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;)V", "retrieveTables", "tableFamilies", "Lcom/intellij/database/model/families/ModNamingIdentifyingFamily;", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeStoredTable;", "sc", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;)[Lcom/intellij/database/model/families/ModNamingIdentifyingFamily;", "loadTables", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;)V", "processTable", "t", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneTable;", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneTable;)V", "table", "oneTable", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeStoredTable;Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneTable;)V", "renewTableOrView", "relKind", "", "objectName", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;CJLjava/lang/String;)Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeStoredTable;", "renewTableOrViewImpl", "isTableKind", "kind", "retrieveStructAttributes", "obtainUsedTypes", "retrieveRoutines", "createRoutine", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseRoutine;", "r", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneRoutine;", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneRoutine;)Lcom/intellij/database/dialects/postgresbase/model/PgBaseRoutine;", "retrieveAggregates", "processAggregate", "agg", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneAggregate;", "aggregate", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseAggregate;", "retrieveOperators", "processOperator", "o", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneOperator;", "operator", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseOperator;", "retrieveTableColumns", "processColumns", "cols", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneColumn;", "(Ljava/util/List;Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;)V", "getOrNull", "T", "key", "(Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;J)Ljava/lang/Object;", "processColumn", "col", "column", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeColumn;", "columns", "Lcom/intellij/database/model/families/ModPositioningNamingFamily;", "adjustRelKind", "name", "getTableOrView", "tableId", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;CJ)Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeStoredTable;", "handleColumnRenaming", "oldName", "tableName", "childrenKind", "newName", "retrieveConstraints", "constraintFamilies", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseTable;", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseTable;)[Lcom/intellij/database/model/families/ModNamingIdentifyingFamily;", "processKey", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseKey;", "con", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneConstraint;", "processCheck", "processForeignKey", "fkey", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseForeignKey;", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseForeignKey;Lcom/intellij/database/dialects/postgresbase/model/PgBaseTable;Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneConstraint;Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;)V", "hasReference", "peekColNames", "columnPositions", "what", "Lcom/intellij/database/model/families/PositioningFamily;", "Lcom/intellij/database/model/basic/BasicTableOrViewColumn;", "getColumnName", "position", "retrieveDescriptions", "retrieveDescriptionsForFragmentKind", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;Lcom/intellij/database/model/ObjectKind;)V", "retrieveDescriptionRows", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneComment;", "retrieveDescriptionsBulk", "(ZZLcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;)V", "processDescription", "descriptions", "", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;Ljava/util/Map$Entry;)V", "findObjectById", "Lcom/intellij/database/model/basic/BasicElement;", "id", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;Ljava/lang/Character;J)Lcom/intellij/database/model/basic/BasicElement;", "retrieveViewSources", "processViewSource", "view", "sourceText", "retrieveFunSources", "processFunSource", "function", "fs", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneFunctionSource;", "processFunSourceAttributes", "getFunSourceText", "Lcom/intellij/database/model/properties/CompositeText;", "applyViewSourceText", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseSourceAware;", "shouldIntrospectTableRelatedData", "shouldIntrospectTableRelatedDataIncremental", "wasDataTables", "processModView", "processModTable", "intellij.database.dialects.postgresbase"})
    @SourceDebugExtension(value={"SMAP\nPgBaseIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PgBaseIntrospector.kt\ncom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector$SchemaRetriever\n+ 2 BooleanFun.kt\ncom/intellij/database/util/common/BooleanFun\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector\n+ 7 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 8 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 9 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 10 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 11 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 12 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n+ 13 ModelFun.kt\ncom/intellij/database/model/ModelFun\n+ 14 BaseIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospector\n*L\n1#1,1881:1\n14#2:1882\n777#3:1883\n873#3,2:1884\n777#3:1886\n873#3,2:1887\n777#3:1889\n873#3,2:1890\n1915#3:1952\n1915#3,2:1953\n1916#3:1955\n1512#3:2014\n1538#3,3:2015\n1541#3,3:2025\n1512#3:2056\n1538#3,3:2057\n1541#3,3:2067\n1512#3:2072\n1538#3,3:2073\n1541#3,3:2083\n1915#3,2:2088\n1512#3:2287\n1538#3,3:2288\n1541#3,3:2298\n742#3,9:2310\n1915#3:2542\n1915#3:2543\n1915#3,2:2545\n1916#3:2548\n1916#3:2549\n11705#4:1892\n12052#4,2:1893\n12054#4:1897\n14060#4,2:2154\n14088#4,2:2163\n14088#4,2:2224\n14088#4,2:2328\n14088#4,2:2386\n14088#4,2:2444\n12033#4,10:2499\n14060#4:2509\n14061#4:2511\n12043#4:2512\n14060#4:2544\n14061#4:2547\n37#5,2:1895\n37#5,2:2319\n521#6:1898\n502#6,2:1899\n505#6,15:1902\n521#6:1917\n502#6,18:1918\n521#6:1957\n502#6,18:1958\n521#6:1976\n502#6,18:1977\n521#6:1995\n502#6,18:1996\n521#6:2037\n502#6,18:2038\n521#6:2092\n502#6,2:2093\n400#6:2095\n401#6,2:2101\n505#6,15:2108\n521#6:2123\n502#6,2:2124\n400#6:2126\n401#6,2:2132\n505#6,15:2139\n521#6:2160\n502#6,2:2161\n505#6,15:2165\n502#6,18:2191\n521#6:2221\n502#6,2:2222\n505#6,15:2226\n502#6,18:2262\n521#6:2325\n502#6,2:2326\n505#6,15:2330\n502#6,18:2356\n521#6:2383\n502#6,2:2384\n505#6,15:2388\n502#6,18:2414\n521#6:2441\n502#6,2:2442\n505#6,15:2446\n502#6,18:2472\n521#6:2539\n502#6,2:2540\n505#6,15:2550\n1#7:1901\n1#7:2189\n1#7:2354\n1#7:2412\n1#7:2470\n1#7:2510\n1011#8:1936\n1041#8,3:1937\n1044#8,3:1947\n383#9,7:1940\n383#9,7:2018\n383#9,7:2060\n383#9,7:2076\n383#9,7:2291\n221#10,2:1950\n221#10:2028\n222#10:2036\n221#10,2:2070\n221#10,2:2086\n221#10:2301\n222#10:2309\n18#11:1956\n179#12,7:2029\n223#12,2:2156\n181#12,2:2158\n183#12,3:2180\n225#12,6:2183\n234#12:2190\n236#12,5:2209\n301#12,2:2214\n198#12,5:2216\n204#12,5:2241\n303#12,16:2246\n320#12,7:2280\n179#12,7:2302\n223#12,2:2321\n181#12,2:2323\n183#12,3:2345\n225#12,6:2348\n234#12:2355\n236#12,5:2374\n223#12,2:2379\n181#12,2:2381\n183#12,3:2403\n225#12,6:2406\n234#12:2413\n236#12,5:2432\n223#12,2:2437\n181#12,2:2439\n183#12,3:2461\n225#12,6:2464\n234#12:2471\n236#12,5:2490\n262#12,26:2513\n289#12,7:2565\n237#13:2090\n230#13:2091\n227#13,4:2495\n1134#14:2096\n1229#14,2:2097\n1135#14,2:2099\n1139#14:2103\n1234#14,2:2104\n1140#14,2:2106\n1134#14:2127\n1229#14,2:2128\n1135#14,2:2130\n1139#14:2134\n1234#14,2:2135\n1140#14,2:2137\n*S KotlinDebug\n*F\n+ 1 PgBaseIntrospector.kt\ncom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector$SchemaRetriever\n*L\n677#1:1882\n685#1:1883\n685#1:1884,2\n695#1:1886\n695#1:1887,2\n721#1:1889\n721#1:1890,2\n941#1:1952\n943#1:1953,2\n941#1:1955\n1261#1:2014\n1261#1:2015,3\n1261#1:2025,3\n1490#1:2056\n1490#1:2057,3\n1490#1:2067,3\n1503#1:2072\n1503#1:2073,3\n1503#1:2083,3\n1514#1:2088,2\n1068#1:2287\n1068#1:2288,3\n1068#1:2298,3\n1122#1:2310,9\n1385#1:2542\n1386#1:2543\n1388#1:2545,2\n1386#1:2548\n1385#1:2549\n727#1:1892\n727#1:1893,2\n727#1:1897\n902#1:2154,2\n962#1:2163,2\n997#1:2224,2\n1107#1:2328,2\n1184#1:2386,2\n1218#1:2444,2\n1377#1:2499,10\n1377#1:2509\n1377#1:2511\n1377#1:2512\n1387#1:2544\n1387#1:2547\n727#1:1895,2\n1122#1:2319,2\n890#1:1898\n890#1:1899,2\n890#1:1902,15\n913#1:1917\n913#1:1918,18\n1063#1:1957\n1063#1:1958,18\n1086#1:1976\n1086#1:1977,18\n1252#1:1995\n1252#1:1996,18\n1470#1:2037\n1470#1:2038,18\n1534#1:2092\n1534#1:2093,2\n1535#1:2095\n1535#1:2101,2\n1534#1:2108,15\n1557#1:2123\n1557#1:2124,2\n1558#1:2126\n1558#1:2132,2\n1557#1:2139,15\n960#1:2160\n960#1:2161,2\n960#1:2165,15\n960#1:2191,18\n995#1:2221\n995#1:2222,2\n995#1:2226,15\n995#1:2262,18\n1105#1:2325\n1105#1:2326,2\n1105#1:2330,15\n1105#1:2356,18\n1182#1:2383\n1182#1:2384,2\n1182#1:2388,15\n1182#1:2414,18\n1216#1:2441\n1216#1:2442,2\n1216#1:2446,15\n1216#1:2472,18\n1382#1:2539\n1382#1:2540,2\n1382#1:2550,15\n959#1:2189\n1104#1:2354\n1181#1:2412\n1215#1:2470\n1377#1:2510\n932#1:1936\n932#1:1937,3\n932#1:1947,3\n932#1:1940,7\n1261#1:2018,7\n1490#1:2060,7\n1503#1:2076,7\n1068#1:2291,7\n932#1:1950,2\n1262#1:2028\n1262#1:2036\n1490#1:2070,2\n1503#1:2086,2\n1069#1:2301\n1069#1:2309\n1041#1:1956\n1264#1:2029,7\n959#1:2156,2\n959#1:2158,2\n959#1:2180,3\n959#1:2183,6\n959#1:2190\n959#1:2209,5\n994#1:2214,2\n994#1:2216,5\n994#1:2241,5\n994#1:2246,16\n994#1:2280,7\n1071#1:2302,7\n1104#1:2321,2\n1104#1:2323,2\n1104#1:2345,3\n1104#1:2348,6\n1104#1:2355\n1104#1:2374,5\n1181#1:2379,2\n1181#1:2381,2\n1181#1:2403,3\n1181#1:2406,6\n1181#1:2413\n1181#1:2432,5\n1215#1:2437,2\n1215#1:2439,2\n1215#1:2461,3\n1215#1:2464,6\n1215#1:2471\n1215#1:2490,5\n1378#1:2513,26\n1378#1:2565,7\n1525#1:2090\n1525#1:2091\n1397#1:2495,4\n1535#1:2096\n1535#1:2097,2\n1535#1:2099,2\n1535#1:2103\n1535#1:2104,2\n1535#1:2106,2\n1558#1:2127\n1558#1:2128,2\n1558#1:2130,2\n1558#1:2134\n1558#1:2135,2\n1558#1:2137,2\n*E\n"})
    protected static abstract class SchemaRetriever<S extends PgBaseSchema>
    extends BaseNativeIntrospector.AbstractMultiLevelSchemaRetriever<S> {
        private boolean recommendLoadNew;
        protected Map<Long, DasType> myTypes;
        private boolean wasStructures;
        private boolean wasTables;
        private boolean wasViews;
        private boolean wasMatViews;
        @NotNull
        private final Set<ObjectKind> tablesAndViews;
        final /* synthetic */ PgBaseIntrospector<MR, D, SL> this$0;

        @NotNull
        protected final Map<Long, DasType> getMyTypes() {
            Map<Long, DasType> map = this.myTypes;
            if (map != null) {
                return map;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"myTypes");
            return null;
        }

        protected final void setMyTypes(@NotNull Map<Long, DasType> map) {
            Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
            this.myTypes = map;
        }

        protected final boolean getWasMatViews() {
            return this.wasMatViews;
        }

        protected final void setWasMatViews(boolean bl) {
            this.wasMatViews = bl;
        }

        @Nullable
        protected final String[] getFragmentNamesOrNull() {
            return this.getMode() == IntrospectionMode.FRAGMENT ? this.getFragmentNames() : null;
        }

        protected SchemaRetriever(@NotNull DBTransaction transaction, S schema) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            this.this$0 = this$0;
            super((BaseNativeIntrospector)this$0, transaction, (BasicModMultiLevelSchema)schema);
            this.recommendLoadNew = true;
            Object[] objectArray = new ObjectKind[]{ObjectKind.TABLE, ObjectKind.FOREIGN_TABLE, ObjectKind.VIEW, ObjectKind.MAT_VIEW};
            this.tablesAndViews = SetsKt.setOf((Object[])objectArray);
            this.prepareParameters();
        }

        /*
         * WARNING - void declaration
         */
        public void setup(boolean majorModificationsFound, @Nullable IntrospectionMode mode, boolean withL3) {
            void _true_$iv;
            void $this$choose$iv;
            super.setup(majorModificationsFound, mode, withL3);
            this.setWithSources(withL3 || this.calcWithSources());
            boolean bl = this.getWithSources();
            Level level = Level.L3;
            Level _false_$iv = Level.L2;
            boolean $i$f$choose = false;
            this.setMode(this.isPossibleToIntrospectSchemaIncrementally(this.getTransaction(), (S)((PgBaseSchema)this.getSchema()), (Level)($this$choose$iv != false ? _true_$iv : _false_$iv)) ? IntrospectionMode.INCREMENT : IntrospectionMode.FULL);
        }

        protected boolean isPossibleToIntrospectSchemaIncrementally(@NotNull DBTransaction tran, @NotNull S schema, @NotNull Level level) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            return true;
        }

        /*
         * WARNING - void declaration
         */
        protected void processLevel2Imp() {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.steps();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                IntroStep it = (IntroStep)element$iv$iv;
                boolean bl = false;
                if (!(it.getLevel() == Level.L2)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List applicableSteps = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
            for (IntroStep step : applicableSteps) {
                step.getPerform().invoke((Object)(this.getMode().increment ? (IntroModeCtx)new IntroModeCtx.IncWithL1(true) : (IntroModeCtx)IntroModeCtx.Full.INSTANCE));
            }
            ((BasicModMultiLevelSchema)this.getSchema()).setLastIntrospectionLevel(Level.L2);
            Long l = this.this$0.getIntrospectionXid();
            ((PgBaseSchema)this.getSchema()).setLastIntrospectionL2Xid(l != null ? l : 0L);
            this.getSchema().setLastIntrospectionLocalTimestamp(this.getIntrospectionBeginLocalTimestamp());
        }

        /*
         * WARNING - void declaration
         */
        protected void processLevel3Imp() {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.steps();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                IntroStep it = (IntroStep)element$iv$iv;
                boolean bl = false;
                if (!(it.getLevel() == Level.L3)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List applicableSteps = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
            for (IntroStep step : applicableSteps) {
                step.getPerform().invoke((Object)(this.getMode().increment ? (IntroModeCtx)new IntroModeCtx.IncWithL1(true) : (IntroModeCtx)IntroModeCtx.Full.INSTANCE));
            }
            ((BasicModMultiLevelSchema)this.getSchema()).setLastIntrospectionLevel(Level.L3);
            Long l = this.this$0.getIntrospectionXid();
            ((PgBaseSchema)this.getSchema()).setLastIntrospectionL3Xid(l != null ? l : 0L);
            this.getSchema().setLastIntrospectionLocalTimestamp(this.getIntrospectionBeginLocalTimestamp());
            this.getModel().setSchemaSourcesVersion((BasicSchema)this.getSchema(), Long.valueOf(((PgBaseSchema)this.getSchema()).getLastIntrospectionL3Xid()));
        }

        public void retrieveNamedFragments(@NotNull ObjectKind fragmentKind, @NotNull String[] fragmentNames) {
            Intrinsics.checkNotNullParameter((Object)fragmentKind, (String)"fragmentKind");
            Intrinsics.checkNotNullParameter((Object)fragmentNames, (String)"fragmentNames");
            if (!this.this$0.nature.getSupportFragmentIntrospection()) {
                super.retrieveNamedFragments(fragmentKind, fragmentNames);
                return;
            }
            this.setFragmentKind(fragmentKind);
            this.setFragmentNames(fragmentNames);
            BaseIntrospectionFunctions.setupModeParameters((IntrospectionMode)this.getMode(), (Map)this.getParametersMap());
            this.getParametersMap().put("f_names", fragmentNames);
            this.doIntroSteps();
        }

        /*
         * WARNING - void declaration
         */
        protected final void doIntroSteps() {
            void $this$mapTo$iv$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.steps();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo22 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                IntroStep it = (IntroStep)element$iv$iv;
                boolean bl = false;
                if (!it.getApplicableKinds().contains(this.getFragmentKind())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List applicableSteps = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
            if (applicableSteps.isEmpty()) {
                IntrospectionQueryContext.logError$default((IntrospectionQueryContext)((IntrospectionQueryContext)this), (String)("Unsupported object kind (" + this.getFragmentKind() + ") for fragment intro"), null, (int)2, null);
            }
            Object[] allFragmentNames = this.getFragmentNames();
            List[] $this$map$iv = CollectionFun.splitIntoChunksOf((List)ArraysKt.toList((Object[])allFragmentNames), (int)50);
            boolean $i$f$map = false;
            List[] $i$f$filterTo22 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                void it;
                void item$iv$iv;
                void var12_18 = item$iv$iv = $this$mapTo$iv$iv[j];
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                Collection $this$toTypedArray$iv = (Collection)it;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                collection.add(thisCollection$iv.toArray(new String[0]));
            }
            List batches = (List)destination$iv$iv2;
            for (IntroStep step : applicableSteps) {
                for (String[] batch : batches) {
                    this.getParametersMap().put("f_names", batch);
                    this.setFragmentNames(batch);
                    step.getPerform().invoke((Object)new IntroModeCtx.Frag(this.getFragmentKind()));
                }
            }
            this.getParametersMap().put("f_names", this.getFragmentNames());
            this.setFragmentNames((String[])allFragmentNames);
        }

        public final void prepareParameters() {
            super.prepareParameters();
            long l2xid = this.getMode().increment ? ((PgBaseSchema)this.getSchema()).getLastIntrospectionL2Xid() : 0L;
            this.this$0.setTx((IntrospectionQueryContext)this, l2xid, "tx", "TXAGE");
            Long l = this.getModel().getSchemaSourcesVersion((BasicSchema)this.getSchema());
            long srcXid = l != null ? l : 0L;
            long l3xid = this.getMode().increment ? Math.min(srcXid, ((PgBaseSchema)this.getSchema()).getLastIntrospectionL3Xid()) : 0L;
            this.this$0.setTx((IntrospectionQueryContext)this, l3xid, "src_tx", "SRCTXAGE");
        }

        public void processPreliminaryPhase() {
            if (this.getMode().fragment) {
                return;
            }
            this.analyzeBriefInfo();
            this.analyzeCurrentContent();
        }

        protected void analyzeBriefInfo() {
            long l2Xid = this.getMode().increment ? ((PgBaseSchema)this.getSchema()).getLastIntrospectionL2Xid() : 0L;
            long l3Xid = this.getMode().increment ? ((PgBaseSchema)this.getSchema()).getLastIntrospectionL3Xid() : 0L;
            this.recommendLoadNew = this.getMode().full ? true : this.this$0.getQueries().checkSchemaChanges(this.getTransaction(), l2Xid, l3Xid, (PgBaseSchema)this.getSchema());
        }

        private final void removeDroppedComments(Long2ObjectMap<Short[]> existentComments, ObjectKind fragmentKind) {
            String[] fragmentNames = this.getFragmentNamesOrNull();
            this.inSchema(arg_0 -> SchemaRetriever.removeDroppedComments$lambda$0(fragmentNames, fragmentKind, this, existentComments, arg_0));
        }

        static /* synthetic */ void removeDroppedComments$default(SchemaRetriever schemaRetriever, Long2ObjectMap long2ObjectMap, ObjectKind objectKind, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: removeDroppedComments");
            }
            if ((n & 2) != 0) {
                objectKind = null;
            }
            schemaRetriever.removeDroppedComments((Long2ObjectMap<Short[]>)long2ObjectMap, objectKind);
        }

        @NotNull
        protected abstract Long2ObjectMap<Short[]> listExistentComments();

        protected void removeComments(@NotNull Long2ObjectMap<Short[]> existentComments, @NotNull BasicModIdentifiedElement e) {
            Object[] commented;
            Intrinsics.checkNotNullParameter(existentComments, (String)"existentComments");
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            BasicModNamedElement cfr_ignored_0 = (BasicModNamedElement)e;
            Object[] objectArray = (Short[])existentComments.get(((BasicIdentifiedElement)e).getObjectId());
            if (objectArray == null) {
                objectArray = new Short[]{};
            }
            if (!ArraysKt.contains((Object[])(commented = objectArray), (Object)0)) {
                ((BasicModNamedElement)e).setComment(null);
            }
            if (e instanceof PgBaseDefType) {
                for (Object column : ((PgBaseDefType)e).getAttributes()) {
                    if (ArraysKt.contains((Object[])commented, (Object)column.getPosition())) continue;
                    column.setComment(null);
                }
            }
            if (e instanceof PgBaseLikeTable) {
                for (Object column : ((PgBaseLikeTable)e).getColumns()) {
                    if (ArraysKt.contains((Object[])commented, (Object)column.getPosition())) continue;
                    column.setComment(null);
                }
                for (BasicModKey k : ((PgBaseLikeTable)e).getKeys()) {
                    Intrinsics.checkNotNull((Object)k, (String)"null cannot be cast to non-null type com.intellij.database.dialects.postgresbase.model.PgBaseKey");
                    this.removeComments(existentComments, (PgBaseKey)k);
                }
                for (BasicModForeignKey fk : ((PgBaseLikeTable)e).getForeignKeys()) {
                    Intrinsics.checkNotNull((Object)fk, (String)"null cannot be cast to non-null type com.intellij.database.dialects.postgresbase.model.PgBaseForeignKey");
                    this.removeComments(existentComments, (PgBaseForeignKey)fk);
                }
            }
        }

        @NotNull
        protected ModIdentifyingFamily<? extends BasicModIdentifiedElement>[] getSchemaChildrenToDrop(@NotNull S schema) {
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            ModIdentifyingFamily[] modIdentifyingFamilyArray = new ModIdentifyingFamily[7];
            Intrinsics.checkNotNullExpressionValue(schema.getDefTypes(), (String)"getDefTypes(...)");
            Intrinsics.checkNotNullExpressionValue(schema.getTables(), (String)"getTables(...)");
            Intrinsics.checkNotNullExpressionValue(schema.getViews(), (String)"getViews(...)");
            Intrinsics.checkNotNullExpressionValue(schema.getMatViews(), (String)"getMatViews(...)");
            Intrinsics.checkNotNullExpressionValue(schema.getRoutines(), (String)"getRoutines(...)");
            Intrinsics.checkNotNullExpressionValue(schema.getOperators(), (String)"getOperators(...)");
            Intrinsics.checkNotNullExpressionValue(schema.getAggregates(), (String)"getAggregates(...)");
            return modIdentifyingFamilyArray;
        }

        protected void retrieveMainContent() {
            List<IntroStep> steps = this.steps();
            CollectionsKt.sort(steps);
            IntroModeCtx modeCtx = this.getMode().increment ? (IntroModeCtx)new IntroModeCtx.IncNoL1(this.recommendLoadNew) : (IntroModeCtx)IntroModeCtx.Full.INSTANCE;
            for (IntroStep step : steps) {
                step.getPerform().invoke((Object)modeCtx);
            }
            if (!this.recommendLoadNew) {
                this.performNonIncrementalPart();
            }
        }

        protected void performNonIncrementalPart() {
            if (!this.incrementalColAcl()) {
                List newGrants = ((PgBaseGrantsHolder)this.getSchema()).getGrants().toMutableList();
                this.retrieveColumnAcl(newGrants);
                ((PgBaseGrantsHolder)this.getSchema()).setGrants((Grants<PgObjectGrant>)((PgBaseGrantsHolder)this.getSchema()).getGrants().with((Iterable)newGrants));
            }
        }

        protected boolean incrementalViewSources() {
            return false;
        }

        protected boolean incrementalColAcl() {
            return true;
        }

        @NotNull
        protected final Set<ObjectKind> getTablesAndViews() {
            return this.tablesAndViews;
        }

        @NotNull
        protected List<IntroStep> steps() {
            Object[] objectArray = new ObjectKind[]{ObjectKind.ROUTINE, ObjectKind.AGGREGATE, ObjectKind.OPERATOR};
            List list = PgBaseIntrospectorKt.add$default(PgBaseIntrospectorKt.add$default(PgBaseIntrospectorKt.add$default(PgBaseIntrospectorKt.add$default(PgBaseIntrospectorKt.add$default(PgBaseIntrospectorKt.add$default(PgBaseIntrospectorKt.add$default(PgBaseIntrospectorKt.add$default(PgBaseIntrospectorKt.add$default(PgBaseIntrospectorKt.add$default(PgBaseIntrospectorKt.add$default(new ArrayList(), 10, SetsKt.setOf((Object)ObjectKind.OBJECT_TYPE), null, arg_0 -> SchemaRetriever.steps$lambda$0(this, arg_0), 4, null), 20, this.tablesAndViews, null, arg_0 -> SchemaRetriever.steps$lambda$1(this, arg_0), 4, null), 30, SetsKt.setOf((Object[])objectArray), null, arg_0 -> SchemaRetriever.steps$lambda$2(this, arg_0), 4, null), 40, SetsKt.setOf((Object)ObjectKind.ROUTINE), null, arg_0 -> SchemaRetriever.steps$lambda$3(this, arg_0), 4, null), 45, SetsKt.setOf((Object)ObjectKind.AGGREGATE), null, arg_0 -> SchemaRetriever.steps$lambda$4(this, arg_0), 4, null), 50, SetsKt.setOf((Object)ObjectKind.OPERATOR), null, arg_0 -> SchemaRetriever.steps$lambda$5(this, arg_0), 4, null), 60, SetsKt.setOf((Object)ObjectKind.OBJECT_TYPE), null, arg_0 -> SchemaRetriever.steps$lambda$6(this, arg_0), 4, null), 70, this.tablesAndViews, null, arg_0 -> SchemaRetriever.steps$lambda$7(this, arg_0), 4, null), 80, this.tablesAndViews, null, arg_0 -> SchemaRetriever.steps$lambda$8(this, arg_0), 4, null), 90, this.this$0.nature.getSupportFragmentKinds(), null, arg_0 -> SchemaRetriever.steps$lambda$9(this, arg_0), 4, null), 99, null, null, arg_0 -> SchemaRetriever.steps$lambda$10(this, arg_0), 6, null);
            objectArray = new ObjectKind[]{ObjectKind.VIEW, ObjectKind.MAT_VIEW};
            return PgBaseIntrospectorKt.add(PgBaseIntrospectorKt.add(list, 100, SetsKt.setOf((Object[])objectArray), Level.L3, (Function1<? super IntroModeCtx, Unit>)((Function1)arg_0 -> SchemaRetriever.steps$lambda$11(this, arg_0))), 110, SetsKt.setOf((Object)ObjectKind.ROUTINE), Level.L3, (Function1<? super IntroModeCtx, Unit>)((Function1)arg_0 -> SchemaRetriever.steps$lambda$12(this, arg_0)));
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveAcls(boolean removeUnaffected, boolean detectDropped, boolean loadNew) {
            void this_$iv;
            this.this$0.reportRetrieving("ACL", "introspection.retrieve.ACL");
            BaseNativeIntrospector baseNativeIntrospector = (BaseNativeIntrospector)this.this$0;
            PgBaseIntrospector pgBaseIntrospector = this.this$0;
            boolean $i$f$continueOnDbError = false;
            void var7_7 = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl = false;
                Grants.Controller ctl = ((PgBaseGrantsHolder)this.getSchema()).getGrants().getController();
                List newGrants = ((PgBaseGrantsHolder)this.getSchema()).getGrants().toMutableList();
                if (detectDropped) {
                    newGrants.removeIf(arg_0 -> SchemaRetriever.retrieveAcls$lambda$0$1(arg_0 -> SchemaRetriever.retrieveAcls$lambda$0$0(ctl, this, arg_0), arg_0));
                }
                if (loadNew) {
                    Long l = ((PgBaseSchema)this.getSchema()).getLastIntrospectionL2Xid();
                    long it = ((Number)l).longValue();
                    boolean bl2 = false;
                    Long tx = this.getMode().increment ? l : null;
                    Lexer lexer = pgBaseIntrospector.getSqlHelper().createLexer();
                    NamingService ns = NamingServices.getNamingService((Dbms)pgBaseIntrospector.dbms, (BasicModel)((BasicModel)this.getModel()), (BasicDatabase)((BasicDatabase)((PgBaseSchema)this.getSchema()).getDatabase()));
                    pgBaseIntrospector.getQueries().processObjectAcls(this.getTransaction(), (PgBaseSchema)this.getSchema(), tx, (Function1<? super PgBaseIntroQueries.OneAcl, Unit>)((Function1)arg_0 -> SchemaRetriever.retrieveAcls$lambda$0$3(newGrants, pgBaseIntrospector, lexer, ns, arg_0)));
                    this.retrieveColumnAcl(newGrants);
                }
                ((PgBaseGrantsHolder)this.getSchema()).setGrants((Grants<PgObjectGrant>)((PgBaseGrantsHolder)this.getSchema()).getGrants().with((Iterable)newGrants));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveColumnAcl(List<PgObjectGrant> newGrants) {
            void this_$iv;
            Long l = ((PgBaseSchema)this.getSchema()).getLastIntrospectionL2Xid();
            long it22 = ((Number)l).longValue();
            boolean bl = false;
            Long tx = this.getMode().increment ? l : null;
            ArrayList columns = new ArrayList();
            BaseNativeIntrospector it22 = (BaseNativeIntrospector)this.this$0;
            PgBaseIntrospector pgBaseIntrospector = this.this$0;
            boolean $i$f$continueOnDbError = false;
            void var7_8 = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl2 = false;
                pgBaseIntrospector.getQueries().processColumnAcls(this.getTransaction(), (PgBaseSchema)this.getSchema(), tx, (Function1<? super PgBaseIntroQueries.AttrAcl, Unit>)((Function1)arg_0 -> SchemaRetriever.retrieveColumnAcl$lambda$1$0(newGrants, columns, this, arg_0)));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl3 = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            this.toGrants(columns, newGrants);
        }

        /*
         * WARNING - void declaration
         */
        private final void toGrants(List<PgBaseIntroQueries.AttrAcl> $this$toGrants, List<PgObjectGrant> newGrants) {
            void $this$forEach$iv;
            void $this$groupByTo$iv$iv;
            Map $this$groupBy$iv;
            if ($this$toGrants.isEmpty()) {
                return;
            }
            long objectId = ((PgBaseIntroQueries.AttrAcl)CollectionsKt.first($this$toGrants)).object_id;
            Lexer lexer = this.this$0.getSqlHelper().createLexer();
            NamingService ns = NamingServices.getNamingService((Dbms)this.this$0.dbms, (BasicModel)((BasicModel)this.getModel()), (BasicDatabase)((BasicDatabase)((PgBaseSchema)this.getSchema()).getDatabase()));
            Sequence sequence = SequencesKt.flatMap((Sequence)((Sequence)SequenceFun.asSequence((Collection)$this$toGrants)), arg_0 -> SchemaRetriever.toGrants$lambda$0(this.this$0, lexer, ns, arg_0));
            boolean $i$f$groupBy = false;
            Iterator iterator = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                void $this$getOrPut$iv$iv$iv;
                kotlin.Pair it = (kotlin.Pair)element$iv$iv;
                boolean bl = false;
                Long key$iv$iv = ((PgAclItem)it.getSecond()).getGrantee();
                Map map = destination$iv$iv;
                Long key$iv$iv$iv = key$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            $this$groupBy$iv = destination$iv$iv;
            boolean $i$f$forEach = false;
            iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                long granteeId = ((Number)entry.getKey()).longValue();
                List grants = (List)entry.getValue();
                this.toGrants(grants, objectId, granteeId, newGrants);
            }
        }

        private final void toGrants(List<kotlin.Pair<Integer, PgAclItem>> $this$toGrants, long objectId, long granteeId, List<PgObjectGrant> newGrants) {
            if (newGrants.isEmpty()) {
                return;
            }
            BitSet columns = new BitSet();
            for (PgPrivilege privilege : PgPrivilege.values()) {
                Iterable $this$forEach$iv = (Iterable)new IntRange(0, 1);
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int g = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl = false;
                    for (kotlin.Pair<Integer, PgAclItem> acl : $this$toGrants) {
                        Iterable $this$forEach$iv2 = g == 1 ? ((PgAclItem)acl.getSecond()).getGrantablePrivileges() : ((PgAclItem)acl.getSecond()).getPrivileges();
                        boolean $i$f$forEach2 = false;
                        for (Object element$iv2 : $this$forEach$iv2) {
                            PgPrivilege p = (PgPrivilege)((Object)element$iv2);
                            boolean bl2 = false;
                            if (p != privilege) continue;
                            columns.set(((Number)acl.getFirst()).intValue());
                        }
                    }
                    if (columns.isEmpty()) continue;
                    newGrants.add(new PgObjectGrant(objectId, columns, granteeId, privilege.name(), g == 1 ? Grants.State.GRANT_WITH_GRANT_OPTION : Grants.State.GRANT));
                    columns.clear();
                }
            }
        }

        protected void retrieveDataTypes(boolean removeUnaffected, boolean detectDropped, boolean loadNew) {
            this.this$0.reportRetrieving("data types", "introspection.retrieve.types");
            this.inSchema(arg_0 -> SchemaRetriever.retrieveDataTypes$lambda$0(removeUnaffected, this, this.this$0, detectDropped, loadNew, arg_0));
        }

        protected void processDataType(@NotNull PgBaseDefType dataType, @NotNull PgBaseIntroQueries.OneDataType oneType, @NotNull S schema) {
            Intrinsics.checkNotNullParameter((Object)dataType, (String)"dataType");
            Intrinsics.checkNotNullParameter((Object)oneType, (String)"oneType");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            PgDataTypeSubKind subKind = PgDataTypeSubKind.of(oneType.type_sub_kind);
            dataType.setStateNumber(oneType.type_state_number);
            dataType.setSubKind(subKind);
            String string = PgBaseIntrospectorKt.access$adjustedTypeSpec(oneType);
            dataType.setDefinition(string != null ? PgBaseIntrospectorKt.normalizeDataTypeSpec(string) : null);
            dataType.setDefaultExpression(oneType.default_expression);
            dataType.setNotNull(oneType.mandatory);
            this.wasStructures = this.wasStructures || subKind == PgDataTypeSubKind.COMPOSITE;
            dataType.setDetailsLevel(LevelFun.max((Level)dataType.getDetailsLevel(), (Level)Level.L2));
        }

        private final void retrieveTables(boolean removeUnaffected, boolean detectDropped, boolean loadNew) {
            this.this$0.reportRetrieving("tables and views", "introspection.retrieve.tablesViews");
            this.inSchema(arg_0 -> SchemaRetriever.retrieveTables$lambda$0(this, removeUnaffected, this.this$0, detectDropped, loadNew, arg_0));
        }

        @NotNull
        protected ModNamingIdentifyingFamily<? extends PgBaseLikeStoredTable>[] tableFamilies(@NotNull S sc) {
            Intrinsics.checkNotNullParameter(sc, (String)"sc");
            ModNamingIdentifyingFamily[] modNamingIdentifyingFamilyArray = new ModNamingIdentifyingFamily[3];
            Intrinsics.checkNotNullExpressionValue(sc.getTables(), (String)"getTables(...)");
            Intrinsics.checkNotNullExpressionValue(sc.getViews(), (String)"getViews(...)");
            Intrinsics.checkNotNullExpressionValue(sc.getMatViews(), (String)"getMatViews(...)");
            return modNamingIdentifyingFamilyArray;
        }

        protected void loadTables(@NotNull S schema) {
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default((BaseNativeIntrospector.AbstractRetriever)((BaseNativeIntrospector.AbstractRetriever)this), this.this$0.getQueries().getRetrieveTables(), (int)0, arg_0 -> SchemaRetriever.loadTables$lambda$0(this, schema, arg_0), (int)2, null);
        }

        protected final void processTable(@NotNull S schema, @NotNull PgBaseIntroQueries.OneTable t) {
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            char c = t.table_kind;
            long l = t.table_id;
            String string = t.table_name;
            Intrinsics.checkNotNull((Object)string);
            PgBaseLikeStoredTable pgBaseLikeStoredTable = this.renewTableOrView(schema, c, l, string);
            if (pgBaseLikeStoredTable == null) {
                return;
            }
            PgBaseLikeStoredTable table = pgBaseLikeStoredTable;
            this.processTable(table, schema, t);
        }

        protected void processTable(@NotNull PgBaseLikeStoredTable table, @NotNull S schema, @NotNull PgBaseIntroQueries.OneTable oneTable) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)oneTable, (String)"oneTable");
            table.setStateNumber(oneTable.table_state_number);
            table.setOwnerRef((BasicReference)BasicNameReference.create((String)oneTable.getOwnerName()));
            PgBaseLikeStoredTable pgBaseLikeStoredTable = table;
            if (pgBaseLikeStoredTable instanceof PgBaseTable) {
                this.processModTable((PgBaseTable)table, oneTable);
            } else if (pgBaseLikeStoredTable instanceof PgBaseView) {
                this.processModView(table, oneTable);
            }
            this.wasTables = this.wasTables || this.isTableKind(oneTable.table_kind);
            this.wasViews = this.wasViews || oneTable.table_kind == 'v';
            this.wasMatViews = this.wasMatViews || oneTable.table_kind == 'm';
            table.setDetailsLevel(LevelFun.max((Level)table.getDetailsLevel(), (Level)Level.L2));
        }

        private final PgBaseLikeStoredTable renewTableOrView(S schema, char relKind, long objectId, String objectName) {
            Object object;
            Object object2;
            PgBaseLikeStoredTable pgBaseLikeStoredTable;
            PgBaseDatabase pgBaseDatabase = schema.getDatabase();
            Intrinsics.checkNotNull((Object)pgBaseDatabase);
            BasicIdentifiedElement existing = pgBaseDatabase.findIdentifiedElement(objectId);
            PgBaseLikeStoredTable newRelation = this.renewTableOrViewImpl(schema, relKind, objectId, objectName);
            BasicIdentifiedElement $this$asSafely$iv = existing;
            boolean $i$f$asSafely = false;
            BasicIdentifiedElement basicIdentifiedElement = $this$asSafely$iv;
            if (!(basicIdentifiedElement instanceof PgBaseLikeStoredTable)) {
                basicIdentifiedElement = null;
            }
            if ((pgBaseLikeStoredTable = (PgBaseLikeStoredTable)basicIdentifiedElement) != null) {
                object2 = pgBaseLikeStoredTable;
                PgBaseLikeStoredTable it = object2;
                boolean bl = false;
                object = newRelation != null && !Intrinsics.areEqual((Object)it, (Object)newRelation) && Intrinsics.areEqual((Object)it.getSchema(), schema) ? object2 : null;
            } else {
                object = null;
            }
            pgBaseLikeStoredTable = object;
            object2 = this.this$0;
            PgBaseLikeStoredTable it = pgBaseLikeStoredTable;
            boolean bl = false;
            return ((PgBaseIntrospector)((Object)object2)).preventDuplicatedRelationForSchema(schema, newRelation, it);
        }

        @Nullable
        protected PgBaseLikeStoredTable renewTableOrViewImpl(@NotNull S schema, char relKind, long objectId, @NotNull String objectName) {
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)objectName, (String)"objectName");
            return this.isTableKind(relKind) ? (PgBaseLikeStoredTable)schema.getTables().renew(objectId, objectName) : (relKind == 'v' ? (PgBaseLikeStoredTable)schema.getViews().renew(objectId, objectName) : (relKind == 'm' ? (PgBaseLikeStoredTable)schema.getMatViews().renew(objectId, objectName) : null));
        }

        protected boolean isTableKind(char kind) {
            return kind == 'r';
        }

        /*
         * WARNING - void declaration
         */
        protected void retrieveStructAttributes() {
            void this_$iv;
            if (!(this.wasStructures || this.getMode().increment && ((PgBaseSchema)this.getSchema()).getDefTypes().hasChildren())) {
                return;
            }
            ObjectKind objectKind = ObjectKind.OBJECT_ATTRIBUTE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"OBJECT_ATTRIBUTE");
            this.this$0.reportRetrieving(objectKind);
            BaseNativeIntrospector baseNativeIntrospector = (BaseNativeIntrospector)this.this$0;
            PgBaseIntrospector pgBaseIntrospector = this.this$0;
            boolean $i$f$continueOnDbError = false;
            void var4_4 = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl = false;
                List ats = (List)this.performQuery(pgBaseIntrospector.getQueries().getRetrieveStructAttributes());
                if (ats.isEmpty()) {
                    return;
                }
                this.inSchema(arg_0 -> SchemaRetriever.retrieveStructAttributes$lambda$0$0(ats, arg_0));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
        }

        /*
         * WARNING - void declaration
         */
        protected void obtainUsedTypes() {
            void this_$iv;
            BaseNativeIntrospector baseNativeIntrospector = (BaseNativeIntrospector)this.this$0;
            PgBaseIntrospector pgBaseIntrospector = this.this$0;
            boolean $i$f$continueOnDbError = false;
            void var4_4 = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl = false;
                Map typeSpecs = (Map)this.performQuery(pgBaseIntrospector.getQueries().getRetrieveUsedArgumentTypes());
                this.setMyTypes(new HashMap(typeSpecs.size()));
                for (Map.Entry entry : typeSpecs.entrySet()) {
                    DataType type;
                    long typeId = ((Number)entry.getKey()).longValue();
                    String typeSpec = (String)entry.getValue();
                    typeSpec = PgBaseIntrospectorKt.normalizeDataTypeSpec(typeSpec);
                    Intrinsics.checkNotNullExpressionValue((Object)DataTypeFactory.of((String)typeSpec), (String)"of(...)");
                    this.getMyTypes().put(typeId, DasUnresolvedTypeReference.Companion.of(type));
                }
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
        }

        protected void retrieveRoutines(boolean removeUnaffected, boolean detectDropped, boolean loadNew) {
            ObjectKind objectKind = ObjectKind.ROUTINE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"ROUTINE");
            this.this$0.reportRetrieving(objectKind);
            this.inSchema(arg_0 -> SchemaRetriever.retrieveRoutines$lambda$0(removeUnaffected, this, this.this$0, detectDropped, loadNew, arg_0));
        }

        @NotNull
        protected PgBaseRoutine createRoutine(@NotNull S schema, @NotNull PgBaseIntroQueries.OneRoutine r) {
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            BasicModNamedElement basicModNamedElement = schema.getRoutines().renew(r.r_id, r.r_name);
            Intrinsics.checkNotNullExpressionValue((Object)basicModNamedElement, (String)"renew(...)");
            BasicModNamedElement basicModNamedElement2 = basicModNamedElement;
            PgBaseRoutine $this$createRoutine_u24lambda_u240 = (PgBaseRoutine)basicModNamedElement2;
            boolean bl = false;
            $this$createRoutine_u24lambda_u240.setSecurityDefiner(r.is_security_definer);
            if (r.configuration_parameters != null) {
                Intrinsics.checkNotNull((Object)r.configuration_parameters);
                $this$createRoutine_u24lambda_u240.setConfigurationParameters(ArraysKt.toMutableList((Object[])r.configuration_parameters));
            }
            return (PgBaseRoutine)basicModNamedElement2;
        }

        protected void retrieveAggregates(boolean removeUnaffected, boolean detectDropped, boolean loadNew) {
            ObjectKind objectKind = ObjectKind.AGGREGATE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"AGGREGATE");
            this.this$0.reportRetrieving(objectKind);
            this.inSchema(arg_0 -> SchemaRetriever.retrieveAggregates$lambda$0(removeUnaffected, this, this.this$0, detectDropped, loadNew, arg_0));
        }

        protected void processAggregate(@NotNull PgBaseIntroQueries.OneAggregate agg, @NotNull PgBaseAggregate aggregate) {
            Intrinsics.checkNotNullParameter((Object)agg, (String)"agg");
            Intrinsics.checkNotNullParameter((Object)aggregate, (String)"aggregate");
            aggregate.setTransitionRef(this.this$0.createIdOrQNameRef(agg.transition_function_id, agg.transition_function_name, ((PgBaseIntrospector)this.this$0).getDbConnectionInfo().schemaName));
            aggregate.setFinalRef(this.this$0.createIdOrQNameRef(agg.final_function_id, agg.final_function_name, ((PgBaseIntrospector)this.this$0).getDbConnectionInfo().schemaName));
            aggregate.setInitialValue(agg.initial_value);
            DasType dasType = this.getMyTypes().get(agg.transition_type);
            if (dasType == null) {
                dasType = (DasType)DasTypeSystemBase.UNKNOWN;
            }
            aggregate.setTransitionStoredType(dasType);
        }

        protected void retrieveOperators(boolean removeUnaffected, boolean detectDropped, boolean loadNew) {
            ObjectKind objectKind = ObjectKind.OPERATOR;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"OPERATOR");
            this.this$0.reportRetrieving(objectKind);
            this.inSchema(arg_0 -> SchemaRetriever.retrieveOperators$lambda$0(removeUnaffected, this, this.this$0, detectDropped, loadNew, arg_0));
        }

        protected void processOperator(@NotNull PgBaseIntroQueries.OneOperator o, @NotNull PgBaseOperator operator) {
            String string;
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            Intrinsics.checkNotNullParameter((Object)operator, (String)"operator");
            operator.setStateNumber(o.state_number);
            operator.setOperatorKind(PgOperatorKind.of(o.op_kind));
            DasType dasType = o.arg_left_type_id > 0L ? this.getMyTypes().get(o.arg_left_type_id) : null;
            if (dasType == null) {
                dasType = (DasType)DasTypeSystemBase.UNKNOWN;
            }
            operator.setLeftStoredType(dasType);
            DasType dasType2 = o.arg_right_type_id > 0L ? this.getMyTypes().get(o.arg_right_type_id) : null;
            if (dasType2 == null) {
                dasType2 = (DasType)DasTypeSystemBase.UNKNOWN;
            }
            operator.setRightStoredType(dasType2);
            DasType dasType3 = o.arg_result_type_id > 0L ? this.getMyTypes().get(o.arg_result_type_id) : null;
            if (dasType3 == null) {
                dasType3 = (DasType)DasTypeSystemBase.UNKNOWN;
            }
            operator.setResultStoredType(dasType3);
            operator.setCallRoutineRef(this.this$0.createIdOrQNameRef(o.main_id, o.main_name, ((PgBaseIntrospector)this.this$0).getDbConnectionInfo().schemaName));
            String string2 = string = o.join_name;
            long l = o.join_id;
            PgBaseIntrospector pgBaseIntrospector = this.this$0;
            PgBaseOperator pgBaseOperator = operator;
            boolean bl = false;
            boolean bl2 = o.join_id != 0L;
            pgBaseOperator.setJoinRoutineRef(pgBaseIntrospector.createIdOrQNameRef(l, bl2 ? string : null, ((PgBaseIntrospector)this.this$0).getDbConnectionInfo().schemaName));
            String it = string = o.restrict_name;
            l = o.restrict_id;
            pgBaseIntrospector = this.this$0;
            pgBaseOperator = operator;
            boolean bl3 = false;
            bl2 = o.restrict_id != 0L;
            pgBaseOperator.setRestrictRoutineRef(pgBaseIntrospector.createIdOrQNameRef(l, bl2 ? string : null, ((PgBaseIntrospector)this.this$0).getDbConnectionInfo().schemaName));
            it = string = o.neg_name;
            l = o.neg_id;
            pgBaseIntrospector = this.this$0;
            pgBaseOperator = operator;
            boolean bl4 = false;
            bl2 = o.neg_id != 0L;
            pgBaseOperator.setNegateOperatorRef(pgBaseIntrospector.createIdOrQNameRef(l, bl2 ? string : null, ((PgBaseIntrospector)this.this$0).getDbConnectionInfo().schemaName));
            it = string = o.com_name;
            l = o.com_id;
            pgBaseIntrospector = this.this$0;
            pgBaseOperator = operator;
            boolean bl5 = false;
            bl2 = o.com_id != 0L;
            pgBaseOperator.setCommuteOperatorRef(pgBaseIntrospector.createIdOrQNameRef(l, bl2 ? string : null, ((PgBaseIntrospector)this.this$0).getDbConnectionInfo().schemaName));
            operator.setHashes(o.hashes);
            operator.setDetailsLevel(LevelFun.max((Level)operator.getDetailsLevel(), (Level)Level.L2));
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveTableColumns() {
            void this_$iv;
            if (!this.shouldIntrospectTableRelatedData()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.COLUMN;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"COLUMN");
            this.this$0.reportRetrieving(objectKind);
            BaseNativeIntrospector baseNativeIntrospector = (BaseNativeIntrospector)this.this$0;
            PgBaseIntrospector pgBaseIntrospector = this.this$0;
            boolean $i$f$continueOnDbError = false;
            void var4_4 = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl = false;
                List cols = (List)this.performQuery(pgBaseIntrospector.getQueries().getRetrieveColumns());
                if (cols.isEmpty()) {
                    return;
                }
                this.inSchema(arg_0 -> SchemaRetriever.retrieveTableColumns$lambda$0$0(this, cols, arg_0));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
        }

        /*
         * WARNING - void declaration
         */
        protected void processColumns(@NotNull List<PgBaseIntroQueries.OneColumn> cols, @NotNull S schema) {
            void $this$groupByTo$iv$iv;
            Intrinsics.checkNotNullParameter(cols, (String)"cols");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            Iterable $this$groupBy$iv = cols;
            boolean $i$f$groupBy = false;
            Object object = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object2;
                void $this$getOrPut$iv$iv$iv;
                PgBaseIntroQueries.OneColumn it = (PgBaseIntroQueries.OneColumn)element$iv$iv;
                boolean bl = false;
                Long key$iv$iv = it.table_id;
                Map map = destination$iv$iv;
                Long key$iv$iv$iv = key$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            Map $this$forEach$iv = destination$iv$iv;
            boolean $i$f$forEach = false;
            object = $this$forEach$iv.entrySet().iterator();
            while (object.hasNext()) {
                PgBaseLikeStoredTable table;
                Map.Entry element$iv;
                Map.Entry entry = element$iv = (Map.Entry)object.next();
                boolean bl = false;
                if (this.getTableOrView(schema, '\u0000', ((Number)entry.getKey()).longValue()) == null) continue;
                ModFamily $this$modifyAndCleanup_u24default$iv = (ModFamily)table.getColumns();
                boolean removeUnaffected$iv = true;
                boolean $i$f$modifyAndCleanup = false;
                $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
                ModPositioningNamingFamily columns = (ModPositioningNamingFamily)$this$modifyAndCleanup_u24default$iv;
                boolean bl3 = false;
                for (PgBaseIntroQueries.OneColumn col : (List)entry.getValue()) {
                    PgBaseLikeColumn pgBaseLikeColumn;
                    if (col.column_is_dropped) continue;
                    if (col.column_position >= 1) {
                        BasicModElement basicModElement = columns.createOrGetAt(col.column_position);
                        Intrinsics.checkNotNullExpressionValue((Object)basicModElement, (String)"createOrGetAt(...)");
                        pgBaseLikeColumn = (PgBaseLikeColumn)basicModElement;
                    } else {
                        String string = col.column_name;
                        Intrinsics.checkNotNull((Object)string);
                        BasicModNamedElement basicModNamedElement = columns.createOrGet(string);
                        Intrinsics.checkNotNullExpressionValue((Object)basicModNamedElement, (String)"createOrGet(...)");
                        pgBaseLikeColumn = (PgBaseLikeColumn)basicModNamedElement;
                    }
                    PgBaseLikeColumn column = pgBaseLikeColumn;
                    Intrinsics.checkNotNull((Object)columns);
                    this.processColumn(col, column, (ModPositioningNamingFamily<PgBaseLikeColumn>)columns, table);
                }
                $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
                $this$modifyAndCleanup_u24default$iv.sort();
            }
        }

        @Nullable
        protected final <T> T getOrNull(@NotNull Long2ObjectMap<T> $this$getOrNull, long key) {
            Intrinsics.checkNotNullParameter($this$getOrNull, (String)"<this>");
            if ($this$getOrNull.containsKey(key)) {
                return (T)$this$getOrNull.get(key);
            }
            return null;
        }

        protected void processColumn(@NotNull PgBaseIntroQueries.OneColumn col, @NotNull PgBaseLikeColumn column, @NotNull ModPositioningNamingFamily<? extends PgBaseLikeColumn> columns, @NotNull PgBaseLikeStoredTable table) {
            Intrinsics.checkNotNullParameter((Object)col, (String)"col");
            Intrinsics.checkNotNullParameter((Object)column, (String)"column");
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            column.setPosition(col.column_position);
            String string = column.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String oldName = string;
            String string2 = col.column_name;
            if (string2 == null) {
                String string3 = ModelConsts.NO_NAME;
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"NO_NAME");
            }
            String newName = string2;
            RenameInfo renameHandlingRequest = (RenameInfo)this.getOrNull((Long2ObjectMap)this.this$0.getRenameHandlingRequests().get(table.getObjectId()), col.column_position);
            if (renameHandlingRequest != null) {
                ((Long2ObjectMap)this.this$0.getRenameHandlingRequests().get(table.getObjectId())).remove((long)col.column_position);
                this.handleColumnRenaming(table, renameHandlingRequest.getOldName(), renameHandlingRequest.getNewName());
            }
            if (!Intrinsics.areEqual((Object)oldName, (Object)newName)) {
                column.setName(newName);
                if (!Intrinsics.areEqual((Object)oldName, (Object)ModelConsts.NO_NAME)) {
                    if (this.getMode() != IntrospectionMode.FRAGMENT) {
                        this.log.warn("Possible level inconsistency: columns rename detected on L2, but not on L1");
                    }
                    this.handleColumnRenaming(table, oldName, newName);
                }
            }
            column.resetSyncPending();
            column.setStateNumber(col.column_state_number);
            column.setStoredType(PgBaseIntrospectorKt.dasTypeOf(col));
            column.setNotNull(col.mandatory);
            if (column instanceof PgBaseTableColumn) {
                ((PgBaseTableColumn)column).setDefaultExpression(StringKt.nullize$default((String)col.column_default_expression, (boolean)false, (int)1, null));
            }
            column.setNameSurrogate(this.this$0.isColumnNameSurrogate(col.column_name));
        }

        protected char adjustRelKind(char kind, @Nullable String name2) {
            return kind;
        }

        @Nullable
        protected PgBaseLikeStoredTable getTableOrView(@NotNull S schema, char relKind, long tableId) {
            PgBaseLikeStoredTable pgBaseLikeStoredTable;
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            char lowerCaseKind = Character.toLowerCase(relKind);
            if (this.isTableKind(lowerCaseKind)) {
                pgBaseLikeStoredTable = (PgBaseLikeStoredTable)schema.getTables().getByObjectId(tableId);
            } else {
                switch (lowerCaseKind) {
                    case 'v': {
                        pgBaseLikeStoredTable = (PgBaseLikeStoredTable)schema.getViews().getByObjectId(tableId);
                        break;
                    }
                    case 'm': {
                        pgBaseLikeStoredTable = (PgBaseLikeStoredTable)schema.getMatViews().getByObjectId(tableId);
                        break;
                    }
                    case '\u0000': {
                        PgBaseRegularTable pgBaseRegularTable = (PgBaseRegularTable)schema.getTables().getByObjectId(tableId);
                        if (pgBaseRegularTable != null) {
                            pgBaseLikeStoredTable = pgBaseRegularTable;
                            break;
                        }
                        PgBaseView pgBaseView = (PgBaseView)schema.getViews().getByObjectId(tableId);
                        if (pgBaseView != null) {
                            pgBaseLikeStoredTable = pgBaseView;
                            break;
                        }
                        pgBaseLikeStoredTable = (PgBaseLikeStoredTable)schema.getMatViews().getByObjectId(tableId);
                        break;
                    }
                    default: {
                        pgBaseLikeStoredTable = null;
                    }
                }
            }
            return pgBaseLikeStoredTable;
        }

        protected void handleColumnRenaming(@NotNull PgBaseLikeStoredTable table, @NotNull String oldName, @NotNull String tableName) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)oldName, (String)"oldName");
            Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
            ObjectKind objectKind = ObjectKind.KEY;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"KEY");
            this.handleColumnRenaming(table, objectKind, oldName, tableName);
            ObjectKind objectKind2 = ObjectKind.FOREIGN_KEY;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind2, (String)"FOREIGN_KEY");
            this.handleColumnRenaming(table, objectKind2, oldName, tableName);
        }

        protected void handleColumnRenaming(@NotNull PgBaseLikeStoredTable table, @NotNull ObjectKind childrenKind, @NotNull String oldName, @NotNull String newName) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)childrenKind, (String)"childrenKind");
            Intrinsics.checkNotNullParameter((Object)oldName, (String)"oldName");
            Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
            ModFamily f = (ModFamily)table.familyOf(childrenKind);
            if (f != null && f.hasChildren()) {
                for (BasicModElement child : f) {
                    if (!(child instanceof BasicModColumniation)) continue;
                    boolean changed = false;
                    ArrayList<String> names = new ArrayList<String>(((BasicModColumniation)child).getColNames());
                    int n = names.size();
                    for (int i2 = 0; i2 < n; ++i2) {
                        if (!Intrinsics.areEqual(names.get(i2), (Object)oldName)) continue;
                        names.set(i2, newName);
                        changed = true;
                    }
                    if (!changed) continue;
                    ((BasicModColumniation)child).setColNames((List)names);
                    if (child instanceof BasicModNamedElement) {
                        ((BasicModNamedElement)child).setNameSurrogate(this.this$0.isNameSurrogate((BasicModColumniation)child));
                    }
                    if (!Intrinsics.areEqual((Object)childrenKind, (Object)ObjectKind.KEY)) continue;
                    if (table.getSchema() != null) {
                        PgBaseSchema pgBaseSchema;
                        PgBaseIntrospector pgBaseIntrospector = this.this$0;
                        PgBaseSchema it = pgBaseSchema;
                        boolean bl = false;
                        pgBaseIntrospector.affectedKeySchemaIds.add((Object)it.getObjectId());
                    }
                }
            }
        }

        private final void retrieveConstraints(boolean removeUnaffected, boolean detectDropped, boolean loadNew) {
            this.this$0.reportRetrieving("constraints", "introspection.retrieve.constraints");
            Ref.BooleanRef wasKeys = new Ref.BooleanRef();
            this.inSchema(arg_0 -> SchemaRetriever.retrieveConstraints$lambda$0(this, removeUnaffected, this.this$0, detectDropped, loadNew, wasKeys, arg_0));
            if (wasKeys.element) {
                ((Collection)this.this$0.affectedKeySchemaIds).add(((BasicIdentifiedElement)this.getSchema()).getObjectId());
            }
        }

        @NotNull
        protected ModNamingIdentifyingFamily<?>[] constraintFamilies(@NotNull PgBaseTable table) {
            ModNamingIdentifyingFamily[] modNamingIdentifyingFamilyArray;
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            PgBaseRegularTable pgBaseRegularTable = table instanceof PgBaseRegularTable ? (PgBaseRegularTable)table : null;
            if (pgBaseRegularTable != null) {
                PgBaseRegularTable $this$constraintFamilies_u24lambda_u240 = pgBaseRegularTable;
                boolean bl = false;
                ModNamingIdentifyingFamily[] modNamingIdentifyingFamilyArray2 = new ModNamingIdentifyingFamily[2];
                Intrinsics.checkNotNullExpressionValue($this$constraintFamilies_u24lambda_u240.getKeys(), (String)"getKeys(...)");
                Intrinsics.checkNotNullExpressionValue($this$constraintFamilies_u24lambda_u240.getForeignKeys(), (String)"getForeignKeys(...)");
                modNamingIdentifyingFamilyArray = modNamingIdentifyingFamilyArray2;
            } else {
                modNamingIdentifyingFamilyArray = new ModNamingIdentifyingFamily[]{};
            }
            return modNamingIdentifyingFamilyArray;
        }

        protected void processKey(@NotNull PgBaseKey key, @NotNull PgBaseTable table, @NotNull PgBaseIntroQueries.OneConstraint con) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)con, (String)"con");
            key.setPrimary(con.con_kind == 'p');
            key.setStateNumber(con.con_state_id);
            String string = con.con_columns;
            String string2 = "Key " + con.con_name + " column positions";
            ModPositioningNamingFamily<? extends PgBaseTableColumn> modPositioningNamingFamily = table.getColumns();
            Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"getColumns(...)");
            key.setColNames(this.peekColNames(string, string2, (PositioningFamily<BasicTableOrViewColumn>)((PositioningFamily)modPositioningNamingFamily)));
            key.setNameSurrogate(this.this$0.isNameSurrogate((BasicModColumniation)key));
        }

        protected void processCheck(@NotNull PgBaseTable table, @NotNull PgBaseIntroQueries.OneConstraint con) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)con, (String)"con");
        }

        protected void processForeignKey(@NotNull PgBaseForeignKey fkey, @NotNull PgBaseTable table, @NotNull PgBaseIntroQueries.OneConstraint con, @NotNull S schema) {
            Intrinsics.checkNotNullParameter((Object)fkey, (String)"fkey");
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)con, (String)"con");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            fkey.setStateNumber(con.con_state_id);
            fkey.setRefTableRef((BasicReference)BasicIdReference.create((long)con.ref_table_id));
            String string = con.con_columns;
            String string2 = "Foreign key " + con.con_name + " domestic column positions";
            ModPositioningNamingFamily<? extends PgBaseTableColumn> modPositioningNamingFamily = table.getColumns();
            Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"getColumns(...)");
            fkey.setColNames(this.peekColNames(string, string2, (PositioningFamily<BasicTableOrViewColumn>)((PositioningFamily)modPositioningNamingFamily)));
            fkey.setNameSurrogate(this.this$0.isNameSurrogate((BasicModColumniation)fkey));
            List<Short> refColPositions = PgBaseIntrospectorKt.parseArrayOfPositions(con.ref_columns, "Foreign Key " + fkey.getName() + " ref columns");
            fkey.setRefKeyRef((BasicReference)BasicByColumnPositionsReference.create(refColPositions));
        }

        protected boolean hasReference(@NotNull PgBaseIntroQueries.OneConstraint con) {
            Intrinsics.checkNotNullParameter((Object)con, (String)"con");
            return con.ref_table_id > 0L && con.ref_columns != null;
        }

        @NotNull
        protected final List<String> peekColNames(@Nullable String columnPositions, @NotNull String what, @NotNull PositioningFamily<? extends BasicTableOrViewColumn> columns) {
            Intrinsics.checkNotNullParameter((Object)what, (String)"what");
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            List<Short> positions = PgBaseIntrospectorKt.parseArrayOfPositions(columnPositions, what);
            int n = positions.size();
            ArrayList<String> names = new ArrayList<String>(n);
            Iterator<Short> iterator = positions.iterator();
            while (iterator.hasNext()) {
                String it;
                short position = ((Number)iterator.next()).shortValue();
                if (this.getColumnName(columns, position) == null) continue;
                boolean bl = false;
                names.add(it);
            }
            return names;
        }

        @Nullable
        protected final String getColumnName(@NotNull PositioningFamily<? extends BasicTableOrViewColumn> $this$getColumnName, short position) {
            Intrinsics.checkNotNullParameter($this$getColumnName, (String)"<this>");
            return this.this$0.getHelper().getColumnName($this$getColumnName, position);
        }

        /*
         * WARNING - void declaration
         */
        protected void retrieveDescriptions(boolean removeUnaffected, boolean detectDropped, boolean loadNew, @Nullable ObjectKind fragmentKind) {
            this.this$0.reportRetrieving("comments", "introspection.retrieve.comments");
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)this.this$0;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl = false;
                this.inSchema(arg_0 -> SchemaRetriever.retrieveDescriptions$lambda$0$0(fragmentKind, this, detectDropped, loadNew, arg_0));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveDescriptionsForFragmentKind(S schema, ObjectKind fragmentKind) {
            void $this$forEach$iv;
            void $this$groupByTo$iv$iv;
            List<PgBaseIntroQueries.OneComment> rows = this.retrieveDescriptionRows();
            Object $this$groupBy$iv = rows;
            boolean $i$f$groupBy = false;
            Object object = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object2;
                void $this$getOrPut$iv$iv$iv;
                PgBaseIntroQueries.OneComment it = (PgBaseIntroQueries.OneComment)element$iv$iv;
                boolean bl = false;
                Long key$iv$iv = it.id;
                Map map = destination$iv$iv;
                Long key$iv$iv$iv = key$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            $this$groupBy$iv = destination$iv$iv;
            boolean $i$f$forEach = false;
            object = $this$forEach$iv.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry element$iv;
                Map.Entry it = element$iv = (Map.Entry)object.next();
                boolean bl = false;
                this.processDescription(schema, it);
            }
        }

        @NotNull
        protected List<PgBaseIntroQueries.OneComment> retrieveDescriptionRows() {
            return new ArrayList();
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveDescriptionsBulk(boolean detectDropped, boolean loadNew, S schema) {
            if (detectDropped) {
                Long2ObjectMap<Short[]> existentComments = this.listExistentComments();
                this.removeDroppedComments(existentComments, null);
            }
            if (loadNew) {
                void $this$forEach$iv;
                void $this$groupByTo$iv$iv;
                Object $this$groupBy$iv = (Iterable)this.performQuery(this.this$0.getQueries().getRetrieveSchemaComments());
                boolean $i$f$groupBy = false;
                Object object = $this$groupBy$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                    Object object2;
                    void $this$getOrPut$iv$iv$iv;
                    PgBaseIntroQueries.OneComment it = (PgBaseIntroQueries.OneComment)element$iv$iv;
                    boolean bl = false;
                    Long key$iv$iv = it.id;
                    Map map = destination$iv$iv;
                    Long key$iv$iv$iv = key$iv$iv;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl2 = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                        object2 = answer$iv$iv$iv;
                    } else {
                        object2 = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object2;
                    list$iv$iv.add(element$iv$iv);
                }
                $this$groupBy$iv = destination$iv$iv;
                boolean $i$f$forEach = false;
                object = $this$forEach$iv.entrySet().iterator();
                while (object.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry it = element$iv = (Map.Entry)object.next();
                    boolean bl = false;
                    this.processDescription(schema, it);
                }
            }
        }

        private final void processDescription(S schema, Map.Entry<Long, ? extends List<PgBaseIntroQueries.OneComment>> descriptions) {
            BasicElement basicElement = this.findObjectById(schema, ((PgBaseIntroQueries.OneComment)CollectionsKt.first(descriptions.getValue())).kind, ((Number)descriptions.getKey()).longValue());
            if (basicElement == null) {
                return;
            }
            BasicElement obj = basicElement;
            Iterable $this$forEach$iv = descriptions.getValue();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BasicModNamedElement target;
                PgBaseIntroQueries.OneComment it = (PgBaseIntroQueries.OneComment)element$iv;
                boolean bl = false;
                BasicModNamedElement basicModNamedElement = target = it.sub_id == 0 ? (obj instanceof BasicModNamedElement ? (BasicModNamedElement)obj : null) : (obj instanceof BasicModLikeTable ? (BasicModNamedElement)((BasicModLikeTable)obj).getColumns().getByNaturalPosition(it.sub_id) : (obj instanceof PgBaseDefType ? (BasicModNamedElement)((PgBaseDefType)obj).getAttributes().getByNaturalPosition(it.sub_id) : null));
                if (basicModNamedElement == null) continue;
                basicModNamedElement.setComment(it.description);
            }
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @Nullable
        protected BasicElement findObjectById(@NotNull S schema, @Nullable Character kind, long id) {
            BasicIdentifiedElement basicIdentifiedElement;
            void $this$findById$iv;
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            BasicSchema basicSchema = (BasicSchema)schema;
            long objectId$iv = id;
            boolean $i$f$findById = false;
            BasicDatabase basicDatabase = $this$findById$iv.getDatabase();
            if (basicDatabase != null) {
                Function1 function1;
                void $this$findAllById$iv$iv;
                BasicDatabase basicDatabase2 = basicDatabase;
                long objectId$iv$iv = objectId$iv;
                boolean $i$f$findAllById = false;
                JBIterable jBIterable = JBIterable.from((Iterable)$this$findAllById$iv$iv.findIdentifiedElements(objectId$iv$iv)).filter(BasicIdentifiedElement.class);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
                basicDatabase = jBIterable;
                if (jBIterable != null && (basicDatabase = basicDatabase.filter(new Condition(function1 = (Function1)new Function1<BasicIdentifiedElement, Boolean>((BasicSchema)$this$findById$iv){
                    final /* synthetic */ BasicSchema $this_findById;
                    {
                        this.$this_findById = $receiver;
                    }

                    public final Boolean invoke(BasicIdentifiedElement it) {
                        return Intrinsics.areEqual((Object)((BasicMixinElement)it).getSchema(), (Object)this.$this_findById);
                    }
                }){
                    private final /* synthetic */ Function1 function;
                    {
                        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                        this.function = function;
                    }

                    public final /* synthetic */ boolean value(Object p0) {
                        return (Boolean)this.function.invoke(p0);
                    }
                })) != null) {
                    basicIdentifiedElement = (BasicIdentifiedElement)basicDatabase.first();
                    return (BasicElement)basicIdentifiedElement;
                }
            }
            basicIdentifiedElement = null;
            return (BasicElement)basicIdentifiedElement;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final void retrieveViewSources() {
            void this_$iv;
            if (!this.getWithSources()) {
                return;
            }
            this.setQueryParameter("INCSRC", this.getMode().increment && this.incrementalViewSources());
            this.this$0.reportRetrieving("view sources", "introspection.retrieve.view.sources");
            BaseNativeIntrospector baseNativeIntrospector = (BaseNativeIntrospector)this.this$0;
            PgBaseIntrospector pgBaseIntrospector = this.this$0;
            boolean $i$f$continueOnDbError = false;
            void var4_4 = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                void this_$iv$iv$iv;
                DiagnosticSectionReference sectionReference$iv$iv$iv;
                void $this$iv$iv$iv;
                void this_$iv$iv;
                boolean bl = false;
                BaseNativeIntrospector this_$iv2 = (BaseNativeIntrospector)pgBaseIntrospector;
                boolean $i$f$writeSources = false;
                BaseIntrospector baseIntrospector = (BaseIntrospector)this_$iv2;
                String name$iv$iv = "WriteSources";
                boolean $i$f$doSection = false;
                void var13_13 = this_$iv$iv;
                String name$iv$iv$iv = name$iv$iv;
                CharSequence message$iv$iv$iv = null;
                boolean $i$f$logSectionBegin = false;
                DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)$this$iv$iv$iv);
                DiagnosticSectionReference ref$iv$iv = dataSourceDiagnosticRecorder != null ? dataSourceDiagnosticRecorder.recordSectionBegin(name$iv$iv$iv, message$iv$iv$iv) : null;
                try {
                    boolean bl2 = false;
                    this_$iv2.getModel().writeSources(new Runnable(this, pgBaseIntrospector){
                        final /* synthetic */ SchemaRetriever this$0;
                        final /* synthetic */ PgBaseIntrospector this$1$inlined;
                        {
                            this.this$0 = schemaRetriever;
                            this.this$1$inlined = pgBaseIntrospector;
                        }

                        public final void run() {
                            boolean bl = false;
                            SchemaRetriever.access$inSchema(this.this$0, (Function1)new Function1<S, Unit>(this.this$0, this.this$1$inlined){
                                final /* synthetic */ SchemaRetriever<S> this$0;
                                final /* synthetic */ PgBaseIntrospector<MR, D, SL> this$1;
                                {
                                    this.this$0 = $receiver;
                                    this.this$1 = $receiver2;
                                }

                                public final void invoke(S schema) {
                                    Intrinsics.checkNotNullParameter(schema, (String)"schema");
                                    BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default((BaseNativeIntrospector.AbstractRetriever)((BaseNativeIntrospector.AbstractRetriever)this.this$0), this.this$1.getQueries().getRetrieveViewSources(), (int)0, (Function1)((Function1)new Function1<PgBaseIntroQueries.OneViewSource, Unit>(this.this$0, schema){
                                        final /* synthetic */ SchemaRetriever<S> this$0;
                                        final /* synthetic */ S $schema;
                                        {
                                            this.this$0 = $receiver;
                                            this.$schema = $schema;
                                        }

                                        public final void invoke(PgBaseIntroQueries.OneViewSource vs) {
                                            Intrinsics.checkNotNullParameter((Object)vs, (String)"vs");
                                            PgBaseLikeStoredTable view = this.this$0.getTableOrView(this.$schema, this.this$0.adjustRelKind(vs.view_kind, vs.view_name), vs.view_id);
                                            String sourceText = vs.source_text;
                                            this.this$0.processViewSource(view, sourceText);
                                        }
                                    }), (int)2, null);
                                }
                            });
                        }
                    });
                    $this$iv$iv$iv = this_$iv$iv;
                    sectionReference$iv$iv$iv = ref$iv$iv;
                    boolean $i$f$logSectionEnd = false;
                    if (sectionReference$iv$iv$iv == null) return;
                }
                catch (Throwable throwable) {
                    void this_$iv$iv$iv2;
                    sectionReference$iv$iv$iv = this_$iv$iv;
                    DiagnosticSectionReference sectionReference$iv$iv$iv2 = ref$iv$iv;
                    boolean $i$f$logSectionEnd = false;
                    if (sectionReference$iv$iv$iv2 == null) throw throwable;
                    DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder2 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv$iv2);
                    if (dataSourceDiagnosticRecorder2 == null) throw throwable;
                    DataSourceDiagnosticRecorder.recordSectionEnd$default((DataSourceDiagnosticRecorder)dataSourceDiagnosticRecorder2, (DiagnosticSectionReference)sectionReference$iv$iv$iv2, null, (int)2, null);
                    throw throwable;
                }
                DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder3 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv$iv);
                if (dataSourceDiagnosticRecorder3 == null) return;
                DataSourceDiagnosticRecorder.recordSectionEnd$default((DataSourceDiagnosticRecorder)dataSourceDiagnosticRecorder3, (DiagnosticSectionReference)sectionReference$iv$iv$iv, null, (int)2, null);
                return;
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
        }

        protected void processViewSource(@Nullable PgBaseLikeStoredTable view, @Nullable String sourceText) {
            block2: {
                if (view instanceof PgBaseView) {
                    this.applyViewSourceText((PgBaseSourceAware)((Object)view), sourceText);
                }
                if (view instanceof PgBaseMatView) {
                    this.applyViewSourceText((PgBaseSourceAware)((Object)view), sourceText);
                }
                PgBaseLikeStoredTable pgBaseLikeStoredTable = view;
                if (pgBaseLikeStoredTable == null) break block2;
                pgBaseLikeStoredTable.setDetailsLevel(Level.L3);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void retrieveFunSources() {
            void this_$iv;
            if (!this.getWithSources()) {
                return;
            }
            this.this$0.reportRetrieving("functions' sources", "introspection.retrieve.routine.sources");
            BaseNativeIntrospector baseNativeIntrospector = (BaseNativeIntrospector)this.this$0;
            PgBaseIntrospector pgBaseIntrospector = this.this$0;
            boolean $i$f$continueOnDbError = false;
            void var4_4 = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                void this_$iv$iv$iv;
                DiagnosticSectionReference sectionReference$iv$iv$iv;
                void $this$iv$iv$iv;
                void this_$iv$iv;
                boolean bl = false;
                BaseNativeIntrospector this_$iv2 = (BaseNativeIntrospector)pgBaseIntrospector;
                boolean $i$f$writeSources = false;
                BaseIntrospector baseIntrospector = (BaseIntrospector)this_$iv2;
                String name$iv$iv = "WriteSources";
                boolean $i$f$doSection = false;
                void var13_13 = this_$iv$iv;
                String name$iv$iv$iv = name$iv$iv;
                CharSequence message$iv$iv$iv = null;
                boolean $i$f$logSectionBegin = false;
                DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)$this$iv$iv$iv);
                DiagnosticSectionReference ref$iv$iv = dataSourceDiagnosticRecorder != null ? dataSourceDiagnosticRecorder.recordSectionBegin(name$iv$iv$iv, message$iv$iv$iv) : null;
                try {
                    boolean bl2 = false;
                    this_$iv2.getModel().writeSources(new Runnable(this, pgBaseIntrospector){
                        final /* synthetic */ SchemaRetriever this$0;
                        final /* synthetic */ PgBaseIntrospector this$1$inlined;
                        {
                            this.this$0 = schemaRetriever;
                            this.this$1$inlined = pgBaseIntrospector;
                        }

                        public final void run() {
                            boolean bl = false;
                            SchemaRetriever.access$inSchema(this.this$0, (Function1)new Function1<S, Unit>(this.this$0, this.this$1$inlined){
                                final /* synthetic */ SchemaRetriever<S> this$0;
                                final /* synthetic */ PgBaseIntrospector<MR, D, SL> this$1;
                                {
                                    this.this$0 = $receiver;
                                    this.this$1 = $receiver2;
                                }

                                public final void invoke(S schema) {
                                    Intrinsics.checkNotNullParameter(schema, (String)"schema");
                                    BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default((BaseNativeIntrospector.AbstractRetriever)((BaseNativeIntrospector.AbstractRetriever)this.this$0), this.this$1.getQueries().getRetrieveFunctionSources(), (int)0, (Function1)((Function1)new Function1<PgBaseIntroQueries.OneFunctionSource, Unit>(schema, this.this$0){
                                        final /* synthetic */ S $schema;
                                        final /* synthetic */ SchemaRetriever<S> this$0;
                                        {
                                            this.$schema = $schema;
                                            this.this$0 = $receiver;
                                        }

                                        public final void invoke(PgBaseIntroQueries.OneFunctionSource fs) {
                                            Intrinsics.checkNotNullParameter((Object)fs, (String)"fs");
                                            PgBaseRoutine pgBaseRoutine = (PgBaseRoutine)this.$schema.getRoutines().getByObjectId(fs.id);
                                            if (pgBaseRoutine == null) {
                                                return;
                                            }
                                            PgBaseRoutine function = pgBaseRoutine;
                                            SchemaRetriever.access$processFunSource(this.this$0, function, fs);
                                        }
                                    }), (int)2, null);
                                }
                            });
                        }
                    });
                    $this$iv$iv$iv = this_$iv$iv;
                    sectionReference$iv$iv$iv = ref$iv$iv;
                    boolean $i$f$logSectionEnd = false;
                    if (sectionReference$iv$iv$iv == null) return;
                }
                catch (Throwable throwable) {
                    void this_$iv$iv$iv2;
                    sectionReference$iv$iv$iv = this_$iv$iv;
                    DiagnosticSectionReference sectionReference$iv$iv$iv2 = ref$iv$iv;
                    boolean $i$f$logSectionEnd = false;
                    if (sectionReference$iv$iv$iv2 == null) throw throwable;
                    DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder2 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv$iv2);
                    if (dataSourceDiagnosticRecorder2 == null) throw throwable;
                    DataSourceDiagnosticRecorder.recordSectionEnd$default((DataSourceDiagnosticRecorder)dataSourceDiagnosticRecorder2, (DiagnosticSectionReference)sectionReference$iv$iv$iv2, null, (int)2, null);
                    throw throwable;
                }
                DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder3 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv$iv);
                if (dataSourceDiagnosticRecorder3 == null) return;
                DataSourceDiagnosticRecorder.recordSectionEnd$default((DataSourceDiagnosticRecorder)dataSourceDiagnosticRecorder3, (DiagnosticSectionReference)sectionReference$iv$iv$iv, null, (int)2, null);
                return;
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
        }

        private final void processFunSource(PgBaseRoutine function, PgBaseIntroQueries.OneFunctionSource fs) {
            this.processFunSourceAttributes(function, fs);
            function.setSourceText(this.getFunSourceText(fs));
            function.setDetailsLevel(Level.L3);
        }

        protected void processFunSourceAttributes(@NotNull PgBaseRoutine function, @NotNull PgBaseIntroQueries.OneFunctionSource fs) {
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            Intrinsics.checkNotNullParameter((Object)fs, (String)"fs");
            function.setArgumentsDefinition(StringKt.nullize((String)fs.arguments_def, (boolean)true));
            function.setResultsDefinition(StringKt.nullize((String)fs.result_def, (boolean)true));
        }

        @Nullable
        protected CompositeText getFunSourceText(@NotNull PgBaseIntroQueries.OneFunctionSource fs) {
            Intrinsics.checkNotNullParameter((Object)fs, (String)"fs");
            String string = fs.source_text;
            return (CompositeText)(string != null ? BaseIntrospectionFunctions.toCompositeText((String)string, (CompositeText.Kind)CompositeText.Kind.ORIGINAL_TEXT) : null);
        }

        private final void applyViewSourceText(PgBaseSourceAware $this$applyViewSourceText, String sourceText) {
            CharSequence charSequence = sourceText;
            if (charSequence == null || charSequence.length() == 0) {
                $this$applyViewSourceText.setSourceText(null);
                return;
            }
            String body = PgBaseIntrospectorKt.removeSuffix(((Object)StringsKt.trim((CharSequence)sourceText)).toString(), ';');
            $this$applyViewSourceText.setSourceText((CompositeText)BaseIntrospectionFunctions.toCompositeText((String)body, (CompositeText.Kind)CompositeText.Kind.DECOMPILED_TEXT));
        }

        protected final boolean shouldIntrospectTableRelatedData() {
            return this.wasDataTables() || this.getMode().increment && this.shouldIntrospectTableRelatedDataIncremental();
        }

        protected boolean shouldIntrospectTableRelatedDataIncremental() {
            return ((PgBaseSchema)this.getSchema()).getTables().hasChildren();
        }

        protected boolean wasDataTables() {
            return this.wasTables || this.wasViews || this.wasMatViews;
        }

        protected abstract void processModView(@NotNull PgBaseLikeStoredTable var1, @NotNull PgBaseIntroQueries.OneTable var2);

        protected abstract void processModTable(@NotNull PgBaseTable var1, @NotNull PgBaseIntroQueries.OneTable var2);

        private static final Unit removeDroppedComments$lambda$0(String[] $fragmentNames, ObjectKind $fragmentKind, SchemaRetriever this$0, Long2ObjectMap $existentComments, PgBaseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            for (ModFamily f : schema.getFamilies()) {
                if (!f.getMetaObject().kindOf(BasicModIdentifiedElement.class)) continue;
                for (BasicModElement c : f) {
                    Intrinsics.checkNotNull((Object)c, (String)"null cannot be cast to non-null type com.intellij.database.model.basic.BasicModIdentifiedElement");
                    BasicModIdentifiedElement cfr_ignored_0 = (BasicModIdentifiedElement)c;
                    if ($fragmentNames != null && (!Intrinsics.areEqual((Object)((BasicModIdentifiedElement)c).getKind(), (Object)$fragmentKind) || !ArraysKt.contains((Object[])$fragmentNames, (Object)((BasicModIdentifiedElement)c).getName()))) continue;
                    this$0.removeComments((Long2ObjectMap<Short[]>)$existentComments, (BasicModIdentifiedElement)c);
                }
            }
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$0(SchemaRetriever this$0, IntroModeCtx $this$add) {
            Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
            IntroGuidance $this$steps_u24lambda_u240_u240 = $this$add.getGuidanceForMajors();
            boolean bl = false;
            this$0.retrieveDataTypes($this$steps_u24lambda_u240_u240.getRemoveUnaffected(), $this$steps_u24lambda_u240_u240.getDetectDropped(), $this$steps_u24lambda_u240_u240.getLoadNew());
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$1(SchemaRetriever this$0, IntroModeCtx $this$add) {
            Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
            IntroGuidance $this$steps_u24lambda_u241_u240 = $this$add.getGuidanceForMajors();
            boolean bl = false;
            this$0.retrieveTables($this$steps_u24lambda_u241_u240.getRemoveUnaffected(), $this$steps_u24lambda_u241_u240.getDetectDropped(), $this$steps_u24lambda_u241_u240.getLoadNew());
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$2(SchemaRetriever this$0, IntroModeCtx $this$add) {
            Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
            if ($this$add.getGuidanceForFetchingAll().getLoadNew()) {
                this$0.obtainUsedTypes();
            }
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$3(SchemaRetriever this$0, IntroModeCtx $this$add) {
            Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
            IntroGuidance $this$steps_u24lambda_u243_u240 = $this$add.getGuidanceForMajors();
            boolean bl = false;
            this$0.retrieveRoutines($this$steps_u24lambda_u243_u240.getRemoveUnaffected(), $this$steps_u24lambda_u243_u240.getDetectDropped(), $this$steps_u24lambda_u243_u240.getLoadNew());
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$4(SchemaRetriever this$0, IntroModeCtx $this$add) {
            Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
            IntroGuidance $this$steps_u24lambda_u244_u240 = $this$add.getGuidanceForMajors();
            boolean bl = false;
            this$0.retrieveAggregates($this$steps_u24lambda_u244_u240.getRemoveUnaffected(), $this$steps_u24lambda_u244_u240.getDetectDropped(), $this$steps_u24lambda_u244_u240.getLoadNew());
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$5(SchemaRetriever this$0, IntroModeCtx $this$add) {
            Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
            IntroGuidance $this$steps_u24lambda_u245_u240 = $this$add.getGuidanceForMajors();
            boolean bl = false;
            this$0.retrieveOperators($this$steps_u24lambda_u245_u240.getRemoveUnaffected(), $this$steps_u24lambda_u245_u240.getDetectDropped(), $this$steps_u24lambda_u245_u240.getLoadNew());
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$6(SchemaRetriever this$0, IntroModeCtx $this$add) {
            Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
            if ($this$add.getGuidanceForFetchingAll().getLoadNew()) {
                this$0.retrieveStructAttributes();
            }
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$7(SchemaRetriever this$0, IntroModeCtx $this$add) {
            Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
            if ($this$add.getGuidanceForFetchingAll().getLoadNew()) {
                this$0.retrieveTableColumns();
            }
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$8(SchemaRetriever this$0, IntroModeCtx $this$add) {
            Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
            IntroGuidance $this$steps_u24lambda_u248_u240 = $this$add.getGuidanceForMinors();
            boolean bl = false;
            this$0.retrieveConstraints($this$steps_u24lambda_u248_u240.getRemoveUnaffected(), $this$steps_u24lambda_u248_u240.getDetectDropped(), $this$steps_u24lambda_u248_u240.getLoadNew());
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$9(SchemaRetriever this$0, IntroModeCtx $this$add) {
            Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
            IntroGuidance $this$steps_u24lambda_u249_u240 = $this$add.getGuidanceForMinors();
            boolean bl = false;
            this$0.retrieveDescriptions($this$steps_u24lambda_u249_u240.getRemoveUnaffected(), $this$steps_u24lambda_u249_u240.getDetectDropped(), $this$steps_u24lambda_u249_u240.getLoadNew(), $this$add.getFragmentKind());
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$10(SchemaRetriever this$0, IntroModeCtx $this$add) {
            Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
            IntroGuidance $this$steps_u24lambda_u2410_u240 = $this$add.getGuidanceForMinors();
            boolean bl = false;
            this$0.retrieveAcls($this$steps_u24lambda_u2410_u240.getRemoveUnaffected(), $this$steps_u24lambda_u2410_u240.getDetectDropped(), $this$steps_u24lambda_u2410_u240.getLoadNew());
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$11(SchemaRetriever this$0, IntroModeCtx $this$add) {
            Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
            if ($this$add.getGuidanceForFetchingAll().getLoadNew() || !this$0.incrementalViewSources()) {
                this$0.retrieveViewSources();
            }
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$12(SchemaRetriever this$0, IntroModeCtx $this$add) {
            Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
            if ($this$add.getGuidanceForFetchingAll().getLoadNew()) {
                this$0.retrieveFunSources();
            }
            return Unit.INSTANCE;
        }

        private static final boolean retrieveAcls$lambda$0$3$0(PgBaseIntroQueries.OneAcl $acl, PgObjectGrant it) {
            return it.getObjectId() == $acl.object_id && !it.isSub();
        }

        private static final boolean retrieveAcls$lambda$0$3$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean retrieveAcls$lambda$0$0(Grants.Controller $ctl, SchemaRetriever this$0, PgObjectGrant it) {
            Grants.Grant grant = it;
            BasicElement basicElement = (BasicElement)this$0.getSchema();
            BasicResolveAssistant basicResolveAssistant = BasicResolveAssistant.DEFAULT;
            Intrinsics.checkNotNullExpressionValue((Object)basicResolveAssistant, (String)"DEFAULT");
            return $ctl.findTarget(grant, basicElement, basicResolveAssistant) == null;
        }

        private static final boolean retrieveAcls$lambda$0$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final Unit retrieveAcls$lambda$0$3(List $newGrants, PgBaseIntrospector this$0, Lexer $lexer, NamingService $ns, PgBaseIntroQueries.OneAcl acl) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)acl, (String)"acl");
                $newGrants.removeIf(arg_0 -> SchemaRetriever.retrieveAcls$lambda$0$3$1(arg_0 -> SchemaRetriever.retrieveAcls$lambda$0$3$0(acl, arg_0), arg_0));
                if (acl.acl == null) break block1;
                String[] $this$forEach$iv = acl.acl;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int j = 0; j < n; ++j) {
                    String element$iv;
                    String it = element$iv = $this$forEach$iv[j];
                    boolean bl = false;
                    PgAclItem pgAclItem = this$0.parseAclItem($lexer, $ns, it);
                    if (pgAclItem == null) continue;
                    pgAclItem.toGrants(acl.object_id, $newGrants);
                }
            }
            return Unit.INSTANCE;
        }

        private static final boolean retrieveColumnAcl$lambda$1$0$0$0(PgBaseIntroQueries.AttrAcl $acl, int n) {
            return n == $acl.attr_position;
        }

        private static final boolean retrieveColumnAcl$lambda$1$0$0(PgBaseIntroQueries.AttrAcl $acl, PgObjectGrant it) {
            Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
            return it.getObjectId() == $acl.object_id && it.isSub() && it.getSubsStream().allMatch(arg_0 -> SchemaRetriever.retrieveColumnAcl$lambda$1$0$0$0($acl, arg_0));
        }

        private static final boolean retrieveColumnAcl$lambda$1$0$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final Unit retrieveColumnAcl$lambda$1$0(List $newGrants, ArrayList $columns, SchemaRetriever this$0, PgBaseIntroQueries.AttrAcl acl) {
            Intrinsics.checkNotNullParameter((Object)acl, (String)"acl");
            $newGrants.removeIf(arg_0 -> SchemaRetriever.retrieveColumnAcl$lambda$1$0$1(arg_0 -> SchemaRetriever.retrieveColumnAcl$lambda$1$0$0(acl, arg_0), arg_0));
            PgBaseIntroQueries.AttrAcl attrAcl = (PgBaseIntroQueries.AttrAcl)CollectionsKt.firstOrNull((List)$columns);
            if (!(attrAcl != null ? attrAcl.object_id == acl.object_id : false)) {
                this$0.toGrants($columns, $newGrants);
                $columns.clear();
            }
            ((Collection)$columns).add(acl);
            return Unit.INSTANCE;
        }

        private static final PgAclItem toGrants$lambda$0$0(PgBaseIntrospector this$0, Lexer $lexer, NamingService $ns, String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return this$0.parseAclItem($lexer, $ns, it);
        }

        private static final kotlin.Pair toGrants$lambda$0$1(PgBaseIntroQueries.AttrAcl $a, PgAclItem it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new kotlin.Pair((Object)$a.attr_position, (Object)it);
        }

        private static final Sequence toGrants$lambda$0(PgBaseIntrospector this$0, Lexer $lexer, NamingService $ns, PgBaseIntroQueries.AttrAcl a) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            String[] stringArray = a.acl;
            if (stringArray == null || (stringArray = SequenceFun.asSequence((Object[])stringArray)) == null || (stringArray = SequencesKt.mapNotNull((Sequence)((Sequence)stringArray), arg_0 -> SchemaRetriever.toGrants$lambda$0$0(this$0, $lexer, $ns, arg_0))) == null || (stringArray = SequencesKt.map((Sequence)stringArray, arg_0 -> SchemaRetriever.toGrants$lambda$0$1(a, arg_0))) == null) {
                stringArray = SequencesKt.emptySequence();
            }
            return stringArray;
        }

        private static final Unit retrieveDataTypes$lambda$0$0$0$1(ModNamingIdentifyingFamily $defTypes, SchemaRetriever this$0, PgBaseSchema $sc, PgBaseIntroQueries.OneDataType dt) {
            Intrinsics.checkNotNullParameter((Object)dt, (String)"dt");
            BasicModNamedElement basicModNamedElement = $defTypes.renew(dt.type_id, dt.type_name);
            Intrinsics.checkNotNullExpressionValue((Object)basicModNamedElement, (String)"renew(...)");
            PgBaseDefType dataType = (PgBaseDefType)basicModNamedElement;
            this$0.processDataType(dataType, dt, $sc);
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveDataTypes$lambda$0(boolean $removeUnaffected, SchemaRetriever this$0, PgBaseIntrospector this$1, boolean $detectDropped, boolean $loadNew, PgBaseSchema sc) {
            Intrinsics.checkNotNullParameter((Object)sc, (String)"sc");
            ModNamingFamily modNamingFamily = (ModNamingFamily)sc.getDefTypes();
            boolean bl = $removeUnaffected;
            String[] fragments$iv = this$0.getFragmentNamesOrNull();
            boolean $i$f$modifyAndCleanup = false;
            if (fragments$iv == null) {
                void $this$modifyAndCleanup$iv$iv;
                ModFamily modFamily = (ModFamily)$this$modifyAndCleanup$iv;
                void removeUnaffected$iv$iv = removeUnaffected$iv;
                boolean $i$f$modifyAndCleanup2 = false;
                if (removeUnaffected$iv$iv != false) {
                    $this$modifyAndCleanup$iv$iv.markChildrenAsSyncPending();
                }
                ModNamingIdentifyingFamily defTypes = (ModNamingIdentifyingFamily)$this$modifyAndCleanup$iv$iv;
                boolean bl2 = false;
                BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)this$1;
                boolean $i$f$continueOnDbError = false;
                BaseNativeIntrospector baseNativeIntrospector = this_$iv;
                Object whatsDoing$iv$iv = null;
                boolean $i$f$continueOnDbError2 = false;
                try {
                    boolean bl3 = false;
                    if ($detectDropped) {
                        long[] $this$forEach$iv = (long[])this$0.performQuery(this$1.getQueries().getRetrieveExistentDataTypes());
                        boolean $i$f$forEach = false;
                        int n = $this$forEach$iv.length;
                        for (int j = 0; j < n; ++j) {
                            long element$iv;
                            long it = element$iv = $this$forEach$iv[j];
                            boolean bl4 = false;
                            PgBaseDefType pgBaseDefType = (PgBaseDefType)defTypes.getByObjectId(it);
                            if (pgBaseDefType != null) {
                                ((BasicModMixinElement)pgBaseDefType).resetSyncPending();
                            }
                        }
                    }
                    if ($loadNew) {
                        BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default((BaseNativeIntrospector.AbstractRetriever)((BaseNativeIntrospector.AbstractRetriever)this$0), this$1.getQueries().getRetrieveDataTypes(), (int)0, arg_0 -> SchemaRetriever.retrieveDataTypes$lambda$0$0$0$1(defTypes, this$0, sc, arg_0), (int)2, null);
                    }
                }
                catch (DBException e$iv$iv) {
                    StringBuilder stringBuilder;
                    void this_$iv$iv;
                    boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                    StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                    boolean bl5 = false;
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                    String message$iv$iv = stringBuilder.toString();
                    if (expected$iv$iv) {
                        this_$iv$iv.trace(message$iv$iv);
                    } else {
                        IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                    }
                    this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
                }
                if (removeUnaffected$iv$iv != false) {
                    $this$modifyAndCleanup$iv$iv.removeSyncPendingChildren();
                }
                $this$modifyAndCleanup$iv$iv.sort();
            } else {
                if (removeUnaffected$iv != false) {
                    for (String fragment$iv : fragments$iv) {
                        BasicModNamedElement $this$modifyAndCleanup_u24lambda_u240$iv;
                        if ((BasicModNamedElement)$this$modifyAndCleanup$iv.get(fragment$iv) == null) continue;
                        boolean bl6 = false;
                        $this$modifyAndCleanup_u24lambda_u240$iv.setSyncPending(true);
                    }
                }
                ModNamingIdentifyingFamily defTypes = (ModNamingIdentifyingFamily)$this$modifyAndCleanup$iv;
                boolean bl7 = false;
                BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)this$1;
                boolean $i$f$continueOnDbError = false;
                BaseNativeIntrospector this_$iv$iv = this_$iv;
                Object whatsDoing$iv$iv = null;
                boolean $i$f$continueOnDbError3 = false;
                try {
                    boolean bl8 = false;
                    if ($detectDropped) {
                        long[] $this$forEach$iv = (long[])this$0.performQuery(this$1.getQueries().getRetrieveExistentDataTypes());
                        boolean $i$f$forEach = false;
                        int n = $this$forEach$iv.length;
                        for (int j = 0; j < n; ++j) {
                            long element$iv;
                            long it = element$iv = $this$forEach$iv[j];
                            boolean bl9 = false;
                            PgBaseDefType pgBaseDefType = (PgBaseDefType)defTypes.getByObjectId(it);
                            if (pgBaseDefType != null) {
                                ((BasicModMixinElement)pgBaseDefType).resetSyncPending();
                            }
                        }
                    }
                    if ($loadNew) {
                        BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default((BaseNativeIntrospector.AbstractRetriever)((BaseNativeIntrospector.AbstractRetriever)this$0), this$1.getQueries().getRetrieveDataTypes(), (int)0, arg_0 -> SchemaRetriever.retrieveDataTypes$lambda$0$0$0$1(defTypes, this$0, sc, arg_0), (int)2, null);
                    }
                }
                catch (DBException e$iv$iv) {
                    StringBuilder stringBuilder;
                    boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                    StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                    boolean bl10 = false;
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                    String message$iv$iv = stringBuilder.toString();
                    if (expected$iv$iv) {
                        this_$iv$iv.trace(message$iv$iv);
                    } else {
                        IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                    }
                    this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
                }
                if (removeUnaffected$iv != false) {
                    $this$modifyAndCleanup$iv.removeSyncPendingChildren();
                }
                $this$modifyAndCleanup$iv.sort();
            }
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveTables$lambda$0(SchemaRetriever this$0, boolean $removeUnaffected, PgBaseIntrospector this$1, boolean $detectDropped, boolean $loadNew, PgBaseSchema sc) {
            Intrinsics.checkNotNullParameter((Object)sc, (String)"sc");
            ModNamingIdentifyingFamily<PgBaseLikeStoredTable>[] fTables = this$0.tableFamilies(sc);
            boolean bl = $removeUnaffected;
            ModNamingFamily[] modNamingFamilyArray = (ModNamingFamily[])Arrays.copyOf(fTables, fTables.length);
            String[] fragments$iv = this$0.getFragmentNamesOrNull();
            boolean $i$f$modifyFamiliesAndCleanup = false;
            if (fragments$iv == null) {
                void families$iv$iv;
                ModFamily[] modFamilyArray = (ModFamily[])Arrays.copyOf(families$iv, ((void)families$iv).length);
                void removeUnaffected$iv$iv = removeUnaffected$iv;
                boolean $i$f$modifyFamiliesAndCleanup2 = false;
                if (removeUnaffected$iv$iv != false) {
                    for (void f$iv$iv : families$iv$iv) {
                        f$iv$iv.markChildrenAsSyncPending();
                    }
                }
                boolean bl2 = false;
                BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)this$1;
                boolean $i$f$continueOnDbError = false;
                BaseNativeIntrospector baseNativeIntrospector = this_$iv;
                Object whatsDoing$iv$iv = null;
                boolean $i$f$continueOnDbError2 = false;
                try {
                    boolean bl3 = false;
                    if ($detectDropped) {
                        long[] $this$forEach$iv = (long[])this$0.performQuery(this$1.getQueries().getRetrieveExistentTables());
                        boolean $i$f$forEach = false;
                        int n = $this$forEach$iv.length;
                        for (int j = 0; j < n; ++j) {
                            long element$iv;
                            long it = element$iv = $this$forEach$iv[j];
                            boolean bl4 = false;
                            for (ModNamingIdentifyingFamily<PgBaseLikeStoredTable> tables : fTables) {
                                PgBaseLikeStoredTable pgBaseLikeStoredTable = (PgBaseLikeStoredTable)tables.getByObjectId(it);
                                if (pgBaseLikeStoredTable == null) continue;
                                ((BasicModMixinElement)pgBaseLikeStoredTable).resetSyncPending();
                            }
                        }
                    }
                    if ($loadNew) {
                        this$0.loadTables(sc);
                    }
                }
                catch (DBException e$iv$iv) {
                    StringBuilder stringBuilder;
                    void this_$iv$iv;
                    boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                    StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                    boolean bl5 = false;
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                    String message$iv$iv = stringBuilder.toString();
                    if (expected$iv$iv) {
                        this_$iv$iv.trace(message$iv$iv);
                    } else {
                        IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                    }
                    this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
                }
                for (void f$iv$iv : families$iv$iv) {
                    if (removeUnaffected$iv$iv != false) {
                        f$iv$iv.removeSyncPendingChildren();
                    }
                    f$iv$iv.sort();
                }
            } else {
                if (removeUnaffected$iv != false) {
                    block8: for (String fragment$iv : fragments$iv) {
                        int n = ((void)families$iv).length;
                        for (int j = 0; j < n; ++j) {
                            void family$iv = families$iv[j];
                            BasicModNamedElement o$iv = (BasicModNamedElement)family$iv.get(fragment$iv);
                            if (o$iv == null) continue;
                            o$iv.setSyncPending(true);
                            continue block8;
                        }
                    }
                }
                boolean bl6 = false;
                BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)this$1;
                boolean $i$f$continueOnDbError = false;
                BaseNativeIntrospector this_$iv$iv = this_$iv;
                Object whatsDoing$iv$iv = null;
                boolean $i$f$continueOnDbError3 = false;
                try {
                    boolean bl7 = false;
                    if ($detectDropped) {
                        long[] $this$forEach$iv = (long[])this$0.performQuery(this$1.getQueries().getRetrieveExistentTables());
                        boolean $i$f$forEach = false;
                        int n = $this$forEach$iv.length;
                        for (int j = 0; j < n; ++j) {
                            long element$iv;
                            long it = element$iv = $this$forEach$iv[j];
                            boolean bl8 = false;
                            for (ModNamingIdentifyingFamily<PgBaseLikeStoredTable> tables : fTables) {
                                PgBaseLikeStoredTable pgBaseLikeStoredTable = (PgBaseLikeStoredTable)tables.getByObjectId(it);
                                if (pgBaseLikeStoredTable == null) continue;
                                ((BasicModMixinElement)pgBaseLikeStoredTable).resetSyncPending();
                            }
                        }
                    }
                    if ($loadNew) {
                        this$0.loadTables(sc);
                    }
                }
                catch (DBException e$iv$iv) {
                    StringBuilder stringBuilder;
                    boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                    StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                    boolean bl9 = false;
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                    String message$iv$iv = stringBuilder.toString();
                    if (expected$iv$iv) {
                        this_$iv$iv.trace(message$iv$iv);
                    } else {
                        IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                    }
                    this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
                }
                for (void family$iv : families$iv) {
                    if (removeUnaffected$iv != false) {
                        family$iv.removeSyncPendingChildren();
                    }
                    family$iv.sort();
                }
            }
            return Unit.INSTANCE;
        }

        private static final Unit loadTables$lambda$0(SchemaRetriever this$0, PgBaseSchema $schema, PgBaseIntroQueries.OneTable it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            this$0.processTable($schema, it);
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveStructAttributes$lambda$0$0(List $ats, PgBaseSchema schema) {
            void $this$groupByTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            Iterable $this$groupBy$iv = $ats;
            boolean $i$f$groupBy = false;
            Object object = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object2;
                void $this$getOrPut$iv$iv$iv;
                PgBaseIntroQueries.OneStructAttribute it = (PgBaseIntroQueries.OneStructAttribute)element$iv$iv;
                boolean bl = false;
                Long key$iv$iv = it.type_id;
                Map map = destination$iv$iv;
                Long key$iv$iv$iv = key$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            Map $this$forEach$iv = destination$iv$iv;
            boolean $i$f$forEach = false;
            object = $this$forEach$iv.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry element$iv;
                Object element$iv$iv;
                Map.Entry entry = element$iv = (Map.Entry)object.next();
                boolean bl = false;
                if ((PgBaseDefType)schema.getDefTypes().getByObjectId(((Number)entry.getKey()).longValue()) == null) continue;
                Intrinsics.checkNotNull(element$iv$iv);
                Object dataType = element$iv$iv;
                ModFamily $this$modifyAndCleanup_u24default$iv = (ModFamily)dataType.getAttributes();
                boolean removeUnaffected$iv = true;
                boolean $i$f$modifyAndCleanup = false;
                $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
                ModPositioningNamingFamily attributes = (ModPositioningNamingFamily)$this$modifyAndCleanup_u24default$iv;
                boolean bl3 = false;
                for (PgBaseIntroQueries.OneStructAttribute at : (List)entry.getValue()) {
                    if (at.att_dropped) continue;
                    PgBaseDefTypeAttribute attribute = (PgBaseDefTypeAttribute)attributes.createOrGetAt(at.att_position);
                    String string = at.att_name;
                    Intrinsics.checkNotNull((Object)string);
                    attribute.setName(string);
                    attribute.setStoredType(PgBaseIntrospectorKt.dasTypeOf(at));
                }
                $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
                $this$modifyAndCleanup_u24default$iv.sort();
            }
            return Unit.INSTANCE;
        }

        private static final DasType retrieveRoutines$lambda$0$0$0$1$1(SchemaRetriever this$0, long it) {
            return this$0.getMyTypes().get(it);
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveRoutines$lambda$0$0$0$1(SchemaRetriever this$0, PgBaseSchema $schema, PgBaseIntrospector this$1, PgBaseIntroQueries.OneRoutine r) {
            PgRoutineKind pgRoutineKind;
            Iterator iterator;
            BasicNameReference basicNameReference;
            Regex it;
            int n;
            PgBaseRoutine routine;
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            PgBaseRoutine pgBaseRoutine = routine = this$0.createRoutine($schema, r);
            String string = r.lang;
            if (string != null) {
                String string2 = string;
                PgBaseRoutine pgBaseRoutine2 = pgBaseRoutine;
                n = 0;
                basicNameReference = BasicNameReference.create((String)it);
                pgBaseRoutine = pgBaseRoutine2;
            } else {
                basicNameReference = null;
            }
            pgBaseRoutine.setLanguageRef((BasicReference)basicNameReference);
            routine.setStateNumber(r.r_state_number);
            routine.setReturnsSet(r.ret_set);
            PgVolatilityKind pgVolatilityKind = PgVolatilityKind.of(r.volatile_kind);
            if (pgVolatilityKind == null) {
                pgVolatilityKind = PgVolatilityKind.VOLATILE;
            }
            routine.setVolatilityKind(pgVolatilityKind);
            PgBaseIntroQueries.ArgumentNameHolder argumentNameHolder = r;
            ModPositioningNamingFamily<? extends PgBaseArgument> modPositioningNamingFamily = routine.getArguments();
            Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"getArguments(...)");
            this$1.processArgs(argumentNameHolder, modPositioningNamingFamily, routine, (Function1<Long, DasType>)((Function1)arg_0 -> SchemaRetriever.retrieveRoutines$lambda$0$0$0$1$1(this$0, arg_0)));
            if (r.arg_defaults != null) {
                void $this$toTypedArray$iv;
                List list;
                Collection $this$dropLastWhile$iv;
                String string3 = r.arg_defaults;
                Intrinsics.checkNotNull((Object)string3);
                Object object = string3;
                it = new Regex(",\\s+");
                n = 0;
                object = it.split((CharSequence)object, n);
                boolean $i$f$dropLastWhile = false;
                if (!$this$dropLastWhile$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String p0 = (String)iterator$iv.previous();
                        boolean bl = false;
                        if (((CharSequence)p0).length() == 0) continue;
                        list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list = CollectionsKt.emptyList();
                }
                $this$dropLastWhile$iv = list;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                String[] defaults = thisCollection$iv.toArray(new String[0]);
                ModPositioningNamingFamily<? extends PgBaseArgument> modPositioningNamingFamily2 = routine.getArguments();
                Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily2, (String)"getArguments(...)");
                List arguments = BaseIntrospectionFunctions.toList((Family)((Family)modPositioningNamingFamily2));
                int an = arguments.size();
                int k = defaults.length;
                for (int i2 = an - 1; -1 < i2; --i2) {
                    PgBaseArgument a = (PgBaseArgument)arguments.get(i2);
                    if (a.getArgumentDirection().isIn()) {
                        if (--k >= 0) {
                            String theDefaultExpression = PgBaseIntrospectorKt.normalizeDefaultExpression(defaults[k]);
                            a.setDefaultExpression(theDefaultExpression);
                            continue;
                        }
                        a.setDefaultExpression(null);
                        continue;
                    }
                    a.setDefaultExpression(null);
                }
            } else {
                iterator = routine.getArguments().iterator();
                while (iterator.hasNext()) {
                    PgBaseArgument a = (PgBaseArgument)iterator.next();
                    a.setDefaultExpression(null);
                }
            }
            if (r.kind == 'p') {
                pgRoutineKind = PgRoutineKind.PG_PROCEDURE;
            } else {
                Object object = routine.getReturnArgument();
                if (object != null && (object = object.getDasType()) != null && (object = DasTypeUtilsKt.getTypeName((DasType)object)) != null) {
                    Object object2 = object;
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                    String string4 = ((String)object2).toLowerCase(locale);
                    v13 = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                } else {
                    v13 = iterator = null;
                }
                pgRoutineKind = Intrinsics.areEqual((Object)iterator, (Object)"trigger") ? PgRoutineKind.PG_TRIGGER : (Intrinsics.areEqual((Object)iterator, (Object)"event_trigger") ? PgRoutineKind.PG_EVENT_TRIGGER : PgRoutineKind.PG_FUNCTION);
            }
            routine.setPgRoutineKind(pgRoutineKind);
            routine.getArguments().sort();
            routine.getArguments().removeSyncPendingChildren();
            routine.setDetailsLevel(LevelFun.max((Level)routine.getDetailsLevel(), (Level)Level.L2));
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveRoutines$lambda$0(boolean $removeUnaffected, SchemaRetriever this$0, PgBaseIntrospector this$1, boolean $detectDropped, boolean $loadNew, PgBaseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            ModNamingFamily modNamingFamily = (ModNamingFamily)schema.getRoutines();
            boolean bl = $removeUnaffected;
            String[] fragments$iv = this$0.getFragmentNamesOrNull();
            boolean $i$f$modifyAndCleanup = false;
            if (fragments$iv == null) {
                void $this$modifyAndCleanup$iv$iv;
                ModFamily modFamily = (ModFamily)$this$modifyAndCleanup$iv;
                void removeUnaffected$iv$iv = removeUnaffected$iv;
                boolean $i$f$modifyAndCleanup2 = false;
                if (removeUnaffected$iv$iv != false) {
                    $this$modifyAndCleanup$iv$iv.markChildrenAsSyncPending();
                }
                ModNamingIdentifyingFamily routines = (ModNamingIdentifyingFamily)$this$modifyAndCleanup$iv$iv;
                boolean bl2 = false;
                BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)this$1;
                boolean $i$f$continueOnDbError = false;
                BaseNativeIntrospector baseNativeIntrospector = this_$iv;
                Object whatsDoing$iv$iv = null;
                boolean $i$f$continueOnDbError2 = false;
                try {
                    boolean bl3 = false;
                    if ($detectDropped) {
                        long[] $this$forEach$iv = (long[])this$0.performQuery(this$1.getQueries().getRetrieveExistentRoutines());
                        boolean $i$f$forEach = false;
                        int n = $this$forEach$iv.length;
                        for (int j = 0; j < n; ++j) {
                            long element$iv;
                            long it = element$iv = $this$forEach$iv[j];
                            boolean bl4 = false;
                            PgBaseRoutine pgBaseRoutine = (PgBaseRoutine)routines.getByObjectId(it);
                            if (pgBaseRoutine != null) {
                                ((BasicModMixinElement)pgBaseRoutine).resetSyncPending();
                            }
                        }
                    }
                    if ($loadNew) {
                        BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default((BaseNativeIntrospector.AbstractRetriever)((BaseNativeIntrospector.AbstractRetriever)this$0), this$1.getQueries().getRetrieveRoutines(), (int)0, arg_0 -> SchemaRetriever.retrieveRoutines$lambda$0$0$0$1(this$0, schema, this$1, arg_0), (int)2, null);
                    }
                }
                catch (DBException e$iv$iv) {
                    StringBuilder stringBuilder;
                    void this_$iv$iv;
                    boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                    StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                    boolean bl5 = false;
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                    String message$iv$iv = stringBuilder.toString();
                    if (expected$iv$iv) {
                        this_$iv$iv.trace(message$iv$iv);
                    } else {
                        IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                    }
                    this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
                }
                if (removeUnaffected$iv$iv != false) {
                    $this$modifyAndCleanup$iv$iv.removeSyncPendingChildren();
                }
                $this$modifyAndCleanup$iv$iv.sort();
            } else {
                if (removeUnaffected$iv != false) {
                    for (String fragment$iv : fragments$iv) {
                        BasicModNamedElement $this$modifyAndCleanup_u24lambda_u240$iv;
                        if ((BasicModNamedElement)$this$modifyAndCleanup$iv.get(fragment$iv) == null) continue;
                        boolean bl6 = false;
                        $this$modifyAndCleanup_u24lambda_u240$iv.setSyncPending(true);
                    }
                }
                ModNamingIdentifyingFamily routines = (ModNamingIdentifyingFamily)$this$modifyAndCleanup$iv;
                boolean bl7 = false;
                BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)this$1;
                boolean $i$f$continueOnDbError = false;
                BaseNativeIntrospector this_$iv$iv = this_$iv;
                Object whatsDoing$iv$iv = null;
                boolean $i$f$continueOnDbError3 = false;
                try {
                    boolean bl8 = false;
                    if ($detectDropped) {
                        long[] $this$forEach$iv = (long[])this$0.performQuery(this$1.getQueries().getRetrieveExistentRoutines());
                        boolean $i$f$forEach = false;
                        int n = $this$forEach$iv.length;
                        for (int j = 0; j < n; ++j) {
                            long element$iv;
                            long it = element$iv = $this$forEach$iv[j];
                            boolean bl9 = false;
                            PgBaseRoutine pgBaseRoutine = (PgBaseRoutine)routines.getByObjectId(it);
                            if (pgBaseRoutine != null) {
                                ((BasicModMixinElement)pgBaseRoutine).resetSyncPending();
                            }
                        }
                    }
                    if ($loadNew) {
                        BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default((BaseNativeIntrospector.AbstractRetriever)((BaseNativeIntrospector.AbstractRetriever)this$0), this$1.getQueries().getRetrieveRoutines(), (int)0, arg_0 -> SchemaRetriever.retrieveRoutines$lambda$0$0$0$1(this$0, schema, this$1, arg_0), (int)2, null);
                    }
                }
                catch (DBException e$iv$iv) {
                    StringBuilder stringBuilder;
                    boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                    StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                    boolean bl10 = false;
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                    String message$iv$iv = stringBuilder.toString();
                    if (expected$iv$iv) {
                        this_$iv$iv.trace(message$iv$iv);
                    } else {
                        IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                    }
                    this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
                }
                if (removeUnaffected$iv != false) {
                    $this$modifyAndCleanup$iv.removeSyncPendingChildren();
                }
                $this$modifyAndCleanup$iv.sort();
            }
            return Unit.INSTANCE;
        }

        private static final DasType retrieveAggregates$lambda$0$0$0$1$0(SchemaRetriever this$0, long it) {
            return this$0.getMyTypes().get(it);
        }

        private static final Unit retrieveAggregates$lambda$0$0$0$1(ModNamingIdentifyingFamily $aggregates, PgBaseIntrospector this$0, SchemaRetriever this$1, PgBaseIntroQueries.OneAggregate agg) {
            Intrinsics.checkNotNullParameter((Object)agg, (String)"agg");
            BasicModNamedElement basicModNamedElement = $aggregates.renew(agg.aggregate_id, agg.aggregate_name);
            Intrinsics.checkNotNullExpressionValue((Object)basicModNamedElement, (String)"renew(...)");
            PgBaseAggregate aggregate = (PgBaseAggregate)basicModNamedElement;
            aggregate.setStateNumber(agg.state_number);
            PgBaseIntroQueries.ArgumentNameHolder argumentNameHolder = agg;
            ModPositioningNamingFamily<? extends PgBaseArgument> modPositioningNamingFamily = aggregate.getArguments();
            Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"getArguments(...)");
            this$0.processArgs(argumentNameHolder, modPositioningNamingFamily, aggregate, (Function1<Long, DasType>)((Function1)arg_0 -> SchemaRetriever.retrieveAggregates$lambda$0$0$0$1$0(this$1, arg_0)));
            this$1.processAggregate(agg, aggregate);
            aggregate.getArguments().sort();
            aggregate.getArguments().removeSyncPendingChildren();
            aggregate.setDetailsLevel(LevelFun.max((Level)aggregate.getDetailsLevel(), (Level)Level.L2));
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveAggregates$lambda$0(boolean $removeUnaffected, SchemaRetriever this$0, PgBaseIntrospector this$1, boolean $detectDropped, boolean $loadNew, PgBaseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            ModNamingFamily modNamingFamily = (ModNamingFamily)schema.getAggregates();
            boolean bl = $removeUnaffected;
            String[] fragments$iv = this$0.getFragmentNamesOrNull();
            boolean $i$f$modifyAndCleanup = false;
            if (fragments$iv == null) {
                void $this$modifyAndCleanup$iv$iv;
                ModFamily modFamily = (ModFamily)$this$modifyAndCleanup$iv;
                void removeUnaffected$iv$iv = removeUnaffected$iv;
                boolean $i$f$modifyAndCleanup2 = false;
                if (removeUnaffected$iv$iv != false) {
                    $this$modifyAndCleanup$iv$iv.markChildrenAsSyncPending();
                }
                ModNamingIdentifyingFamily aggregates = (ModNamingIdentifyingFamily)$this$modifyAndCleanup$iv$iv;
                boolean bl2 = false;
                BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)this$1;
                boolean $i$f$continueOnDbError = false;
                BaseNativeIntrospector baseNativeIntrospector = this_$iv;
                Object whatsDoing$iv$iv = null;
                boolean $i$f$continueOnDbError2 = false;
                try {
                    boolean bl3 = false;
                    if ($detectDropped) {
                        long[] $this$forEach$iv = (long[])this$0.performQuery(this$1.getQueries().getRetrieveExistentAggregates());
                        boolean $i$f$forEach = false;
                        int n = $this$forEach$iv.length;
                        for (int j = 0; j < n; ++j) {
                            long element$iv;
                            long it = element$iv = $this$forEach$iv[j];
                            boolean bl4 = false;
                            PgBaseAggregate pgBaseAggregate = (PgBaseAggregate)aggregates.getByObjectId(it);
                            if (pgBaseAggregate != null) {
                                ((BasicModMixinElement)pgBaseAggregate).resetSyncPending();
                            }
                        }
                    }
                    if ($loadNew) {
                        BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default((BaseNativeIntrospector.AbstractRetriever)((BaseNativeIntrospector.AbstractRetriever)this$0), this$1.getQueries().getRetrieveAggregates(), (int)0, arg_0 -> SchemaRetriever.retrieveAggregates$lambda$0$0$0$1(aggregates, this$1, this$0, arg_0), (int)2, null);
                    }
                }
                catch (DBException e$iv$iv) {
                    StringBuilder stringBuilder;
                    void this_$iv$iv;
                    boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                    StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                    boolean bl5 = false;
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                    String message$iv$iv = stringBuilder.toString();
                    if (expected$iv$iv) {
                        this_$iv$iv.trace(message$iv$iv);
                    } else {
                        IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                    }
                    this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
                }
                if (removeUnaffected$iv$iv != false) {
                    $this$modifyAndCleanup$iv$iv.removeSyncPendingChildren();
                }
                $this$modifyAndCleanup$iv$iv.sort();
            } else {
                if (removeUnaffected$iv != false) {
                    for (String fragment$iv : fragments$iv) {
                        BasicModNamedElement $this$modifyAndCleanup_u24lambda_u240$iv;
                        if ((BasicModNamedElement)$this$modifyAndCleanup$iv.get(fragment$iv) == null) continue;
                        boolean bl6 = false;
                        $this$modifyAndCleanup_u24lambda_u240$iv.setSyncPending(true);
                    }
                }
                ModNamingIdentifyingFamily aggregates = (ModNamingIdentifyingFamily)$this$modifyAndCleanup$iv;
                boolean bl7 = false;
                BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)this$1;
                boolean $i$f$continueOnDbError = false;
                BaseNativeIntrospector this_$iv$iv = this_$iv;
                Object whatsDoing$iv$iv = null;
                boolean $i$f$continueOnDbError3 = false;
                try {
                    boolean bl8 = false;
                    if ($detectDropped) {
                        long[] $this$forEach$iv = (long[])this$0.performQuery(this$1.getQueries().getRetrieveExistentAggregates());
                        boolean $i$f$forEach = false;
                        int n = $this$forEach$iv.length;
                        for (int j = 0; j < n; ++j) {
                            long element$iv;
                            long it = element$iv = $this$forEach$iv[j];
                            boolean bl9 = false;
                            PgBaseAggregate pgBaseAggregate = (PgBaseAggregate)aggregates.getByObjectId(it);
                            if (pgBaseAggregate != null) {
                                ((BasicModMixinElement)pgBaseAggregate).resetSyncPending();
                            }
                        }
                    }
                    if ($loadNew) {
                        BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default((BaseNativeIntrospector.AbstractRetriever)((BaseNativeIntrospector.AbstractRetriever)this$0), this$1.getQueries().getRetrieveAggregates(), (int)0, arg_0 -> SchemaRetriever.retrieveAggregates$lambda$0$0$0$1(aggregates, this$1, this$0, arg_0), (int)2, null);
                    }
                }
                catch (DBException e$iv$iv) {
                    StringBuilder stringBuilder;
                    boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                    StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                    boolean bl10 = false;
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                    String message$iv$iv = stringBuilder.toString();
                    if (expected$iv$iv) {
                        this_$iv$iv.trace(message$iv$iv);
                    } else {
                        IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                    }
                    this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
                }
                if (removeUnaffected$iv != false) {
                    $this$modifyAndCleanup$iv.removeSyncPendingChildren();
                }
                $this$modifyAndCleanup$iv.sort();
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveOperators$lambda$0$0$0$1(ModNamingIdentifyingFamily $operators, SchemaRetriever this$0, PgBaseIntroQueries.OneOperator op) {
            Intrinsics.checkNotNullParameter((Object)op, (String)"op");
            BasicModNamedElement basicModNamedElement = $operators.renew(op.op_id, op.op_name);
            Intrinsics.checkNotNullExpressionValue((Object)basicModNamedElement, (String)"renew(...)");
            PgBaseOperator operator = (PgBaseOperator)basicModNamedElement;
            this$0.processOperator(op, operator);
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveOperators$lambda$0(boolean $removeUnaffected, SchemaRetriever this$0, PgBaseIntrospector this$1, boolean $detectDropped, boolean $loadNew, PgBaseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            ModNamingFamily modNamingFamily = (ModNamingFamily)schema.getOperators();
            boolean bl = $removeUnaffected;
            String[] fragments$iv = this$0.getFragmentNamesOrNull();
            boolean $i$f$modifyAndCleanup = false;
            if (fragments$iv == null) {
                void $this$modifyAndCleanup$iv$iv;
                ModFamily modFamily = (ModFamily)$this$modifyAndCleanup$iv;
                void removeUnaffected$iv$iv = removeUnaffected$iv;
                boolean $i$f$modifyAndCleanup2 = false;
                if (removeUnaffected$iv$iv != false) {
                    $this$modifyAndCleanup$iv$iv.markChildrenAsSyncPending();
                }
                ModNamingIdentifyingFamily operators = (ModNamingIdentifyingFamily)$this$modifyAndCleanup$iv$iv;
                boolean bl2 = false;
                BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)this$1;
                boolean $i$f$continueOnDbError = false;
                BaseNativeIntrospector baseNativeIntrospector = this_$iv;
                Object whatsDoing$iv$iv = null;
                boolean $i$f$continueOnDbError2 = false;
                try {
                    boolean bl3 = false;
                    if ($detectDropped) {
                        long[] $this$forEach$iv = (long[])this$0.performQuery(this$1.getQueries().getRetrieveExistentOperators());
                        boolean $i$f$forEach = false;
                        int n = $this$forEach$iv.length;
                        for (int j = 0; j < n; ++j) {
                            long element$iv;
                            long it = element$iv = $this$forEach$iv[j];
                            boolean bl4 = false;
                            PgBaseOperator pgBaseOperator = (PgBaseOperator)operators.getByObjectId(it);
                            if (pgBaseOperator != null) {
                                ((BasicModMixinElement)pgBaseOperator).resetSyncPending();
                            }
                        }
                    }
                    if ($loadNew) {
                        BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default((BaseNativeIntrospector.AbstractRetriever)((BaseNativeIntrospector.AbstractRetriever)this$0), this$1.getQueries().getRetrieveOperators(), (int)0, arg_0 -> SchemaRetriever.retrieveOperators$lambda$0$0$0$1(operators, this$0, arg_0), (int)2, null);
                    }
                }
                catch (DBException e$iv$iv) {
                    StringBuilder stringBuilder;
                    void this_$iv$iv;
                    boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                    StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                    boolean bl5 = false;
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                    String message$iv$iv = stringBuilder.toString();
                    if (expected$iv$iv) {
                        this_$iv$iv.trace(message$iv$iv);
                    } else {
                        IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                    }
                    this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
                }
                if (removeUnaffected$iv$iv != false) {
                    $this$modifyAndCleanup$iv$iv.removeSyncPendingChildren();
                }
                $this$modifyAndCleanup$iv$iv.sort();
            } else {
                if (removeUnaffected$iv != false) {
                    for (String fragment$iv : fragments$iv) {
                        BasicModNamedElement $this$modifyAndCleanup_u24lambda_u240$iv;
                        if ((BasicModNamedElement)$this$modifyAndCleanup$iv.get(fragment$iv) == null) continue;
                        boolean bl6 = false;
                        $this$modifyAndCleanup_u24lambda_u240$iv.setSyncPending(true);
                    }
                }
                ModNamingIdentifyingFamily operators = (ModNamingIdentifyingFamily)$this$modifyAndCleanup$iv;
                boolean bl7 = false;
                BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)this$1;
                boolean $i$f$continueOnDbError = false;
                BaseNativeIntrospector this_$iv$iv = this_$iv;
                Object whatsDoing$iv$iv = null;
                boolean $i$f$continueOnDbError3 = false;
                try {
                    boolean bl8 = false;
                    if ($detectDropped) {
                        long[] $this$forEach$iv = (long[])this$0.performQuery(this$1.getQueries().getRetrieveExistentOperators());
                        boolean $i$f$forEach = false;
                        int n = $this$forEach$iv.length;
                        for (int j = 0; j < n; ++j) {
                            long element$iv;
                            long it = element$iv = $this$forEach$iv[j];
                            boolean bl9 = false;
                            PgBaseOperator pgBaseOperator = (PgBaseOperator)operators.getByObjectId(it);
                            if (pgBaseOperator != null) {
                                ((BasicModMixinElement)pgBaseOperator).resetSyncPending();
                            }
                        }
                    }
                    if ($loadNew) {
                        BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default((BaseNativeIntrospector.AbstractRetriever)((BaseNativeIntrospector.AbstractRetriever)this$0), this$1.getQueries().getRetrieveOperators(), (int)0, arg_0 -> SchemaRetriever.retrieveOperators$lambda$0$0$0$1(operators, this$0, arg_0), (int)2, null);
                    }
                }
                catch (DBException e$iv$iv) {
                    StringBuilder stringBuilder;
                    boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                    StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                    boolean bl10 = false;
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                    $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                    String message$iv$iv = stringBuilder.toString();
                    if (expected$iv$iv) {
                        this_$iv$iv.trace(message$iv$iv);
                    } else {
                        IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                    }
                    this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
                }
                if (removeUnaffected$iv != false) {
                    $this$modifyAndCleanup$iv.removeSyncPendingChildren();
                }
                $this$modifyAndCleanup$iv.sort();
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveTableColumns$lambda$0$0(SchemaRetriever this$0, List $cols, PgBaseSchema it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            this$0.processColumns($cols, it);
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveConstraints$lambda$0$2$0$1(PgBaseSchema $schema, SchemaRetriever this$0, Ref.BooleanRef $wasKeys, PgBaseIntroQueries.OneConstraint con) {
            BasicModIdentifiedElement basicModIdentifiedElement;
            block12: {
                block11: {
                    void $this$findAllById$iv$iv;
                    void $this$findById$iv;
                    Intrinsics.checkNotNullParameter((Object)con, (String)"con");
                    basicModIdentifiedElement = $schema.getDatabase();
                    if (basicModIdentifiedElement == null) break block11;
                    BasicDatabase basicDatabase = (BasicDatabase)basicModIdentifiedElement;
                    long objectId$iv = con.table_id;
                    boolean $i$f$findById = false;
                    void var9_11 = $this$findById$iv;
                    long objectId$iv$iv = objectId$iv;
                    boolean $i$f$findAllById = false;
                    JBIterable jBIterable = JBIterable.from((Iterable)$this$findAllById$iv$iv.findIdentifiedElements(objectId$iv$iv)).filter(PgBaseTable.class);
                    Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
                    basicModIdentifiedElement = (PgBaseTable)((BasicIdentifiedElement)jBIterable.first());
                    if (basicModIdentifiedElement != null) break block12;
                }
                return Unit.INSTANCE;
            }
            BasicModIdentifiedElement table = basicModIdentifiedElement;
            switch (con.con_kind) {
                case 'p': 
                case 'u': 
                case 'x': {
                    PgBaseRegularTable pgBaseRegularTable = table instanceof PgBaseRegularTable ? (PgBaseRegularTable)table : null;
                    if (pgBaseRegularTable != null) {
                        PgBaseRegularTable it = pgBaseRegularTable;
                        boolean bl = false;
                        BasicModNamedElement basicModNamedElement = it.getKeys().renew(con.con_id, con.con_name);
                        Intrinsics.checkNotNullExpressionValue((Object)basicModNamedElement, (String)"renew(...)");
                        PgBaseKey key = (PgBaseKey)basicModNamedElement;
                        this$0.processKey(key, it, con);
                        $wasKeys.element = true;
                    }
                    break;
                }
                case 'f': {
                    PgBaseRegularTable pgBaseRegularTable = table instanceof PgBaseRegularTable ? (PgBaseRegularTable)table : null;
                    if (pgBaseRegularTable != null) {
                        PgBaseRegularTable it = pgBaseRegularTable;
                        boolean bl = false;
                        BasicModNamedElement basicModNamedElement = it.getForeignKeys().renew(con.con_id, con.con_name);
                        Intrinsics.checkNotNullExpressionValue((Object)basicModNamedElement, (String)"renew(...)");
                        PgBaseForeignKey fkey = (PgBaseForeignKey)basicModNamedElement;
                        this$0.processForeignKey(fkey, it, con, $schema);
                    }
                    break;
                }
                case 'c': {
                    this$0.processCheck((PgBaseTable)table, con);
                }
            }
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveConstraints$lambda$0(SchemaRetriever this$0, boolean $removeUnaffected, PgBaseIntrospector this$1, boolean $detectDropped, boolean $loadNew, Ref.BooleanRef $wasKeys, PgBaseSchema schema) {
            void removeUnaffected$iv;
            void fragments$iv;
            String[] $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            ModNamingIdentifyingFamily<PgBaseLikeStoredTable>[] $this$mapNotNull$iv22 = this$0.tableFamilies(schema);
            boolean $i$f$mapNotNull22 = false;
            ModNamingIdentifyingFamily<PgBaseLikeStoredTable>[] modNamingIdentifyingFamilyArray = $this$mapNotNull$iv22;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                ModNamingFamily it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
                boolean bl = false;
                void it = element$iv$iv;
                boolean bl2 = false;
                if (ModelFun.tryCast((ModNamingFamily)((ModNamingFamily)it), PgBaseTable.class) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List tables = (List)destination$iv$iv;
            boolean $this$mapNotNull$iv22 = $removeUnaffected;
            Iterable $i$f$mapNotNull22 = tables;
            $this$mapNotNullTo$iv$iv = this$0.getFragmentNamesOrNull();
            boolean $i$f$modifyFamilyFragmentsAndCleanupInner = false;
            List relevantInnerFamilies$iv = new ArrayList();
            if (fragments$iv == null) {
                for (ModNamingFamily family$iv : majorFamilies$iv) {
                    for (BasicModNamedElement element$iv : family$iv) {
                        Intrinsics.checkNotNull((Object)element$iv);
                        t = (PgBaseTable)element$iv;
                        boolean bl = false;
                        Iterable innerFamilies$iv = ArraysKt.asIterable((Object[])this$0.constraintFamilies(t));
                        CollectionsKt.addAll((Collection)relevantInnerFamilies$iv, (Iterable)innerFamilies$iv);
                    }
                }
            } else {
                for (Iterator<Object> fragment$iv : fragments$iv) {
                    for (ModNamingFamily family$iv : majorFamilies$iv) {
                        BasicModNamedElement element$iv;
                        if ((BasicModNamedElement)family$iv.get(fragment$iv) == null) continue;
                        t = (PgBaseTable)element$iv;
                        boolean bl = false;
                        Iterable innerFamilies$iv = ArraysKt.asIterable((Object[])this$0.constraintFamilies(t));
                        CollectionsKt.addAll((Collection)relevantInnerFamilies$iv, (Iterable)innerFamilies$iv);
                    }
                }
            }
            if (removeUnaffected$iv != false) {
                for (ModNamingFamily innerFamily$iv : relevantInnerFamilies$iv) {
                    innerFamily$iv.markChildrenAsSyncPending();
                }
            }
            boolean bl = false;
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)this$1;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl4 = false;
                if ($detectDropped) {
                    LongOpenHashSet ids = new LongOpenHashSet((long[])this$0.performQuery(this$1.getQueries().getRetrieveExistentConstraints()));
                    Iterable $this$forEach$iv = tables;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ModNamingFamily tf = (ModNamingFamily)element$iv;
                        boolean bl5 = false;
                        Iterable $this$forEach$iv2 = (Iterable)tf;
                        boolean $i$f$forEach3 = false;
                        for (Object element$iv2 : $this$forEach$iv2) {
                            PgBaseTable t = (PgBaseTable)element$iv2;
                            boolean bl6 = false;
                            Intrinsics.checkNotNull((Object)t);
                            ModNamingIdentifyingFamily<?>[] $this$forEach$iv3 = this$0.constraintFamilies(t);
                            boolean $i$f$forEach4 = false;
                            int n2 = $this$forEach$iv3.length;
                            for (int j = 0; j < n2; ++j) {
                                ModNamingIdentifyingFamily<?> element$iv3;
                                ModNamingIdentifyingFamily<?> f = element$iv3 = $this$forEach$iv3[j];
                                boolean bl7 = false;
                                Iterable $this$forEach$iv4 = (Iterable)f;
                                boolean $i$f$forEach5 = false;
                                for (Object element$iv4 : $this$forEach$iv4) {
                                    BasicModElement it = (BasicModElement)element$iv4;
                                    boolean bl8 = false;
                                    if (!ids.contains(((BasicIdentifiedElement)it).getObjectId())) continue;
                                    ((BasicModMixinElement)it).resetSyncPending();
                                }
                            }
                        }
                    }
                }
                if ($loadNew) {
                    BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default((BaseNativeIntrospector.AbstractRetriever)((BaseNativeIntrospector.AbstractRetriever)this$0), this$1.getQueries().getRetrieveConstraints(), (int)0, arg_0 -> SchemaRetriever.retrieveConstraints$lambda$0$2$0$1(schema, this$0, $wasKeys, arg_0), (int)2, null);
                }
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl9 = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            for (ModNamingFamily innerFamily$iv : relevantInnerFamilies$iv) {
                if (removeUnaffected$iv != false) {
                    innerFamily$iv.removeSyncPendingChildren();
                }
                innerFamily$iv.sort();
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveDescriptions$lambda$0$0(ObjectKind $fragmentKind, SchemaRetriever this$0, boolean $detectDropped, boolean $loadNew, PgBaseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            if ($fragmentKind == null && this$0.getMode() == IntrospectionMode.FRAGMENT) {
                throw new IllegalStateException("In fragment mode fragment kind must always be supplied");
            }
            if ($fragmentKind != null && this$0.getMode() != IntrospectionMode.FRAGMENT) {
                throw new IllegalStateException("In regular modes fragment kind must never be supplied");
            }
            if ($fragmentKind == null) {
                this$0.retrieveDescriptionsBulk($detectDropped, $loadNew, schema);
                return Unit.INSTANCE;
            }
            this$0.removeDroppedComments((Long2ObjectMap<Short[]>)((Long2ObjectMap)new Long2ObjectOpenHashMap()), $fragmentKind);
            this$0.retrieveDescriptionsForFragmentKind(schema, $fragmentKind);
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ void access$inSchema(SchemaRetriever $this, Function1 modifier) {
            $this.inSchema(modifier);
        }

        public static final /* synthetic */ void access$processFunSource(SchemaRetriever $this, PgBaseRoutine function, PgBaseIntroQueries.OneFunctionSource fs) {
            $this.processFunSource(function, fs);
        }
    }
}

