/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.psi.impl;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.parser.blocks.frontmatter.FrontMatterContentLanguage;
import org.intellij.plugins.markdown.lang.parser.blocks.frontmatter.FrontMatterHeaderMarkerProvider;
import org.intellij.plugins.markdown.lang.parser.blocks.frontmatter.FrontMatterLanguages;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElement;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElementFactory;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFrontMatterHeader$Manipulator$handleContentChange$;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFrontMatterHeaderContent;
import org.intellij.plugins.markdown.lang.psi.util.PsiUtilsKt;
import org.intellij.plugins.markdown.util.MarkdownPsiUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u0014B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u000eH\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0002R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownFrontMatterHeader;", "Lcom/intellij/psi/impl/source/tree/CompositePsiElement;", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "Lorg/intellij/plugins/markdown/lang/psi/MarkdownPsiElement;", "type", "Lcom/intellij/psi/tree/IElementType;", "<init>", "(Lcom/intellij/psi/tree/IElementType;)V", "isValidHost", "", "updateText", "text", "", "createLiteralTextEscaper", "Lcom/intellij/psi/LiteralTextEscaper;", "contentLanguage", "Lorg/intellij/plugins/markdown/lang/parser/blocks/frontmatter/FrontMatterContentLanguage;", "getContentLanguage", "()Lorg/intellij/plugins/markdown/lang/parser/blocks/frontmatter/FrontMatterContentLanguage;", "determineContentLanguage", "Manipulator", "intellij.markdown"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nMarkdownFrontMatterHeader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownFrontMatterHeader.kt\norg/intellij/plugins/markdown/lang/psi/impl/MarkdownFrontMatterHeader\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n1297#2,3:74\n1#3:77\n*S KotlinDebug\n*F\n+ 1 MarkdownFrontMatterHeader.kt\norg/intellij/plugins/markdown/lang/psi/impl/MarkdownFrontMatterHeader\n*L\n27#1:74,3\n*E\n"})
public final class MarkdownFrontMatterHeader
extends CompositePsiElement
implements PsiLanguageInjectionHost,
MarkdownPsiElement {
    public MarkdownFrontMatterHeader(@NotNull IElementType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        super(type);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isValidHost() {
        Object e;
        IElementType iElementType;
        PsiElement it;
        Sequence children2;
        PsiElement psiElement = this.getFirstChild();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getFirstChild(...)");
        Sequence $this$count$iv = children2 = PsiTreeUtilKt.siblings((PsiElement)psiElement, (boolean)true, (boolean)true);
        boolean $i$f$count = false;
        int count$iv = 0;
        for (Object element$iv : $this$count$iv) {
            PsiElement it2 = (PsiElement)element$iv;
            boolean bl = false;
            if (!MarkdownPsiUtil.WhiteSpaces.isNewLine(it2) || ++count$iv >= 0) continue;
            CollectionsKt.throwCountOverflow();
        }
        int newlines = count$iv;
        if (newlines < 2) return false;
        Sequence sequence = children2;
        Iterator iterator = sequence.iterator();
        do {
            if (!iterator.hasNext()) return false;
            e = iterator.next();
            it = (PsiElement)e;
            boolean bl = false;
            iElementType = MarkdownElementTypes.FRONT_MATTER_HEADER_CONTENT;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"FRONT_MATTER_HEADER_CONTENT");
        } while (!PsiUtilsKt.hasType(it, iElementType));
        Object v2 = e;
        if (v2 == null) return false;
        return true;
    }

    @NotNull
    public PsiLanguageInjectionHost updateText(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        PsiElement psiElement = ElementManipulators.handleContentChange((PsiElement)((PsiElement)this), (String)text2);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"handleContentChange(...)");
        return (PsiLanguageInjectionHost)psiElement;
    }

    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        LiteralTextEscaper literalTextEscaper = LiteralTextEscaper.createSimple((PsiLanguageInjectionHost)this);
        Intrinsics.checkNotNullExpressionValue((Object)literalTextEscaper, (String)"createSimple(...)");
        return literalTextEscaper;
    }

    @NotNull
    public final FrontMatterContentLanguage getContentLanguage() {
        return this.determineContentLanguage();
    }

    private final FrontMatterContentLanguage determineContentLanguage() {
        PsiElement psiElement = (PsiElement)this;
        IElementType iElementType = MarkdownElementTypes.FRONT_MATTER_HEADER_DELIMITER;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"FRONT_MATTER_HEADER_DELIMITER");
        List delimiters = SequencesKt.toList(PsiUtilsKt.childrenOfType(psiElement, iElementType));
        if (!(delimiters.size() == 2)) {
            boolean $i$a$-check-MarkdownFrontMatterHeader$determineContentLanguage$22 = false;
            String $i$a$-check-MarkdownFrontMatterHeader$determineContentLanguage$22 = "Unexpected number of delimiters: " + delimiters.size();
            throw new IllegalStateException($i$a$-check-MarkdownFrontMatterHeader$determineContentLanguage$22.toString());
        }
        String opening = ((PsiElement)delimiters.get(0)).getText();
        String closing = ((PsiElement)delimiters.get(1)).getText();
        Intrinsics.checkNotNull((Object)opening);
        Intrinsics.checkNotNull((Object)closing);
        if (FrontMatterHeaderMarkerProvider.Companion.isYamlDelimiters$intellij_markdown(opening, closing)) {
            return FrontMatterLanguages.INSTANCE.getYAML();
        }
        if (FrontMatterHeaderMarkerProvider.Companion.isTomlDelimiters$intellij_markdown(opening, closing)) {
            return FrontMatterLanguages.INSTANCE.getTOML();
        }
        throw new IllegalStateException(("Failed to match opening (" + opening + ") and closing (" + closing + ") delimiters to determine content language").toString());
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\"\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownFrontMatterHeader$Manipulator;", "Lcom/intellij/psi/AbstractElementManipulator;", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownFrontMatterHeader;", "<init>", "()V", "handleContentChange", "element", "range", "Lcom/intellij/openapi/util/TextRange;", "content", "", "intellij.markdown"})
    @SourceDebugExtension(value={"SMAP\nMarkdownFrontMatterHeader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownFrontMatterHeader.kt\norg/intellij/plugins/markdown/lang/psi/impl/MarkdownFrontMatterHeader$Manipulator\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,73:1\n479#2:74\n*S KotlinDebug\n*F\n+ 1 MarkdownFrontMatterHeader.kt\norg/intellij/plugins/markdown/lang/psi/impl/MarkdownFrontMatterHeader$Manipulator\n*L\n65#1:74\n*E\n"})
    public static final class Manipulator
    extends AbstractElementManipulator<MarkdownFrontMatterHeader> {
        @Nullable
        public MarkdownFrontMatterHeader handleContentChange(@NotNull MarkdownFrontMatterHeader element2, @NotNull TextRange range, @NotNull String content2) {
            Sequence children2;
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            if (StringsKt.contains$default((CharSequence)content2, (CharSequence)"---", (boolean)false, (int)2, null)) {
                MarkdownFrontMatterHeader markdownFrontMatterHeader;
                MarkdownPsiElement markdownPsiElement = MarkdownPsiElementFactory.createTextElement(element2.getProject(), content2);
                Intrinsics.checkNotNullExpressionValue((Object)markdownPsiElement, (String)"createTextElement(...)");
                MarkdownPsiElement textElement = markdownPsiElement;
                if (textElement instanceof MarkdownFrontMatterHeader) {
                    PsiElement psiElement = element2.replace((PsiElement)textElement);
                    Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.intellij.plugins.markdown.lang.psi.impl.MarkdownFrontMatterHeader");
                    markdownFrontMatterHeader = (MarkdownFrontMatterHeader)psiElement;
                } else {
                    markdownFrontMatterHeader = null;
                }
                return markdownFrontMatterHeader;
            }
            PsiElement psiElement = element2.getFirstChild();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getFirstChild(...)");
            Sequence $this$filterIsInstance$iv = children2 = PsiTreeUtilKt.siblings((PsiElement)psiElement, (boolean)true, (boolean)true);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)Manipulator$handleContentChange$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            MarkdownFrontMatterHeaderContent markdownFrontMatterHeaderContent = (MarkdownFrontMatterHeaderContent)SequencesKt.firstOrNull((Sequence)sequence);
            if (markdownFrontMatterHeaderContent == null) {
                return null;
            }
            MarkdownFrontMatterHeaderContent contentElement = markdownFrontMatterHeaderContent;
            TextRange textRange = range.shiftLeft(contentElement.getStartOffsetInParent());
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftLeft(...)");
            TextRange shiftedRange = textRange;
            String string = shiftedRange.replace(contentElement.getText(), content2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"replace(...)");
            String updatedText = string;
            contentElement.replaceWithText(updatedText);
            return element2;
        }
    }
}

