/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.platform.workspace.jps.entities.SdkEntity;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@ApiStatus.NonExtendable
public interface ProjectFileIndex
extends FileIndex {
    @NotNull
    public static ProjectFileIndex getInstance(@NotNull Project project) {
        if (project == null) {
            ProjectFileIndex.$$$reportNull$$$0(0);
        }
        ProjectFileIndex projectFileIndex = (ProjectFileIndex)project.getService(ProjectFileIndex.class);
        if (projectFileIndex == null) {
            ProjectFileIndex.$$$reportNull$$$0(1);
        }
        return projectFileIndex;
    }

    @RequiresReadLock
    public boolean isInProject(@NotNull VirtualFile var1);

    @RequiresReadLock
    public boolean isInProjectOrExcluded(@NotNull VirtualFile var1);

    @RequiresReadLock
    @Nullable
    public Module getModuleForFile(@NotNull VirtualFile var1);

    @RequiresReadLock
    @Nullable
    public Module getModuleForFile(@NotNull VirtualFile var1, boolean var2);

    @ApiStatus.Experimental
    @RequiresReadLock
    @NotNull
    public @Unmodifiable Set<Module> getModulesForFile(@NotNull VirtualFile var1, boolean var2);

    @RequiresReadLock
    @NotNull
    public @Unmodifiable List<OrderEntry> getOrderEntriesForFile(@NotNull VirtualFile var1);

    @RequiresReadLock
    @Nullable
    public VirtualFile getClassRootForFile(@NotNull VirtualFile var1);

    @RequiresReadLock
    @Nullable
    public VirtualFile getSourceRootForFile(@NotNull VirtualFile var1);

    @RequiresReadLock
    @Nullable
    public VirtualFile getContentRootForFile(@NotNull VirtualFile var1);

    @RequiresReadLock
    @Nullable
    public VirtualFile getContentRootForFile(@NotNull VirtualFile var1, boolean var2);

    @Deprecated
    @RequiresReadLock
    @Nullable
    public String getPackageNameByDirectory(@NotNull VirtualFile var1);

    @Deprecated
    @RequiresReadLock
    public boolean isLibraryClassFile(@NotNull VirtualFile var1);

    @RequiresReadLock
    public boolean isInSource(@NotNull VirtualFile var1);

    @RequiresReadLock
    public boolean isInLibraryClasses(@NotNull VirtualFile var1);

    @RequiresReadLock
    public boolean isInLibrary(@NotNull VirtualFile var1);

    @RequiresReadLock
    public boolean isInLibrarySource(@NotNull VirtualFile var1);

    @RequiresReadLock
    public boolean isExcluded(@NotNull VirtualFile var1);

    @ApiStatus.Experimental
    @NotNull
    public @NotNull @Unmodifiable Collection<@NotNull LibraryEntity> findContainingLibraries(@NotNull VirtualFile var1);

    @ApiStatus.Experimental
    @NotNull
    public @NotNull @Unmodifiable Collection<@NotNull SdkEntity> findContainingSdks(@NotNull VirtualFile var1);

    @RequiresReadLock
    public boolean isUnderIgnored(@NotNull VirtualFile var1);

    @RequiresReadLock
    @Nullable
    public JpsModuleSourceRootType<?> getContainingSourceRootType(@NotNull VirtualFile var1);

    @RequiresReadLock
    public boolean isInGeneratedSources(@NotNull VirtualFile var1);

    @Nullable
    public String getUnloadedModuleNameForFile(@NotNull VirtualFile var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ProjectFileIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ProjectFileIndex";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    @Deprecated
    public static final class SERVICE {
        private SERVICE() {
        }

        public static ProjectFileIndex getInstance(Project project) {
            return ProjectFileIndex.getInstance(project);
        }
    }
}

