/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.eel.provider;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelOsFamily;
import com.intellij.platform.eel.EelPathBoundDescriptor;
import com.intellij.platform.eel.EelPlatformKt;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.path.EelPathException;
import com.intellij.platform.eel.provider.EelMountProvider;
import com.intellij.platform.eel.provider.EelNioBridgeService;
import com.intellij.platform.eel.provider.EelProvider;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0007\u001a\u0016\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0007\u001a\u000e\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u0002H\u0007\u001a\f\u0010\u0006\u001a\u00020\u0002*\u00020\u0001H\u0007\u001a\u0014\u0010\u0006\u001a\u00020\u0002*\u00020\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0007\u001a\u000e\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\bH\u0007\u001a\u0012\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\f*\u00020\bH\u0007\"\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"asNioPath", "Ljava/nio/file/Path;", "Lcom/intellij/platform/eel/path/EelPath;", "project", "Lcom/intellij/openapi/project/Project;", "asNioPathOrNull", "asEelPath", "descriptor", "Lcom/intellij/platform/eel/EelDescriptor;", "mountProvider", "Lcom/intellij/platform/eel/provider/EelMountProvider;", "routingPrefixes", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.eel.provider"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nEelNioBridgeService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EelNioBridgeService.kt\ncom/intellij/platform/eel/provider/EelNioBridgeServiceKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,135:1\n67#2,4:136\n67#2,4:143\n13#2:160\n1849#3,3:140\n1849#3,2:147\n1851#3:150\n1480#3,2:151\n1586#3:153\n1661#3,3:154\n1482#3,3:157\n1#4:149\n*S KotlinDebug\n*F\n+ 1 EelNioBridgeService.kt\ncom/intellij/platform/eel/provider/EelNioBridgeServiceKt\n*L\n58#1:136,4\n67#1:143,4\n135#1:160\n66#1:140,3\n104#1:147,2\n104#1:150\n128#1:151,2\n129#1:153\n129#1:154,3\n128#1:157,3\n*E\n"})
public final class EelNioBridgeServiceKt {
    @NotNull
    private static final Logger LOG;

    @ApiStatus.Experimental
    @NotNull
    public static final Path asNioPath(@NotNull EelPath $this$asNioPath) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)$this$asNioPath, (String)"<this>");
        Path path = EelNioBridgeServiceKt.asNioPathOrNull($this$asNioPath);
        if (path == null) {
            throw new IllegalArgumentException("Could not convert " + $this$asNioPath + " to NIO path, descriptor is " + $this$asNioPath.getDescriptor());
        }
        return path;
    }

    @Deprecated(message="Use asNioPath() instead", replaceWith=@ReplaceWith(expression="asNioPath()", imports={}))
    @ApiStatus.Internal
    @NotNull
    public static final Path asNioPath(@NotNull EelPath $this$asNioPath, @Nullable Project project) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)$this$asNioPath, (String)"<this>");
        return EelNioBridgeServiceKt.asNioPath($this$asNioPath);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="It never returns null anymore")
    @ApiStatus.Experimental
    @Nullable
    public static final Path asNioPathOrNull(@NotNull EelPath $this$asNioPathOrNull) {
        void $this$fold$iv;
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)$this$asNioPathOrNull, (String)"<this>");
        if ($this$asNioPathOrNull.getDescriptor() == LocalEelDescriptor.INSTANCE) {
            return Path.of($this$asNioPathOrNull.toString(), new String[0]);
        }
        EelDescriptor eelDescriptor = $this$asNioPathOrNull.getDescriptor();
        Object object = eelDescriptor instanceof EelPathBoundDescriptor ? (EelPathBoundDescriptor)eelDescriptor : null;
        if (object == null || (object = object.getRootPath()) == null) {
            return null;
        }
        Object root = object;
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace22 = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("asNioPathOrNull(): path=" + $this$asNioPathOrNull + " descriptor=" + $this$asNioPathOrNull.getDescriptor() + " rootPath=" + (Path)root);
        }
        Iterable $i$f$trace22 = $this$asNioPathOrNull.getParts();
        Object initial$iv = root;
        boolean $i$f$fold = false;
        Object accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void p1;
            String string = (String)element$iv;
            Object p0 = accumulator$iv;
            boolean bl = false;
            accumulator$iv = p0.resolve((String)p1);
        }
        Object result = accumulator$iv;
        Logger $this$trace$iv2 = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv2.isTraceEnabled()) {
            logger = $this$trace$iv2;
            boolean bl = false;
            logger.trace("asNioPathOrNull(): path=" + $this$asNioPathOrNull + " basePath=" + (Path)root + " result=" + (Path)result);
        }
        return result;
    }

    @ApiStatus.Experimental
    @NotNull
    public static final EelPath asEelPath(@NotNull Path $this$asEelPath) throws EelPathException {
        Intrinsics.checkNotNullParameter((Object)$this$asEelPath, (String)"<this>");
        return EelNioBridgeServiceKt.asEelPath($this$asEelPath, EelProviderUtil.getEelDescriptor($this$asEelPath));
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Experimental
    @NotNull
    public static final EelPath asEelPath(@NotNull Path $this$asEelPath, @NotNull EelDescriptor descriptor) throws EelPathException {
        EelDescriptor eelDescriptor;
        block6: {
            void $this$fold$iv;
            Intrinsics.checkNotNullParameter((Object)$this$asEelPath, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            eelDescriptor = descriptor;
            if (eelDescriptor instanceof LocalEelDescriptor) {
                return EelPath.Companion.parse(((Object)$this$asEelPath).toString(), descriptor);
            }
            if (!(eelDescriptor instanceof EelPathBoundDescriptor) || !EelPlatformKt.isPosix((EelOsFamily)descriptor.getOsFamily())) break block6;
            Path root = ((EelPathBoundDescriptor)descriptor).getRootPath();
            Path relative = root.relativize($this$asEelPath);
            Intrinsics.checkNotNull((Object)relative);
            Iterable iterable = relative;
            EelPath initial$iv = EelPath.Companion.parse("/", descriptor);
            boolean $i$f$fold = false;
            Object accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                String string;
                block8: {
                    EelPath path;
                    block7: {
                        void part;
                        String string2;
                        Path path2 = (Path)element$iv;
                        path = accumulator$iv;
                        boolean bl = false;
                        String it = string2 = part.toString();
                        boolean bl2 = false;
                        string = ((CharSequence)it).length() > 0 ? string2 : null;
                        if (string == null) break block7;
                        String it2 = string;
                        boolean bl3 = false;
                        EelPath eelPath = path.getChild(it2);
                        string = eelPath;
                        if (eelPath != null) break block8;
                    }
                    string = path;
                }
                accumulator$iv = string;
            }
            return accumulator$iv;
        }
        if (eelDescriptor instanceof EelPathBoundDescriptor) {
            throw new NotImplementedError(null, 1, null);
        }
        throw new NoSuchElementException("Cannot find a root for " + $this$asEelPath);
    }

    @ApiStatus.Internal
    @Nullable
    public static final EelMountProvider mountProvider(@NotNull EelDescriptor $this$mountProvider) {
        EelMountProvider eelMountProvider;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$mountProvider, (String)"<this>");
            for (EelProvider eelProvider : (Iterable)EelProvider.Companion.getEP_NAME().getExtensionList()) {
                boolean bl = false;
                EelMountProvider eelMountProvider2 = eelProvider.getMountProvider($this$mountProvider);
                if (eelMountProvider2 == null) continue;
                eelMountProvider = eelMountProvider2;
                break block1;
            }
            eelMountProvider = null;
        }
        return eelMountProvider;
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @NotNull
    public static final Set<Path> routingPrefixes(@NotNull EelDescriptor $this$routingPrefixes) {
        void var2_2;
        void $this$flatMapTo$iv;
        Intrinsics.checkNotNullParameter((Object)$this$routingPrefixes, (String)"<this>");
        Iterable iterable = EelProvider.Companion.getEP_NAME().getExtensionList();
        Collection destination$iv = new HashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            Collection collection;
            EelProvider eelProvider = (EelProvider)element$iv;
            boolean bl = false;
            Collection<String> collection2 = eelProvider.getCustomRoots($this$routingPrefixes);
            if (collection2 != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = collection2;
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    String string = (String)item$iv$iv;
                    Collection collection3 = destination$iv$iv;
                    boolean bl2 = false;
                    collection3.add(Path.of((String)p0, new String[0]));
                }
                collection = (List)destination$iv$iv;
            } else {
                collection = SetsKt.emptySet();
            }
            Iterable list$iv = collection;
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        return (Set)var2_2;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(EelNioBridgeService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

