/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aiplayground.ui.chat.editor;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.aiplayground.models.statistic.PlaygroundCollector;
import com.intellij.aiplayground.ui.chat.editor.ChatFileEditor;
import com.intellij.aiplayground.ui.chat.editor.ChatVirtualFile;
import com.intellij.aiplayground.ui.utils.GetChatNameKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.impl.EditorTabTitleProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001b2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0007H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\rH\u0016J\u001f\u0010\u0016\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u00172\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u000bH\u0016J\u001f\u0010\u0019\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u001a2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u000bH\u0016\u00a8\u0006\u001c"}, d2={"Lcom/intellij/aiplayground/ui/chat/editor/ChatFileEditorProvider;", "Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "Lcom/intellij/openapi/fileEditor/impl/EditorTabTitleProvider;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "accept", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "getEditorTypeId", "", "getPolicy", "Lcom/intellij/openapi/fileEditor/FileEditorPolicy;", "isDumbAware", "disposeEditor", "", "editor", "getEditorTabTooltipText", "Lcom/intellij/openapi/util/NlsContexts$Tooltip;", "virtualFile", "getEditorTabTitle", "Lcom/intellij/openapi/util/NlsContexts$TabTitle;", "Companion", "intellij.aiplayground.ui"})
@StabilityInferred(parameters=1)
public final class ChatFileEditorProvider
implements FileEditorProvider,
EditorTabTitleProvider,
DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    @NotNull
    public static final String ID = "AiPlaygroundChatFileEditor";

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file instanceof ChatVirtualFile;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ChatVirtualFile chatFile = (ChatVirtualFile)file;
        PlaygroundCollector.INSTANCE.logEditorOpened();
        return new ChatFileEditor(project, chatFile);
    }

    @NotNull
    public String getEditorTypeId() {
        return ID;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.HIDE_OTHER_EDITORS;
    }

    public boolean isDumbAware() {
        return true;
    }

    public void disposeEditor(@NotNull FileEditor editor) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            ChatFileEditor disposable = (ChatFileEditor)editor;
            Disposer.dispose((Disposable)((Disposable)disposable));
            VirtualFile virtualFile = disposable.getFile();
            ChatVirtualFile chatVirtualFile = virtualFile instanceof ChatVirtualFile ? (ChatVirtualFile)virtualFile : null;
            if (chatVirtualFile == null) break block0;
            ChatVirtualFile it = chatVirtualFile;
            boolean bl = false;
            PlaygroundCollector.INSTANCE.logEditorClosed();
        }
    }

    @Nullable
    public String getEditorTabTooltipText(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        if (!(virtualFile instanceof ChatVirtualFile)) {
            return super.getEditorTabTooltipText(project, virtualFile);
        }
        return GetChatNameKt.getChatName(((ChatVirtualFile)virtualFile).getChat().getTitle());
    }

    @Nullable
    public String getEditorTabTitle(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        if (!(virtualFile instanceof ChatVirtualFile)) {
            return null;
        }
        return GetChatNameKt.getChatName(((ChatVirtualFile)virtualFile).getChat().getTitle());
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/aiplayground/ui/chat/editor/ChatFileEditorProvider$Companion;", "", "<init>", "()V", "ID", "", "intellij.aiplayground.ui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

