/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.sql.common.impl.formatter.settings;

import com.intellij.ui.components.JBCheckBox;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 $2\u00020\u0001:\u0001$B\u001e\b\u0016\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J\u0010\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u0011H\u0002J\u0010\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\u0003H\u0002J\u0010\u0010\"\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0014\u0010#\u001a\u00020\n2\n\b\u0001\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u000e\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/database/sql/common/impl/formatter/settings/LinkingCheckBox;", "Lcom/intellij/ui/components/JBCheckBox;", "text", "", "Lcom/intellij/openapi/util/NlsContexts$Checkbox;", "linkAction", "Ljava/lang/Runnable;", "<init>", "(Ljava/lang/String;Ljava/lang/Runnable;)V", "Lkotlin/Function0;", "", "htmlView", "Ljavax/swing/text/View;", "originalHtmlText", "underlineHtmlText", "Lcom/intellij/openapi/util/NlsSafe;", "underlineActive", "", "effectiveIcon", "Ljavax/swing/Icon;", "computeTextRect", "Ljava/awt/Rectangle;", "isLinkAt", "x", "", "y", "processMouseEvent", "e", "Ljava/awt/event/MouseEvent;", "processMouseMotionEvent", "updateUnderline", "hoverOnLink", "ensureUnderlinedVariantPrepared", "currentText", "makeLinksUnderlinedVariant", "setText", "Companion", "intellij.database.sql.common.impl"})
public final class LinkingCheckBox
extends JBCheckBox {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<Unit> linkAction;
    @Nullable
    private String originalHtmlText;
    @Nullable
    private String underlineHtmlText;
    private boolean underlineActive;
    @Deprecated
    @NotNull
    public static final String ourUnderlineStyle = "<head><style type=\"text/css\">a{ text-decoration: underline; }</style></head>";

    public LinkingCheckBox(@NotNull String text, @NotNull Runnable linkAction) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)linkAction, (String)"linkAction");
        super(text);
        this.linkAction = (Function0)new Function0<Unit>((Object)linkAction){

            public final void invoke() {
                ((Runnable)this.receiver).run();
            }
        };
    }

    private final View htmlView() {
        Object object = this.getClientProperty("html");
        return object instanceof View ? (View)object : null;
    }

    private final Icon effectiveIcon() {
        Icon icon = this.getIcon();
        Icon icon2 = icon;
        if (icon2 == null) {
            icon2 = UIManager.getIcon("CheckBox.icon");
        }
        return icon2;
    }

    private final Rectangle computeTextRect() {
        Rectangle viewRect = new Rectangle(this.getInsets().left, this.getInsets().top, this.getWidth() - this.getInsets().left - this.getInsets().right, this.getHeight() - this.getInsets().top - this.getInsets().bottom);
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        FontMetrics fm = this.getFontMetrics(this.getFont());
        SwingUtilities.layoutCompoundLabel((JComponent)((Object)this), fm, this.getText(), this.effectiveIcon(), this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), viewRect, iconRect, textRect, this.getIconTextGap());
        return textRect;
    }

    private final boolean isLinkAt(int x, int y) {
        View view = this.htmlView();
        if (view == null) {
            return false;
        }
        View view2 = view;
        Rectangle textRect = this.computeTextRect();
        if (textRect.width <= 0 || textRect.height <= 0) {
            return false;
        }
        int x1 = x - textRect.x;
        int y1 = y - textRect.y;
        if (x1 < 0 || y1 < 0 || x1 >= textRect.width || y1 >= textRect.height) {
            return false;
        }
        Rectangle alloc = new Rectangle(0, 0, textRect.width, textRect.height);
        Position.Bias[] bias = new Position.Bias[1];
        int pos = view2.viewToModel(x1, y1, alloc, bias);
        if (pos < 0) {
            return false;
        }
        Document document = view2.getDocument();
        HTMLDocument hTMLDocument = document instanceof HTMLDocument ? (HTMLDocument)document : null;
        if (hTMLDocument == null) {
            return false;
        }
        HTMLDocument doc = hTMLDocument;
        Element elem = doc.getCharacterElement(pos);
        return elem instanceof HTMLDocument.RunElement && ((HTMLDocument.RunElement)elem).getAttribute(HTML.Tag.A) != null;
    }

    protected void processMouseEvent(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if ((e.getID() == 501 || e.getID() == 500) && this.isLinkAt(e.getX(), e.getY())) {
            if (e.getID() == 500 && e.getButton() == 1) {
                this.linkAction.invoke();
            }
            e.consume();
            return;
        }
        if (e.getID() == 505) {
            this.updateUnderline(false);
        }
        super.processMouseEvent(e);
    }

    protected void processMouseMotionEvent(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        boolean overLink = this.isLinkAt(e.getX(), e.getY());
        this.setCursor(overLink ? Cursor.getPredefinedCursor(12) : null);
        this.updateUnderline(overLink);
        super.processMouseMotionEvent(e);
    }

    private final void updateUnderline(boolean hoverOnLink) {
        String string;
        String orig;
        if (hoverOnLink == this.underlineActive) {
            return;
        }
        this.underlineActive = hoverOnLink;
        String string2 = this.originalHtmlText;
        if (string2 == null) {
            string2 = this.getText();
        }
        if ((orig = string2) == null) {
            return;
        }
        if (!BasicHTML.isHTMLString(orig)) {
            return;
        }
        this.ensureUnderlinedVariantPrepared(orig);
        if (this.underlineActive) {
            string = this.underlineHtmlText;
            if (string == null) {
                string = orig;
            }
        } else {
            string = orig;
        }
        String adjustedText = string;
        super.setText(adjustedText);
    }

    private final void ensureUnderlinedVariantPrepared(String currentText) {
        if (this.originalHtmlText == null || !Intrinsics.areEqual((Object)this.originalHtmlText, (Object)currentText)) {
            this.originalHtmlText = currentText;
            this.underlineHtmlText = this.makeLinksUnderlinedVariant(currentText);
        } else if (this.underlineHtmlText == null) {
            this.underlineHtmlText = this.makeLinksUnderlinedVariant(currentText);
        }
    }

    private final String makeLinksUnderlinedVariant(String text) {
        if (StringsKt.startsWith$default((String)text, (String)"<html>", (boolean)false, (int)2, null)) {
            String string = text;
            int n = 6;
            int n2 = 6;
            CharSequence charSequence = ourUnderlineStyle;
            String newText = ((Object)StringsKt.replaceRange((CharSequence)string, (int)n, (int)n2, (CharSequence)charSequence)).toString();
            return newText;
        }
        return text;
    }

    public void setText(@Nls @Nullable String text) {
        if (text != null && BasicHTML.isHTMLString(text)) {
            this.originalHtmlText = text;
            this.underlineHtmlText = null;
            if (this.underlineActive) {
                this.ensureUnderlinedVariantPrepared(text);
                super.setText(this.underlineHtmlText);
                return;
            }
        } else {
            this.originalHtmlText = null;
            this.underlineHtmlText = null;
            this.underlineActive = false;
        }
        super.setText(text);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/sql/common/impl/formatter/settings/LinkingCheckBox$Companion;", "", "<init>", "()V", "ourUnderlineStyle", "", "Lcom/intellij/openapi/util/NlsSafe;", "intellij.database.sql.common.impl"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

