/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.table;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssPropertyValue;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.util.table.CssColorValueCompletionHandler;
import com.intellij.psi.css.impl.util.table.CssLookupValue;
import com.intellij.psi.css.impl.util.table.CssPropertyValueImpl;
import com.intellij.psi.css.impl.util.table.CssTableValue;
import com.intellij.psi.css.util.CssCompletionUtil;
import com.intellij.xml.util.ColorMap;
import com.intellij.xml.util.ColorSampleLookupValue;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssColorValue
extends CssLookupValue {
    private final boolean myAllColorKeywordsKnown;

    public CssColorValue() {
        this(true);
    }

    public CssColorValue(boolean allColorKeywordsKnown) {
        super(CssTableValue.Type.OR, CssTermTypes.COLOR);
        this.myAllColorKeywordsKnown = allColorKeywordsKnown;
        this.addChild(new CssPropertyValueImpl(CssCompletionUtil.lookupForUserColorLookup()));
        for (ColorSampleLookupValue color : ColorSampleLookupValue.getColors()) {
            if (ColorMap.isSystemColorName((String)StringUtil.toLowerCase((String)color.getName()))) continue;
            if (this.myAllColorKeywordsKnown) {
                String colorName = color.getName();
                this.addChild(new MyCssPropertyValueImpl(this, new ColorSampleLookupValue(colorName, color.getValue(), true)));
                continue;
            }
            this.addChild(new MyCssPropertyValueImpl(this, color));
        }
    }

    public boolean isAllColorKeywordsKnown() {
        return this.myAllColorKeywordsKnown;
    }

    @Override
    @NotNull
    public List<? extends CssPropertyValue> getDynamicVariants(@NotNull PsiElement contextElement) {
        CssColorValueCompletionHandler completionHandler;
        if (contextElement == null) {
            CssColorValue.$$$reportNull$$$0(0);
        }
        List<Object> list = (completionHandler = CssColorValueCompletionHandler.getInstance()) == null ? Collections.emptyList() : completionHandler.getDynamicVariants(this, contextElement);
        if (list == null) {
            CssColorValue.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/util/table/CssColorValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/util/table/CssColorValue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDynamicVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDynamicVariants";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static class MyCssPropertyValueImpl
    extends CssPropertyValueImpl {
        @NotNull
        private final CssColorValue myCssColorValue;

        public MyCssPropertyValueImpl(@NotNull CssColorValue colorValue, ColorSampleLookupValue color) {
            if (colorValue == null) {
                MyCssPropertyValueImpl.$$$reportNull$$$0(0);
            }
            super(color);
            this.myCssColorValue = colorValue;
        }

        @Override
        public boolean isValueBelongs(@Nullable PsiElement element) {
            return this.myCssColorValue.isValueBelongs(element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorValue", "com/intellij/psi/css/impl/util/table/CssColorValue$MyCssPropertyValueImpl", "<init>"));
        }
    }

    public static class MyPopularColorLookupValue
    extends ColorSampleLookupValue {
        public MyPopularColorLookupValue(String name, String value, boolean isStandard) {
            super(name, value, isStandard);
        }
    }
}

