/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Property;
import com.jetbrains.python.packaging.CondaExecutablesLocator;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="PyCondaPackageService", storages={@Storage(value="conda_packages.xml", roamingType=RoamingType.DISABLED)})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u0000H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0000H\u0016R.\u0010\u0007\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00062\r\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00068\u0006@BX\u0087\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/python/packaging/PyCondaPackageService;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "<init>", "()V", "value", "", "Lorg/jetbrains/annotations/SystemDependent;", "preferredCondaPath", "getPreferredCondaPath", "()Ljava/lang/String;", "getState", "loadState", "", "state", "Companion", "intellij.python.sdk"})
public final class PyCondaPackageService
implements PersistentStateComponent<PyCondaPackageService> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Property
    @Nullable
    private String preferredCondaPath;
    @NotNull
    private static final Logger LOG;

    @Nullable
    public final String getPreferredCondaPath() {
        return this.preferredCondaPath;
    }

    @NotNull
    public PyCondaPackageService getState() {
        return this;
    }

    public void loadState(@NotNull PyCondaPackageService state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    @JvmStatic
    @Nullable
    public static final String getCondaExecutable(@Nullable String sdkPath) {
        return Companion.getCondaExecutable(sdkPath);
    }

    static {
        Logger logger = Logger.getInstance(PyCondaPackageService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bJ\u0019\u0010\t\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\nH\u0007J\u0013\u0010\r\u001a\u00020\u000e2\u000b\u0010\u000f\u001a\u00070\n\u00a2\u0006\u0002\b\u000bR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/python/packaging/PyCondaPackageService$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lcom/jetbrains/python/packaging/PyCondaPackageService;", "getCondaExecutable", "", "Lorg/jetbrains/annotations/SystemDependent;", "sdkPath", "onCondaEnvCreated", "", "condaExecutable", "intellij.python.sdk"})
    @SourceDebugExtension(value={"SMAP\nPyCondaPackageService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyCondaPackageService.kt\ncom/jetbrains/python/packaging/PyCondaPackageService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,52:1\n42#2,3:53\n*S KotlinDebug\n*F\n+ 1 PyCondaPackageService.kt\ncom/jetbrains/python/packaging/PyCondaPackageService$Companion\n*L\n26#1:53,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PyCondaPackageService getInstance() {
            boolean $i$f$service = false;
            Class<PyCondaPackageService> serviceClass$iv = PyCondaPackageService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (PyCondaPackageService)object;
        }

        @JvmStatic
        @Nullable
        public final String getCondaExecutable(@Nullable String sdkPath) {
            String preferredCondaPath;
            CharSequence charSequence;
            if (sdkPath != null) {
                Path path = Path.of(sdkPath, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
                Path condaPath = CondaExecutablesLocator.findCondaExecutableRelativeToEnv(path);
                if (condaPath != null) {
                    LOG.info("Using " + condaPath + " as a conda executable for " + sdkPath + " (found as a relative to the env)");
                    return ((Object)condaPath).toString();
                }
            }
            if (!((charSequence = (CharSequence)(preferredCondaPath = this.getInstance().getPreferredCondaPath())) == null || charSequence.length() == 0)) {
                String string = sdkPath;
                Object forSdkPath = string == null ? "" : " for " + string;
                LOG.info("Using " + preferredCondaPath + " as a conda executable" + (String)forSdkPath + " (specified as a preferred conda path)");
                return preferredCondaPath;
            }
            Path path = CondaExecutablesLocator.getSystemCondaExecutable();
            return path != null ? ((Object)path).toString() : null;
        }

        public final void onCondaEnvCreated(@NotNull String condaExecutable) {
            Intrinsics.checkNotNullParameter((Object)condaExecutable, (String)"condaExecutable");
            this.getInstance().preferredCondaPath = condaExecutable;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

