/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.tables.panel.filtering.utils;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.scientific.tables.DSTableBundle;
import com.intellij.scientific.tables.api.filters.FilterValuePanelCustomizer;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.util.TextFieldCompletionProvider;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.FontMetrics;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000e\u001a\u00020\tH\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\tH\u0014R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Lcom/intellij/scientific/tables/panel/filtering/utils/FilterValueEditorTextField;", "Lcom/intellij/ui/EditorTextField;", "document", "Lcom/intellij/openapi/editor/Document;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/project/Project;)V", "myLocalEditorEx", "Lcom/intellij/openapi/editor/ex/EditorEx;", "getMyLocalEditorEx", "()Lcom/intellij/openapi/editor/ex/EditorEx;", "setMyLocalEditorEx", "(Lcom/intellij/openapi/editor/ex/EditorEx;)V", "createEditor", "computePreferredWidth", "", "createCustomBorder", "Ljavax/swing/border/Border;", "backgroundColor", "Ljava/awt/Color;", "shouldHaveBorder", "", "setupBorder", "", "editor", "Companion", "intellij.scientific.tables"})
public final class FilterValueEditorTextField
extends EditorTextField {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private EditorEx myLocalEditorEx;

    public FilterValueEditorTextField(@NotNull Document document, @NotNull Project project) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(document, project, (FileType)Companion.getAvailableLanguageFileTypes(), false, true);
            TextFieldCompletionProvider textFieldCompletionProvider = Companion.getAvailableCompletionProvider(project);
            if (textFieldCompletionProvider == null) break block0;
            textFieldCompletionProvider.apply((EditorTextField)this);
        }
    }

    @Nullable
    public final EditorEx getMyLocalEditorEx() {
        return this.myLocalEditorEx;
    }

    public final void setMyLocalEditorEx(@Nullable EditorEx editorEx) {
        this.myLocalEditorEx = editorEx;
    }

    @NotNull
    protected EditorEx createEditor() {
        EditorEx editorEx;
        EditorEx editorEx2 = super.createEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editorEx2, (String)"createEditor(...)");
        EditorEx editor = editorEx2;
        Color backgroundColor = UIUtil.getTextFieldBackground();
        EditorEx $this$createEditor_u24lambda_u240 = editorEx = editor;
        boolean bl = false;
        $this$createEditor_u24lambda_u240.setVerticalScrollbarVisible(false);
        this.setPreferredWidth(this.computePreferredWidth());
        $this$createEditor_u24lambda_u240.setShowPlaceholderWhenFocused(true);
        $this$createEditor_u24lambda_u240.setPlaceholder((CharSequence)DSTableBundle.message("ds.TableFiltering.FilterView.panel.text.field", new Object[0]));
        EditorHighlighterFactory editorHighlighterFactory = EditorHighlighterFactory.Companion.getInstance();
        Project project = $this$createEditor_u24lambda_u240.getProject();
        FileType fileType = this.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        $this$createEditor_u24lambda_u240.setHighlighter(editorHighlighterFactory.createEditorHighlighter(project, fileType));
        this.setBackground(backgroundColor);
        JComponent jComponent = $this$createEditor_u24lambda_u240.getComponent();
        Intrinsics.checkNotNull((Object)backgroundColor);
        jComponent.setBorder(this.createCustomBorder(backgroundColor));
        this.myLocalEditorEx = editor;
        return editor;
    }

    private final int computePreferredWidth() {
        FontMetrics fontMetrics = this.getComponent().getFontMetrics(this.getFont());
        int placeholderWidth = fontMetrics.stringWidth(DSTableBundle.message("ds.TableFiltering.FilterView.panel.text.field", new Object[0]));
        int spaceWidth = fontMetrics.stringWidth(" ");
        return placeholderWidth + spaceWidth * 3;
    }

    private final Border createCustomBorder(Color backgroundColor) {
        return new CompoundBorder((Border)new CustomLineBorder(backgroundColor, 3, 3, 1, 1), (Border)JBUI.Borders.empty());
    }

    protected boolean shouldHaveBorder() {
        return false;
    }

    protected void setupBorder(@NotNull EditorEx editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/intellij/scientific/tables/panel/filtering/utils/FilterValueEditorTextField$Companion;", "", "<init>", "()V", "getAvailableLanguageFileTypes", "Lcom/intellij/openapi/fileTypes/LanguageFileType;", "getAvailableCompletionProvider", "Lcom/intellij/util/TextFieldCompletionProvider;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.scientific.tables"})
    @SourceDebugExtension(value={"SMAP\nFilterValueEditorTextField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilterValueEditorTextField.kt\ncom/intellij/scientific/tables/panel/filtering/utils/FilterValueEditorTextField$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1#2:71\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LanguageFileType getAvailableLanguageFileTypes() {
            FilterValuePanelCustomizer filterValuePanelCustomizer = (FilterValuePanelCustomizer)CollectionsKt.firstOrNull((List)FilterValuePanelCustomizer.Companion.getEP_NAME().getExtensionList());
            if (filterValuePanelCustomizer == null || (filterValuePanelCustomizer = filterValuePanelCustomizer.getFileType()) == null) {
                LanguageFileType languageFileType = FileTypes.PLAIN_TEXT;
                filterValuePanelCustomizer = languageFileType;
                Intrinsics.checkNotNullExpressionValue((Object)languageFileType, (String)"PLAIN_TEXT");
            }
            return filterValuePanelCustomizer;
        }

        @Nullable
        public final TextFieldCompletionProvider getAvailableCompletionProvider(@NotNull Project project) {
            TextFieldCompletionProvider textFieldCompletionProvider;
            block1: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                for (FilterValuePanelCustomizer it : (Iterable)FilterValuePanelCustomizer.Companion.getEP_NAME().getExtensionList()) {
                    boolean bl = false;
                    TextFieldCompletionProvider textFieldCompletionProvider2 = it.getCompletionProvider(project);
                    if (textFieldCompletionProvider2 == null) continue;
                    textFieldCompletionProvider = textFieldCompletionProvider2;
                    break block1;
                }
                textFieldCompletionProvider = null;
            }
            return textFieldCompletionProvider;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

