/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringUtil {
    private StringUtil() {
    }

    @Contract(pure=true)
    @NotNull
    public static String replace(@NotNull String text, @NotNull List<String> from, @NotNull List<String> to) {
        assert (from.size() == to.size());
        StringBuilder result = null;
        block0: for (int i = 0; i < text.length(); ++i) {
            for (int j = 0; j < from.size(); ++j) {
                String toReplace = from.get(j);
                String replaceWith = to.get(j);
                int len = toReplace.length();
                if (len == 0 || !text.regionMatches(i, toReplace, 0, len)) continue;
                if (result == null) {
                    result = new StringBuilder(text.length());
                    result.append(text, 0, i);
                }
                result.append(replaceWith);
                i += len - 1;
                continue block0;
            }
            if (result == null) continue;
            result.append(text.charAt(i));
        }
        return result == null ? text : result.toString();
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable String s) {
        return s == null || s.isEmpty();
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmptyOrSpaces(@Nullable String s) {
        if (StringUtil.isEmpty(s)) {
            return true;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) <= ' ') continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static List<String> split(@NotNull String s, @NotNull String separator, boolean excludeSeparator, boolean excludeEmptyStrings) {
        return StringUtil.split((CharSequence)s, (CharSequence)separator, excludeSeparator, excludeEmptyStrings);
    }

    @Contract(pure=true)
    @NotNull
    public static List<CharSequence> split(@NotNull CharSequence s, @NotNull CharSequence separator, boolean excludeSeparator, boolean excludeEmptyStrings) {
        int index;
        if (separator.length() == 0) {
            return Collections.singletonList(s);
        }
        ArrayList<CharSequence> result = new ArrayList<CharSequence>();
        int pos = 0;
        while ((index = StringUtil.indexOf(s, separator, pos, s.length())) != -1) {
            int nextPos = index + separator.length();
            CharSequence token = s.subSequence(pos, excludeSeparator ? index : nextPos);
            if (token.length() != 0 || !excludeEmptyStrings) {
                result.add(token);
            }
            pos = nextPos;
        }
        if (pos < s.length() || !excludeEmptyStrings && pos == s.length()) {
            result.add(s.subSequence(pos, s.length()));
        }
        return result;
    }

    @NotNull
    public static List<String> split(@NotNull String text, char separator) {
        ArrayList<String> result = new ArrayList<String>();
        int pos = 0;
        int index = text.indexOf(separator, pos);
        while (index >= 0) {
            int nextPos = index + 1;
            String token = text.substring(pos, index);
            if (token.length() != 0) {
                result.add(token);
            }
            pos = nextPos;
            index = text.indexOf(separator, pos);
        }
        if (pos < text.length()) {
            result.add(text.substring(pos));
        }
        return result;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence sequence, @NotNull CharSequence infix, int start, int end) {
        for (int i = start; i <= end - infix.length(); ++i) {
            if (!StringUtil.startsWith(sequence, i, infix)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static boolean startsWith(@NotNull CharSequence text, int startIndex, @NotNull CharSequence prefix) {
        int tl = text.length();
        if (startIndex < 0 || startIndex > tl) {
            throw new IllegalArgumentException("Index is out of bounds: " + startIndex + ", length: " + tl);
        }
        int l1 = tl - startIndex;
        int l2 = prefix.length();
        if (l1 < l2) {
            return false;
        }
        for (int i = 0; i < l2; ++i) {
            if (text.charAt(i + startIndex) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    @NotNull
    public static String toHexString(byte @NotNull [] bytes) {
        String digits = "0123456789abcdef";
        StringBuilder sb = new StringBuilder(2 * bytes.length);
        for (byte b : bytes) {
            sb.append(digits.charAt(b >> 4 & 0xF)).append(digits.charAt(b & 0xF));
        }
        return sb.toString();
    }
}

