/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fus.reporting.jvm;

import com.jetbrains.fus.reporting.FusHttpClient;
import com.jetbrains.fus.reporting.HttpResponse;
import com.jetbrains.fus.reporting.jvm.JvmHttpClientKt;
import com.jetbrains.fus.reporting.jvm.ProxyInfo;
import com.jetbrains.fus.reporting.jvm.ProxyProvider;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BW\u0012\u0012\b\u0002\u0010\u0002\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u001a\b\u0002\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\n0\u0003\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\bH\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u0017\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u0019J\u0018\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\bH\u0016J\u0014\u0010\u001c\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0017\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\b\u0012\u0004\u0012\u00020 0\u001f\u00a2\u0006\u0002\u0010!R \u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\n0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0002\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/jetbrains/fus/reporting/jvm/JvmHttpClient;", "Lcom/jetbrains/fus/reporting/FusHttpClient;", "sslContextProvider", "Lkotlin/Function0;", "Ljavax/net/ssl/SSLContext;", "proxyProvider", "Lcom/jetbrains/fus/reporting/jvm/ProxyProvider;", "userAgent", "", "extraHeadersProvider", "", "timeout", "Ljava/time/Duration;", "(Lkotlin/jvm/functions/Function0;Lcom/jetbrains/fus/reporting/jvm/ProxyProvider;Ljava/lang/String;Lkotlin/jvm/functions/Function0;Ljava/time/Duration;)V", "createHttpClientBuilder", "Ljava/net/http/HttpClient$Builder;", "url", "createRequestBuilder", "Ljava/net/http/HttpRequest$Builder;", "get", "Lcom/jetbrains/fus/reporting/HttpResponse;", "lastModified", "", "parseDate", "string", "(Ljava/lang/String;)Ljava/lang/Long;", "post", "data", "configureProxy", "proxyInfo", "Lcom/jetbrains/fus/reporting/jvm/ProxyInfo;", "Ljava/net/http/HttpResponse;", "Ljava/lang/Void;", "(Ljava/net/http/HttpResponse;)Ljava/lang/Long;", "api-jvm-defaults"})
@SourceDebugExtension(value={"SMAP\nJvmHttpClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmHttpClient.kt\ncom/jetbrains/fus/reporting/jvm/JvmHttpClient\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,141:1\n215#2,2:142\n1549#3:144\n1620#3,3:145\n*S KotlinDebug\n*F\n+ 1 JvmHttpClient.kt\ncom/jetbrains/fus/reporting/jvm/JvmHttpClient\n*L\n52#1:142,2\n128#1:144\n128#1:145,3\n*E\n"})
public final class JvmHttpClient
implements FusHttpClient {
    @Nullable
    private final Function0<SSLContext> sslContextProvider;
    @Nullable
    private final ProxyProvider proxyProvider;
    @Nullable
    private final String userAgent;
    @NotNull
    private final Function0<Map<String, String>> extraHeadersProvider;
    @NotNull
    private final Duration timeout;

    public JvmHttpClient(@Nullable Function0<? extends SSLContext> sslContextProvider, @Nullable ProxyProvider proxyProvider, @Nullable String userAgent, @NotNull Function0<? extends Map<String, String>> extraHeadersProvider, @NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter(extraHeadersProvider, (String)"extraHeadersProvider");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        this.sslContextProvider = sslContextProvider;
        this.proxyProvider = proxyProvider;
        this.userAgent = userAgent;
        this.extraHeadersProvider = extraHeadersProvider;
        this.timeout = timeout;
    }

    public /* synthetic */ JvmHttpClient(Function0 function0, ProxyProvider proxyProvider, String string, Function0 function02, Duration duration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function0 = null;
        }
        if ((n & 2) != 0) {
            proxyProvider = null;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            function02 = 1.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            Duration duration2 = Duration.ofSeconds(10L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(10)");
            duration = duration2;
        }
        this((Function0<? extends SSLContext>)function0, proxyProvider, string, (Function0<? extends Map<String, String>>)function02, duration);
    }

    private final HttpRequest.Builder createRequestBuilder() {
        Map extraHeaders;
        HttpRequest.Builder builder = HttpRequest.newBuilder().timeout(this.timeout);
        if (this.userAgent != null) {
            builder.setHeader("User-Agent", this.userAgent);
        }
        Map $this$forEach$iv = extraHeaders = (Map)this.extraHeadersProvider.invoke();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String k = (String)entry.getKey();
            String v = (String)entry.getValue();
            builder.setHeader(k, v);
        }
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder");
        return builder;
    }

    private final HttpClient.Builder createHttpClientBuilder(String url) {
        ProxyInfo proxyInfo;
        SSLContext sslContext;
        HttpClient.Builder builder = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL);
        Function0<SSLContext> function0 = this.sslContextProvider;
        SSLContext sSLContext = sslContext = function0 != null ? (SSLContext)function0.invoke() : null;
        if (sslContext != null) {
            builder.sslContext(sslContext);
        }
        ProxyProvider proxyProvider = this.proxyProvider;
        ProxyInfo proxyInfo2 = proxyInfo = proxyProvider != null ? proxyProvider.getProxy(url) : null;
        if (proxyInfo != null) {
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder");
            this.configureProxy(builder, proxyInfo);
        }
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder");
        return builder;
    }

    private final HttpClient.Builder configureProxy(HttpClient.Builder $this$configureProxy, ProxyInfo proxyInfo) {
        SocketAddress proxyAddress;
        if (proxyInfo.isNoProxy()) {
            return $this$configureProxy;
        }
        Proxy proxy = proxyInfo.getProxy();
        if ((proxy.type() == Proxy.Type.HTTP || proxy.type() == Proxy.Type.SOCKS) && (proxyAddress = proxy.address()) instanceof InetSocketAddress) {
            $this$configureProxy.proxy(ProxySelector.of(new InetSocketAddress(((InetSocketAddress)proxyAddress).getHostString(), ((InetSocketAddress)proxyAddress).getPort())));
            if (proxyInfo.getProxyAuth() != null && proxyInfo.getProxyAuth().getProxyLogin() != null) {
                $this$configureProxy.authenticator(new Authenticator(proxyInfo){
                    final /* synthetic */ ProxyInfo $proxyInfo;
                    {
                        this.$proxyInfo = $proxyInfo;
                    }

                    @NotNull
                    protected PasswordAuthentication getPasswordAuthentication() {
                        Object object;
                        String string;
                        block3: {
                            block2: {
                                string = this.$proxyInfo.getProxyAuth().getProxyLogin();
                                object = this.$proxyInfo.getProxyAuth().getProxyPassword();
                                if (object == null) break block2;
                                char[] cArray = ((String)object).toCharArray();
                                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
                                object = cArray;
                                if (cArray != null) break block3;
                            }
                            char[] cArray = "".toCharArray();
                            object = cArray;
                            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
                        }
                        return new PasswordAuthentication(string, (char[])object);
                    }
                });
            }
        }
        return $this$configureProxy;
    }

    @Override
    @NotNull
    public HttpResponse post(@NotNull String url, @NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        HttpRequest request = this.createRequestBuilder().uri(URI.create(url)).POST(HttpRequest.BodyPublishers.ofString(data)).build();
        HttpClient client = this.createHttpClientBuilder(url).build();
        java.net.http.HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
        return new HttpResponse(response.statusCode(), response.body());
    }

    @Override
    @NotNull
    public HttpResponse get(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        HttpRequest request = this.createRequestBuilder().uri(URI.create(url)).build();
        HttpClient client = this.createHttpClientBuilder(url).build();
        java.net.http.HttpResponse<String> httpResponse = client.send(request, HttpResponse.BodyHandlers.ofString());
        Intrinsics.checkNotNullExpressionValue(httpResponse, (String)"client.send(request, BodyHandlers.ofString())");
        java.net.http.HttpResponse<String> response = httpResponse;
        return new HttpResponse(response.statusCode(), response.body());
    }

    @Override
    public long lastModified(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        HttpRequest request = this.createRequestBuilder().uri(URI.create(url)).method("HEAD", HttpRequest.BodyPublishers.noBody()).build();
        HttpClient client = this.createHttpClientBuilder(url).build();
        java.net.http.HttpResponse<Void> httpResponse = client.send(request, HttpResponse.BodyHandlers.discarding());
        Intrinsics.checkNotNullExpressionValue(httpResponse, (String)"client.send(request, BodyHandlers.discarding())");
        java.net.http.HttpResponse<Void> response = httpResponse;
        Long l = this.lastModified(response);
        return l != null ? l : 0L;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Long lastModified(@NotNull java.net.http.HttpResponse<Void> $this$lastModified) {
        Long l;
        Intrinsics.checkNotNullParameter($this$lastModified, (String)"<this>");
        List<String> list = $this$lastModified.headers().allValues("Last-Modified");
        if (list != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void value;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.parseDate((String)value));
            }
            l = (Long)CollectionsKt.maxWithOrNull((Iterable)((List)destination$iv$iv), (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Long it = (Long)a;
                    boolean bl = false;
                    Comparable comparable = it;
                    it = (Long)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it);
                }
            });
        } else {
            l = null;
        }
        return l;
    }

    private final Long parseDate(String string) {
        for (DateTimeFormatter format : JvmHttpClientKt.getDATE_FORMATS()) {
            try {
                return ZonedDateTime.parse(string, format).toInstant().toEpochMilli();
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        return null;
    }

    public JvmHttpClient() {
        this(null, null, null, null, null, 31, null);
    }
}

