/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.errorTreeView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ErrorTreeElementKind {
    INFO("INFO", IdeBundle.message("errortree.information", new Object[0]), AllIcons.General.Information),
    ERROR("ERROR", IdeBundle.message("errortree.error", new Object[0]), AllIcons.General.Error),
    WARNING("WARNING", IdeBundle.message("errortree.warning", new Object[0]), AllIcons.General.Warning),
    NOTE("NOTE", IdeBundle.message("errortree.note", new Object[0]), AllIcons.General.Note),
    GENERIC("GENERIC", "", null);

    private final String myText;
    @Nls
    private final String myPresentableText;
    private final Icon myIcon;

    private ErrorTreeElementKind(@Nullable String text, String presentableText, Icon icon) {
        if (presentableText == null) {
            ErrorTreeElementKind.$$$reportNull$$$0(0);
        }
        this.myText = text;
        this.myPresentableText = presentableText;
        this.myIcon = icon;
    }

    public String toString() {
        return this.myText;
    }

    @Nls
    public String getPresentableText() {
        return this.myPresentableText;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    @NotNull
    public static ErrorTreeElementKind convertMessageFromCompilerErrorType(int type) {
        ErrorTreeElementKind errorTreeElementKind = switch (type) {
            case 4 -> ERROR;
            case 5 -> WARNING;
            case 2, 3 -> INFO;
            case 1 -> GENERIC;
            case 6 -> NOTE;
            default -> GENERIC;
        };
        if (errorTreeElementKind == null) {
            ErrorTreeElementKind.$$$reportNull$$$0(1);
        }
        return errorTreeElementKind;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/errorTreeView/ErrorTreeElementKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/errorTreeView/ErrorTreeElementKind";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "convertMessageFromCompilerErrorType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

